// priority: 0
ServerEvents.recipes((event) => {
  const stonecutting = event.stonecutting;
  var transmute = function (arrayOfBlocks) {
    var cpt = 0;
    while (cpt < arrayOfBlocks.length) {
      var otherBlocks = arrayOfBlocks.slice(0, cpt).concat(arrayOfBlocks.slice(cpt + 1));
      stonecutting(arrayOfBlocks[cpt], otherBlocks);
      cpt++;
    }
  };

  event
    .custom({
      type: "mekanism:rotary",
      fluidInput: { amount: 1, fluid: "ftbskies:volatile_redstone" },
      fluidOutput: { amount: 1, fluid: "ftbskies:volatile_redstone" },
      gasInput: { amount: 1, gas: "kubejs:volatile_redstone_gas" },
      gasOutput: { amount: 1, gas: "kubejs:volatile_redstone_gas" },
    })
    .id("ftbskies:volatile_redstone_rotary");

  //spidereye
  event
    .custom({
      type: "thermal:centrifuge",
      ingredient: {
        item: "minecraft:fermented_spider_eye",
      },
      result: [
        {
          item: "minecraft:brown_mushroom",
          chance: 0.75,
          locked: true,
        },
        {
          item: "minecraft:spider_eye",
          chance: 1.0,
        },
        {
          item: "minecraft:sugar",
          chance: 0.25,
        },
      ],
      energy: 1000,
    })
    .id("ftbskies:spidereye");

    event.smelting("petrock:stoneium", "minecraft:smooth_stone").xp(0.5).id("ftbskies:stonium");

  //everburn air
  event.smelting("16x ftbskies:everburnair", "ars_nouveau:air_essence").xp(0.5).id("ftbskies:everburn");

  //charcoal
  event.smelting("mekanism:block_charcoal", "ftbskies:logpile").xp(0.5).id("ftbskies:charcoalpile");

  //alchemical silver
  event
    .custom({
      type: "cyclic:solidifier",
      ingredients: [
        {
          item: "botania:mana_powder",
        },
      ],
      mix: {
        fluid: "hexerei:quicksilver_fluid",
        count: 1000,
      },
      energy: {
        rfpertick: 1000,
        ticks: 40,
      },
      result: {
        item: "occultism:raw_silver",
        count: 1,
      },
    })
    .id("ftbskies:solidifier_alchemicalsilver");

  //nether brick
  event
    .custom({
      type: "occultism:spirit_fire",
      ingredient: {
        item: "minecraft:brick",
      },
      result: {
        item: "minecraft:nether_brick",
      },
    })
    .id("ftbskies:netherbrick");

  //sourceberry
  event
    .custom({
      type: "botania:mana_infusion",
      input: {
        item: "minecraft:sweet_berries",
      },
      mana: 1000,
      output: {
        item: "ars_nouveau:source_berry",
      },
    })
    .id("ftbskies:sourceberry");

  //menril sapling
  event
    .custom({
      type: "botania:mana_infusion",
      input: {
        item: "minecraft:oak_sapling",
      },
      mana: 1000,
      output: {
        item: "integrateddynamics:menril_sapling",
      },
    })
    .id("ftbskies:menrilsapling");

  //bee hive
  event
    .shaped("minecraft:beehive", ["PPP", "SSS", "PPP"], {
      P: "#minecraft:planks",
      S: "minecraft:sugar",
    })
    .id("ftbskies:hivealternate");

  //glow lichen
  event
    .custom({
      type: "botania:mana_infusion",
      input: {
        item: "minecraft:kelp",
      },
      mana: 500,
      output: {
        item: "minecraft:glow_lichen",
      },
    })
    .id("ftbskies:glowlichen");

  event
    .custom({
      type: "occultism:spirit_fire",
      ingredient: {
        item: "minecraft:sand",
      },
      result: {
        item: "minecraft:soul_sand",
      },
    })
    .id("ftbskies:soulsand");

  event
    .custom({
      type: "occultism:spirit_fire",
      ingredient: {
        item: "minecraft:charcoal",
      },
      result: {
        item: "minecraft:black_dye",
      },
    })
    .id("ftbskies:black_dye");

  event
    .shaped("ftbskies:desh_mesh", ["SAS", "AMA", "SAS"], {
      S: "forcecraft:force_stick",
      A: "ftbskies:springaline_desh_ingot",
      M: "ftbskies:mana_steel_mesh",
    })
    .id("ftbskies:desh_mesh");

  event
    .shaped("ftbskies:mana_steel_mesh", ["SMS", "MAM", "SMS"], {
      S: "immersiveengineering:stick_treated",
      M: "botania:manasteel_ingot",
      A: "createsifter:andesite_mesh",
    })
    .id("ftbskies:manasteel_mesh");

  event.shapeless("4x minecraft:end_rod", ["minecraft:blaze_rod", "integrateddynamics:proto_chorus"]).id("ftbskies:end_rod_alt");
  event.shapeless("minecraft:diorite", ["4x ftbskies:diorite_chunk"]).id("ftbskies:diorite");
  event.shapeless("minecraft:tuff", ["4x ftbskies:tuff_chunk"]).id("ftbskies:tuff");
  event.shapeless("minecraft:andesite", ["4x ftbskies:andesite_chunk"]).id("ftbskies:andesite");
  event.shapeless("ftbskies:logpile", ["9x #minecraft:logs"]).id("ftbskies:logpile");

  event.shapeless("thermal:quartz_dust", ["mekanism:dust_quartz"]).id("ftbskies:quartzconversion");

  //springaline desh
  event
    .custom({
      type: "immersiveengineering:arc_furnace",
      additives: [{ tag: "forge:ingots/desh" }],
      energy: 409600,
      input: { item: "ftbskies:springaline_dust" },
      results: [{ item: "ftbskies:springaline_desh_ingot" }],
      time: 150,
    })
    .id("ftbskies:springaline_desh_ingot");

  //statue manual
  event.shapeless(Item.of("patchouli:guide_book", '{"patchouli:book":"statues:statues"}'), [
    "minecraft:book",
    "statues:display_stand",
  ]);
  event.shapeless("minecraft:cobblestone", ["4x ftbskies:rock"]).id("ftbskies:rock");
  event.shapeless("minecraft:dirt", ["4x ftbskies:soil"]).id("ftbskies:soil");

  //void upgrade
  event.shapeless("functionalstorage:void_upgrade", ["thermal:machine_null_augment"]).id("ftbskies:voidupgrade");
  event.shapeless("thermal:machine_null_augment", ["functionalstorage:void_upgrade"]).id("ftbskies:voidupgradeconvert");

  //gravel
  event.shapeless("2x minecraft:gravel", ["2x ftbskies:rock", "2x ftbskies:soil"]).id("ftbskies:gravel");

  //witch gate
  let witchGate = Item.of("gateways:gate_pearl").withNBT('{gateway:"gateways:endless_witch_gate"}');
  event.shapeless(witchGate, ["elementalcraft:earth_shard", "minecraft:ender_pearl"]).id("ftbskies:witchgate");

  let eHead = Item.of("minecraft:player_head").withNBT(
    '{SkullOwner:{Id:[I;1090499442,318129784,-1275977354,-1084826293],Name:"MHF_Enderman",Properties:{textures:[{Signature:"vw5qrGqKTKN/AEOoxdrpBsjW+vd70dtjuupPzSyBgmrsw4RrYvW8MfoRI/FEhSt0ofilE66Jt5fpR6GtkuTNKKGYgAzELS315RbJQsU8NrMhR4w9k91n1cjkeXZeGNsPJObgPO88B/qKBg3iEEwBiCMIymqf2Rs8JN5hyzNPaXFTd8HwAZ1548ClzoW3U+QuJ7itSNIs4dmoQ+i7LGx9uhb/tuIX7+6PkgwiyJqzYtD/fgwlgxfgL6JXYopKvUfe0576usLjkJLyRrGpMP2J0AFi2HOCqBDgxZg+cz9ymHdQDaLopSbhVAyymKQMUXOYW3M+vxZ/tzNniWdfARaR9JQg2uILxeccdVorA7SOoDcDWGDJPEaUV35SmSlOQtjE0rXd+J6GfESkdcXEPYwJZ2Zxn6+jYBZ4GCBPXPbEd0ccAcXHqUOS3vizw77I9LL1cY0ksWR7OcVozQTjp5SlquIBX/38mnTCqro2gaSZ/Y0epPiV6z91pele3tmiYJ2JcdS2VY8UbxEFczFJRfAFqItldicuVPyrJTchM1hWcgEWrxbpUGCssY44+9I6y6Dd85TnvdjdgLIQujlbHu1Rpq/O5Nzj2fnXy7BX3IdWLKrelsrXgzFDdr5dYBpCRXC4fn7TA1W+8uB/oe4cnqxuemL5JtzJD/9ah5FzMYDuC5Q=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTY4MDMyNjg3OTAxMSwKICAicHJvZmlsZUlkIiA6ICI0MGZmYjM3MjEyZjY0Njc4YjNmMjIxNzZiZjU2ZGQ0YiIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfRW5kZXJtYW4iLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWIwOWEzNzUyNTEwZTkxNGIwYmRjOTA5NmIzOTJiYjM1OWY3YThlOGE5NTY2YTAyZTdmNjZmYWZmOGQ2Zjg5ZSIKICAgIH0KICB9Cn0="}]}}}'
  );
  //enderman head
  event.shapeless(eHead, ["supplementaries:enderman_head"]).id("ftbskies:ehead1");
  event.shapeless("supplementaries:enderman_head", [eHead]).id("ftbskies:ehead2");

  //eye of legend
  event
    .shaped("ftbskies:eye_of_legend", [" D ", "DED", " D "], {
      D: "occultism:otherworld_ashes",
      E: "minecraft:ender_eye",
    })
    .id("ftbskies:eyeoflegend");

  //ad astra book
  event.shapeless("ad_astra:astrodux", ["#forge:ingots/steel", "minecraft:book"]).id("ftbskies:astrodux");

  //Bamboo blocks
  transmute(["quark:bamboo_block", "thermal:bamboo_block"]);
  transmute(["quark:bamboo_block", "tropicraft:bamboo_bundle"]);
  transmute(["thermal:bamboo_block", "tropicraft:bamboo_bundle"]);

  //SugarCane
  transmute(["quark:sugar_cane_block", "thermal:sugar_cane_block"]);
  transmute(["quark:sugar_cane_block", "tropicraft:thatch_bundle"]);
  transmute(["thermal:sugar_cane_block", "tropicraft:thatch_bundle"]);

  //written book
  event
    .shapeless("minecraft:writable_book", ["#forge:dyes/black", "minecraft:feather", "minecraft:book"])
    .id("ftbskies:writablebook");

  //Ender Inhibitor
  event
    .shaped("mob_grinding_utils:ender_inhibitor_on", [" R ", "WMW", " G "], {
      R: "#forge:dusts/redstone",
      M: "#forge:ingots/manasteel",
      W: "elementalcraft:watercrystal",
      G: "#forge:dusts/glowstone",
    })
    .id("ftbskies:ender_inhibitor");

  // Pressurized Spawner
  event
    .shaped("pneumaticcraft:pressurized_spawner", ["RMR", "MFM", "RMR"], {
      R: "#forge:ingots/compressed_iron",
      M: "pneumaticcraft:reinforced_pressure_tube",
      F: "minecraft:iron_bars",
    })
    .id("ftbskies:pressurized_spawner");

  //Andesite alloy
  event
    .shaped("4x create:andesite_alloy", ["ASA", "SPS", "ASA"], {
      A: "minecraft:andesite",
      P: "thermal:apatite",
      S: "mekanism:shard_iron",
    })
    .id("ftbskies:andesite_alloy");

  // Entity Converter
  event.shapeless("mob_grinding_utils:entity_conveyor", ["darkutils:vector_plate"]).id("ftbskies:entity_converter");
  //bucket
  event
    .shaped("minecraft:bucket", ["   ", "P P", " P "], {
      P: "#forge:plates/iron",
    })
    .id("ftbskies:bucket");

  //shard block
  event.shapeless("ftbskies:iron_substrate", ["2x mekanism:shard_iron"]).id("ftbskies:iron_substrate");

  //Magnetic compressed iron
  event.custom({
    type: "ae2:charger",
    ingredient: {
      item: "pneumaticcraft:ingot_iron_compressed",
    },
    result: {
      item: "ftbskies:magnetized_compressed_iron_ingot",
    },
  });

  //Contained crystal
  event
    .shaped("elementalcraft:contained_crystal", ["GGG", "GIG", "GGG"], {
      G: "minecraft:gold_nugget",
      I: "elementalcraft:inert_crystal",
    })
    .id("ftbskies:contained_crystal");

  //Petal Apothecary
  event
    .shaped("botania:apothecary_default", ["RPR", " W ", "RRR"], {
      R: "elementalcraft:whiterock",
      P: "#botania:petals",
      W: "ars_nouveau:water_essence",
    })
    .id("ftbskies:apothecary_default");

  //alternate diamond recipe
  event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          type: "pneumaticcraft:stacked_item",
          count: 1,
          tag: "forge:storage_blocks/coal_coke",
        },
      ],
      pressure: 4.0,
      results: [
        {
          item: "minecraft:diamond",
        },
      ],
    })
    .id("ftbskies:alternate_diamond");

  //Flint and steel early alt
  event
    .shapeless("minecraft:flint_and_steel", ["mekanism:shard_iron", "minecraft:flint"])
    .id("ftbskies:flintnsteel_early");

  //Flint and steel with plate shapeless
  event
    .shapeless("minecraft:flint_and_steel", ["#forge:plates/iron", "minecraft:flint"])
    .id("ftbskies:flintnsteel_plate");

    //Squeezer
  event
    .shaped("simplemagnets:advancedmagnet", ["SFS", "FMF", "SFS"], {
      S: "#forge:plates/signalum",
      M: "simplemagnets:basicmagnet",
      F: "#forge:plates/force",
    })
    .id("ftbskies:adv_magnet");

    //Squeezer
  event
    .shaped("integrateddynamics:squeezer", ["SBS", "S S", "PAP"], {
      S: "minecraft:stick",
      A: "create:andesite_alloy",
      P: "#minecraft:planks",
      B: "ftbskies:iron_shard_block",
    })
    .id("ftbskies:squeezer");

  //Solidifier
  event
    .shaped("ftbsba:super_cooler", ["LQL", "GCG", "EEE"], {
      L: "minecraft:lapis_block",
      Q: "minecraft:quartz",
      G: "#forge:glass",
      C: "industrialforegoing:machine_frame_pity",
      E: "immersiveengineering:light_engineering",
    })
    .id("ftbskies:solidifier");

  //Cyclic Generator
  event
    .shaped("cyclic:generator_item", ["OCO", "SPS", "LCL"], {
      O: "minecraft:observer",
      C: "minecraft:copper_ingot",
      S: "#forge:sheetmetals",
      L: "immersiveengineering:light_engineering",
      P: "industrialforegoing:machine_frame_pity",
    })
    .id("ftbskies:cyclic_generator");

  //Ash blasting
  event.blasting("3x supplementaries:ash", "#minecraft:logs");
  event.blasting("immersiveengineering:slag_glass", "#forge:slag");

  // base cauldron
  event
    .shaped("minecraft:cauldron", ["I I", "I I", "III"], {
      I: "#forge:plates/iron",
    })
    .id("ftbskies:cauldron");

  // mixing cauldron
  event
    .shaped("hexerei:mixing_cauldron", ["S S", "ICI", "SIS"], {
      I: "mekanism:shard_copper",
      C: "minecraft:cauldron",
      S: "minecraft:stone",
    })
    .id("ftbskies:mixing_cauldron");

  // melting chamber
  event
    .shaped("ftbsba:fusing_machine", ["RNR", "GFG", "QLQ"], {
      F: "industrialforegoing:machine_frame_pity",
      G: "minecraft:glass",
      R: "minecraft:redstone_block",
      N: "minecraft:quartz",
      Q: "minecraft:quartz_block",
      L: "immersiveengineering:light_engineering",
    })
    .id("ftbskies:melting_chamber");

  event.shapeless("ftbsba:fusing_machine", "cyclic:melter").id("ftbskies:melting_chamber_convert");
  event.shapeless("ftbsba:super_cooler", "cyclic:solidifier").id("ftbskies:solidifier_convert");

  //Pedestal
  event
    .shaped("pedestals:block_pedestal", ["LAL", " S ", "SSS"], {
      L: "minecraft:stone_slab",
      A: "create:andesite_alloy",
      S: "minecraft:stone",
    })
    .id("ftbskies:pedestal");

  //Vitalic Sourcelink
  event
    .shaped("ars_nouveau:vitalic_sourcelink", [" S ", "GCG", " S "], {
      S: "ars_nouveau:source_gem",
      G: "minecraft:gold_ingot",
      C: "spirit:soul_crystal_shard",
    })
    .id("ftbskies:vitalic");

  //Experience Obelisk
  event
    .shaped("experienceobelisk:experience_obelisk", ["IAI", "ITI", "IOI"], {
      I: "thermal:iron_plate",
      A: "cyclic:gem_amber",
      T: "create:fluid_tank",
      O: "minecraft:obsidian",
    })
    .id("ftbskies:exp_ob");

  //mechanical Press
  event
    .shaped("create:mechanical_press", [" C ", " A ", " S "], {
      C: "create:shaft",
      A: "create:andesite_casing",
      S: "minecraft:smooth_stone_slab",
    })
    .id("ftbskies:mechpress");

  //Magic steel Block to Ingot
  event.shapeless("9x ftbskies:magic_steel", ["ftbskies:magic_steel_block"]).id("ftbskies:magicsteel_block_to_ingot");

  //Magic steel Ingot to block
  event.shapeless("ftbskies:magic_steel_block", ["9x ftbskies:magic_steel"]).id("ftbskies:magicsteel_ingot_to_block");

  //Create Waterwheel Small
  event
    .shaped("ftbricketyww:rickety_water_wheel", ["SCS", "CHC", "SCS"], {
      S: "#minecraft:wooden_slabs",
      C: "create:andesite_casing",
      H: "create:shaft",
    })
    .id("ftbskies:create_small_waterwheel");

  //Soul Lantern
  event
    .shaped("minecraft:soul_lantern", [" P ", "PTP", " P "], {
      P: "#forge:plates/iron",
      T: "minecraft:soul_torch",
    })
    .id("ftbskies:soullantern");

  //Pity Frame
  event
    .shaped("industrialforegoing:machine_frame_pity", ["LSL", "SRS", "LSL"], {
      L: "#minecraft:logs",
      S: "thermal:iron_plate",
      R: "minecraft:redstone_block",
    })
    .id("ftbskies:pity");

  //autotrader
  //whiterock
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: false,
      output: {
        item: "easy_villagers:auto_trader",
      },
      pedestalItems: [
        {
          item: "ftbskies:sentient_steel",
        },
        {
          item: "ftbskies:sentient_steel",
        },
        {
          item: "jaopca:plates.swift_alloy",
        },
        {
          item: "jaopca:plates.swift_alloy",
        },
      ],
      reagent: [
        {
          item: "easy_villagers:trader",
        },
      ],
      sourceCost: 2500,
    })
    .id("ftbskies:autotrader");

  //Enchanting Apparatus
  event
    .shaped("ars_nouveau:enchanting_apparatus", ["NSN", "GAG", "NSN"], {
      N: "minecraft:gold_nugget",
      S: "ars_nouveau:sourcestone",
      G: "minecraft:gold_ingot",
      A: "cyclic:gem_amber",
    })
    .id("ftbskies:enchant_appa");

  //Peat Farm
  event
    .shaped("cyclic:peat_farm", ["CDC", "LPL", "CDC"], {
      C: "minecraft:copper_ingot",
      D: "minecraft:dispenser",
      L: "immersiveengineering:light_engineering",
      P: "industrialforegoing:machine_frame_pity",
    })
    .id("ftbskies:peat_farm");

  //Assembly Drill
  event
    .shaped("pneumaticcraft:assembly_drill", ["MCC", " PC", "IFI"], {
      M: "botania:manasteel_ingot",
      C: "pneumaticcraft:pneumatic_cylinder",
      I: "pneumaticcraft:ingot_iron_compressed",
      P: "pneumaticcraft:printed_circuit_board",
      F: "thermal:machine_frame",
    })
    .id("ftbskies:assembly_drill");

  //Assembly Laser
  event
    .shaped("pneumaticcraft:assembly_laser", ["MCC", " PC", "IFI"], {
      M: "botania:mana_diamond",
      C: "pneumaticcraft:pneumatic_cylinder",
      I: "pneumaticcraft:ingot_iron_compressed",
      P: "pneumaticcraft:printed_circuit_board",
      F: "thermal:machine_frame",
    })
    .id("ftbskies:assembly_laser");

  //Thermo Plant
  event
    .shaped("pneumaticcraft:thermopneumatic_processing_plant", ["SHS", "TPT", "LFL"], {
      S: "pneumaticcraft:reinforced_stone_slab",
      H: "immersiveengineering:heavy_engineering",
      T: "pneumaticcraft:small_tank",
      P: "pneumaticcraft:pressure_tube",
      F: "thermal:machine_frame",
      L: "immersiveengineering:light_engineering",
    })
    .id("ftbskies:thermo_plant");

  //Refinery
  event
    .shaped("pneumaticcraft:refinery", ["   ", "PTP", "   "], {
      P: "#forge:plates/desh",
      T: "pneumaticcraft:thermopneumatic_processing_plant",
    })
    .id("ftbskies:thermo_plant_refinery");

  //Fluid Mixer
  event
    .shaped("pneumaticcraft:fluid_mixer", ["PTP", "TFT", "HMH"], {
      P: "pneumaticcraft:pressure_tube",
      T: "pneumaticcraft:small_tank",
      F: "pneumaticcraft:turbine_rotor",
      H: "immersiveengineering:heavy_engineering",
      M: "thermal:machine_frame",
    })
    .id("ftbskies:fluid_mixer");

  //create Straw
  event
    .shaped("createaddition:straw", ["PBP", "PBP", "PBP"], {
      P: "minecraft:paper",
      B: "minecraft:bamboo",
    })
    .id("ftbskies:create_straw");

  //logic circuit
  event
    .shaped("immersiveengineering:logic_circuit", ["CCC", "EPE", "CCC"], {
      C: "immersiveengineering:wire_copper",
      E: "immersiveengineering:component_electronic",
      P: "immersiveengineering:circuit_board",
    })
    .id("ftbskies:logic_circuit");

  //Fractionating still
  event
    .shaped("thermal:machine_refinery", ["THT", "FMF", "LEL"], {
      T: "pneumaticcraft:small_tank",
      H: "immersiveengineering:heavy_engineering",
      F: "thermal:rf_coil",
      M: "thermal:machine_frame",
      L: "immersiveengineering:light_engineering",
      E: "immersiveengineering:furnace_heater",
    })
    .id("ftbskies:fractionating_still");

  //IF latex bucket to rubber
  event.shapeless("3x thermal:rubber", ["industrialforegoing:latex_bucket"]).id("ftbskies:iflatex_bucket_rubber");

  //Fluid Encapsulator
  event
    .shaped("thermal:machine_bottler", ["ERE", "GFG", "LCL"], {
      R: "thermal:fluid_reservoir",
      G: "pneumaticcraft:pressure_chamber_glass",
      F: "thermal:machine_frame",
      L: "immersiveengineering:light_engineering",
      C: "thermal:rf_coil",
      E: "thermal:copper_gear",
    })
    .id("ftbskies:fluid_encapsulator");

  //UV Light Box
  event
    .shaped("pneumaticcraft:uv_light_box", ["LLL", "CBP", "CHC"], {
      L: "minecraft:redstone_lamp",
      C: "pneumaticcraft:ingot_iron_compressed",
      B: "pneumaticcraft:pcb_blueprint",
      P: "pneumaticcraft:pressure_tube",
      H: "immersiveengineering:heavy_engineering",
    })
    .id("ftbskies:uv_box");

  //Etching Tank
  event
    .shaped("pneumaticcraft:etching_tank", ["HLH", "BTB", "HFH"], {
      H: "immersiveengineering:heavy_engineering",
      L: "immersiveengineering:light_engineering",
      B: "pneumaticcraft:reinforced_bricks",
      T: "pneumaticcraft:small_tank",
      F: "thermal:machine_frame",
    })
    .id("ftbskies:etching_tank");

  //Crystallizer
  event
    .shaped("thermal:machine_crystallizer", ["IGI", "EFE", "LCL"], {
      I: "thermal:invar_plate",
      G: "thermal:obsidian_glass",
      E: "thermal:electrum_gear",
      F: "thermal:machine_frame",
      L: "immersiveengineering:light_engineering",
      C: "thermal:rf_coil",
    })
    .id("ftbskies:crystallizer");

  //assembly Controller
  event
    .shaped("pneumaticcraft:assembly_controller", [" S ", "TPP", "IFI"], {
      S: "rftoolsbase:information_screen",
      T: "pneumaticcraft:pressure_tube",
      P: "pneumaticcraft:printed_circuit_board",
      I: "pneumaticcraft:ingot_iron_compressed",
      F: "thermal:machine_frame",
    })
    .id("ftbskies:assembly_controller");

  //Assembly Platform
  event
    .shaped("pneumaticcraft:assembly_platform", ["C C", "PBP", "IFI"], {
      C: "pneumaticcraft:pneumatic_cylinder",
      P: "industrialforegoing:plastic",
      B: "pneumaticcraft:printed_circuit_board",
      I: "pneumaticcraft:ingot_iron_compressed",
      F: "thermal:machine_frame",
    })
    .id("ftbskies:assembly_platform");

  //assembly IO (import)
  event
    .shaped("pneumaticcraft:assembly_io_unit_import", ["HCC", " PC", "IFI"], {
      C: "pneumaticcraft:pneumatic_cylinder",
      H: "minecraft:hopper",
      P: "pneumaticcraft:printed_circuit_board",
      I: "pneumaticcraft:ingot_iron_compressed",
      F: "thermal:machine_frame",
    })
    .id("ftbskies:assembly_import");

  //assembly IO (export)
  event
    .shaped("pneumaticcraft:assembly_io_unit_export", ["CCH", "CPO", "IFI"], {
      C: "pneumaticcraft:pneumatic_cylinder",
      O: "minecraft:observer",
      H: "create:brass_hand",
      P: "pneumaticcraft:printed_circuit_board",
      I: "pneumaticcraft:ingot_iron_compressed",
      F: "thermal:machine_frame",
    })
    .id("ftbskies:assembly_export");

  //Sentient Steel
  //signalum
  event
    .custom({
      type: "immersiveengineering:arc_furnace",
      energy: 402400,
      input: { item: "experienceobelisk:cognitive_alloy" },
      additives: [{ item: "botania:terrasteel_ingot" }],
      results: [{ item: "ftbskies:sentient_steel" }],
      time: 400,
    })
    .id("ftbskies:sentient_steel");

  //Cobble Gens
  event
    .shaped("cobblefordays:tier_2", ["BBB", "WCL", "BBB"], {
      B: "#forge:cobblestone",
      W: "minecraft:water_bucket",
      C: "cobblefordays:tier_1",
      L: "minecraft:lava_bucket",
    })
    .id("ftbskies:cobblegen2");

  event
    .shaped("cobblefordays:tier_3", ["BBB", "WCL", "BBB"], {
      B: "#forge:ingots/iron",
      W: "minecraft:water_bucket",
      C: "cobblefordays:tier_2",
      L: "minecraft:lava_bucket",
    })
    .id("ftbskies:cobblegen3");

  event
    .shaped("cobblefordays:tier_4", ["BBB", "WCL", "BBB"], {
      B: "#forge:ingots/gold",
      W: "minecraft:water_bucket",
      C: "cobblefordays:tier_3",
      L: "minecraft:lava_bucket",
    })
    .id("ftbskies:cobblegen4");

  event
    .shaped("cobblefordays:tier_5", ["BBB", "WCL", "BBB"], {
      B: "#forge:gems/diamond",
      W: "minecraft:water_bucket",
      C: "cobblefordays:tier_4",
      L: "minecraft:lava_bucket",
    })
    .id("ftbskies:cobblegen5");

  event
    .shaped("mekanism:basic_fluid_tank", ["RIR", "I I", "RIR"], {
      R: "#forge:dusts/redstone",
      I: "#forge:plates/iron",
    })
    .id("ftbskies:mek_tank");

  // Gold Trap Door
  event
    .shaped("supplementaries:gold_trapdoor", [" G ", "GDG", " G "], {
      G: "#forge:ingots/gold",
      D: "#minecraft:wooden_trapdoors",
    })
    .id("ftbskies:gold_trapdoor");

  //Flint out of 3x Gravel [Why this isn't a vanilla recipe? O.o]
  event
    .shapeless("minecraft:flint", [
      // arg 1: output
      "3x minecraft:gravel",
    ])
    .id("ftbskies:flint_by_hand_manual_only");

  //Minecraft Mud by Hand
  event
    .shaped("4x minecraft:mud", [" D ", "DWD", " D "], {
      W: "#forge:buckets/water",
      D: "#minecraft:dirt",
    })
    .id("ftbskies:mud_by_hand");

  // Elementalcraft Container recipe
  event.remove({ id: "elementalcraft:container" });

  event
    .shaped("elementalcraft:container", ["DCD", "PSP", "WWW"], {
      D: "elementalcraft:drenched_iron_ingot",
      C: "elementalcraft:contained_crystal",
      P: "elementalcraft:elementpipe",
      S: "ftbskies:springaline_dust",
      W: "elementalcraft:whiterock",
    })
    .id("ftbskies:elementalcraft_container");

  //Stonecutter
  event
    .shaped("minecraft:stonecutter", ["   ", " S ", "CCC"], {
      S: "natprog:flint_saw",
      C: "minecraft:stone",
    })
    .id("ftbskies:stonecutter");

  //Coal Dust in the Occultism Crusher
  event
    .custom({
      type: "occultism:crushing",
      crushing_time: 200,
      ignore_crushing_multiplier: false,
      ingredient: {
        item: "minecraft:coal",
      },
      result: {
        count: 1,
        item: "mekanism:dust_coal",
      },
    })
    .id("ftbskies:occultism_crush_coal_dust");

  event
    .custom({
      type: "create:crushing",
      ingredients: [
        {
          item: "minecraft:coal",
        },
      ],
      results: [
        {
          item: "mekanism:dust_coal",
          count: 1,
        },
      ],
      processingTime: 100,
    })
    .id("ftbskies:create_crush_coal_dust");

  event
    .custom({
      type: "occultism:crushing",
      crushing_time: 200,
      ignore_crushing_multiplier: false,
      ingredient: {
        item: "minecraft:coal_block",
      },
      result: {
        count: 9,
        item: "mekanism:dust_coal",
      },
    })
    .id("ftbskies:occultism_crush_coal_dust_block");

  event
    .custom({
      type: "create:crushing",
      ingredients: [
        {
          item: "minecraft:coal_block",
        },
      ],
      results: [
        {
          item: "mekanism:dust_coal",
          count: 9,
        },
      ],
      processingTime: 100,
    })
    .id("ftbskies:create_crush_coal_dust_block");

  event
    .custom({
      type: "mekanism:crushing",
      input: { ingredient: { item: "minecraft:coal_block" } },
      output: { item: "9x mekanism:dust_coal" },
    })
    .id("ftbskies:mekanism_coal_dust_block");

  //Coke Dust Recipes
  event
    .custom({
      type: "integrateddynamics:squeezer",
      item: "immersiveengineering:coal_coke",
      result: {
        items: [
          {
            item: "immersiveengineering:dust_coke",
          },
        ],
      },
    })
    .id("ftbskies:integrated_squeezer_coke_dust");

  event
    .custom({
      type: "integrateddynamics:mechanical_squeezer",
      item: "immersiveengineering:coal_coke",
      result: {
        items: [
          {
            item: "immersiveengineering:dust_coke",
          },
        ],
      },
      duration: 10,
    })
    .id("ftbskies:integrated_mechanical_squeezer_coke_dust");

  event
    .custom({
      type: "mekanism:crushing",
      input: { ingredient: { tag: "forge:coal_coke" } },
      output: { item: "immersiveengineering:dust_coke" },
    })
    .id("ftbskies:mekanism_coke_dust");
  event
    .custom({
      type: "mekanism:crushing",
      input: { ingredient: { tag: "forge:storage_blocks/coal_coke" } },
      output: { item: "9x immersiveengineering:dust_coke" },
    })
    .id("ftbskies:mekanism_coke_dust_block");

  event
    .custom({
      type: "occultism:crushing",
      crushing_time: 200,
      ignore_crushing_multiplier: false,
      ingredient: {
        tag: "forge:coal_coke",
      },
      result: {
        count: 1,
        item: "immersiveengineering:dust_coke",
      },
    })
    .id("ftbskies:occultism_crush_coke_dust");

  //Charcoal Dust Recipes
  event
    .custom({
      type: "integrateddynamics:squeezer",
      item: "minecraft:charcoal",
      result: {
        items: [
          {
            item: "mekanism:dust_charcoal",
          },
        ],
      },
    })
    .id("ftbskies:integrated_squeezer_charcoal_dust");

  event
    .custom({
      type: "integrateddynamics:mechanical_squeezer",
      item: "minecraft:charcoal",
      result: {
        items: [
          {
            item: "mekanism:dust_charcoal",
          },
        ],
      },
      duration: 10,
    })
    .id("ftbskies:integrated_mechanical_squeezer_charcoal_dust");

  event
    .custom({
      type: "mekanism:crushing",
      input: { ingredient: { tag: "forge:storage_blocks/charcoal" } },
      output: { item: "9x mekanism:dust_charcoal" },
    })
    .id("ftbskies:mekanism_charcoal_dust_block");

  event
    .custom({
      type: "occultism:crushing",
      crushing_time: 200,
      ignore_crushing_multiplier: false,
      ingredient: {
        item: "minecraft:charcoal",
      },
      result: {
        count: 1,
        item: "mekanism:dust_charcoal",
      },
    })
    .id("ftbskies:occultism_crush_charcoal_dust");

  event
    .custom({
      type: "occultism:crushing",
      crushing_time: 200,
      ignore_crushing_multiplier: false,
      ingredient: {
        tag: "forge:storage_blocks/charcoal",
      },
      result: {
        count: 9,
        item: "mekanism:dust_charcoal",
      },
    })
    .id("ftbskies:occultism_crush_charcoal_dust_block");

  event
    .custom({
      type: "create:crushing",
      ingredients: [
        {
          item: "minecraft:charcoal",
        },
      ],
      results: [
        {
          item: "mekanism:dust_charcoal",
          count: 1,
        },
      ],
      processingTime: 100,
    })
    .id("ftbskies:create_crush_charcoal_dust");

  event
    .custom({
      type: "create:crushing",
      ingredients: [
        {
          tag: "forge:storage_blocks/charcoal",
        },
      ],
      results: [
        {
          item: "mekanism:dust_charcoal",
          count: 9,
        },
      ],
      processingTime: 100,
    })
    .id("ftbskies:create_crush_charcoal_dust_block");

  // Redstone Arsenal: Flux Gem
  event
    .custom({
      type: "powah:energizing",
      ingredients: [
        {
          item: "botania:dragonstone",
        },
        {
          item: "ftbskies:volatile_substrate",
        },
      ],
      energy: 1000000,
      result: {
        item: "redstone_arsenal:flux_gem",
        count: 2,
      },
    })
    .id("ftbskies:flux_gem");

  // Redstone Arsenal: Flux Ingot
  event
    .custom({
      type: "powah:energizing",
      ingredients: [
        {
          item: "elementalcraft:fireite_ingot",
        },
        {
          item: "ftbskies:volatile_substrate",
        },
      ],
      energy: 1000000,
      result: {
        item: "redstone_arsenal:flux_ingot",
        count: 2,
      },
    })
    .id("ftbskies:flux_ingot");

  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "industrialforegoing:plastic",
        },
        {
          fluid: "ftbskies:polyethylene",
          amount: 250,
        },
      ],
      result: [
        {
          item: "ftbskies:ldpe_sheet",
        },
      ],
    })
    .id("ftbskies:ldpe_sheet");

  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "mekanism:substrate",
        },
        {
          fluid: "ftbskies:volatile_redstone",
          amount: 250,
        },
      ],
      result: [
        {
          item: "ftbskies:volatile_substrate",
        },
      ],
    })
    .id("ftbskies:volatile_substrate");

  event
    .shaped("ftbskies:powerful_void_shard", ["SSS", "SSS", "SSS"], {
      S: "ftbskies:void_shard",
    })
    .id("ftbskies:powerful_void_shard");

  event.shapeless("8x ftbskies:tiny_charcoal", ["minecraft:charcoal"]).id("ftbskies:tiny_charcoal");
  event.shapeless("8x ftbskies:tiny_coal", ["minecraft:coal"]).id("ftbskies:tiny_coal");
  event.shaped("minecraft:coal", ["CCC", "C C", "CCC"], { C: "ftbskies:tiny_coal" }).id("ftbskies:crafting_coal");
  event
    .shaped("minecraft:charcoal", ["CCC", "C C", "CCC"], { C: "ftbskies:tiny_charcoal" })
    .id("ftbskies:crafting_charcoal");

  const eyeIngore = [
    { mod: "powah" },
    { id: "itemcollectors:advanced_collector" },
    { id: "mob_grinding_utils:recipe_absorbtion_hopper" },
    { id: "gag:time_sand_pouch" },
    { id: "darkutils:crafting/charm_portal_eye" },
    { id: "pneumaticcraft:search_upgrade" },
    { id: "pneumaticcraft:vacuum_trap" },
    { id: "glassential:glass_dark_ethereal" },
    { id: "glassential:glass_ethereal" },
    { id: "ars_nouveau:scryers_crystal" },
    { id: "compactmachines:personal_shrinking_device" },
  ];

  const plateIgnore = [
    { output: "jaopca:plates.compressed_iron" },
    { output: "jaopca:rods.compressed_iron" },
    { output: "pneumaticcraft:compressed_iron_gear" },
    { output: "pneumaticcraft:compressed_iron_block" },
    { output: "jaopca:plates.manasteel" },
    { output: "jaopca:gears.manasteel" },
    { output: "botania:manasteel_block" },
    { output: "botania:manasteel_nugget" },
    { output: "jaopca:rods.manasteel" },
    { output: "immersiveengineering:plate_steel" },
    { output: "jaopca:gears.steel" },
    { output: "mekanism:block_steel" },
    { output: "mekanism:nugget_steel" },
    { output: "immersiveengineering:stick_steel" },
    { output: "thermal:electrum_block" },
    { output: "thermal:electrum_gear" },
    { output: "thermal:electrum_dust" },
    { output: "thermal:invar_dust" },
    { output: "thermal:lumium_dust" },
    { output: "thermal:enderium_dust" },
    { output: "thermal:_dust" },
    { output: "thermal:electrum_plate" },
    { output: "createaddition:electrum_rod" },
    { output: "thermal:electrum_nugget" },
    { output: "thermal:invar_block" },
    { output: "thermal:invar_gear" },
    { output: "thermal:invar_plate" },
    { output: "jaopca:rods.invar" },
    { output: "thermal:invar_nugget" },
    { output: "thermal:constantan_block" },
    { output: "thermal:constantan_gear" },
    { output: "thermal:constantan_plate" },
    { output: "jaopca:rods.constantan" },
    { output: "thermal:constantan_nugget" },
    { output: "thermal:signalum_block" },
    { output: "thermal:signalum_gear" },
    { output: "thermal:signalum_plate" },
    { output: "jaopca:rods.signalum" },
    { output: "thermal:signalum_nugget" },
    { output: "thermal:lumium_block" },
    { output: "thermal:lumium_gear" },
    { output: "thermal:lumium_plate" },
    { output: "jaopca:rods.lumium" },
    { output: "thermal:lumium_nugget" },
    { output: "thermal:enderium_block" },
    { output: "thermal:enderium_gear" },
    { output: "thermal:enderium_plate" },
    { output: "jaopca:rods.enderium" },
    { output: "thermal:enderium_nugget" },
    { output: "minecraft:gold_block" },
    { output: "createaddition:gold_rod" },
    { output: "thermal:gold_plate" },
    { output: "minecraft:gold_nugget" },
    { output: "thermal:gold_gear" },
    { output: "thermal:electrum_ingot" },
    { output: "industrialforegoing:pink_slime_ingot" },
    { output: "occultism:gold_dust" },
    { output: "minecraft:iron_block" },
    { output: "immersiveengineering:stick_iron" },
    { output: "thermal:iron_plate" },
    { output: "minecraft:iron_nugget" },
    { output: "thermal:iron_gear" },
    { output: "minecraft:iron_ingot" },
    { output: "thermal:invar_ingot" },
    { output: "mekanism:ingot_steel" },
    { output: "industrialforegoing:pink_slime_ingot" },
    { output: "mekanism:enriched_iron" },
    { output: "ftbskies:magnetized_compressed_iron_ingot" },
    { output: "pneumaticcraft:ingot_iron_compressed" },
    { output: "mekanism:alloy_infused" },
    { output: "spirit:soul_steel_ingot" },
    { output: "occultism:iron_dust" },
    { mod: "ae2" },
  ];
  event.replaceInput({ mod: "powah" }, "minecraft:iron_ingot", "#forge:ingots/steel");
  event.replaceInput({ mod: "mekanism" }, "minecraft:iron_ingot", "#forge:ingots/steel");
  event.replaceInput({ mod: "forcecraft" }, "forcecraft:force_ingot", "#forge:plates/force");
  event.replaceInput({ mod: "computercraft" }, "#forge:stone", "pneumaticcraft:reinforced_stone");
  event.replaceInput({ mod: "computercraft" }, "#c:glass_panes", "thermal:obsidian_glass");
  event.replaceInput({ mod: "computercraft" }, "minecraft:ender_pearl", "createteleporters:redstone_pearl");
  event.replaceInput({ mod: "computercraft" }, "minecraft:redstone", "mekanism:alloy_infused");
  event.replaceInput({ mod: "computercraft" }, "minecraft:gold_ingot", "thermal:electrum_plate");
  event.replaceInput({ mod: "computercraft" }, "thermal:gold_plate", "thermal:electrum_plate");
  event.replaceInput({ mod: "computercraft" }, "#forge:plates/gold", "thermal:electrum_plate");
  event.replaceInput({ mod: "computercraft" }, "#forge:ingots/gold", "thermal:electrum_plate");
  event.replaceInput({ mod: "advancedperipherals" }, "#forge:stone", "pneumaticcraft:reinforced_stone");
  event.replaceInput({ mod: "advancedperipherals" }, "#c:glass_panes", "thermal:obsidian_glass");
  event.replaceInput({ mod: "advancedperipherals" }, "minecraft:ender_pearl", "createteleporters:redstone_pearl");
  event.replaceInput({ mod: "advancedperipherals" }, "minecraft:redstone", "mekanism:alloy_infused");
  event.replaceInput({ mod: "advancedperipherals" }, "minecraft:gold_ingot", "thermal:electrum_plate");
  event.replaceInput({ mod: "advancedperipherals" }, "thermal:gold_plate", "thermal:electrum_plate");
  event.replaceInput({ mod: "advancedperipherals" }, "#forge:plates/gold", "thermal:electrum_plate");
  event.replaceInput({ mod: "modularrouters" }, "minecraft:iron_ingot", "ftbskies:springaline_desh_ingot");
  event.replaceInput({ mod: "modularrouters" }, "minecraft:gold_nugget", "ftbskies:space_plate");
  event.replaceInput({ mod: "modularrouters" }, "minecraft:gold_ingot", "ad_astra:ostrum_plate");
  event.replaceInput({ mod: "modularrouters" }, "minecraft:blaze_rod", "powah:crystal_blazing");
  event.replaceInput({ mod: "easy_villagers" }, "minecraft:iron_ingot", "ftbskies:magic_steel");
  event.replaceInput({ mod: "ae2" }, "minecraft:iron_ingot", "immersiveengineering:plate_aluminum");
  event.replaceInput({ mod: "ae2" }, "minecraft:gold_ingot", "thermal:electrum_plate");
  event.replaceInput({ mod: "mekanism" }, "minecraft:gold_ingot", "thermal:gold_plate");
  event.replaceInput({ id: "pedestals:upgrades/upgrade_magnet" }, "minecraft:iron_ingot", "simplemagnets:basicmagnet");
  event.replaceInput({ id: "thermal:flux_magnet" }, "minecraft:iron_ingot", "ftbskies:space_plate");
  event.replaceInput({ id: "sophisticatedbackpacks:magnet_upgrade" }, "minecraft:iron_ingot", "ftbskies:space_plate");
  event.replaceInput({ id: "thermal:device_collector" }, "#forge:ingots/tin", "ftbskies:space_plate");
  event.replaceInput({ id: "cyclic:collector" }, "minecraft:iron_ingot", "ftbskies:space_plate");
  event.replaceInput({ id: "mekanism:processing/iron/enriched" }, "#forge:ingots/steel", "minecraft:iron_ingot");
  event.replaceInput({ not: eyeIngore }, "minecraft:ender_eye", "powah:ender_core");
  event.replaceInput({ not: plateIgnore }, "pneumaticcraft:ingot_iron_compressed", "jaopca:plates.compressed_iron");
  event.replaceInput({ not: plateIgnore }, "botania:manasteel_ingot", "jaopca:plates.manasteel");
  event.replaceInput({ not: plateIgnore }, "mekanism:ingot_steel", "immersiveengineering:plate_steel");
  event.replaceInput({ not: plateIgnore }, "thermal:electrum_ingot", "thermal:electrum_plate");
  event.replaceInput({ not: plateIgnore }, "thermal:invar_ingot", "thermal:invar_plate");
  event.replaceInput({ not: plateIgnore }, "thermal:constantan_ingot", "thermal:constantan_plate");
  event.replaceInput({ not: plateIgnore }, "thermal:signalum_ingot", "thermal:signalum_plate");
  event.replaceInput({ not: plateIgnore }, "thermal:lumium_ingot", "thermal:lumium_plate");
  event.replaceInput({ not: plateIgnore }, "thermal:enderium_ingot", "thermal:enderium_plate");
  event.replaceInput({ not: plateIgnore }, "minecraft:gold_ingot", "thermal:gold_plate");
  event.replaceInput({ not: plateIgnore }, "minecraft:iron_ingot", "thermal:iron_plate");
  event.replaceInput({ id: "pnuematicraft:refinery" }, "minecraft:redstone", "thermal:signalum_plate");

  event.replaceInput(
    { id: "ars_artifice:imbuement_spell_gem_upgrade_t1" },
    "ars_nouveau:source_gem",
    "minecraft:diamond"
  );
  event.replaceInput({ id: "botania:alchemy_catalyst" }, "minecraft:gold_ingot", "thermal:electrum_ingot");
  event.replaceInput({ id: "botania:alchemy_catalyst" }, "botania:mana_pearl", "ars_artifice:spell_gem_t3");

  //Simple compact machines
  event
    .shaped("compactmachines:machine_tiny", ["III", "TCT", "III"], {
      I: "#forge:plates/iron",
      T: "industrialforegoing:item_transporter_type",
      C: "#forge:storage_blocks/copper",
    })
    .id("ftbskies:compactmachine_tiny");

  event
    .shaped("compactmachines:machine_small", ["III", "ICI", "III"], {
      I: "#forge:plates/invar",
      C: "compactmachines:machine_tiny",
    })
    .id("ftbskies:compactmachine_small");

  // event.replaceInput({mod: "arsnouveau"}, "minecraft:gold_nugget", )
  event
    .custom({
      type: "mekanism:reaction",
      duration: 260,
      energyRequired: 10000,
      fluidInput: { amount: 1000, fluid: "ad_astra:cryo_fuel" },
      gasInput: { amount: 100, gas: "mekanism:hydrogen" },
      itemInput: { ingredient: { item: "elementalcraft:crude_water_gem" } },
      gasOutput: { amount: 250, gas: "kubejs:cryo_gas" },
    })
    .id("ftbskies:cryo_gas_mekanism");

  //Cognitium
  event
    .custom({
      type: "create:mixing",
      ingredients: [
        {
          item: "spirit:soul_powder",
        },
        {
          item: "thermal:quartz_dust",
        },
        {
          amount: 500,
          fluidTag: "forge:experience",
        },
      ],
      results: [
        {
          count: 2,
          item: "experienceobelisk:cognitive_flux",
        },
      ],
    })
    .id("ftbskies:cognitiveflux");

  //entangled block
  event.recipes.occultism
    .ritual(
      "entangled:block",
      [
        "occultism:afrit_essence",
        "thermal:machine_frame",
        "thermal:lumium_glass",
        "thermal:lumium_glass",
        "ae2:fluix_pearl",
      ],
      "createteleporters:quantum_mechanism",
      "occultism:craft_djinni"
    )
    .id("ftbskies:endtangled_block");

  //enderstorage
  event.recipes.occultism
    .ritual(
      "2x enderstorage:ender_chest",
      [
        "occultism:afrit_essence",
        "createteleporters:quantum_mechanism",
        "functionalstorage:ender_drawer",
        "functionalstorage:ender_drawer",
      ],
      "ae2:sky_stone_chest",
      "occultism:craft_djinni"
    )
    .id("ftbskies:ender_chest");

  event.recipes.occultism
    .ritual(
      "2x enderstorage:ender_tank",
      [
        "occultism:afrit_essence",
        "createteleporters:quantum_mechanism",
        "functionalstorage:ender_drawer",
        "functionalstorage:ender_drawer",
      ],
      "ae2:sky_stone_tank",
      "occultism:craft_djinni"
    )
    .id("ftbskies:ender_tank");

  //andesite to chunks
  event.shapeless("4x ftbskies:andesite_chunk", ["minecraft:andesite"]).id("ftbskies:andesite_to_chunks");
  //diorite to chunks
  event.shapeless("4x ftbskies:diorite_chunk", ["minecraft:diorite"]).id("ftbskies:diorite_to_chunks");
  //tuff to chunks
  event.shapeless("4x ftbskies:tuff_chunk", ["minecraft:tuff"]).id("ftbskies:tuff_to_chunks");

  event
    .shapeless("32x ftbskies:faux_amethyst_block", ["ars_nouveau:source_gem", "3x #forge:glass/colorless"])
    .id("ftbskies:faux_amethyst");

  event
    .custom({
      type: "immersiveengineering:metal_press",
      energy: 2400,
      mold: "immersiveengineering:mold_wire",
      input: { item: "create:dough" },
      result: { item: "farmersdelight:raw_pasta", count: 2 },
    })
    .id("ftbskies:pasta_metalpress");

  const compressingBlocks = ["dirt", "cobblestone", "gravel"];
  compressingBlocks.forEach((block) => {
    event
      .custom({
        type: "create:compacting",
        ingredients: [
          {
            item: `minecraft:${block}`,
          },
          {
            item: `minecraft:${block}`,
          },
          {
            item: `minecraft:${block}`,
          },
          {
            item: `minecraft:${block}`,
          },
          {
            item: `minecraft:${block}`,
          },
          {
            item: `minecraft:${block}`,
          },
          {
            item: `minecraft:${block}`,
          },
          {
            item: `minecraft:${block}`,
          },
          {
            item: `minecraft:${block}`,
          },
        ],
        results: [
          {
            item: `ftbskies:compressed_${block}`,
          },
        ],
      })
      .id(`ftbskies:compressed_${block}`);
  });

  //Space Plating Decorations
  event
    .shaped("32x ftbskies:deco_space_plating", ["CCC", "CBC", "CCC"], {
      C: "#forge:plates/iron",
      B: "ftbskies:space_plating_block",
    })
    .id("ftbskies:deco_space_plating");
  event.stonecutting("ftbskies:deco_space_plating_pipe", "ftbskies:deco_space_plating");
  event.stonecutting("ftbskies:deco_space_plating_broken_fan", "ftbskies:deco_space_plating");

  // Amethyst Shards
  event
    .custom({
      type: "immersiveengineering:crusher",
      energy: 6400,
      input: {
        item: "minecraft:amethyst_cluster",
      },
      result: {
        count: 4,
        item: "minecraft:amethyst_shard",
      },
      secondaries: [
        {
          chance: 0.25,
          output: {
            count: 2,
            item: "minecraft:amethyst_shard",
          },
        },
        {
          chance: 0.5,
          output: {
            count: 1,
            item: "minecraft:amethyst_shard",
          },
        },
      ],
    })
    .id("ftbskies:amethyst_shard_ie");

  event.custom({
    type: "thermal:pulverizer",
    ingredient: {
      item: "minecraft:amethyst_cluster",
    },
    result: [
      {
        item: "minecraft:amethyst_shard",
        chance: 2.0,
      },
      {
        item: "minecraft:amethyst_shard",
        chance: 0.5,
      },
      {
        item: "minecraft:amethyst_shard",
        chance: 0.33,
      },
    ],
    experience: 0.1,
  });

  // Custom Stuff for rockets

  // Stabilized Fire
  event
    .custom({
      type: "create:mixing",
      heatRequirement: "superheated",
      ingredients: [
        {
          amount: 250,
          fluid: "ftbskies:liquid_elemental_fire",
        },
        {
          item: "ftbskies:venus_blaze_dust",
        },
        {
          item: "cyclic:fireball",
        },
      ],
      results: [
        {
          amount: 250,
          fluid: "ftbskies:stabilized_fire",
        },
      ],
    })
    .id("ftbskies:stabilized_fire");

  // Molten Cheese
  event
    .custom({
      type: "thermal:crucible",
      ingredient: {
        item: "ad_astra:cheese",
      },
      result: [
        {
          fluid: "ftbskies:molten_cheese",
          amount: 100,
        },
      ],
      energy: 2000,
    })
    .id("ftbskies:molten_cheese");

  // Stabilized Void Ingot
  centrifugeRecipe(event, 200, "ftbskies:stabilized_void_ingot",true)
    .energyInput(1000000)
    .itemInput(Item.of("ftbskies:sentient_steel", 1))
    .fluidInput(Fluid.of("ftbskies:liquid_elemental_fire", 500))
    .itemOutput(Item.of("ftbskies:stabilized_void_ingot"))
    .build();

  //Enigmatic Control Circuit
  event
    .custom({
      type: "industrialforegoing:dissolution_chamber",
      input: [
        {
          tag: "forge:circuits/elite",
        },
        {
          tag: "forge:circuits/elite",
        },
        {
          tag: "forge:circuits/elite",
        },
        {
          tag: "forge:circuits/elite",
        },
        {
          tag: "forge:plates/lumium",
        },
        {
          item: "ftbskies:perfected_gem_catalyst",
        },
      ],
      inputFluid: '{Amount:200,FluidName:"ftbskies:polytetrafluoroethylene"}',
      output: {
        count: 1,
        item: "ftbskies:enigmatic_circuit",
      },
      processingTime: 400,
    })
    .id("ftbskies:enigmatic_control_circuit");

  // Weak Radiation Shielding
  centrifugeRecipe(event, 100, "ftbskies:weak_rad_shielding",true)
    .energyInput(250000)
    .itemInput(Item.of("#forge:plates/lead", 6))
    .fluidInput(Fluid.of("immersiveengineering:concrete", 1000))
    .itemOutput(Item.of("ftbskies:weak_rad_shielding"))
    .build();

  // Dimensional Attuned Calorite Plates
  event
    .custom({
      type: "mekanism:reaction",
      duration: 1600,
      energyRequired: 2500,
      fluidInput: { amount: 250, fluid: "ftbskies:methane" },
      gasInput: { amount: 100, gas: "kubejs:resonant_gas" },
      itemInput: { amount: 1, ingredient: { item: "ad_astra:calorite_plate" } },
      itemOutput: { item: "ftbskies:dimensionally_attuned_calorite_plate" },
    })
    .id("ftbskies:dimensionally_attuned_calorite_plate");

//shelves
  event.smithing("apotheosis:dormant_deepshelf", "apotheosis:infused_hellshelf", "reaper:rune_obitus").id("ftbskies:deepshelf");
  event.smithing("apotheosis:endshelf", "apotheosis:deepshelf", "powah:ender_core").id("ftbskies:endshelf");

  // Desh Space Plate
  quantumAssemblerRecipe(event, 50, "ftbskies:desh_space_plate")
    .energyInput(1000000)
    .fluidInput(Fluid.of("ftbskies:molten_cheese", 25))
    .itemInput(Item.of("ftbskies:space_plate", 1))
    .itemInput(Item.of("ftbskies:platinum_plate", 1))
    .itemInput(Item.of("mekanism:enriched_carbon", 2))
    .itemInput(Item.of("#forge:plates/desh", 1))
    .itemOutput(Item.of("ftbskies:desh_space_plate", 1))
    .build();

  //osmium infused ostrum
  event
    .custom({
      type: "mekanism:compressing",
      chemicalInput: { amount: 1, gas: "mekanism:osmium" },
      itemInput: { ingredient: { tag: "forge:ingots/ostrum" } },
      output: { item: "ftbskies:osmium_infused_ostrum_ingot" },
    })
    .id("ftbskies:osmium_infused_ostrum_ingot");

  //plate
  event.custom({
    type: "thermal:press",
    ingredient: {
      item: "ftbskies:osmium_infused_ostrum_ingot",
    },
    result: [
      {
        item: "ftbskies:osmium_infused_ostrum_plate",
      },
    ],
  });

  event.custom({
    type: "create:pressing",
    ingredients: [
      {
        item: "ftbskies:osmium_infused_ostrum_ingot",
      },
    ],
    results: [
      {
        item: "ftbskies:osmium_infused_ostrum_plate",
      },
    ],
  });

  // Ostrum Space Plate
  quantumAssemblerRecipe(event, 50, "ftbskies:ostrum_space_plate")
    .energyInput(15000000)
    .fluidInput(Fluid.of("ftbskies:polytetrafluoroethylene", 25))
    .itemInput(Item.of("ftbskies:desh_space_plate", 1))
    .itemInput(Item.of("ftbskies:osmium_infused_ostrum_plate", 1))
    .itemInput(Item.of("jaopca:plates.refined_obsidian", 1))
    .itemInput(Item.of("mekanism:enriched_diamond", 2))
    .itemOutput(Item.of("ftbskies:ostrum_space_plate", 1))
    .build();

  // Calorite Space Plate
  quantumAssemblerRecipe(event, 50, "ftbskies:calorite_space_plate")
    .energyInput(25000000)
    .fluidInput(Fluid.of("ftbskies:stabilized_fire", 25))
    .itemInput(Item.of("ftbskies:ostrum_space_plate", 1))
    .itemInput(Item.of("ftbskies:dimensionally_attuned_calorite_plate", 1))
    .itemInput(Item.of("jaopca:plates.force", 1))
    .itemInput(Item.of("mekanism:enriched_diamond", 4))
    .itemOutput(Item.of("ftbskies:calorite_space_plate", 1))
    .build();

  // Desh Space Block
  event
    .custom({
      type: "create:sequenced_assembly",
      ingredient: {
        item: "immersiveengineering:sheetmetal_aluminum",
      },
      loops: 4,
      results: [
        {
          item: "ftbskies:desh_space_plating_block",
        },
      ],
      sequence: [
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "ftbskies:incomplete_desh_space_plating_block",
            },
            {
              item: "ftbskies:desh_space_plate",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_desh_space_plating_block",
            },
          ],
        },
        {
          type: "create:filling",
          ingredients: [
            {
              item: "ftbskies:incomplete_desh_space_plating_block",
            },
            {
              amount: 250,
              fluid: "hexerei:quicksilver_fluid",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_desh_space_plating_block",
            },
          ],
        },
        {
          type: "create:pressing",
          ingredients: [
            {
              item: "ftbskies:incomplete_desh_space_plating_block",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_desh_space_plating_block",
            },
          ],
        },
      ],
      transitionalItem: {
        item: "ftbskies:incomplete_desh_space_plating_block",
      },
    })
    .id("ftbskies:desh_space_plating_block");

  // Ostrum Space Block
  event
    .custom({
      type: "create:sequenced_assembly",
      ingredient: {
        item: "thermal:lead_plate",
      },
      loops: 4,
      results: [
        {
          item: "ftbskies:ostrum_space_plating_block",
        },
      ],
      sequence: [
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "ftbskies:incomplete_ostrum_space_plating_block",
            },
            {
              item: "ftbskies:ostrum_space_plate",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_ostrum_space_plating_block",
            },
          ],
        },
        {
          type: "create:filling",
          ingredients: [
            {
              item: "ftbskies:incomplete_ostrum_space_plating_block",
            },
            {
              amount: 100,
              fluid: "mekanism:lithium",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_ostrum_space_plating_block",
            },
          ],
        },
        {
          type: "create:pressing",
          ingredients: [
            {
              item: "ftbskies:incomplete_ostrum_space_plating_block",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_ostrum_space_plating_block",
            },
          ],
        },
      ],
      transitionalItem: {
        item: "ftbskies:incomplete_ostrum_space_plating_block",
      },
    })
    .id("ftbskies:ostrum_space_plating_block");

  // Ultramafic lava
  event
    .custom({
      type: "mekanism:evaporating",
      input: {
        amount: 10,
        tag: "minecraft:lava",
      },
      output: {
        amount: 1,
        fluid: "ftbskies:ultramafic_lava",
      },
    })
    .id("ftbskies:ultramafic_lava");

  //cryotheum
  event
    .custom({
      type: "pneumaticcraft:thermo_plant",
      air_use_multiplier: 2.0,
      exothermic: true,
      fluid_input: {
        type: "pneumaticcraft:fluid",
        amount: 1000,
        fluid: "ad_astra:cryo_fuel",
      },
      item_input: {
        item: "thermal:blizz_powder",
      },
      item_output: {
        item: "ftbskies:cryotheum",
      },
      pressure: 3.0,
      speed: 0.2,
      temperature: {
        max_temp: 33,
        min_temp: 1,
      },
    })
    .id("ftbskies:cryotheum");

  //nitro diesel
  event
    .custom({
      type: "mekanism:reaction",
      duration: 160,
      energyRequired: 800000,
      fluidInput: { amount: 100, fluid: "ftbskies:flux_diesel" },
      gasInput: { amount: 30, gas: "kubejs:benzene_gas" },
      gasOutput: { amount: 100, gas: "kubejs:nitro_gas" },
      itemInput: { amount: 1, ingredient: { item: "ftbskies:cryotheum" } },
      itemOutput: { item: "minecraft:snowball" },
    })
    .id("ftbskies:nitro_diesel");

  // Resonant Liquid
  event
    .custom({
      type: "pneumaticcraft:thermo_plant",
      exothermic: true,
      fluid_input: {
        type: "pneumaticcraft:fluid",
        amount: 250,
        fluid: "industrialforegoing:ether_gas",
      },
      item_input: {
        item: "rftoolsbase:dimensionalshard",
      },
      fluid_output: {
        type: "pneumaticcraft:fluid",
        amount: 250,
        fluid: "ftbskies:resonant_liquid",
      },
      temperature: {
        min_temp: 1999,
      },
      pressure: 4.0,
      speed: 0.5,
    })
    .id("ftbskies:resonant_liqiud");

  // Resonant Gas
  event
    .custom({
      type: "mekanism:rotary",
      fluidInput: {
        amount: 1,
        fluid: "ftbskies:resonant_liquid",
      },
      fluidOutput: {
        amount: 1,
        fluid: "ftbskies:resonant_liquid",
      },
      gasInput: {
        amount: 1,
        gas: "kubejs:resonant_gas",
      },
      gasOutput: {
        amount: 1,
        gas: "kubejs:resonant_gas",
      },
    })
    .id("ftbskies:resonant_gas_conversion");

  // Calorite Space Block
  event
    .custom({
      type: "create:sequenced_assembly",
      ingredient: {
        item: "thermal:electrum_plate",
      },
      loops: 4,
      results: [
        {
          item: "ftbskies:calorite_space_plating_block",
        },
      ],
      sequence: [
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "ftbskies:incomplete_calorite_space_plating_block",
            },
            {
              item: "ftbskies:calorite_space_plate",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_calorite_space_plating_block",
            },
          ],
        },
        {
          type: "create:filling",
          ingredients: [
            {
              item: "ftbskies:incomplete_calorite_space_plating_block",
            },
            {
              amount: 250,
              fluid: "ftbskies:liquid_elemental_void",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_calorite_space_plating_block",
            },
          ],
        },
        {
          type: "create:pressing",
          ingredients: [
            {
              item: "ftbskies:incomplete_calorite_space_plating_block",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_calorite_space_plating_block",
            },
          ],
        },
      ],
      transitionalItem: {
        item: "ftbskies:incomplete_calorite_space_plating_block",
      },
    })
    .id("ftbskies:calorite_space_plating_block");

  //heart of the sea
  event
    .custom({
      type: "botania:mana_infusion",
      input: {
        item: "minecraft:nautilus_shell",
      },
      output: {
        item: "minecraft:heart_of_the_sea",
      },
      mana: 20000,
      catalyst: {
        type: "block",
        block: "botania:alchemy_catalyst",
      },
    })
    .id("ftbskies:heart_of_the_sea");

  event.custom({
    type: "immersiveengineering:metal_press",
    energy: 2400,
    input: { tag: "forge:ingots/platinum" },
    mold: "immersiveengineering:mold_plate",
    result: { item: "ftbskies:platinum_plate" },
  }).id("ftbskies:immersive_platinum_plate");

  // Ender Chest
  quantumAssemblerRecipe(event, 100, "ftbskies:quantum_ender_chest")
    .energyInput(2000000)
    .itemInput(Item.of("occultism:afrit_essence", 1))
    .itemInput(Item.of("createteleporters:quantum_mechanism", 1))
    .itemInput(Item.of("ae2:sky_stone_chest", 1))
    .itemInput(Item.of("functionalstorage:ender_drawer", 2))
    .itemOutput(Item.of("enderstorage:ender_chest", 2))
    .build();

  // Ender Tank
  quantumAssemblerRecipe(event, 100, "ftbskies:quantum_ender_tank")
    .energyInput(2000000)
    .itemInput(Item.of("occultism:afrit_essence", 1))
    .itemInput(Item.of("createteleporters:quantum_mechanism", 1))
    .itemInput(Item.of("ae2:sky_stone_tank", 1))
    .itemInput(Item.of("functionalstorage:ender_drawer", 2))
    .itemOutput(Item.of("enderstorage:ender_tank", 2))
    .build();

  quantumAssemblerRecipe(event, 100, "ftbskies:entangled_block")
    .energyInput(1000000)
    .itemInput(Item.of("occultism:afrit_essence", 1))
    .itemInput(Item.of("createteleporters:quantum_mechanism", 1))
    .itemInput(Item.of("thermal:machine_frame", 1))
    .itemInput(Item.of("thermal:lumium_glass", 2))
    .itemInput(Item.of("ae2:fluix_pearl", 1))
    .itemOutput(Item.of("entangled:block", 1))
    .build();

  event
    .custom({
      type: "thermal:smelter",
      ingredients: [
        {
          value: [
            {
              item: "mekanism:ingot_tin",
            },
          ],
          count: 6,
        },
        {
          value: [
            {
              item: "minecraft:copper_ingot",
            },
          ],
          count: 1,
        },
        {
          value: [
            {
              item: "minecraft:redstone",
            },
          ],
          count: 2,
        },
      ],
      result: [
        {
          item: "ftbskies:conductive_soldering_alloy",
          count: 2,
        },
      ],
      energy: 1600,
    })
    .id("ftbskies:conductive_soldering_alloy");

  event
    .shaped("minecraft:tinted_glass", [" D ", "DGD", " D "], {
      D: "#forge:dyes/black",
      G: "minecraft:glass",
    })
    .id("ftbskies:tinted_glass");

  event
    .shaped("ftbskies:wolf_sushi", ["   ", "RDR", "KKK"], {
      R: "farmersdelight:cooked_rice",
      D: "farmersdelight:dog_food",
      K: "minecraft:dried_kelp",
    })
    .id("ftbskies:wolf_sushi");

  //Copper Oxidation in Elemental Infuser
  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "minecraft:copper_block",
      },
      output: {
        item: "minecraft:exposed_copper",
      },
    })
    .id("ftbskies:copper_block_ox_1");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "minecraft:exposed_copper",
      },
      output: {
        item: "minecraft:weathered_copper",
      },
    })
    .id("ftbskies:copper_block_ox_2");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "minecraft:weathered_copper",
      },
      output: {
        item: "minecraft:oxidized_copper",
      },
    })
    .id("ftbskies:copper_block_ox_3");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "minecraft:cut_copper",
      },
      output: {
        item: "minecraft:exposed_cut_copper",
      },
    })
    .id("ftbskies:cut_copper_ox_1");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "minecraft:exposed_cut_copper",
      },
      output: {
        item: "minecraft:weathered_cut_copper",
      },
    })
    .id("ftbskies:cut_copper_ox_2");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "minecraft:weathered_cut_copper",
      },
      output: {
        item: "minecraft:oxidized_cut_copper",
      },
    })
    .id("ftbskies:cut_copper_ox_3");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "minecraft:cut_copper_stairs",
      },
      output: {
        item: "minecraft:exposed_cut_copper_stairs",
      },
    })
    .id("ftbskies:cut_copper_stairs_ox_1");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "minecraft:exposed_cut_copper_stairs",
      },
      output: {
        item: "minecraft:weathered_cut_copper_stairs",
      },
    })
    .id("ftbskies:cut_copper_stairs_ox_2");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "minecraft:weathered_cut_copper_stairs",
      },
      output: {
        item: "minecraft:oxidized_cut_copper_stairs",
      },
    })
    .id("ftbskies:cut_copper_stairs_ox_3");

  // Create Copper Oxidation

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "create:copper_shingles",
      },
      output: {
        item: "create:exposed_copper_shingles",
      },
    })
    .id("ftbskies:copper_shingle_block_ox_1");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "create:exposed_copper_shingles",
      },
      output: {
        item: "create:weathered_copper_shingles",
      },
    })
    .id("ftbskies:copper_shingle_block_ox_2");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "create:weathered_copper_shingles",
      },
      output: {
        item: "create:oxidized_copper_shingles",
      },
    })
    .id("ftbskies:copper_shingle_block_ox_3");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "create:copper_tiles",
      },
      output: {
        item: "create:exposed_copper_tiles",
      },
    })
    .id("ftbskies:copper_tile_ox_1");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "create:exposed_copper_tiles",
      },
      output: {
        item: "create:weathered_copper_tiles",
      },
    })
    .id("ftbskies:copper_tile_ox_2");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "create:weathered_copper_tiles",
      },
      output: {
        item: "create:oxidized_copper_tiles",
      },
    })
    .id("ftbskies:copper_tile_ox_3");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "create:copper_shingle_stairs",
      },
      output: {
        item: "create:exposed_copper_shingle_stairs",
      },
    })
    .id("ftbskies:cut_copper_shingle_stairs_ox_1");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "create:exposed_copper_shingle_stairs",
      },
      output: {
        item: "create:weathered_copper_shingle_stairs",
      },
    })
    .id("ftbskies:copper_shingle_stairs_ox_2");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "create:weathered_copper_shingle_stairs",
      },
      output: {
        item: "create:oxidized_copper_shingle_stairs",
      },
    })
    .id("ftbskies:copper_shingle_stairs_ox_3");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "create:copper_tile_stairs",
      },
      output: {
        item: "create:exposed_copper_tile_stairs",
      },
    })
    .id("ftbskies:cut_copper_tile_stairs_ox_1");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "create:exposed_copper_tile_stairs",
      },
      output: {
        item: "create:weathered_copper_tile_stairs",
      },
    })
    .id("ftbskies:copper_tile_stairs_ox_2");

  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 10,
      element_type: "water",
      input: {
        item: "create:weathered_copper_tile_stairs",
      },
      output: {
        item: "create:oxidized_copper_tile_stairs",
      },
    })
    .id("ftbskies:copper_tile_stairs_ox_3");

    //Magically Imbued Soils ======================================================================

    //Lightly Imbued Magical Soil
    event.custom({
      type: "elementalcraft:infusion",
      element_amount: 1000,
      element_type: "earth",
      input: {
        item: "cyclic:terra_preta",
      },
      output: {
        item: "ftbskies:lightly_magical_imbued_soil",
      },
    }).id("ftbskies:lightly_magical_imbued_soil");

    //Magical Soil
    event.custom({
      type: "create:mixing",
      ingredients: [
        {
          item: "ftbskies:lightly_magical_imbued_soil",
        },
        {
          item: "ars_nouveau:earth_essence",
        },
        {
          item: "hexerei:moon_dust",
        },
        {
          fluid: "sliceanddice:fertilizer",
          "amount": 1000
        },
      ],
      results: [
        {
          "amount": 1,
          "item": "ftbskies:magical_imbued_soil"
        },
      ],
    }).id("ftbskies:magical_imbued_soil");

    //Densely Magical Soil
    event.custom({
      type: "botania:runic_altar",
      ingredients: [
        {
          item: "ftbskies:magical_imbued_soil",
        },
        {
          item: "botania:rune_summer",
        },
        {
          item: "elementalcraft:pristine_earth_gem",
        },
        {
          item: "farmingforblockheads:green_fertilizer",
        },
        {
          item: "farmingforblockheads:red_fertilizer",
        },
        {
          item: "farmingforblockheads:yellow_fertilizer",
        },
      ],
      mana: 60000,
      output: {
        count: 1,
        item: "ftbskies:densely_magical_imbued_soil",
      },
    }).id("ftbskies:densely_magical_imbued_soil");

    //Unstable Blocks to Unstable Ingots
    event.shapeless("9x unstabletools:unstable_ingot", ["unstabletools:unstable_block"]).id("ftbskies:unstable_uncompress");

    // ============================================================================================
});
