ServerEvents.recipes((event) => {


  //Rocket Melt Down
  event
    .custom({
      type: "immersiveengineering:arc_furnace",
      additives: [],
      energy: 102400,
      input: { item: "ad_astra:tier_1_rocket" },
      results: [{ item: "ftbskies:space_plating_block", count: 64 }],
      time: 200,
    })
    .id("ftbskies:rocket_recycle_1");

    event
    .custom({
      type: "immersiveengineering:arc_furnace",
      additives: [],
      energy: 102400,
      input: { item: "ad_astra:tier_2_rocket" },
      results: [{ item: "ftbskies:space_plating_block", count: 64 }],
      time: 200,
    })
    .id("ftbskies:rocket_recycle_2");

    event
    .custom({
      type: "immersiveengineering:arc_furnace",
      additives: [],
      energy: 102400,
      input: { item: "ad_astra:tier_3_rocket" },
      results: [{ item: "ftbskies:space_plating_block", count: 64 }],
      time: 200,
    })
    .id("ftbskies:rocket_recycle_3");



  //NASA Workbench
  event
    .shaped("ad_astra:nasa_workbench", ["DSL", "PRP", "HFH"], {
      D: "pneumaticcraft:assembly_drill",
      S: "minecraft:lever",
      L: "pneumaticcraft:assembly_laser",
      R: "immersiveengineering:rs_engineering",
      P: "pneumaticcraft:printed_circuit_board",
      H: "immersiveengineering:heavy_engineering",
      F: "industrialforegoing:machine_frame_simple",
    })
    .id("ftbskies:nasabench");

  //Rocket Fuel
  event
    .custom({
      type: "pneumaticcraft:fluid_mixer",
      fluid_output: {
        amount: 50,
        fluid: "ad_astra:fuel",
      },
      input1: {
        type: "pneumaticcraft:fluid",
        amount: 25,
        fluid: "pneumaticcraft:biodiesel",
      },
      input2: {
        type: "pneumaticcraft:fluid",
        amount: 25,
        tag: "forge:source",
      },
      pressure: 4.0,
      time: 300,
    })
    .id("ftbskies:rocket_fuel_from_biodiesel");

      //Rocket Fuel
  event
  .custom({
    type: "pneumaticcraft:fluid_mixer",
    fluid_output: {
      amount: 50,
      fluid: "ad_astra:fuel",
    },
    input1: {
      type: "pneumaticcraft:fluid",
      amount: 25,
      fluid: "pneumaticcraft:diesel",
    },
    input2: {
      type: "pneumaticcraft:fluid",
      amount: 25,
      tag: "forge:source",
    },
    pressure: 4.0,
    time: 300,
  })
  .id("ftbskies:rocket_fuel_from_diesel");

  //Oxygen Loader
  event
    .shaped("ad_astra:oxygen_loader", ["DGD", "DTD", "DGD"], {
      D: "#ad_astra_platform:desh_plates",
      T: "pneumaticcraft:medium_tank",
      G: "#thermal:glass/hardened",
    })
    .id("ftbskies:cheaper_oxygen_loader");


  //Tier 1 Rocket
  event
    .custom({
      type: "ad_astra:nasa_workbench",
      ingredients: [
        {
          ingredient: {
            item: "ad_astra:rocket_nose_cone",
          },
        },
        {
          ingredient: {
            tag: "ad_astra_platform:steel_blocks",
          },
        },
        {
          ingredient: {
            tag: "ad_astra_platform:steel_blocks",
          },
        },
        {
          ingredient: {
            item: "immersiveengineering:heavy_engineering",
          },
        },
        {
          ingredient: {
            item: "immersiveengineering:heavy_engineering",
          },
        },
        {
          ingredient: {
            tag: "ad_astra_platform:steel_blocks",
          },
        },
        {
          ingredient: {
            tag: "ad_astra_platform:steel_blocks",
          },
        },
        {
          ingredient: {
            item: "ad_astra:rocket_fin",
          },
        },
        {
          ingredient: {
            item: "ad_astra:steel_tank",
          },
        },
        {
          ingredient: {
            item: "ad_astra:steel_tank",
          },
        },
        {
          ingredient: {
            item: "ad_astra:rocket_fin",
          },
        },
        {
          ingredient: {
            item: "ad_astra:rocket_fin",
          },
        },
        {
          ingredient: {
            item: "ad_astra:steel_engine",
          },
        },
        {
          ingredient: {
            item: "ad_astra:rocket_fin",
          },
        },
      ],
      output: "ad_astra:tier_1_rocket",
    })
    .id("ftbskies:tier1rocket");

  //Space Suit ===================================================================

  //Helmet
  event
    .shaped("ad_astra:space_helmet", ["   ", "PPP", "PHP"], {
      P: "ftbskies:space_plate",
      H: "thermal:obsidian_glass",
    })
    .id("ftbskies:spacesuit_helmet");

  //Suit
  event
    .shaped("ad_astra:space_suit", ["PFP", "TGT", "PFP"], {
      P: "ftbskies:space_plate",
      F: "thermal:hazmat_fabric",
      T: "ad_astra:oxygen_tank",
      G: "ad_astra:oxygen_gear",
    })
    .id("ftbskies:spacesuit_suit");

  //Suit
  event
    .shaped("ad_astra:space_pants", ["PPP", "F F", "P P"], {
      P: "ftbskies:space_plate",
      F: "thermal:hazmat_fabric",
    })
    .id("ftbskies:spacesuit_pants");

  //Suit
  event
    .shaped("ad_astra:space_boots", ["   ", "F F", "P P"], {
      P: "ftbskies:space_plate",
      F: "thermal:hazmat_fabric",
    })
    .id("ftbskies:spacesuit_boots");

  //==============================================================================

  //Desh Dust into Ingot
  event
    .custom({
      type: "immersiveengineering:arc_furnace",
      additives: [],
      energy: 1228800,
      input: { tag: "forge:dusts/desh" },
      results: [{ tag: "forge:ingots/desh" }],
      time: 600,
    })
    .id("ftbskies:desh_dust_to_desh_ingot");

  //Ostrum Dust into Ingot
  event
    .custom({
      type: "immersiveengineering:arc_furnace",
      additives: [],
      energy: 1628800,
      input: { tag: "forge:dusts/ostrum" },
      results: [{ tag: "forge:ingots/ostrum" }],
      time: 600,
    })
    .id("ftbskies:ostrum_dust_to_ostrum_ingot");

  //Calroite Dust into Ingot
  event
  .custom({
    type: "immersiveengineering:arc_furnace",
    additives: [],
    energy: 2228800,
    input: { tag: "forge:dusts/calorite" },
    results: [{ tag: "forge:ingots/calorite" }],
    time: 600,
  })
  .id("ftbskies:calorite_dust_to_calorite_ingot");

  //Energizer
  event
    .shaped("ad_astra:energizer", ["PDP", "PLP", "DBD"], {
      P: "ad_astra:desh_plate",
      B: "ad_astra:desh_block",
      D: "create_new_age:overcharged_diamond",
      L: "botanicadds:mana_lapis_block",
    })
    .id("ftbskies:ad_astra_energizer");

  event
    .custom({
      type: "ad_astra:lunarian_trade_simple",
      buyA: {
        count: 24,
        id: "thermal:enderium_coin",
      },
      experience: 100,
      level: 1,
      profession: "minecraft:farmer",
      sell: {
        count: 1,
        id: "tropicraft:palm_sapling",
      },
    })
    .id("ftbskies:lunarian_trade_palm_sapling");

  // Miniaturization Crafting
  event
    .custom({
      type: "compactcrafting:miniaturization",
      recipeSize: 5,
      layers: [
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["O", "O", "O", "O", "O"],
            ["O", "O", "O", "O", "O"],
            ["O", "O", "H", "O", "O"],
            ["O", "O", "O", "O", "O"],
            ["O", "O", "O", "O", "O"],
          ],
        },
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["O", "O", "O", "O", "O"],
            ["O", "O", "P", "O", "O"],
            ["O", "P", "H", "P", "O"],
            ["O", "O", "P", "O", "O"],
            ["O", "O", "O", "O", "O"],
          ],
        },
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["O", "O", "P", "O", "O"],
            ["O", "O", "L", "O", "O"],
            ["P", "L", "H", "L", "P"],
            ["O", "O", "L", "O", "O"],
            ["O", "O", "P", "O", "O"],
          ],
        },
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["O", "O", "P", "O", "O"],
            ["O", "O", "P", "O", "O"],
            ["P", "P", "O", "P", "P"],
            ["O", "O", "P", "O", "O"],
            ["O", "O", "P", "O", "O"],
          ],
        },
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["O", "O", "P", "O", "O"],
            ["O", "O", "O", "O", "O"],
            ["P", "O", "O", "O", "P"],
            ["O", "O", "O", "O", "O"],
            ["O", "O", "P", "O", "O"],
          ],
        },
      ],
      catalyst: {
        id: "ftbskies:space_plate",
        Count: 1,
      },
      components: {
        P: {
          type: "compactcrafting:block",
          block: "ftbskies:space_plating_block",
        },
        H: {
          type: "compactcrafting:block",
          block: "immersiveengineering:heavy_engineering",
        },
        L: {
          type: "compactcrafting:block",
          block: "immersiveengineering:light_engineering",
        },
        O: {
          type: "compactcrafting:block",
          block: "minecraft:air",
        },
      },
      outputs: [
        {
          id: "ad_astra:rocket_fin",
          Count: 4,
        },
      ],
    })
    .id("ftbskies:ad_astra/rocket_fin");

  event
    .custom({
      type: "compactcrafting:miniaturization",
      recipeSize: 5,
      layers: [
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["O", "O", "O", "O", "O"],
            ["O", "O", "O", "O", "O"],
            ["O", "O", "L", "O", "O"],
            ["O", "O", "O", "O", "O"],
            ["O", "O", "O", "O", "O"],
          ],
        },
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["O", "O", "O", "O", "O"],
            ["O", "O", "O", "O", "O"],
            ["O", "O", "P", "O", "O"],
            ["O", "O", "O", "O", "O"],
            ["O", "O", "O", "O", "O"],
          ],
        },
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["O", "O", "O", "O", "O"],
            ["O", "O", "P", "O", "O"],
            ["O", "P", "P", "P", "O"],
            ["O", "O", "P", "O", "O"],
            ["O", "O", "O", "O", "O"],
          ],
        },
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["O", "O", "O", "O", "O"],
            ["O", "P", "P", "P", "O"],
            ["O", "P", "P", "P", "O"],
            ["O", "P", "P", "P", "O"],
            ["O", "O", "O", "O", "O"],
          ],
        },
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["O", "P", "P", "P", "O"],
            ["P", "P", "O", "P", "P"],
            ["P", "O", "O", "O", "P"],
            ["P", "P", "O", "P", "P"],
            ["O", "P", "P", "P", "O"],
          ],
        },
      ],
      catalyst: {
        id: "ftbskies:space_plate",
        Count: 1,
      },
      components: {
        P: {
          type: "compactcrafting:block",
          block: "ftbskies:space_plating_block",
        },
        L: {
          type: "compactcrafting:block",
          block: "minecraft:lightning_rod",
        },
        O: {
          type: "compactcrafting:block",
          block: "minecraft:air",
        },
      },
      outputs: [
        {
          id: "ad_astra:rocket_nose_cone",
          Count: 1,
        },
      ],
    })
    .id("ftbskies:ad_astra/rocket_nose_cone");

  event
    .custom({
      type: "compactcrafting:miniaturization",
      recipeSize: 3,
      layers: [
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["L", "L", "L"],
            ["L", "E", "L"],
            ["L", "L", "L"],
          ],
        },
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["L", "G", "L"],
            ["T", "C", "T"],
            ["L", "G", "L"],
          ],
        },
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["H", "H", "H"],
            ["H", "R", "H"],
            ["H", "H", "H"],
          ],
        },
      ],
      catalyst: {
        id: "ftbskies:space_plate",
        Count: 1,
      },
      components: {
        H: {
          type: "compactcrafting:block",
          block: "immersiveengineering:heavy_engineering",
        },
        L: {
          type: "compactcrafting:block",
          block: "immersiveengineering:light_engineering",
        },
        R: {
          type: "compactcrafting:block",
          block: "immersiveengineering:rs_engineering",
        },
        T: {
          type: "compactcrafting:block",
          block: "pneumaticcraft:medium_tank",
        },
        C: {
          type: "compactcrafting:block",
          block: "immersiveengineering:coil_lv",
        },
        E: {
          type: "compactcrafting:block",
          block: "immersiveengineering:radiator",
        },
        G: {
          type: "compactcrafting:block",
          block: "thermal:obsidian_glass",
        },
      },
      outputs: [
        {
          id: "ad_astra:oxygen_loader",
          Count: 1,
        },
      ],
    })
    .id("ftbskies:ad_astra/oxygen_loader");

  // Tiered Rockets
  const tieredRockets = [
    [
      "ad_astra:steel_engine",
      "ad_astra:steel_tank",
      "ftbskies:space_plating_block",
      "compressedcreativity:compressed_air_engine",
      "ftbskies:space_plate",
    ],
    [
      "ad_astra:desh_engine",
      "ad_astra:desh_tank",
      "ftbskies:desh_space_plating_block",
      "createaddition:electric_motor",
      "ftbskies:desh_space_plate",
    ],
    [
      "ad_astra:ostrum_engine",
      "ad_astra:ostrum_tank",
      "ftbskies:ostrum_space_plating_block",
      "ae2:64k_crafting_storage",
      "ftbskies:ostrum_space_plate",
    ],
    [
      "ad_astra:calorite_engine",
      "ad_astra:calorite_tank",
      "ftbskies:calorite_space_plating_block",
      "ae2:256k_crafting_storage",
      "ftbskies:calorite_space_plate",
    ],
  ];

  tieredRockets.forEach((rocket) => {
    event
      .custom({
        type: "compactcrafting:miniaturization",
        recipeSize: 5,
        layers: [
          {
            type: "compactcrafting:mixed",
            pattern: [
              ["O", "O", "O", "O", "O"],
              ["O", "O", "P", "O", "O"],
              ["O", "P", "L", "P", "O"],
              ["O", "O", "P", "O", "O"],
              ["O", "O", "O", "O", "O"],
            ],
          },
          {
            type: "compactcrafting:mixed",
            pattern: [
              ["O", "O", "O", "O", "O"],
              ["O", "O", "P", "O", "O"],
              ["O", "P", "S", "P", "O"],
              ["O", "O", "P", "O", "O"],
              ["O", "O", "O", "O", "O"],
            ],
          },
          {
            type: "compactcrafting:mixed",
            pattern: [
              ["O", "O", "O", "O", "O"],
              ["O", "P", "R", "P", "O"],
              ["O", "R", "G", "R", "O"],
              ["O", "P", "R", "P", "O"],
              ["O", "O", "O", "O", "O"],
            ],
          },
          {
            type: "compactcrafting:mixed",
            pattern: [
              ["O", "P", "P", "P", "O"],
              ["P", "H", "H", "H", "P"],
              ["P", "H", "O", "H", "P"],
              ["P", "H", "H", "H", "P"],
              ["O", "P", "P", "P", "O"],
            ],
          },
          {
            type: "compactcrafting:mixed",
            pattern: [
              ["O", "H", "H", "H", "O"],
              ["H", "O", "O", "O", "H"],
              ["H", "O", "O", "O", "H"],
              ["H", "O", "O", "O", "H"],
              ["O", "H", "H", "H", "O"],
            ],
          },
        ],
        catalyst: {
          id: `${rocket[4]}`,
          Count: 1,
        },
        components: {
          P: {
            type: "compactcrafting:block",
            block: `${rocket[2]}`,
          },
          H: {
            type: "compactcrafting:block",
            block: "immersiveengineering:heavy_engineering",
          },
          L: {
            type: "compactcrafting:block",
            block: "immersiveengineering:light_engineering",
          },
          R: {
            type: "compactcrafting:block",
            block: "immersiveengineering:radiator",
          },
          G: {
            type: "compactcrafting:block",
            block: `${rocket[3]}`,
          },
          S: {
            type: "compactcrafting:block",
            block: "immersiveengineering:rs_engineering",
          },
          O: {
            type: "compactcrafting:block",
            block: "minecraft:air",
          },
        },
        outputs: [
          {
            id: `${rocket[0]}`,
            Count: 1,
          },
        ],
      })
      .id("ftbskies:ad_astra/" + rocket[0].split(":")[1]);

    event
      .custom({
        type: "compactcrafting:miniaturization",
        recipeSize: 5,
        layers: [
          {
            type: "compactcrafting:mixed",
            pattern: [
              ["O", "P", "P", "P", "O"],
              ["P", "P", "P", "P", "P"],
              ["P", "P", "P", "P", "P"],
              ["P", "P", "P", "P", "P"],
              ["O", "P", "P", "P", "O"],
            ],
          },
          {
            type: "compactcrafting:mixed",
            pattern: [
              ["O", "P", "G", "P", "O"],
              ["P", "T", "T", "T", "P"],
              ["G", "T", "T", "T", "G"],
              ["P", "T", "T", "T", "P"],
              ["O", "P", "G", "P", "O"],
            ],
          },
          {
            type: "compactcrafting:mixed",
            pattern: [
              ["O", "P", "G", "P", "O"],
              ["P", "T", "T", "T", "P"],
              ["G", "T", "T", "T", "G"],
              ["P", "T", "T", "T", "P"],
              ["O", "P", "G", "P", "O"],
            ],
          },
          {
            type: "compactcrafting:mixed",
            pattern: [
              ["O", "P", "G", "P", "O"],
              ["P", "T", "T", "T", "P"],
              ["G", "T", "T", "T", "G"],
              ["P", "T", "T", "T", "P"],
              ["O", "P", "G", "P", "O"],
            ],
          },
          {
            type: "compactcrafting:mixed",
            pattern: [
              ["O", "P", "P", "P", "O"],
              ["P", "P", "P", "P", "P"],
              ["P", "P", "P", "P", "P"],
              ["P", "P", "P", "P", "P"],
              ["O", "P", "P", "P", "O"],
            ],
          },
        ],
        catalyst: {
          id: `${rocket[4]}`,
          Count: 1,
        },
        components: {
          P: {
            type: "compactcrafting:block",
            block: `${rocket[2]}`,
          },
          G: {
            type: "compactcrafting:block",
            block: "thermal:obsidian_glass",
          },
          T: {
            type: "compactcrafting:block",
            block: "mekanism:dynamic_tank",
          },
          O: {
            type: "compactcrafting:block",
            block: "minecraft:air",
          },
        },
        outputs: [
          {
            id: `${rocket[1]}`,
            Count: 1,
          },
        ],
      })
      .id("ftbskies:ad_astra/" + rocket[1].split(":")[1]);
  });
});
