// priority: 0
ServerEvents.recipes((event) => {
  event.smithing("ae2:name_press", "minecraft:paper", "minecraft:name_tag").id("ftbskies:namepress");
  event.smithing("ae2:quartz_fixture", "thermal:invar_plate", "minecraft:quartz").id("ftbskies:alt_fixture");

  event
    .custom({
      type: "botania:pure_daisy",
      input: {
        type: "block",
        block: "ad_astra:moon_stone",
      },
      output: {
        name: "ae2:sky_stone_block",
      },
    })
    .id("ftbskies:skystone_puredaisy");

  //Printed Silicon Circuits
  event
    .custom({
      type: "mekanism:reaction",
      duration: 60,
      energyRequired: 5000,
      fluidInput: { amount: 50, fluid: "ftbskies:polyethylene" },
      gasInput: { amount: 10, gas: "mekanism:chlorine" },
      itemInput: { ingredient: { item: "ae2:silicon" } },
      itemOutput: { item: "ae2:printed_silicon" },
    })
    .id("ftbskies:silicon_circuit");

  //Calculation Processor
  event
    .custom({
      type: "pneumaticcraft:assembly_laser",
      input: {
        type: "pneumaticcraft:stacked_item",
        item: "ae2:printed_calculation_processor",
        count: 4,
      },
      program: "laser",
      result: {
        item: "ae2:calculation_processor",
        count: 4,
      },
    })
    .id("ftbskies:calculation_processor");

  //Engineering Processor
  event
    .custom({
      type: "pneumaticcraft:assembly_laser",
      input: {
        type: "pneumaticcraft:stacked_item",
        item: "ae2:printed_engineering_processor",
        count: 4,
      },
      program: "laser",
      result: {
        item: "ae2:engineering_processor",
        count: 4,
      },
    })
    .id("ftbskies:engineering_processor");

  //Logic Processor
  event
    .custom({
      type: "pneumaticcraft:assembly_laser",
      input: {
        type: "pneumaticcraft:stacked_item",
        item: "ae2:printed_logic_processor",
        count: 4,
      },
      program: "laser",
      result: {
        item: "ae2:logic_processor",
        count: 4,
      },
    })
    .id("ftbskies:logic_processor");

  //Desh Processor
  event.custom({
    type: "ae2:inscriber",
    ingredients: {
      bottom: {
        item: "ae2:printed_silicon",
      },
      middle: {
        item: "ftbskies:conductive_soldering_alloy",
      },
      top: {
        item: "ad_astra:desh_plate",
      },
    },
    mode: "press",
    result: {
      item: "jaopca:processors.desh",
    },
  });

  //Mana Processor
  event.custom({
    type: "ae2:inscriber",
    ingredients: {
      bottom: {
        item: "ae2:printed_silicon",
      },
      middle: {
        item: "ftbskies:conductive_soldering_alloy",
      },
      top: {
        item: "jaopca:plates.manasteel",
      },
    },
    mode: "press",
    result: {
      item: "jaopca:circuits.manasteel",
    },
  });

  //Gem Processor
  event.custom({
    type: "ae2:inscriber",
    ingredients: {
      bottom: {
        item: "ae2:printed_silicon",
      },
      middle: {
        item: "ftbskies:conductive_soldering_alloy",
      },
      top: {
        item: "ars_nouveau:source_gem",
      },
    },
    mode: "press",
    result: {
      item: "jaopca:circuits.source",
    },
  });

  event.custom({
    type: "ae2:inscriber",
    ingredients: {
      bottom: {
        item: "ae2:printed_silicon",
      },
      middle: {
        item: "ftbskies:conductive_soldering_alloy",
      },
      top: {
        item: "jaopca:plates.osmium",
      },
    },
    mode: "press",
    result: {
      item: "jaopca:circuits.osmium",
    },
  });

  //Ostrum Processor
  event
    .custom({
      type: "ae2:inscriber",
      mode: "press",
      ingredients: {
        top: {
          item: "redstone_arsenal:flux_gem",
        },
        middle: {
          item: "ad_astra:ostrum_ingot",
        },
        bottom: {
          item: "ae2:printed_silicon",
        },
      },
      result: {
        item: "jaopca:circuits.ostrum",
      },
    })
    .id("ftbskies:circuits_ostrum");

  event
    .custom({
      type: "pneumaticcraft:assembly_laser",
      input: {
        type: "pneumaticcraft:stacked_item",
        item: "jaopca:circuits.ostrum",
        count: 4,
      },
      program: "laser",
      result: {
        item: "jaopca:processors.ostrum",
        count: 4,
      },
    })
    .id("ftbskies:ostrum_processor");

  // Drives
  event.shaped("ae2betterhousings:onekstoragehousing", ["GQG", "Q Q", "SSS"], {
    G: "thermal:obsidian_glass",
    Q: "create:rose_quartz",
    S: "thermal:silver_plate",
  });

  event.shaped("ae2betterhousings:fourkstoragehousing", ["GQG", "QHQ", "SSS"], {
    G: "botania:mana_glass",
    Q: "create:rose_quartz",
    S: "ad_astra:desh_plate",
    H: "ae2betterhousings:onekstoragehousing",
  });

  event.shaped("ae2betterhousings:sixteenkstoragehousing", ["GQG", "QHQ", "SSS"], {
    G: "elementalcraft:springaline_glass",
    Q: "create:rose_quartz",
    S: "thermal:lumium_plate",
    H: "ae2betterhousings:fourkstoragehousing",
  });

  event.shaped("ae2betterhousings:sixtyfourkstoragehousing", ["GQG", "QHQ", "SSS"], {
    G: "botania:elf_glass",
    Q: "create:rose_quartz",
    S: "thermal:enderium_plate",
    H: "ae2betterhousings:sixteenkstoragehousing",
  });

  event.shaped("ae2betterhousings:twofiftysixkstoragehousing", ["GQG", "QHQ", "SSS"], {
    G: "thermal:enderium_glass",
    Q: "jaopca:plates.unstable",
    S: "ad_astra:calorite_plate",
    H: "ae2betterhousings:sixtyfourkstoragehousing",
  });

  event.shaped("4x ae2:basic_card", ["PP ", "CRP", "PP "], {
    P: "thermal:electrum_plate",
    R: "ae2:calculation_processor",
    C: "mekanism:enriched_redstone",
  });

  event.shaped("4x ae2:advanced_card", ["PP ", "DSP", "PP "], {
    P: "thermal:signalum_plate",
    D: "mekanism:enriched_diamond",
    S: "ae2:basic_card",
  });

  // Cells
  const sizes = [
    ["ae2betterhousings:onekstoragehousing", "1"],
    ["ae2betterhousings:fourkstoragehousing", "4"],
    ["ae2betterhousings:sixteenkstoragehousing", "16"],
    ["ae2betterhousings:sixtyfourkstoragehousing", "64"],
    ["ae2betterhousings:twofiftysixkstoragehousing", "256"],
  ];
  sizes.forEach((size) => {
    const housing = size[0];
    const amount = size[1] + "k";
    const storage = `ae2:cell_component_${amount}`;

    // Cell Types
    const botania_cell = "appbot:mana_cell_housing";
    const source_cell = "arseng:source_cell_housing";
    const fluid_cell = "ae2:fluid_cell_housing";
    const chemical_cell = "appmek:chemical_cell_housing";
    const deep_item_cell = "ae2things:disk_housing";

    // Portable Ingredients
    const energy_cell = "ae2:energy_cell";
    const ae2_chest = "ae2:chest";

    // Item Cells
    event.shapeless("ae2:item_storage_cell_" + amount, [housing, storage]).id("ftbskies:storage_item_" + amount);
    event
      .shapeless("ae2:portable_item_cell_" + amount, [housing, storage, ae2_chest, energy_cell])
      .id("ftbskies:storage_item_portable_" + amount);

    // Deep Storage Cells
    event
      .shapeless("ae2things:disk_drive_" + amount, [housing, storage, deep_item_cell])
      .id("ftbskies:storage_deep_" + amount);

    // Fluid Cells
    event
      .shapeless("ae2:fluid_storage_cell_" + amount, [housing, storage, fluid_cell])
      .id("ftbskies:storage_fluid_" + amount);
    event
      .shapeless("ae2:portable_fluid_cell_" + amount, [housing, storage, fluid_cell, ae2_chest, energy_cell])
      .id("ftbskies:storage_fluid_portable_" + amount);

    // Botania Cells
    event
      .shapeless("appbot:mana_storage_cell_" + amount, [housing, storage, botania_cell])
      .id("ftbskies:storage_botania_" + amount);
    event
      .shapeless("appbot:portable_mana_storage_cell_" + amount, [
        housing,
        storage,
        botania_cell,
        ae2_chest,
        energy_cell,
      ])
      .id("ftbskies:storage_botania_portable_" + amount);

    // Chemical Cells
    event
      .shapeless("appmek:chemical_storage_cell_" + amount, [housing, storage, chemical_cell])
      .id("ftbskies:storage_chemical_" + amount);
    event
      .shapeless("appmek:portable_chemical_storage_cell_" + amount, [
        housing,
        storage,
        chemical_cell,
        ae2_chest,
        energy_cell,
      ])
      .id("ftbskies:storage_chemical_portable_" + amount);
    // Source Cells
    event
      .shapeless("arseng:source_storage_cell_" + amount, [housing, storage, source_cell])
      .id("ftbskies:storage_source_" + amount);
    event
      .shapeless("arseng:portable_source_cell_" + amount, [housing, storage, source_cell, ae2_chest, energy_cell])
      .id("ftbskies:storage_source_portable_" + amount);
  });

  // Cell Housing
  event
    .custom({
      type: "thermal:smelter",
      ingredients: [
        {
          value: [
            {
              item: "ae2:item_cell_housing",
            },
          ],
          count: 1,
        },
        {
          item: "thermal:netherite_gear",
          count: 1,
        },
      ],
      result: [
        {
          item: "ae2things:disk_housing",
          count: 1,
        },
      ],
      energy: 16000,
    })
    .id("ftbskies:ae2things_cell_housing");

  // Mana Cell Housing
  event
    .custom({
      type: "botania:mana_infusion",
      catalyst: {
        type: "block",
        block: "botania:alchemy_catalyst",
      },
      input: {
        item: "jaopca:circuits.manasteel",
      },
      mana: 20000,
      output: {
        item: "appbot:mana_cell_housing",
      },
    })
    .id("ftbskies:magic_cell_housing");

  // Source Cell Housing
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: false,
      output: {
        item: "arseng:source_cell_housing",
      },
      pedestalItems: [
        {
          item: {
            item: "ars_nouveau:manipulation_essence",
          },
        },
        {
          item: {
            item: "ars_nouveau:manipulation_essence",
          },
        },
        {
          item: {
            item: "ars_nouveau:source_gem",
          },
        },
        {
          item: {
            item: "ars_nouveau:source_gem",
          },
        },
        {
          item: {
            item: "thermal:electrum_plate",
          },
        },
        {
          item: {
            item: "thermal:electrum_plate",
          },
        },
        {
          item: {
            item: "thermal:electrum_plate",
          },
        },
        {
          item: {
            item: "thermal:electrum_plate",
          },
        },
      ],
      reagent: [
        {
          item: "jaopca:circuits.source",
        },
      ],
      sourceCost: 2000,
    })
    .id("ftbskies:source_cell_housing");

  //Chemical Cell Housing
  event
    .custom({
      type: "mekanism:metallurgic_infusing",
      chemicalInput: { amount: 20, tag: "mekanism:diamond" },
      itemInput: { ingredient: { item: "jaopca:circuits.osmium" } },
      output: { item: "appmek:chemical_cell_housing" },
    })
    .id("ftbskies:chemical_cell_housing");

  //Fluid Cell Housing
  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "ae2:printed_silicon",
        },
        {
          fluid: "ftbskies:volatile_redstone",
          amount: 250,
        },
      ],
      result: [
        {
          item: "ae2:fluid_cell_housing",
          amount: 1,
        },
      ],
      energy: 50000,
    })
    .id("ftbskies:fluid_cell_housing");
  //Quartz Glass
  event
    .custom({
      type: "thermal:smelter",
      ingredients: [
        {
          value: [
            {
              item: "ae2:certus_quartz_dust",
            },
          ],
          count: 4,
        },
        {
          item: "minecraft:glass",
          count: 4,
        },
      ],
      result: [
        {
          item: "ae2:quartz_glass",
          count: 4,
        },
      ],
      energy: 32000,
    })
    .id("ftbskies:quartz_glass");

  // Cores
  centrifugeRecipe(event, 100, "ftbskies:annihilationcores",true)
    .energyInput(50000)
    .itemInput(Item.of("create:polished_rose_quartz", 1))
    .fluidInput(Fluid.of("thermal:glowstone", 1000))
    .itemOutput(Item.of("ae2:annihilation_core", 1))
    .build();

  centrifugeRecipe(event, 100, "ftbskies:formationcores",true)
    .energyInput(50000)
    .itemInput(Item.of("ae2:charged_certus_quartz_crystal", 1))
    .fluidInput(Fluid.of("thermal:glowstone", 1000))
    .itemOutput(Item.of("ae2:formation_core", 1))
    .build();

  // Fluix Crystal
  quantumAssemblerRecipe(event, 10, "ftbskies:qafluix")
    .energyInput(50000)
    .itemInput(Item.of("ae2:charged_certus_quartz_crystal", 1))
    .itemInput(Item.of("minecraft:quartz", 1))
    .fluidInput(Fluid.of("thermal:redstone", 10))
    .itemOutput(Item.of("ae2:fluix_crystal", 2))
    .build();

  event
    .custom({
      type: "industrialforegoing:dissolution_chamber",
      input: [
        {
          tag: "forge:gems/quartz",
        },
        {
          tag: "forge:dusts/refined_obsidian",
        },
        {
          item: "ae2:charged_certus_quartz_crystal",
        },
        {
          tag: "forge:dusts/signalum",
        },
        {
          item: "ftbskies:mana_infused_copper",
        },
        {
          item: "ae2:charged_certus_quartz_crystal",
        },
        {
          tag: "forge:dusts/refined_obsidian",
        },
        {
          tag: "forge:gems/quartz",
        },
      ],
      inputFluid: '{Amount:20,FluidName:"thermal:redstone"}',
      output: {
        count: 4,
        item: "ae2:fluix_crystal",
      },
      processingTime: 2500,
    })
    .id("ftbskies:fluix_crystal_if");

  // Quartz Fiber
  event
    .custom({
      type: "immersiveengineering:metal_press",
      input: {
        base_ingredient: {
          tag: `forge:dusts/quartz`,
        },
        count: 1,
      },
      result: {
        item: `ae2:quartz_fiber`,
        count: 2,
      },
      mold: "immersiveengineering:mold_rod",
      energy: 2400,
    })
    .id("ftbskies:quartz_fiber_ie");

  //Advanced Inscriber
  event
    .shaped("ae2things:advanced_inscriber", ["PHP", "OIO", "PHP"], {
      P: "#forge:plates/aluminum",
      I: "ae2:inscriber",
      O: "#forge:processors/ostrum",
      H: "minecraft:hopper",
    })
    .id("ftbskies:advanced_inscriber");

  //Magnet Card
  event
    .shaped("ae2wtlib:magnet_card", ["LPR", "ACA", "AAA"], {
      A: "#forge:storage_blocks/aluminum",
      C: "ae2:advanced_card",
      L: "#forge:storage_blocks/lapis",
      R: "#forge:storage_blocks/redstone",
      P: "ae2:annihilation_plane",
    })
    .id("ftbskies:ae_magnet_card");

  event
    .custom({
      type: "compactcrafting:miniaturization",
      recipeSize: 3,
      layers: [
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["S", "S", "S"],
            ["S", "S", "S"],
            ["S", "S", "S"],
          ],
        },
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["F", "F", "F"],
            ["F", "C", "F"],
            ["F", "F", "F"],
          ],
        },
        {
          type: "compactcrafting:mixed",
          pattern: [
            ["S", "S", "S"],
            ["S", "S", "S"],
            ["S", "S", "S"],
          ],
        },
      ],
      catalyst: {
        id: "ae2:engineering_processor",
        Count: 1,
      },
      components: {
        S: {
          type: "compactcrafting:block",
          block: "ae2:smooth_sky_stone_block",
        },
        C: {
          type: "compactcrafting:block",
          block: "ae2:energy_cell",
        },
        F: {
          type: "compactcrafting:block",
          block: "ae2:fluix_block",
        },
      },
      outputs: [
        {
          id: "ae2:controller",
          Count: 1,
        },
      ],
    })
    .id("ftbskies:ae2_controller");
});
