//priority: -10

const gemProcessingRecipe = (event, liquidType, diamondResult, blazingResult, nioticResult, spiritedResult, heartResult, explosiveResult) => {

  //Mana Diamond Gem
  centrifugeRecipe(event, 100, (`ftbskies:${liquidType}_${diamondResult}`), true)
    .energyInput(20000)
    .itemInput(Item.of("ftbskies:inert_gemstone", 1))
    .itemInput(Item.of("botania:mana_diamond", 1))
    .fluidInput(Fluid.of(`ftbskies:liquid_elemental_${liquidType}`, 250))
    .itemOutput(Item.of("apotheosis:gem", `{gem:'apotheosis:${diamondResult}', rarirty:'common'}`), 1)
  .build();

  //Blazing Gem
  centrifugeRecipe(event, 100, (`ftbskies:${liquidType}_${blazingResult}`), true)
    .energyInput(20000)
    .itemInput(Item.of("ftbskies:inert_gemstone", 1))
    .itemInput(Item.of("powah:crystal_blazing", 1))
    .fluidInput(Fluid.of(`ftbskies:liquid_elemental_${liquidType}`, 250))
    .itemOutput(Item.of("apotheosis:gem", `{gem:'apotheosis:${blazingResult}', rarirty:'common'}`), 1)
  .build();

  //Niotic Gem
  centrifugeRecipe(event, 100, (`ftbskies:${liquidType}_${nioticResult}`), true)
    .energyInput(20000)
    .itemInput(Item.of("ftbskies:inert_gemstone", 1))
    .itemInput(Item.of("powah:crystal_niotic", 1))
    .fluidInput(Fluid.of(`ftbskies:liquid_elemental_${liquidType}`, 250))
    .itemOutput(Item.of("apotheosis:gem", `{gem:'apotheosis:${nioticResult}', rarirty:'common'}`), 1)
  .build();

  //Spirited Gem
  centrifugeRecipe(event, 100, (`ftbskies:${liquidType}_${spiritedResult}`), true)
    .energyInput(20000)
    .itemInput(Item.of("ftbskies:inert_gemstone", 1))
    .itemInput(Item.of("powah:crystal_spirited", 1))
    .fluidInput(Fluid.of(`ftbskies:liquid_elemental_${liquidType}`, 250))
    .itemOutput(Item.of("apotheosis:gem", `{gem:'apotheosis:${spiritedResult}', rarirty:'common'}`), 1)
  .build();

  //Hearty Gem (Only Supports Modded Gems from apotheotic_additions)
  centrifugeRecipe(event, 100, (`ftbskies:${liquidType}_${heartResult}`), true)
    .energyInput(20000)
    .itemInput(Item.of("ftbskies:inert_gemstone", 1))
    .itemTagInput("forge:heart", 1)
    .fluidInput(Fluid.of(`ftbskies:liquid_elemental_${liquidType}`, 250))
    .itemOutput(Item.of("apotheosis:gem", `{gem:'apotheotic_additions:${heartResult}', rarirty:'common'}`), 1)
  .build();

  //TNT Gem (Only Supports Modded Gems from apotheotic_additions)
  if (explosiveResult) {
    centrifugeRecipe(event, 100, (`ftbskies:${liquidType}_${explosiveResult}`), true)
      .energyInput(20000)
      .itemInput(Item.of("ftbskies:inert_gemstone", 1))
      .itemInput(Item.of("thermal:fire_tnt", 1))
      .fluidInput(Fluid.of(`ftbskies:liquid_elemental_${liquidType}`, 250))
      .itemOutput(Item.of("apotheosis:gem", `{gem:'apotheotic_additions:${explosiveResult}', rarirty:'common'}`), 1)
    .build();
  }


};

ServerEvents.recipes((event) => {
  gemProcessingRecipe(event, "fire", "core/solar", "core/brawlers", "the_nether/inferno", "core/tyrannical", "modded/armor", "modded/cataclysm");
  gemProcessingRecipe(event, "earth", "core/ballast", "core/guardian", "core/combatant", "overworld/earth", "modded/safari", null);
  gemProcessingRecipe(event, "air", "core/lightning", "core/warlord", "overworld/royalty", "the_nether/blood_lord", "modded/ars_mana", null);
  gemProcessingRecipe(event, "void", "core/splendor", "the_end/mageslayer", "core/samurai", "the_end/endersurge", "modded/hearty", null);
  gemProcessingRecipe(event, "water", "core/lunar", "core/breach", "core/slipstream", null, "modded/archmage", "modded/thermal");
});
