ServerEvents.recipes((event) => {
  //whiterock
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: false,
      output: {
        item: "elementalcraft:whiterock",
      },
      pedestalItems: [
        {
          item: "cyclic:peat_fuel_enriched",
        },
        {
          item: "ars_nouveau:earth_essence",
        },
        {
          item: "minecraft:coal_block",
        },
        {
          item: "spirit:soul_powder",
        },
      ],
      reagent: [
        {
          tag: "forge:gems/source",
        },
      ],
      sourceCost: 1000,
    })
    .id("ftbskies:whiterock");

  //Magebloom Fibers
  event
    .custom({
      type: "occultism:crushing",
      ingredient: {
        item: "ars_nouveau:magebloom",
      },
      result: {
        item: "ars_nouveau:magebloom_fiber",
        count: 1,
      },
      crushing_time: 200,
    })
    .id("ftbskies:magebloom_fiber");

  event
    .custom({
      type: "ars_nouveau:imbuement",
      count: 1,
      input: {
        item: "elementalcraft:air_shard",
      },
      output: "ars_nouveau:air_essence",
      pedestalItems: [],
      source: 1000,
    })
    .id("ftbskies:ars_air");

  event
    .custom({
      type: "ars_nouveau:imbuement",
      count: 9,
      input: {
        item: "elementalcraft:powerful_air_shard",
      },
      output: "ars_nouveau:air_essence",
      pedestalItems: [],
      source: 5000,
    })
    .id("ftbskies:ars_air2");

  event
    .custom({
      type: "ars_nouveau:imbuement",
      count: 1,
      input: {
        item: "elementalcraft:earth_shard",
      },
      output: "ars_nouveau:earth_essence",
      pedestalItems: [],
      source: 1000,
    })
    .id("ftbskies:ars_earth");

  event
    .custom({
      type: "ars_nouveau:imbuement",
      count: 9,
      input: {
        item: "elementalcraft:powerful_earth_shard",
      },
      output: "ars_nouveau:earth_essence",
      pedestalItems: [],
      source: 5000,
    })
    .id("ftbskies:ars_earth2");

  event
    .custom({
      type: "ars_nouveau:imbuement",
      count: 1,
      input: {
        item: "elementalcraft:fire_shard",
      },
      output: "ars_nouveau:fire_essence",
      pedestalItems: [],
      source: 1000,
    })
    .id("ftbskies:ars_fire");

  event
    .custom({
      type: "ars_nouveau:imbuement",
      count: 9,
      input: {
        item: "elementalcraft:powerful_fire_shard",
      },
      output: "ars_nouveau:fire_essence",
      pedestalItems: [],
      source: 5000,
    })
    .id("ftbskies:ars_fire2");

  event
    .custom({
      type: "ars_nouveau:imbuement",
      count: 1,
      input: {
        item: "elementalcraft:water_shard",
      },
      output: "ars_nouveau:water_essence",
      pedestalItems: [],
      source: 1000,
    })
    .id("ftbskies:ars_water");

  event
    .custom({
      type: "ars_nouveau:imbuement",
      count: 9,
      input: {
        item: "elementalcraft:powerful_water_shard",
      },
      output: "ars_nouveau:water_essence",
      pedestalItems: [],
      source: 5000,
    })
    .id("ftbskies:ars_water2");

  //pedestal linking tool
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: false,
      output: {
        item: "pedestals:tool_linkingtool",
      },
      pedestalItems: [
        {
          tag: "forge:bookshelves",
        },
        {
          item: "elementalcraft:fire_shard",
        },
        {
          item: "elementalcraft:water_shard",
        },
        {
          item: "elementalcraft:earth_shard",
        },
        {
          item: "elementalcraft:air_shard",
        },
        {
          item: "ars_nouveau:abjuration_essence",
        },
        {
          item: "ars_nouveau:manipulation_essence",
        },
      ],
      reagent: [
        {
          item: "createaddition:gold_rod",
        },
      ],
      sourceCost: 2000,
    })
    .id("ftbskies:linking_tool");

  //Iron Catalyst
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: true,
      output: {
        item: "ftbskies:ironcatalyst",
        count: 16,
      },
      pedestalItems: [
        {
          item: "minecraft:rotten_flesh",
        },
      ],
      reagent: [
        {
          item: "ars_nouveau:source_gem",
        },
      ],
      sourceCost: 1000,
    })
    .id("ftbskies:catalyst_iron");

  //Gold Catalyst
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: true,
      output: {
        item: "ftbskies:goldcatalyst",
        count: 16,
      },
      pedestalItems: [
        {
          item: "minecraft:redstone",
        },
      ],
      reagent: [
        {
          item: "ars_nouveau:source_gem",
        },
      ],
      sourceCost: 1000,
    })
    .id("ftbskies:catalyst_gold");

  //Zinc Catalyst
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: true,
      output: {
        item: "ftbskies:zinccatalyst",
        count: 16,
      },
      pedestalItems: [
        {
          item: "minecraft:gunpowder",
        },
      ],
      reagent: [
        {
          item: "ars_nouveau:source_gem",
        },
      ],
      sourceCost: 1000,
    })
    .id("ftbskies:catalyst_zinc");

  //Copper Catalyst
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: true,
      output: {
        item: "ftbskies:coppercatalyst",
        count: 16,
      },
      pedestalItems: [
        {
          item: "minecraft:bone",
        },
      ],
      reagent: [
        {
          item: "ars_nouveau:source_gem",
        },
      ],
      sourceCost: 1000,
    })
    .id("ftbskies:catalyst_copper");

  //Magically Inclined Steel
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: true,
      output: {
        item: "ftbskies:magic_steel",
      },
      pedestalItems: [
        {
          item: "ars_nouveau:air_essence",
        },
        {
          item: "ars_nouveau:earth_essence",
        },
        {
          item: "ars_nouveau:fire_essence",
        },
        {
          item: "ars_nouveau:water_essence",
        },
      ],
      reagent: [
        {
          item: "elementalcraft:drenched_iron_ingot",
        },
      ],
      sourceCost: 1000,
    })
    .id("ftbskies:magicsteel");

  //Magically Inclined Steel block
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: true,
      output: {
        item: "ftbskies:magic_steel_block",
      },
      pedestalItems: [
        {
          item: "ars_nouveau:air_essence",
        },
        {
          item: "ars_nouveau:air_essence",
        },
        {
          item: "ars_nouveau:earth_essence",
        },
        {
          item: "ars_nouveau:earth_essence",
        },
        {
          item: "ars_nouveau:fire_essence",
        },
        {
          item: "ars_nouveau:fire_essence",
        },
        {
          item: "ars_nouveau:water_essence",
        },
        {
          item: "ars_nouveau:water_essence",
        },
      ],
      reagent: [
        {
          item: "elementalcraft:drenched_iron_block",
        },
      ],
      sourceCost: 6000,
    })
    .id("ftbskies:magicsteel_block");

  //Mana Spreader
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: true,
      output: {
        item: "botania:mana_spreader",
      },
      pedestalItems: [
        {
          item: "ars_nouveau:manipulation_essence",
        },
        {
          tag: "botania:livingwood_logs",
        },
        {
          tag: "botania:livingwood_logs",
        },
        {
          tag: "botania:livingwood_logs",
        },
        {
          tag: "botania:livingwood_logs",
        },
        {
          tag: "botania:livingwood_logs",
        },
        {
          tag: "botania:livingwood_logs",
        },
      ],
      reagent: [
        {
          item: "ars_nouveau:relay",
        },
      ],
      sourceCost: 5000,
    })
    .id("ftbskies:mana_spreader");

  //Blaze Fiber
  event
    .custom({
      type: "ars_nouveau:imbuement",
      count: 2,
      input: {
        item: "ars_nouveau:magebloom_fiber",
      },
      output: "ars_nouveau:blaze_fiber",
      pedestalItems: [
        {
          item: {
            item: "elementalcraft:fire_shard",
          },
        },
        {
          item: {
            item: "minecraft:blaze_powder",
          },
        },
      ],
      source: 500,
    })
    .id("ftbskies:blaze_fiber");

  // Magnets
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: false,
      output: {
        item: "simplemagnets:basicmagnet",
        count: 1,
      },
      pedestalItems: [
        {
          item: "thermal:invar_plate",
        },
        {
          item: "minecraft:redstone",
        },
        {
          item: "compressedcreativity:brass_gilded_lapis_lazuli",
        },
        {
          item: "mob_grinding_utils:absorption_hopper",
        },
      ],
      reagent: [
        {
          item: "botania:magnet_ring",
        },
      ],
      sourceCost: 1000,
    })
    .id("ftbskies:basicmagnet");

  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: true,
      output: {
        item: "ars_nouveau:starbuncle_charm",
        count: 1,
      },
      pedestalItems: [
        {
          tag: "forge:ingots/electrum",
        },
        {
          tag: "forge:ingots/electrum",
        },
        {
          tag: "forge:ingots/electrum",
        },
        {
          tag: "forge:ingots/electrum",
        },
      ],
      reagent: [
        {
          item: "ars_nouveau:starbuncle_shards",
        },
      ],
      sourceCost: 2000,
    })
    .id("ftbskies:starbuncle_charm");

  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      reagent: [
        {
          item: "ars_nouveau:drygmy_shard",
        },
      ],
      pedestalItems: [
        {
          item: {
            tag: "minecraft:fishes",
          },
        },
        {
          item: {
            item: "minecraft:wheat",
          },
        },
        {
          item: {
            item: "minecraft:apple",
          },
        },
        {
          item: {
            item: "minecraft:carrot",
          },
        },
        {
          item: {
            item: "hexerei:seed_mixture",
          },
        },
        {
          item: {
            item: "elementalcraft:strongly_contained_crystal",
          },
        },
        {
          item: {
            item: "elementalcraft:strongly_contained_crystal",
          },
        },
        {
          item: {
            item: "elementalcraft:strongly_contained_crystal",
          },
        },
      ],
      output: {
        item: "ars_nouveau:drygmy_charm",
      },
      sourceCost: 0,
      keepNbtOfReagent: false,
    })
    .id("ftbskies:drygmy_charm");

  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: false,
      output: {
        item: "ars_nouveau:storage_lectern",
      },
      pedestalItems: [
        {
          tag: "forge:chests",
        },
        {
          tag: "forge:chests",
        },
        {
          item: "ironchest:gold_chest",
        },
        {
          item: "thermal:xp_crystal",
        },
      ],
      reagent: [
        {
          item: "minecraft:lectern",
        },
      ],
      sourceCost: 0,
    })
    .id("ftbskies:storage_lectern");


    event
    .shapeless("ars_nouveau:scryers_crystal", [
      "ars_nouveau:source_gem",
      "2x glassential:glass_redstone",
      "createteleporters:quantum_mechanism"
    ])
    .id("ftbskies:scryingplate");


  event
    .shapeless("ars_nouveau:novice_spell_book", [
      "minecraft:book",
      "ars_nouveau:fire_essence",
      "ars_nouveau:water_essence",
      "ars_nouveau:earth_essence",
      "ars_nouveau:air_essence",
    ])
    .id("ftbskies:novice_spell_book");

  //sourcelinks
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: false,
      output: {
        item: "ars_nouveau:agronomic_sourcelink",
      },
      pedestalItems: [
        {
          item: "forcecraft:force_gear",
        },
        {
          item: "thermal:invar_ingot",
        },
        {
          item: "ars_nouveau:source_gem",
        },
        {
          item: "ars_nouveau:source_gem",
        },
        {
          item: "ars_nouveau:source_gem",
        },
      ],
      reagent: [
        {
          item: "minecraft:wheat",
        },
      ],
      sourceCost: 2000,
    })
    .id("ftbskies:agrisourcelink");

  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: false,
      output: {
        item: "ars_nouveau:alchemical_sourcelink",
      },
      pedestalItems: [
        {
          item: "forcecraft:force_gear",
        },
        {
          item: "thermal:invar_ingot",
        },
        {
          item: "ars_nouveau:source_gem",
        },
        {
          item: "ars_nouveau:source_gem",
        },
        {
          item: "ars_nouveau:source_gem",
        },
      ],
      reagent: [
        {
          item: "minecraft:brewing_stand",
        },
      ],
      sourceCost: 2000,
    })
    .id("ftbskies:alchemicalsourcelink");

  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: false,
      output: {
        item: "ars_nouveau:volcanic_sourcelink",
      },
      pedestalItems: [
        {
          item: "forcecraft:force_gear",
        },
        {
          item: "thermal:invar_ingot",
        },
        {
          item: "ars_nouveau:source_gem",
        },
        {
          item: "ars_nouveau:source_gem",
        },
        {
          item: "ars_nouveau:source_gem",
        },
      ],
      reagent: [
        {
          item: "minecraft:magma_block",
        },
      ],
      sourceCost: 2000,
    })
    .id("ftbskies:volcanicsourcelink");

  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: false,
      output: {
        item: "ars_nouveau:mycelial_sourcelink",
      },
      pedestalItems: [
        {
          item: "forcecraft:force_gear",
        },
        {
          item: "thermal:invar_ingot",
        },
        {
          item: "ars_nouveau:source_gem",
        },
        {
          item: "ars_nouveau:source_gem",
        },
        {
          item: "ars_nouveau:source_gem",
        },
      ],
      reagent: [
        {
          item: "farmersdelight:brown_mushroom_colony",
        },
      ],
      sourceCost: 2000,
    })
    .id("ftbskies:mycelialsourcelink");

  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: false,
      output: {
        item: "starbunclemania:fluid_sourcelink",
      },
      pedestalItems: [
        {
          item: "forcecraft:force_gear",
        },
        {
          item: "thermal:invar_ingot",
        },
        {
          item: "ars_nouveau:source_gem",
        },
        {
          item: "ars_nouveau:source_gem",
        },
        {
          item: "ars_nouveau:source_gem",
        },
      ],
      reagent: [
        {
          item: "starbunclemania:source_fluid_bucket",
        },
      ],
      sourceCost: 2000,
    })
    .id("ftbskies:fluidsourcelink");

  event
    .custom({
      type: "botania:elven_trade",
      ingredients: [
        {
          item: "ars_nouveau:warp_scroll",
        },
      ],
      output: [
        {
          item: "ars_nouveau:stable_warp_scroll",
        },
      ],
    })
    .id("ftbskies:stable_warp_scroll");

  event.replaceInput({ id: "ars_nouveau:wilden_summon_alt" }, "minecraft:emerald_block", "minecraft:emerald");


  event
    .custom({
      type: "starbunclemania:fluid_sourcelink",
      fluid: "pneumaticcraft:biodiesel",
      mb_to_source_ratio: 3.2,
    })
    .id("ftbskies:fluid_sourcelink_pneumaticcraft_biodiesel");

  event
    .custom({
      type: "starbunclemania:fluid_sourcelink",
      fluid: "ftbskies:force_infused_biodiesel",
      mb_to_source_ratio: 6.4,
    })
    .id("ftbskies:fluid_sourcelink_force_infused_biodiesel");

  event
    .custom({
      type: "starbunclemania:fluid_sourcelink",
      fluid: "ftbskies:force_infused_diesel",
      mb_to_source_ratio: 6.4,
    })
    .id("ftbskies:fluid_sourcelink_force_infused_diesel");


  event.custom({
    type: "thermal:press",
    ingredients: [
      {
        item: `ars_nouveau:source_gem`,
        count: 4,
      },
      {
        item: "immersiveengineering:mold_packing_4",
      },
    ],
    result: [
      {
        item: `ars_nouveau:source_gem_block`,
        count: 1,
      },
    ],
    energy: 800,
  });

  event.custom({
    type: "thermal:press",
    ingredients: [
      {
        item: `ars_nouveau:source_gem_block`,
        count: 1,
      },
    ],
    result: [
      {
        item: `ars_nouveau:source_gem`,
        count: 4,
      },
    ],
    energy: 800,
  });
});
