ServerEvents.recipes((event) => {
  //mana pool
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: false,
      output: {
        item: "botania:mana_pool",
      },
      pedestalItems: [
        {
          item: "elementalcraft:springaline_shard",
        },
        {
          item: "immersiveengineering:plate_steel",
        },
        {
          item: "ars_nouveau:earth_essence",
        },
        {
          item: "ars_nouveau:fire_essence",
        },
        {
          item: "ars_nouveau:air_essence",
        },
        {
          item: "ars_nouveau:water_essence",
        },
      ],
      reagent: [
        {
          item: "botania:livingrock",
        },
      ],
      sourceCost: 7500,
    })
    .id("ftbskies:mana_pool");

  event
    .custom({
      type: "botania:pure_daisy",
      input: {
        type: "block",
        block: "minecraft:blackstone",
      },
      output: {
        name: "elementalcraft:whiterock",
      },
    })
    .id("ftbskies:whiterock1");

  event
    .custom({
      type: "botania:pure_daisy",
      input: {
        type: "block",
        block: "minecraft:infested_stone",
      },
      output: {
        name: "botania:livingrock",
      },
    })
    .id("ftbskies:livingrock");

  event
    .custom({
      type: "botania:pure_daisy",
      input: {
        type: "block",
        block: "ars_nouveau:source_gem_block",
      },
      output: {
        name: "elementalcraft:inertcrystal_block",
      },
    })
    .id("ftbskies:inertcrystal_block");

  //Kekimurus
  event
    .custom({
      type: "botania:petal_apothecary",
      ingredients: [
        {
          tag: "botania:petals/white",
        },
        {
          tag: "botania:petals/white",
        },
        {
          tag: "botania:petals/orange",
        },
        {
          tag: "botania:petals/orange",
        },
        {
          tag: "botania:petals/brown",
        },
        {
          tag: "botania:petals/brown",
        },
        {
          item: "minecraft:cake",
        },
        {
          item: "spirit:soul_powder",
        },
      ],
      output: {
        item: "botania:kekimurus",
      },
      reagent: {
        tag: "botania:seed_apothecary_reagent",
      },
    })
    .id("ftbskies:keki");

  //Manasteel
  event
    .custom({
      type: "botania:mana_infusion",
      input: {
        item: "ftbskies:magic_steel",
      },
      mana: 2500,
      output: {
        item: "botania:manasteel_ingot",
      },
    })
    .id("ftbskies:manasteel");

  //Mana infused copper
  event
    .custom({
      type: "botania:mana_infusion",
      input: {
        tag: "forge:dusts/copper",
      },
      mana: 2500,
      output: {
        item: "ftbskies:mana_infused_copper",
      },
    })
    .id("ftbskies:mana_infused_copper");

  //Manasteel Block
  event
    .custom({
      type: "botania:mana_infusion",
      input: {
        item: "ftbskies:magic_steel_block",
      },
      mana: 20000,
      output: {
        item: "botania:manasteel_block",
      },
    })
    .id("ftbskies:manasteel_block");

  //pixie dust
  event
    .custom({
      type: "botania:elven_trade",
      ingredients: [
        {
          item: "jaopca:dusts.ostrum",
        },
      ],
      output: [
        {
          item: "botania:pixie_dust",
        },
      ],
    })
    .id("ftbskies:pixie_dust");

  //Water Rune
  event
    .custom({
      type: "botania:runic_altar",
      ingredients: [
        {
          tag: "botania:mana_dusts",
        },
        {
          tag: "botania:manasteel_ingots",
        },
        {
          type: "forge:partial_nbt",
          item: "elementalcraft:rune",
          nbt: '{elementalcraft:{rune:"elementalcraft:claptrap"}}',
        },
        {
          item: "ars_nouveau:water_essence",
        },
      ],
      mana: 15000,
      output: {
        count: 2,
        item: "botania:rune_water",
      },
    })
    .id("ftbskies:rune_water");


  //pineapple
  event
    .custom({
      type: "botania:runic_altar",
      ingredients: [
        {
          item: "ftbskies:cryotheum",
        },
        {
          item: "botania:rune_gluttony",
        },
        {
          item: "cyclic:apple_bone",
        },
        {
          item: "cyclic:apple_lapis",
        },
        {
          item: "bhc:relic_apple",
        },
        {
          item: "minecraft:enchanted_golden_apple",
        },
        {
          item: "create:honeyed_apple",
        },
        {
          item: "cyclic:apple_chorus",
        },
        {
          item: "apotheotic_additions:mythic_apple",
        },
        {
          item: "botania:rune_greed",
        },
        {
          item: "ftbskies:flugel_dust",
        }
      ],
      mana: 100000,
      output: {
        count: 1,
        item: "tropicraft:pineapple",
      },
    })
    .id("ftbskies:pineapple_initial");

  //fire Rune
  event
    .custom({
      type: "botania:runic_altar",
      ingredients: [
        {
          tag: "botania:mana_dusts",
        },
        {
          tag: "botania:manasteel_ingots",
        },
        {
          type: "forge:partial_nbt",
          item: "elementalcraft:rune",
          nbt: '{elementalcraft:{rune:"elementalcraft:manx"}}',
        },
        {
          item: "ars_nouveau:fire_essence",
        },
      ],
      mana: 15000,
      output: {
        count: 2,
        item: "botania:rune_fire",
      },
    })
    .id("ftbskies:rune_fire");

  //Earth Rune
  event
    .custom({
      type: "botania:runic_altar",
      ingredients: [
        {
          tag: "botania:mana_dusts",
        },
        {
          tag: "botania:manasteel_ingots",
        },
        {
          type: "forge:partial_nbt",
          item: "elementalcraft:rune",
          nbt: '{elementalcraft:{rune:"elementalcraft:soaryn"}}',
        },
        {
          item: "ars_nouveau:earth_essence",
        },
      ],
      mana: 15000,
      output: {
        count: 2,
        item: "botania:rune_earth",
      },
    })
    .id("ftbskies:rune_earth");

  //Air Rune
  event
    .custom({
      type: "botania:runic_altar",
      ingredients: [
        {
          tag: "botania:mana_dusts",
        },
        {
          tag: "botania:manasteel_ingots",
        },
        {
          type: "forge:partial_nbt",
          item: "elementalcraft:rune",
          nbt: '{elementalcraft:{rune:"elementalcraft:wii"}}',
        },
        {
          item: "ars_nouveau:air_essence",
        },
      ],
      mana: 15000,
      output: {
        count: 2,
        item: "botania:rune_air",
      },
    })
    .id("ftbskies:rune_air");

  event.recipes.botania.petal_apothecary("botania:hydroangeas", [
    "#botania:petals/blue",
    "#botania:petals/blue",
    "#botania:petals/cyan",
    "#botania:petals/cyan",
    "botania:rune_mana",
  ]);
  event.recipes.botania.petal_apothecary("botania:endoflame", [
    "#botania:petals/brown",
    "#botania:petals/brown",
    "#botania:petals/red",
    "#botania:petals/gray",
    "botania:rune_mana",
  ]);
  event.recipes.botania.petal_apothecary("botanicadds:flowers/glaciflora", [
    "#botania:petals/white",
    "#botania:petals/white",
    "#botania:petals/white",
    "#botania:petals/light_blue",
    "#botania:petals/light_blue",
    "#botania:petals/light_blue",
    "#botania:petals/light_blue",
    "botania:rune_mana",
  ]);
  event.recipes.botania.petal_apothecary("botanicadds:flowers/rainute", [
    "#botania:petals/yellow",
    "#botania:petals/light_blue",
    "#botania:petals/light_blue",
    "#botania:petals/blue",
    "#botania:petals/blue",
    "#botania:petals/blue",
    "#botania:petals/blue",
    "botania:rune_mana",
  ]);

  //Mana String
  event
    .custom({
      type: "botania:mana_infusion",
      input: {
        item: "ars_nouveau:blaze_fiber",
      },
      mana: 5000,
      output: {
        item: "botania:mana_string",
      },
    })
    .id("ftbskies:mana_string");

  //budding amethyst
  event
    .custom({
      type: "botania:mana_infusion",
      catalyst: {
        type: "block",
        block: "botania:alchemy_catalyst",
      },
      input: {
        item: "minecraft:amethyst_block",
      },
      mana: 25000,
      output: {
        item: "minecraft:budding_amethyst",
      },
    })
    .id("ftbskies:buddingamethyst");

  //diamond
  event
    .custom({
      type: "botania:mana_infusion",
      catalyst: {
        type: "block",
        block: "botania:alchemy_catalyst",
      },
      input: {
        item: "integrateddynamics:crystalized_menril_block",
      },
      mana: 10000,
      output: {
        item: "minecraft:diamond",
      },
    })
    .id("ftbskies:diamondfrommenril");

  //lumizer
  event
    .shaped("2x botania:light_relay", ["GCG", "CPC", "GCG"], {
      G: "#forge:dusts/glowstone",
      P: "createteleporters:redstone_pearl",
      C: "ftbskies:mana_infused_copper",
    })
    .id("ftbskies:luminzer");

  //alchemy catalyst
  event
    .shaped("botania:alchemy_catalyst", ["LGL", "SCS", "LGL"], {
      L: "botania:livingrock",
      G: "create_new_age:overcharged_gold",
      S: "elementalcraft:springaline_glass_pane",
      C: "ars_artifice:spell_gem_t3",
    })
    .id("ftbskies:catalyst");

  //Natura Pylon
  event.custom({
    type: "elementalcraft:binding",
    element_amount: 30000,
    element_type: "earth",
    ingredients: [
      {
        item: "ftbskies:sentient_steel",
      },
      {
        item: "botania:mana_pylon",
      },
      {
        item: "ftbskies:eye_of_legend",
      },
      {
        tag: "forge:dusts/ostrum",
      },
    ],
    output: {
      item: "botania:natura_pylon",
    },
  });

  event.custom({
    type: "create:sequenced_assembly",

    ingredient: {
      item: "botania:red_mystical_flower",
    },

    transitionalItem: {
      item: "ftbskies:incomplete_energizera",
    },

    sequence: [
      {
        type: "create:deploying",
        ingredients: [
          {
            item: "ftbskies:incomplete_energizera",
          },
          {
            item: "botania:red_petal",
          },
        ],
        results: [
          {
            item: "ftbskies:incomplete_energizera",
          },
        ],
      },
      {
        type: "create:deploying",
        ingredients: [
          {
            item: "ftbskies:incomplete_energizera",
          },
          {
            item: "botania:green_petal",
          },
        ],
        results: [
          {
            item: "ftbskies:incomplete_energizera",
          },
        ],
      },
      {
        type: "create:deploying",
        ingredients: [
          {
            item: "ftbskies:incomplete_energizera",
          },
          {
            item: "botania:mana_powder",
          },
        ],
        results: [
          {
            item: "ftbskies:incomplete_energizera",
          },
        ],
      },
      {
        type: "create_new_age:energising",
        energy_needed: 100000,
        ingredients: [
          {
            item: "ftbskies:incomplete_energizera",
          },
        ],
        results: [
          {
            item: "ftbskies:incomplete_energizera",
          },
        ],
      },
    ],
    results: [
      {
        item: "botanicadds:flowers/energizera",
      },
    ],
    loops: 1,
  });

  //Spark Augment: Isolated
  event
    .shapeless("botania:spark_upgrade_isolated", [
      "#forge:dusts/signalum",
      "#forge:plates/manasteel",
      "botania:rune_air",
    ])
    .id("ftbskies:spark_upgrade_isolated");
  //Spark Augment: Recessive
  event
    .shapeless("botania:spark_upgrade_recessive", [
      "#forge:dusts/signalum",
      "#forge:plates/manasteel",
      "botania:rune_earth",
    ])
    .id("ftbskies:spark_upgrade_recessive");
  //Spark Augment: Dominant
  event
    .shapeless("botania:spark_upgrade_dominant", [
      "#forge:dusts/signalum",
      "#forge:plates/manasteel",
      "botania:rune_fire",
    ])
    .id("ftbskies:spark_upgrade_dominant");
  //Spark Augment: Dispersive
  event
    .shapeless("botania:spark_upgrade_dispersive", [
      "#forge:dusts/signalum",
      "#forge:plates/manasteel",
      "botania:rune_water",
    ])
    .id("ftbskies:spark_upgrade_dispersive");
  // Dilluted Mana Pool
  event.shapeless("4x botania:diluted_pool", ["botania:mana_pool"]).id("ftbskies:diluted_pool");

  //Mana Blaster
  event
    .shaped("botania:mana_gun", ["RMD", " LE", "  L"], {
      D: "botania:mana_diamond",
      M: "botania:rune_mana",
      R: "botania:redstone_spreader",
      L: "#botania:livingwood_logs",
      E: "thermal:explosive_grenade",
    })
    .id("ftbskies:mana_blaster");

  //Manastorm Charge
  event
    .shaped("botania:mana_bomb", ["LEL", "EGE", "LEL"], {
      L: "#botania:livingwood_logs",
      E: "thermal:explosive_grenade",
      G: "botania:life_essence",
    })
    .id("ftbskies:mana_bomb");

  //Mana Ring
  event
    .shaped("botania:mana_ring", ["TM ", "M M", " M "], {
      M: "#forge:plates/manasteel",
      T: "botania:mana_tablet",
    })
    .id("ftbskies:mana_ring");

  //Great Fairy Ring
  event
    .shaped("botania:pixie_ring", ["PE ", "E E", " E "], {
      E: "#forge:plates/elementium",
      P: "botania:pixie_dust",
    })
    .id("ftbskies:pixie_ring");

  //Ring of Far Reach
  event
    .shaped("botania:reach_ring", ["PE ", "E E", " E "], {
      E: "#forge:plates/elementium",
      P: "botania:rune_pride",
    })
    .id("ftbskies:reach_ring");

  //Brewery
  event
    .shaped("botania:brewery", ["LBL", "LRL", "LML"], {
      M: "#forge:gears/manasteel",
      L: "botania:livingrock",
      B: "minecraft:brewing_stand",
      R: "botania:rune_mana",
    })
    .id("ftbskies:brewery");

  //Red String
  event
    .shapeless("botania:red_string", [
      "botania:mana_string",
      "#forge:storage_blocks/redstone",
      "powah:ender_core",
      "chipped:end_pumpkin",
    ])
    .id("ftbskies:red_string");

  //Corporea Spark
  event
    .shapeless("4x botania:corporea_spark", [
      "botania:spark",
      "powah:ender_core",
      "integrateddynamics:variable_transformer_output",
      "integrateddynamics:variable_transformer_input",
    ])
    .id("ftbskies:corporea_spark");

  //Conjuration Catalyst
  event
    .shaped("botania:conjuration_catalyst", ["LDL", "EAE", "LEL"], {
      L: "botania:livingrock",
      E: "botania:elementium_ingot",
      A: "botania:alchemy_catalyst",
      D: "botania:dragonstone",
    })
    .id("ftbskies:conjuration_catalyst");
});
