ServerEvents.recipes((event) => {
  event.forEachRecipe({ type: "create:crushing" }, (r) => {
    r.remove();
  });

  //Milling Recipes
  event
    .custom({
      type: "create:milling",
      ingredients: [
        {
          item: "minecraft:gravel",
        },
      ],
      processingTime: 250,
      results: [
        {
          item: "minecraft:sand",
        },
      ],
    })
    .id("ftbskies:millingsand");

  event
    .custom({
      type: "create:milling",
      ingredients: [
        {
          item: "minecraft:sand",
        },
      ],
      processingTime: 250,
      results: [
        {
          item: "ftbskies:dust",
        },
      ],
    })
    .id("ftbskies:millingdust");

  event
    .custom({
      type: "create:milling",
      ingredients: [
        {
          item: "minecraft:sand",
        },
      ],
      processingTime: 250,
      results: [
        {
          item: "ftbskies:dust",
        },
      ],
    })
    .id("ftbskies:millingdust");

  event
    .custom({
      type: "create:milling",
      ingredients: [
        {
          item: "thermal:sulfur",
        },
      ],
      processingTime: 250,
      results: [
        {
          item: "mekanism:dust_sulfur",
        },
      ],
    })
    .id("ftbskies:create_suflur_dust");

  event
    .custom({
      type: "create:milling",
      ingredients: [
        {
          item: "minecraft:end_stone",
        },
      ],
      processingTime: 250,
      results: [
        {
          item: "ftbskies:crushed_end_stone",
        },
      ],
    })
    .id("ftbskies:millingendstone");

    event
    .custom({
      type: "create:milling",
      ingredients: [
        {
          item: "minecraft:netherrack",
        },
      ],
      processingTime: 250,
      results: [
        {
          item: "ftbskies:crushed_netherrack",
        },
      ],
    })
    .id("ftbskies:millingnetherrack");

event.custom({
  "type": "create:haunting",
  "ingredients": [
    {
      "tag": "forge:dusts/glowstone"
    }
  ],
  "results": [
    {
      "item": "spirit:soul_powder",
      "count": 2
    }
  ]
}).id("ftbskies:haunting_soul_powder");

event.custom({
  "type": "create:haunting",
  "ingredients": [
    {
      "tag": "forge:storage_blocks/glowstone"
    }
  ],
  "results": [
    {
      "item": "spirit:soul_powder",
      "count": 8
    }
  ]
}).id("ftbskies:haunting_soul_powder2");

    //hand crank
  event
    .shaped("create:hand_crank", [" B ", "PPP", "  C"], {
      B: "#minecraft:buttons",
      P: "#minecraft:planks",
      C: "minecraft:cobblestone",
    })
    .id("ftbskies:handcrank");

  //sifter
  event
    .shaped("createsifter:sifter", ["PCP", "SGS", " S "], {
      G: "ftbskies:wooden_gear",
      P: "#minecraft:planks",
      C: "minecraft:cobblestone",
      S: "minecraft:stone",
    })
    .id("ftbskies:sifter");

  event.custom({
    "type": "create:mixing",
    "ingredients": [
      {
        "fluid": "pneumaticcraft:vegetable_oil",
        "amount": 100
      },
      {
        "item": "ftbskies:everburnair",
        "amount": 1
      },    
      {
        "fluid": "pneumaticcraft:ethanol",
        "amount": 100
      }
    ],
    "results": [
      {
        "fluid": "pneumaticcraft:biodiesel",
        "amount": 200
      }
    ]
  }).id("ftbskies:biodiesel_create_mixing");


  event.custom({
    "type": "create:compacting",
    "ingredients": [
      {
        "tag": "forge:seeds"
      }
    ],
    "results": [
      {
        "fluid": "pneumaticcraft:vegetable_oil",
        "amount": 25
      }
    ]
  }).id("ftbskies:seed_oil");

  event.custom({
    "type": "create:mixing",
    "ingredients": [
        {
            "item": "minecraft:spider_eye"
        },
        {
            "item": "minecraft:sugar"
        },
        {
            "fluid": "minecraft:water",
            "amount": 100
        }
    ],
    "processingTime": 200,
    "results": [
        {
            "item": "minecraft:fermented_spider_eye"
        },
        {
            "fluid": "pneumaticcraft:ethanol",
            "amount": 100
        }
    ]
  }).id("ftbskies:fermenting_spider_eye");
    
  //Primitive Slurry
  event
    .custom({
      type: "create:mixing",
      heatRequirement: "heated",
      ingredients: [
        {
          tag: "forge:gravel",
        },
        {
          tag: "forge:gravel",
        },
        {
          tag: "forge:gravel",
        },
        {
          tag: "forge:gravel",
        },
      ],
      results: [
        {
          amount: 1000,
          fluid: "ftbskies:primitive_slurry",
        },
      ],
    })
    .id("ftbskies:primitive_slurry");

  //Biomass
  event
    .custom({
      type: "create:mixing",
      ingredients: [
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "forge:carbon_dusts",
        },
      ],
      results: [
        {
          count: 8,
          item: "cyclic:biomass",
        },
      ],
    })
    .id("ftbskies:biomass");

  event
    .custom({
      type: "create:mixing",
      ingredients: [
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "minecraft:flowers",
        },
        {
          tag: "forge:dusts/coal_coke",
        },
      ],
      results: [
        {
          count: 16,
          item: "cyclic:biomass",
        },
      ],
    })
    .id("ftbskies:biomass_coke");

  //Cake batter
  event
    .custom({
      type: "create:mixing",
      ingredients: [
        {
          tag: "forge:eggs",
        },
        {
          tag: "forge:eggs",
        },
        {
          item: "minecraft:sugar",
        },
        {
          item: "minecraft:sugar",
        },
        {
          item: "minecraft:sugar",
        },
        {
          item: "create:wheat_flour",
        },
        {
          item: "create:wheat_flour",
        },
        {
          item: "create:wheat_flour",
        },
        {
          amount: 500,
          fluidTag: "forge:milk",
        },
      ],
      results: [
        {
          amount: 1000,
          fluid: "ftbskies:cake_batter",
        },
      ],
    })
    .id("ftbskies:cakemix");

  //icing
  event
    .custom({
      type: "create:mixing",
      ingredients: [
        {
          item: "minecraft:sugar",
        },
        {
          item: "minecraft:sugar",
        },
        {
          item: "minecraft:sugar",
        },
        {
          item: "minecraft:sweet_berries",
        },
        {
          item: "minecraft:sweet_berries",
        },
        {
          amount: 1000,
          fluidTag: "forge:milk",
        },
      ],
      results: [
        {
          amount: 1000,
          fluid: "ftbskies:icing",
        },
      ],
    })
    .id("ftbskies:icingmix");

  //cake base uncooked
  event
    .custom({
      type: "create:compacting",
      ingredients: [
        {
          amount: 500,
          fluid: "ftbskies:cake_batter",
        },
      ],
      results: [
        {
          item: "createaddition:cake_base",
        },
      ],
    })
    .id("ftbskies:cake_base");

  //Cake
  event
    .custom({
      type: "create:filling",
      ingredients: [
        {
          item: "createaddition:cake_base_baked",
        },
        {
          fluid: "ftbskies:icing",
          amount: 500,
        },
      ],
      results: [
        {
          item: "minecraft:cake",
        },
      ],
    })
    .id("ftbskies:cake");

  //Raw Copper
  event
    .custom({
      type: "create:mixing",
      ingredients: [
        {
          item: "mekanism:shard_copper",
        },
        {
          item: "mekanism:shard_copper",
        },
        {
          item: "mekanism:shard_copper",
        },
        {
          item: "mekanism:shard_copper",
        },
      ],
      results: [
        {
          item: "minecraft:raw_copper",
        },
      ],
    })
    .id("ftbskies:raw_copper");

  //Coke brick
  event
    .custom({
      type: "create:sequenced_assembly",
      ingredient: {
        item: "ars_nouveau:fire_essence",
      },
      loops: 4,
      results: [
        {
          item: "immersiveengineering:cokebrick",
        },
      ],
      sequence: [
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "ftbskies:incomplete_cokebrick",
            },
            {
              tag: "forge:sandstone",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_cokebrick",
            },
          ],
        },
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "ftbskies:incomplete_cokebrick",
            },
            {
              item: "minecraft:clay_ball",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_cokebrick",
            },
          ],
        },
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "ftbskies:incomplete_cokebrick",
            },
            {
              item: "supplementaries:ash_brick",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_cokebrick",
            },
          ],
        },
      ],
      transitionalItem: {
        item: "ftbskies:incomplete_cokebrick",
      },
    })
    .id("ftbskies:cokebrick");

  // Vector Plates

  event
    .custom({
      type: "create:sequenced_assembly",
      ingredient: {
        item: "darkutils:vector_plate",
      },
      loops: 2,
      results: [
        {
          item: "darkutils:vector_plate_fast",
        },
      ],
      sequence: [
        {
          type: "create:filling",
          ingredients: [
            {
              item: "ftbskies:incomplete_fast_vector_plate",
            },
            {
              amount: 100,
              fluid: "ftbskies:primitive_slurry",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_fast_vector_plate",
            },
          ],
        },
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "ftbskies:incomplete_fast_vector_plate",
            },
            {
              item: "minecraft:sugar",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_fast_vector_plate",
            },
          ],
        },
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "ftbskies:incomplete_fast_vector_plate",
            },
            {
              item: "minecraft:sugar",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_fast_vector_plate",
            },
          ],
        },
        {
          type: "create:filling",
          ingredients: [
            {
              item: "ftbskies:incomplete_fast_vector_plate",
            },
            {
              amount: 100,
              fluid: "ftbskies:primitive_slurry",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_fast_vector_plate",
            },
          ],
        },
      ],
      transitionalItem: {
        item: "ftbskies:incomplete_fast_vector_plate",
      },
    })
    .id("ftbskies:fast_vector_plate");

  //Ash brick
  event
    .custom({
      type: "create:compacting",
      heatRequirement: "heated",
      ingredients: [
        {
          item: "supplementaries:ash",
        },
        {
          item: "supplementaries:ash",
        },
      ],
      results: [
        {
          item: "supplementaries:ash_brick",
        },
      ],
    })
    .id("ftbskies:ashbrick");

  //Gold Ingot
  event
    .custom({
      type: "create:compacting",
      heatRequirement: "heated",
      ingredients: [
        {
          item: "mekanism:shard_gold",
        },
        {
          item: "mekanism:shard_gold",
        },
      ],
      results: [
        {
          item: "minecraft:gold_ingot",
        },
        {
          item: "thermal:slag",
        },
      ],
    })
    .id("ftbskies:goldingot");

  //Blast brick
  event
    .custom({
      type: "create:sequenced_assembly",
      ingredient: {
        tag: "forge:magma",
      },
      loops: 4,
      results: [
        {
          item: "immersiveengineering:blastbrick",
        },
      ],
      sequence: [
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "ftbskies:incomplete_blastbrick",
            },
            {
              item: "minecraft:nether_brick",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_blastbrick",
            },
          ],
        },
        {
          type: "create:filling",
          ingredients: [
            {
              item: "ftbskies:incomplete_blastbrick",
            },
            {
              amount: 125,
              fluid: "immersiveengineering:creosote",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_blastbrick",
            },
          ],
        },
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "ftbskies:incomplete_blastbrick",
            },
            {
              item: "ftbskies:everburnair",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_blastbrick",
            },
          ],
        },
        {
          type: "create:pressing",
          ingredients: [
            {
              item: "ftbskies:incomplete_blastbrick",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_blastbrick",
            },
          ],
        },
      ],
      transitionalItem: {
        item: "ftbskies:incomplete_blastbrick",
      },
    })
    .id("ftbskies:blastbrick");

  //Blast brick slab
  event
    .custom({
      type: "create:cutting",
      ingredients: [
        {
          item: "immersiveengineering:blastbrick",
        },
      ],
      processingTime: 50,
      results: [
        {
          item: "immersiveengineering:slab_blastbrick",
        },
        {
          item: "immersiveengineering:slab_blastbrick",
        },
      ],
    })
    .id("ftbskies:blastbrick_slab");

  event
    .custom({
      type: "create:pressing",
      ingredients: [
        {
          item: "ftbskies:iron_substrate",
        },
      ],
      results: [
        {
          item: "thermal:iron_plate",
        },
      ],
    })
    .id("ftbskies:iron_pressed_plate");

  //reinforced blast brick slab
  event
    .custom({
      type: "create:deploying",
      ingredients: [
        {
          item: "immersiveengineering:slab_blastbrick",
        },
        {
          tag: "forge:plates/steel",
        },
      ],
      results: [
        {
          item: "immersiveengineering:slab_blastbrick_reinforced",
        },
      ],
    })
    .id("ftbskies:blastbrick_reinforced_slab");

  //reinforced blast brick slab reverse
  event
    .custom({
      type: "create:cutting",
      ingredients: [
        {
          item: "immersiveengineering:blastbrick_reinforced",
        },
      ],
      processingTime: 50,
      results: [
        {
          item: "immersiveengineering:slab_blastbrick_reinforced",
        },
        {
          item: "immersiveengineering:slab_blastbrick_reinforced",
        },
      ],
    })
    .id("ftbskies:blastbrick_to_slab");

  //Blaze Burner
  event
    .shaped("create:empty_blaze_burner", [" P ", "PSP", " P "], {
      P: "thermal:iron_plate",
      S: "spirit:soul_cage",
    })
    .id("ftbskies:blaze_burner");

    let dieselGen = Item.of('custommachinery:custom_machine_item', '{machine:\"ftbskies:diesel_generator\"}')

  //Diesel Engine
  event
    .custom({
      type: "create:mechanical_crafting",
      pattern: ["#Q#", "#G#", "BFB", "OSO"],
      key: {
        "#": {
          item: "create:mechanical_piston",
        },
        Q: {
          item: "immersiveengineering:rs_engineering",
        },
        G: {
          item: "immersiveengineering:light_engineering",
        },
        B: {
          tag: "forge:plates/brass",
        },
        O: {
          item: "create:sturdy_sheet",
        },
        S: {
          item: "create:fluid_pipe",
        },
        F: {
          item: "create:fluid_tank",
        },
      },
      result: dieselGen
    })
    .id("ftbskies:diesel_engine");

  //Thermal machine Frame
  event
    .custom({
      type: "create:mechanical_crafting",
      pattern: ["IRI", "LPL", "IHI"],
      key: {
        I: {
          item: "pneumaticcraft:ingot_iron_compressed",
        },
        R: {
          item: "immersiveengineering:rs_engineering",
        },
        L: {
          item: "immersiveengineering:light_engineering",
        },
        P: {
          item: "industrialforegoing:machine_frame_pity",
        },
        H: {
          item: "immersiveengineering:heavy_engineering",
        },
      },
      result: {
        item: "thermal:machine_frame",
        count: 2,
      },
    })
    .id("ftbskies:mech_machine_frame");


    event
    .custom({
      type: "create:mechanical_crafting",
      pattern: ["PPP", "FCF", "PPP"],
      key: {
        C: {
          tag: "forge:circuits/advanced",
        },
        F: {
          tag: "forge:plates/force",
        },
        P: {
          item: "pneumaticcraft:pressure_chamber_wall",
        },
      },
      result: {
        item: 'custommachinery:custom_machine_item',
        nbt: '{machine:\"ftbskies:implosion_compressor\"}',
      },
    })
    .id("ftbskies:implosion_compressor");


  //space plating block
  event
    .custom({
      type: "create:sequenced_assembly",
      ingredient: {
        tag: "forge:sheetmetals/steel",
      },
      loops: 4,
      results: [
        {
          item: "ftbskies:space_plating_block",
        },
      ],
      sequence: [
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "ftbskies:incomplete_space_plating_block",
            },
            {
              item: "ftbskies:space_plate",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_space_plating_block",
            },
          ],
        },
        {
          type: "create:filling",
          ingredients: [
            {
              item: "ftbskies:incomplete_space_plating_block",
            },
            {
              amount: 125,
              fluid: "ftbskies:polyethylene",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_space_plating_block",
            },
          ],
        },
        {
          type: "create:pressing",
          ingredients: [
            {
              item: "ftbskies:incomplete_space_plating_block",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_space_plating_block",
            },
          ],
        },
      ],
      transitionalItem: {
        item: "ftbskies:incomplete_space_plating_block",
      },
    })
    .id("ftbskies:space_plating_block");

    //etching acid
    event
    .custom({
      type: "create:mixing",
      ingredients: [
        {
          item: "minecraft:spider_eye",
        },
        {
          item: "minecraft:rotten_flesh",
        },
        {
          item: "minecraft:gunpowder",
        },    
        {
          "amount": 500,
          "fluidTag": "forge:redstone_acid"
        }
    ],
      results: [
        {
          "amount": 500,
          "fluid": "pneumaticcraft:etching_acid"
        },
      ],
    })
    .id("ftbskies:ethcing_acid");



  event
    .custom({
      type: "create:mixing",
      ingredients: [
        {
          item: "minecraft:bone_meal",
        },
        {
          item: "minecraft:bone_meal",
        },
        {
          item: "minecraft:bone_meal",
        },
        {
          item: "minecraft:bone_meal",
        },
        {
          tag: "forge:carbon_dusts",
        },
      ],
      results: [
        {
          count: 8,
          item: "cyclic:biomass",
        },
      ],
    })
    .id("ftbskies:biomass_meal");

  event
    .custom({
      type: "create:mixing",
      ingredients: [
        {
          item: "minecraft:bone_meal",
        },
        {
          item: "minecraft:bone_meal",
        },
        {
          item: "minecraft:bone_meal",
        },
        {
          item: "minecraft:bone_meal",
        },
        {
          tag: "forge:dusts/coal_coke",
        },
      ],
      results: [
        {
          count: 16,
          item: "cyclic:biomass",
        },
      ],
    })
    .id("ftbskies:biomass_coke_meal");

  event
    .custom({
      type: "create:mixing",
      ingredients: [
        {
          tag: "minecraft:dirt",
        },
        {
          tag: "minecraft:dirt",
        },
        {
          tag: "minecraft:dirt",
        },
        {
          item: "cyclic:biomass",
        },
        {
          item: "cyclic:biomass",
        },
        {
          item: "cyclic:biomass",
        },
        {
          item: "cyclic:biomass",
        },
        {
          tag: "forge:dusts/coal_coke",
        },
        {
          tag: "forge:dusts/coal_coke",
        },
      ],
      results: [
        {
          count: 2,
          item: "cyclic:peat_unbaked",
        },
      ],
    })
    .id("ftbskies:peat_unbaked_mixing");

  event
    .custom({
      type: "create:mixing",
      ingredients: [
        {
          tag: "minecraft:dirt",
        },
        {
          tag: "minecraft:dirt",
        },
        {
          tag: "minecraft:dirt",
        },
        {
          item: "cyclic:biomass",
        },
        {
          item: "cyclic:biomass",
        },
        {
          item: "cyclic:biomass",
        },
        {
          item: "cyclic:biomass",
        },
        {
          tag: "forge:carbon_dusts",
        },
        {
          tag: "forge:carbon_dusts",
        },
      ],
      results: [
        {
          count: 1,
          item: "cyclic:peat_unbaked",
        },
      ],
    })
    .id("ftbskies:peat_unbaked_mixing_1");

  //Projector Dish
  event
    .custom({
      type: "create:mechanical_crafting",
      pattern: ["GSH", "GES", "GSH"],
      key: {
        G: {
          item: "elementalcraft:springaline_glass_pane",
        },
        S: {
          item: "mekanism:ingot_steel",
        },
        E: {
          item: "minecraft:ender_eye",
        },
        H: {
          item: "thermal:obsidian_glass",
        },
      },
      result: {
        item: "compactcrafting:projector_dish",
      },
    })
    .id("ftbskies:projector_dish");

  //Compact Crafting Base
  event
    .custom({
      type: "create:mechanical_crafting",
      pattern: [" T ", "DCD", "SFS"],
      key: {
        T: {
          item: "minecraft:redstone_torch",
        },
        D: {
          item: "botania:mana_diamond",
        },
        C: {
          item: "pneumaticcraft:pneumatic_cylinder",
        },
        S: {
          item: "pneumaticcraft:reinforced_stone_slab",
        },
        F: {
          item: "industrialforegoing:machine_frame_simple",
        },
      },
      result: {
        item: "compactcrafting:base",
      },
    })
    .id("ftbskies:projector_base");

  //Inscriber
  event
    .custom({
      type: "create:mechanical_crafting",
      pattern: ["SPS", "C Q", "SPS"],
      key: {
        S: {
          item: "mekanism:ingot_steel",
        },
        P: {
          item: "minecraft:sticky_piston",
        },
        C: {
          item: "minecraft:copper_ingot",
        },
        Q: {
          item: "ae2:certus_quartz_crystal",
        },
      },
      result: {
        item: "ae2:inscriber",
      },
    })
    .id("ftbskies:inscriber");

  event.custom({
    type: "create:mixing",
    heatRequirement: "heated",
    ingredients: [
      {
        tag: "forge:sandstone",
      },
      {
        tag: "forge:ingots/brick",
      },
    ],
    results: [
      {
        item: "immersiveengineering:alloybrick",
      },
    ],
  });

  //magnetic block
  event
    .shaped("create_new_age:magnetite_block", ["DDD", "DMD", "DDD"], {
      M: "create_new_age:overcharged_iron",
      D: "minecraft:deepslate",
    })
    .id("ftbskies:magnetic_block");

  //redstone magnet
  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "create_new_age:magnetite_block",
        },
        {
          fluid: "ftbskies:volatile_redstone",
          amount: 1000,
        },
      ],
      result: [
        {
          item: "create_new_age:redstone_magnet",
        },
      ],
    })
    .id("ftbskies:redstone_magnet");

  //Layered magnet
  event
    .custom({
      type: "thermal:smelter",
      ingredients: [
        {
          value: [
            {
              item: "create_new_age:overcharged_gold",
            },
          ],
          count: 4,
        },
        {
          item: "create_new_age:redstone_magnet",
          count: 1,
        },
      ],
      result: [
        {
          item: "create_new_age:layered_magnet",
          count: 1,
        },
      ],
      energy: 120000,
    })
    .id("ftbskies:layered_magnet");
  //fluxed magnet
  event
    .custom({
      type: "immersiveengineering:arc_furnace",
      additives: [{ item: "redstone_arsenal:flux_ingot" }],
      energy: 204800,
      input: { item: "create_new_age:layered_magnet" },
      results: [
        {
          base_ingredient: { item: "create_new_age:fluxuated_magnetite" },
          count: 1,
        },
      ],
      time: 5000,
    })
    .id("ftbskies:fluxed_magnet");
  //overcharged sheet compat
  event
    .custom({
      type: "immersiveengineering:metal_press",
      energy: 2400,
      mold: "immersiveengineering:mold_plate",
      input: { item: "create_new_age:overcharged_iron" },
      result: { item: "create_new_age:overcharged_iron_sheet" },
    })
    .id("ftbskies:overcharged_iron_sheet_metal_press");

  event
    .custom({
      type: "immersiveengineering:metal_press",
      energy: 2400,
      mold: "immersiveengineering:mold_plate",
      input: { item: "create_new_age:overcharged_gold" },
      result: { item: "create_new_age:overcharged_golden_sheet" },
    })
    .id("ftbskies:overcharged_gold_sheet_metal_press");

  event
    .custom({
      type: "thermal:press",
      ingredient: {
        item: "create_new_age:overcharged_iron",
      },
      result: [
        {
          item: "create_new_age:overcharged_iron_sheet",
        },
      ],
    })
    .id("ftbskies:overcharged_iron_sheet_multiservo_press");

  event
    .custom({
      type: "thermal:press",
      ingredient: {
        item: "create_new_age:overcharged_gold",
      },
      result: [
        {
          item: "create_new_age:overcharged_golden_sheet",
        },
      ],
    })
    .id("ftbskies:overcharged_gold_sheet_multiservo_press");

  event
    .shaped("create:electron_tube", ["RRR", "R R", "RIR"], {
      R: "glassential:glass_redstone",
      I: "thermal:iron_plate",
    })
    .id("ftbskies:electron_tube");

  event
    .custom({
      type: "createaddition:liquid_burning",
      input: {
        fluid: "ftbskies:force_infused_biodiesel",
        amount: 1000,
      },
      burnTime: 48000,
      superheated: true,
    })
    .id("ftbskies:force_infused_biodiesel_burning");

  event
    .custom({
      type: "createaddition:liquid_burning",
      input: {
        fluid: "hexerei:quicksilver_fluid",
        amount: 1000,
      },
      burnTime: 48000,
      superheated: true,
    })
    .id("ftbskies:quicksilver_burning");

  event
    .custom({
      type: "createaddition:liquid_burning",
      input: {
        fluid: "ftbskies:force_infused_diesel",
        amount: 1000,
      },
      burnTime: 48000,
      superheated: true,
    })
    .id("ftbskies:force_infused_diesel_burning");

  event
    .custom({
      type: "createaddition:liquid_burning",
      input: {
        fluid: "ftbskies:flux_diesel",
        amount: 1000,
      },
      burnTime: 192000,
      superheated: true,
    })
    .id("ftbskies:flux_diesel_burning");

  event
    .custom({
      type: "create:sequenced_assembly",
      ingredient: {
        tag: "forge:plates/gold",
      },
      loops: 5,
      results: [
        {
          chance: 120.0,
          item: "create:precision_mechanism",
        },
        {
          chance: 8.0,
          item: "thermal:gold_plate",
        },
        {
          chance: 8.0,
          item: "create:andesite_alloy",
        },
        {
          chance: 5.0,
          item: "create:cogwheel",
        },
        {
          chance: 3.0,
          item: "minecraft:gold_nugget",
        },
        {
          chance: 2.0,
          item: "create:shaft",
        },
        {
          chance: 2.0,
          item: "create:crushed_raw_gold",
        },
        {
          item: "minecraft:iron_ingot",
        },
        {
          item: "minecraft:clock",
        },
      ],
      sequence: [
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "create:incomplete_precision_mechanism",
            },
            {
              item: "create:cogwheel",
            },
          ],
          results: [
            {
              item: "create:incomplete_precision_mechanism",
            },
          ],
        },
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "create:incomplete_precision_mechanism",
            },
            {
              item: "create:large_cogwheel",
            },
          ],
          results: [
            {
              item: "create:incomplete_precision_mechanism",
            },
          ],
        },
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "create:incomplete_precision_mechanism",
            },
            {
              tag: "forge:nuggets/iron",
            },
          ],
          results: [
            {
              item: "create:incomplete_precision_mechanism",
            },
          ],
        },
      ],
      transitionalItem: {
        item: "create:incomplete_precision_mechanism",
      },
    })
    .id("ftbskies:precision_mechanism");

  //Platinum Plates with Create
  event
    .custom({
      type: "create:pressing",
      ingredients: [
        {
          item: "ftbskies:platinum_ingot",
        },
      ],
      results: [
        {
          item: "ftbskies:platinum_plate",
        },
      ],
    })
    .id("ftbskies:_create_platinum_plate");

  event
    .shapeless("create:encased_chain_drive", ["create:andesite_casing", "3x thermal:iron_plate"])
    .id("ftbskies:encased_chain_drive");

  event
    .custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "ironchest:iron_chest"
      },
      "loops": 1,
      "results": [
        {
          "item": "create:item_vault",
          count: 4,
        }
      ],
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "ironchest:iron_chest"
            },
            [
              {
                "tag": "forge:plates/invar"
              }
            ]
          ],
          "results": [
            {
              "item": "ironchest:iron_chest"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "ironchest:iron_chest"
            },
            [
              {
                "tag": "forge:plates/invar"
              }
            ]
          ],
          "results": [
            {
              "item": "ironchest:iron_chest"
            }
          ]
        },
        {
          "type": "create:pressing",
          "ingredients": [
            {
              "item": "ironchest:iron_chest"
            }
          ],
          "results": [
            {
              "item": "ironchest:iron_chest"
            }
          ]
        }
      ],
      "transitionalItem": {
        "item": "ironchest:iron_chest"
      }
    })
    .id("ftbskies:vault");

    event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          item: "minecraft:cobblestone",
        },
        {
          item: "elementalcraft:watercrystal_block",
        },
      ],
      pressure: 1.0,
      results: [
        {
          item: "create:asurine",
        },
      ],
    });

  event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          item: "minecraft:cobblestone",
        },
        {
          item: "elementalcraft:firecrystal_block",
        },
      ],
      pressure: 1.0,
      results: [
        {
          item: "create:crimsite",
        },
      ],
    });

  event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          item: "minecraft:cobblestone",
        },
        {
          item: "elementalcraft:aircrystal_block",
        },
      ],
      pressure: 1.0,
      results: [
        {
          item: "create:ochrum",
        },
      ],
    });

  event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          item: "minecraft:cobblestone",
        },
        {
          item: "elementalcraft:earthcrystal_block",
        },
      ],
      pressure: 1.0,
      results: [
        {
          item: "create:veridium",
        },
      ],
    });

});

// script for repairing the rickety water wheels
const repairItems = {
  "create:andesite_alloy": 36000,
};

const $KineticBlock = Java.loadClass("com.simibubi.create.content.kinetics.base.KineticBlockEntity");
const RotProp = Java.loadClass("com.simibubi.create.content.kinetics.RotationPropagator");

BlockEvents.rightClicked("ftbricketyww:rickety_water_wheel", (event) => {
  const { player, hand, item, block, server, level } = event;
  if (hand != "MAIN_HAND") return;
  if (!player) return;
  if (!player.isPlayer()) return;
  if (player.isFake()) return;

  // Get the Kinetic Block
  let kinBlock = $KineticBlock(level.getBlockEntity(block.pos));
  // Get the Network
  let network = kinBlock.getOrCreateNetwork();

  // get Durabilty and Repair (also break Network)
  let data = block.entityData;
  if (repairItems[item.id]) {
    if (data.Durability > 35990) {
      actionbar(player.username, `Already Repaired`);
      event.cancel();
      return;
    }
    if (data.Durability + repairItems[item.id] >= 35999) {
      actionbar(player.username, `Fully Repaired`);
      data.Durability = 36000;
    } else {
      actionbar(player.username, `Adding ${repairItems[item.id]} durability`);
      data.Durability = data.Durability + repairItems[item.id];
    }
    level.getBlock(block.x, block.y, block.z).mergeEntityData(data);
    item.count--;
    server.runCommandSilent(
      `execute in ${level.dimension} run particle minecraft:wax_off ${block.x + 0.5} ${block.y + 0.5} ${
        block.z + 0.5
      } 0.5 0.1 0.5 2 50`
    );

    // Add back to Network
    if (network) {
      kinBlock.setNetwork(network.id);
      network.add(kinBlock);
      network.updateNetwork();

      // This still Errors somehow, but it works
      // add all members back to the network
      try {
        network.members.forEach((member) => {
          member.setSource(kinBlock);
        });
      } catch (error) {}
      RotProp.handleAdded(event.level, block.pos, kinBlock);
    }
  }
});
