const commonKeys = {
  T: "create:fluid_tank",
  G: "ae2:quartz_vibrant_glass",
  H: "pneumaticcraft:heat_sink",
};

const centrifugeMap = [
  ["PGP", "TET", "PmP"],
  ["PGP", "T T", "PGP"],
  ["PGP", "T T", "PGP"],
  ["PGP", "TMT", "PGP"],
];

const centrifugeKeys = {
  T: "create:fluid_tank",
  G: "ae2:quartz_vibrant_glass",
  H: "pneumaticcraft:heat_sink",
  P: "ad_astra:steel_pillar",
  M: "create:mechanical_mixer",
  E: "ad_astra:energizer",
};

const quantumMap = [
  [" ESE ", " ECE ", " ECE ", " QQQ ", " FCF "],
  [" CGC ", " C C ", " C C ", " QLQ ", " CmC "],
  [" FSF ", " FCF ", " FCF ", " QQQ ", " FCF "],
];

const quantumKeys = {
  T: "create:fluid_tank",
  G: "ae2:quartz_vibrant_glass",
  H: "pneumaticcraft:heat_sink",
  F: "ae2:fluix_stairs",
  S: "rftoolsbuilder:space_chamber",
  C: "compactmachines:wall",
  Q: "ae2:quantum_ring",
  L: "ae2:quantum_link",
  E: "entangled:block",
};

const rtgMap = [
  ["PPP", "PPP", "PmP"],
  [" C ", "CPC", " C "],
  [" C ", "CPC", " C "],
  [" H ", "HHH", " H "],
];

const rtgKeys = {
  T: "create:fluid_tank",
  G: "ae2:quartz_vibrant_glass",
  H: "pneumaticcraft:heat_sink",
  C: "create:cut_calcite_wall",
  P: "ad_astra:desh_plating",
};

const microfusionMap = [
  ["PGP", "TPT", "PmP"],
  ["PGP", "T T", "PGP"],
  ["PGP", "TET", "PGP"],
  ["HHH", "HHH", "HHH"],
];

const microfusionKeys = {
  T: "create:fluid_tank",
  G: "ae2:quartz_vibrant_glass",
  H: "pneumaticcraft:heat_sink",
  P: "ad_astra:calorite_pillar",
  E: "create_new_age:energiser_t3",
};

function centrifugeRecipe(event, duration, id, requiresStructure) {
  const recipe = event.recipes.custommachinery.custom_machine("ftbskies:fabrication_matrix", duration);

  if (requiresStructure === true) {
    recipe.requireStructure(centrifugeMap, centrifugeKeys);
  }
  let itemTotal = 0;
  return {
    energyInput(energyIn) {
      recipe.requireEnergy(energyIn);
      return this;
    },

    itemInput(item) {
      // Max of 2, KubeJs Item.of()
      itemTotal++;
      recipe.requireItem(item);
      return this;
    },

    itemTagInput(tag, amount) {
      // Max of 4
      itemTotal++;
      recipe.requireItemTag(tag, amount);
      return this;
    },

    fluidInput(fluid) {
      // KubeJs Fluid.of()
      recipe.requireFluid(fluid, "inputtank");
      return this;
    },

    fluidTagInput(tag, amount) {
      recipe.requireFluidTag(tag, amount, "inputtank");
      return this;
    },

    itemOutput(item) {
      // Max of 6, KubeJs Item.of
      itemTotal++;
      recipe.produceItem(item, `outputslot${itemTotal}`);
      return this;
    },

    fluidOutput(fluid) {
      recipe.produceFluid(fluid, "outputtank");
      return this;
    },

    requireBiome(biome) {
      recipe.biomeWhitelist(biome);
      return this;
    },

    build() {
      recipe.jei();
      recipe.id(id);
    },
  };
}

function quantumAssemblerRecipe(event, duration, id) {
  const recipe = event.recipes.custommachinery
    .custom_machine("ftbskies:quantum_assembler", duration)
    .requireStructure(quantumMap, quantumKeys);
  let itemTotal = 0;
  let fluidTotal = 0;
  return {
    energyInput(energyIn) {
      recipe.requireEnergy(energyIn);
      return this;
    },
    itemInput(item) {
      // Max of 8, KubeJs Item.of
      itemTotal++;
      recipe.requireItem(item);
      return this;
    },
    itemTagInput(tag, amount) {
      // Max of 8
      itemTotal++;
      recipe.requireItemTag(tag, amount);
      return this;
    },
    fluidInput(fluid) {
      // Max of 6, KubeJs Fluid.of
      fluidTotal++;
      recipe.requireFluid(fluid);
      return this;
    },
    fluidTagInput(tag, amount) {
      // Max of 6
      fluidTotal++;
      recipe.requireFluidTag(tag, amount);
      return this;
    },
    itemOutput(item) {
      // KubeJs Item.of
      recipe.produceItem(item, "outputslot");
      return this;
    },
    fluidOutput(fluid) {
      recipe.produceFluid(fluid, "outputtank");
      return this;
    },
    build() {
      recipe.jei();
      recipe.id(id);
    },
  };
}

//advanced mixer foobar
function advancedMixerRecipe(event, duration, id) {
  const recipe = event.recipes.custommachinery.custom_machine("ftbskies:advanced_mixer", duration);
  let itemTotal = 0;
  let fluidTotal = 0;
  return {
    energyInput(energyIn) {
      recipe.requireEnergy(energyIn);
      return this;
    },
    heatInput(heat) {
      recipe.requireHeat(heat);
      return this;
    },
    itemInput(item) {
      // Max of 4, KubeJs Item.of
      itemTotal++;
      recipe.requireItem(item);
      return this;
    },
    itemTagInput(tag, amount) {
      // Max of 4
      itemTotal++;
      recipe.requireItemTag(tag, amount);
      return this;
    },
    fluidInput(fluid) {
      // Max of 2, KubeJs Fluid.of
      fluidTotal++;
      recipe.requireFluid(fluid);
      return this;
    },
    fluidTagInput(tag, amount) {
      // Max of 2
      fluidTotal++;
      recipe.requireFluidTag(tag, amount);
      return this;
    },
    itemOutput(item) {
      // KubeJs Item.of
      recipe.produceItem(item, "outputslot");
      return this;
    },
    fluidOutput(fluid) {
      recipe.produceFluid(fluid, "outputtank");
      return this;
    },
    build() {
      recipe.jei();
      recipe.id(id);
    },
  };
}

function dieselGeneratorRecipe(event, duration, id, priority) {
  const recipe = event.recipes.custommachinery.custom_machine("ftbskies:diesel_generator", duration);
  return {
    fluidTagInput(tag, amount) {
      recipe.requireFluidTag(tag, amount, "inputtank1");
      return this;
    },
    fluidInput(fluid, amount) {
      recipe.requireFluid(Fluid.of(fluid, amount), "inputtank2");
      return this;
    },
    stressOutput(rpm, stress) {
      recipe.produceSU(rpm, stress);
      return this;
    },
    build() {
      recipe.requireRedstone(0);
      recipe.priority(priority);
      recipe.jei();
      recipe.id(id);
    },
  };
}

function advancedDieselGeneratorRecipe(event, duration, id, priority) {
  const recipe = event.recipes.custommachinery.custom_machine("ftbskies:advanced_diesel_generator", duration);
  return {
    fluidTagInput(tag, amount) {
      recipe.requireFluidTag(tag, amount * 8, "inputtank1");
      return this;
    },
    fluidInput(fluid, amount) {
      recipe.requireFluid(Fluid.of(fluid, amount * 4), "inputtank2");
      return this;
    },
    stressOutput(rpm, stress) {
      recipe.produceSU(rpm, stress * 8);
      return this;
    },
    build() {
      recipe.requireRedstone(0);
      recipe.priority(priority);
      recipe.jei();
      recipe.id(id);
    },
  };
}

function turboDieselGeneratorRecipe(event, duration, id, priority) {
  const recipe = event.recipes.custommachinery.custom_machine("ftbskies:turbo_diesel_generator", duration);
  return {
    fluidTagInput(tag, amount) {
      recipe.requireFluidTag(tag, amount * 64, "inputtank1");
      return this;
    },
    fluidInput(fluid, amount) {
      recipe.requireFluid(Fluid.of(fluid, amount * 32), "inputtank2");
      return this;
    },
    stressOutput(rpm, stress) {
      recipe.produceSU(rpm, stress * 64);
      return this;
    },
    build() {
      recipe.requireRedstone(0);
      recipe.priority(priority);
      recipe.jei();
      recipe.id(id);
    },
  };
}

function hyperDieselGeneratorRecipe(event, duration, id, priority) {
  const recipe = event.recipes.custommachinery.custom_machine("ftbskies:hyper_diesel_generator", duration);
  return {
    fluidTagInput(tag, amount) {
      recipe.requireFluidTag(tag, amount * 512, "inputtank1");
      return this;
    },
    fluidInput(fluid, amount) {
      recipe.requireFluid(Fluid.of(fluid, amount * 256), "inputtank2");
      return this;
    },
    stressOutput(rpm, stress) {
      recipe.produceSU(rpm, stress * 512);
      return this;
    },
    build() {
      recipe.requireRedstone(0);
      recipe.priority(priority);
      recipe.jei();
      recipe.id(id);
    },
  };
}

//.requireStructure(

function implosionRecipe(event, duration, id, biomes) {
  const recipe = event.recipes.custommachinery
    .custom_machine("ftbskies:implosion_compressor", duration)
    .requireStructure(
      [
        ["aaa", "aaa", "aaa"],
        ["aba", "bnb", "ama"],
        ["aaa", "aba", "aaa"],
      ],
      { a: "mekanism:dynamic_tank", b: "thermal:lumium_glass", n: "laserio:laser_node" }
    );
  let inputTotal = 0;
  let outputTotal = 0;
  return {
    itemInput(item) {
      // Max of 2, Use KubeJs Item.of
      inputTotal++;
      recipe.requireItem(item, `inputslot${inputTotal}`);
      return this;
    },
    itemTagInput(tag, amount) {
      // Max of 2
      inputTotal++;
      recipe.requireItemTag(tag, amount, `inputslot${inputTotal}`);
      return this;
    },
    itemOutput(item) {
      // Max of 2, KubeJs Item.of
      outputTotal++;
      recipe.produceItem(item, `outputslot${outputTotal}`);
      return this;
    },
    build() {
      recipe.biomeWhitelist(biomes);
      recipe.jei();
      recipe.id(id);
    },
  };
}

function microfusionRecipe(event, duration, id) {
  const recipe = event.recipes.custommachinery
    .custom_machine("ftbskies:microfusion_extrapolator", duration)
    .requireStructure(microfusionMap, microfusionKeys);
  let itemTotal = 0;

  return {
    itemInput(item) {
      // Max of 2, Use KubeJs Item.of
      itemTotal++;
      recipe.requireItem(item, `inputslot${itemTotal}`);
      return this;
    },
    itemTagInput(tag, amount) {
      // Max of 2
      itemTotal++;
      recipe.requireItemTag(tag, amount, `inputslot${itemTotal}`);
      return this;
    },
    fuel(amount, fluid) {
      recipe.requireFluid(Fluid.of(fluid, amount), "inputtank");
      return this;
    },
    radiationInput(rads, radiusForRadiation) {
      recipe.requireRadiationPerTick(rads);
      return this;
    },
    heatInput(heat) {
      recipe.requireHeat(heat);
      return this;
    },
    itemOutput(item) {
      recipe.produceItem(item, "outputslot");
      return this;
    },
    build() {
      recipe.jei();
      recipe.id(id);
    },
  };
}

function rtgRecipe(event, duration, id) {
  const recipe = event.recipes.custommachinery.custom_machine("ftbskies:rtg_generator", duration);
  //.requireStructure(rtgMap, rtgKeys);
  return {
    itemInput(item) {
      // Use KubeJs Item.of
      recipe.requireItem(item, "inputslot");
      return this;
    },
    itemTagInput(tag, amount) {
      recipe.requireItemTag(tag, amount, "inputslot");
      return this;
    },
    heatPerTick(heat) {
      recipe.produceHeatPerTick(heat);
      return this;
    },
    energyPerTick(energy) {
      recipe.produceEnergyPerTick(energy);
      return this;
    },
    radiationPerTick(rads) {
      recipe.emitRadiationPerTick(rads);
      return this;
    },
    build() {
      recipe.requireRedstone(0);
      recipe.jei();
      recipe.id(id);
    },
  };
}

const fuelMap = [
  ["forge:biodiesel", 22, 2],
  ["forge:diesel", 32, 2],
  ["forge:flux_diesel", 127, 1],
  ["forge:force_biodiesel", 64, 1],
  ["forge:force_diesel", 84, 1],
  ["forge:nitro_diesel", 256, 1],
];

ServerEvents.recipes((event) => {
  centrifugeRecipe(event, 60, "ftbskies:alt_processor", true)
    .energyInput(20000)
    .itemInput(Item.of("createteleporters:quantum_mechanism", 1))
    .fluidInput(Fluid.of("integrateddynamics:menril_resin", 250))
    .itemOutput(Item.of("mekanism:basic_control_circuit"), 2)
    .build();

  centrifugeRecipe(event, 600, "ftbskies:alt_processor_adv", true)
    .energyInput(40000)
    .itemInput(Item.of("jaopca:processors.signalum", 1))
    .fluidInput(Fluid.of("ftbskies:volatile_redstone", 250))
    .itemOutput(Item.of("mekanism:advanced_control_circuit"), 1)
    .build();

  centrifugeRecipe(event, 100, "ftbskies:venus_blaze_rod", true)
    .energyInput(1000000)
    .itemInput(Item.of("ad_astra:calorite_ingot", 1))
    .fluidInput(Fluid.of("ftbskies:ultramafic_lava", 1000))
    .itemOutput(Item.of("ftbskies:venus_blaze_rod"), 1)
    .build();

  centrifugeRecipe(event, 200, "ftbskies:liquid_elemental_void", true)
    .energyInput(2000)
    .itemInput(Item.of("botania:pixie_dust", 1))
    .fluidInput(Fluid.of("starbunclemania:source_fluid", 1000))
    .fluidOutput(Fluid.of("ftbskies:liquid_elemental_void", 100))
    .build();

  advancedMixerRecipe(event, 250, "ftbskies:prismalium")
    .energyInput(50000)
    .heatInput(250)
    .itemInput(Item.of("thermal:lumium_dust", 1))
    .itemInput(Item.of("minecraft:prismarine_crystals", 4))
    .fluidInput(Fluid.of("ftbskies:liquid_elemental_water", 1000))
    .itemOutput(Item.of("thermalendergy:prismalium_dust", 1))
    .build();

  advancedMixerRecipe(event, 250, "ftbskies:stellarium")
    .energyInput(500000)
    .heatInput(3000)
    .itemInput(Item.of("thermalendergy:melodium_dust", 1))
    .itemInput(Item.of("minecraft:nether_star", 1))
    .fluidInput(Fluid.of("mekanism:superheated_sodium", 1000))
    .itemOutput(Item.of("thermalendergy:stellarium_dust", 1))
    .build();

  advancedMixerRecipe(event, 250, "ftbskies:melodium")
    .energyInput(100000)
    .heatInput(500)
    .itemInput(Item.of("thermalendergy:prismalium_dust", 1))
    .itemInput(Item.of("cyclic:fireball_dark", 4))
    .fluidInput(Fluid.of("ftbskies:liquid_elemental_void", 1000))
    .itemOutput(Item.of("thermalendergy:melodium_dust", 1))
    .build();

  let oily = Item.of("productivebees:configurable_honeycomb", '{EntityTag:{type:"productivebees:oily"}}');
  let desh = Item.of("productivebees:configurable_honeycomb", '{EntityTag:{type:"productivebees:desh"}}');
  let ostrum = Item.of("productivebees:configurable_honeycomb", '{EntityTag:{type:"productivebees:ostrum"}}');
  let calorite = Item.of("productivebees:configurable_honeycomb", '{EntityTag:{type:"productivebees:calorite"}}');
  //Custom Recipes
  centrifugeRecipe(event, 50, "ftbskies:oil_from_comb", false)
    .energyInput(12000)
    .requireBiome("ad_astra:orbit")
    .itemInput(oily)
    .fluidOutput(Fluid.of("pneumaticcraft:oil", 100))
    .build();

  centrifugeRecipe(event, 50, "ftbskies:desh_from_comb", false)
    .energyInput(12000)
    .requireBiome("ad_astra:orbit")
    .itemInput(desh)
    .itemOutput(Item.of("ad_astra:raw_desh", 1))
    .build();

  centrifugeRecipe(event, 50, "ftbskies:ostrum_from_comb", false)
    .energyInput(12000)
    .requireBiome("ad_astra:orbit")
    .itemInput(ostrum)
    .itemOutput(Item.of("ad_astra:raw_ostrum", 1))
    .build();

  centrifugeRecipe(event, 50, "ftbskies:calorite_from_comb", false)
    .energyInput(12000)
    .requireBiome("ad_astra:orbit")
    .itemInput(calorite)
    .itemOutput(Item.of("ad_astra:raw_calorite", 1))
    .build();

  //Fuels
  fuelMap.forEach((fuel) => {
    dieselGeneratorRecipe(event, 20, `ftbskies:diesel_su_gen_${fuel[0].split(":")[1]}`, 1)
      .fluidTagInput(fuel[0], fuel[2])
      .stressOutput(96, fuel[1])
      .build();

    dieselGeneratorRecipe(event, 20, `ftbskies:diesel_su_gen_${fuel[0].split(":")[1]}_oxygen_boosted`, 1000)
      .fluidTagInput(fuel[0], fuel[2])
      .fluidInput("mekanism:oxygen", fuel[2])
      .stressOutput(96, fuel[1] * 1.5)
      .build();

    turboDieselGeneratorRecipe(event, 20, `ftbskies:turbo_diesel_su_gen_${fuel[0].split(":")[1]}`, 1)
      .fluidTagInput(fuel[0], fuel[2])
      .stressOutput(96, fuel[1])
      .build();

    turboDieselGeneratorRecipe(event, 20, `ftbskies:turbo_diesel_su_gen_${fuel[0].split(":")[1]}_oxygen_boosted`, 1000)
      .fluidTagInput(fuel[0], fuel[2])
      .fluidInput("mekanism:oxygen", fuel[2])
      .stressOutput(96, fuel[1] * 1.5)
      .build();

    hyperDieselGeneratorRecipe(event, 20, `ftbskies:hyper_diesel_su_gen_${fuel[0].split(":")[1]}`, 1)
      .fluidTagInput(fuel[0], fuel[2])
      .stressOutput(96, fuel[1])
      .build();

    hyperDieselGeneratorRecipe(event, 20, `ftbskies:hyper_diesel_su_gen_${fuel[0].split(":")[1]}_oxygen_boosted`, 1000)
      .fluidTagInput(fuel[0], fuel[2])
      .fluidInput("mekanism:oxygen", fuel[2])
      .stressOutput(96, fuel[1] * 1.5)
      .build();

    advancedDieselGeneratorRecipe(event, 20, `ftbskies:advanced_diesel_su_gen_${fuel[0].split(":")[1]}`, 1)
      .fluidTagInput(fuel[0], fuel[2])
      .stressOutput(96, fuel[1])
      .build();

    advancedDieselGeneratorRecipe(
      event,
      20,
      `ftbskies:advanced_diesel_su_gen_${fuel[0].split(":")[1]}_oxygen_boosted`,
      1000
    )
      .fluidTagInput(fuel[0], fuel[2])
      .fluidInput("mekanism:oxygen", fuel[2])
      .stressOutput(96, fuel[1] * 1.5)
      .build();
  });

  quantumAssemblerRecipe(event, 400, "ftbskies:quantum_assembler_diamonds")
    .energyInput(50000)
    .itemInput(Item.of("minecraft:emerald", 1))
    .fluidInput(Fluid.of("starbunclemania:source_fluid", 100))
    .itemOutput(Item.of("minecraft:diamond", 1))
    .fluidOutput(Fluid.of("experienceobelisk:cognitium", 100))
    .build();

  quantumAssemblerRecipe(event, 400, "ftbskies:pres_mechanism")
    .energyInput(50000)
    .itemInput(Item.of("thermal:electrum_gear", 1))
    .itemInput(Item.of("create:large_cogwheel", 1))
    .itemInput(Item.of("immersiveengineering:stick_steel", 1))
    .itemOutput(Item.of("create:precision_mechanism", 2))
    .build();

  quantumAssemblerRecipe(event, 400, "ftbskies:fusion_igniter")
    .energyInput(1000000)
    .itemInput(Item.of("ftbskies:enigmatic_circuit", 1))
    .itemInput(Item.of("create_new_age:overcharged_diamond", 2))
    .itemInput(Item.of("mekanism:ingot_refined_glowstone", 8))
    .itemInput(Item.of("thermal:lumium_glass", 2))
    .fluidInput(Fluid.of("ftbskies:stabilized_pyrotheum", 4000))
    .itemOutput(Item.of("mekanismgenerators:hohlraum", 1))
    .build();

  quantumAssemblerRecipe(event, 100, "ftbskies:fission_casing")
    .energyInput(100000)
    .itemInput(Item.of("mekanism:steel_casing", 1))
    .itemInput(Item.of("ftbskies:rad_shielding", 1))
    .itemInput(Item.of("thermal:lead_plate", 32))
    .fluidInput(Fluid.of("ftbskies:ultramafic_lava", 1000))
    .itemOutput(Item.of("mekanismgenerators:fission_reactor_casing", 4))
    .build();

  quantumAssemblerRecipe(event, 400, "ftbskies:fusion_casing")
    .energyInput(800000)
    .itemInput(Item.of("mekanism:pellet_polonium", 4))
    .itemInput(Item.of("ftbskies:rad_shielding", 2))
    .itemInput(Item.of("ftbskies:enigmatic_circuit", 1))
    .itemInput(Item.of("thermal:lead_plate", 4))
    .fluidInput(Fluid.of("ftbskies:stabilized_pyrotheum", 1000))
    .itemOutput(Item.of("mekanismgenerators:fusion_reactor_frame", 4))
    .build();

  quantumAssemblerRecipe(event, 400, "ftbskies:perfected_gem_catalysts")
    .energyInput(50000)
    .itemInput(Item.of("elementalcraft:purecrystal", 1))
    .itemInput(Item.of("elementalcraft:pristine_air_gem", 1))
    .itemInput(Item.of("elementalcraft:pristine_fire_gem", 1))
    .itemInput(Item.of("elementalcraft:pristine_earth_gem", 1))
    .itemInput(Item.of("elementalcraft:pristine_water_gem", 1))
    .fluidInput(Fluid.of("ftbskies:liquid_elemental_void", 250))
    .itemOutput(Item.of("ftbskies:perfected_gem_catalyst", 64))
    .build();

  microfusionRecipe(event, 50, "ftbskies:uranium")
    .itemInput(Item.of("mekanism:crystal_lead", 1))
    .radiationInput(.0001)
    .heatInput(250)
    .fuel(100, "ftbskies:liquid_elemental_void")
    .itemOutput(Item.of("mekanism:crystal_uranium", 1))
    .build();

  rtgRecipe(event, 10000, "ftbskies:rtg_power_from_yellowcake")
    .itemInput(Item.of("mekanism:yellow_cake_uranium", 1))
    .heatPerTick(1000)
    .radiationPerTick(0.00001)
    .energyPerTick(80)
    .build();

  rtgRecipe(event, 51840000, "ftbskies:rtg_power_from_plutonium")
    .itemInput(Item.of("mekanism:pellet_plutonium", 1))
    .heatPerTick(2000)
    .radiationPerTick(0.00002)
    .energyPerTick(180)
    .build();

    rtgRecipe(event, 25920000, "ftbskies:rtg_power_from_polonium")
    .itemInput(Item.of("mekanism:pellet_polonium", 1))
    .heatPerTick(2250)
    .radiationPerTick(0.00006)
    .energyPerTick(240)
    .build();


  implosionRecipe(event, 20, "ftbskies:desh_implosion", "ad_astra:orbit")
    .itemInput(Item.of("minecraft:tnt", 1))
    .itemTagInput("forge:ingots/desh", 8)
    .itemOutput(Item.of("ad_astra:desh_plate", 8))
    .build();

  implosionRecipe(event, 20, "ftbskies:desh_implosion2", "ad_astra:orbit")
    .itemInput(Item.of("ftbskies:nitro_tnt", 1))
    .itemTagInput("forge:ingots/desh", 16)
    .itemOutput(Item.of("ad_astra:desh_plate", 16))
    .build();

  implosionRecipe(event, 20, "ftbskies:desh_implosion3", "ad_astra:orbit")
    .itemInput(Item.of("ftbskies:mega_tnt", 1))
    .itemTagInput("forge:ingots/desh", 32)
    .itemOutput(Item.of("ad_astra:desh_plate", 32))
    .build();

  implosionRecipe(event, 20, "ftbskies:ostrum_implosion", "ad_astra:orbit")
    .itemInput(Item.of("ftbskies:nitro_tnt", 1))
    .itemTagInput("forge:ingots/ostrum", 8)
    .itemOutput(Item.of("ad_astra:ostrum_plate", 8))
    .build();

  implosionRecipe(event, 20, "ftbskies:ostrum_implosion2", "ad_astra:orbit")
    .itemInput(Item.of("ftbskies:mega_tnt", 1))
    .itemTagInput("forge:ingots/ostrum", 16)
    .itemOutput(Item.of("ad_astra:ostrum_plate", 16))
    .build();

  implosionRecipe(event, 20, "ftbskies:calorite_implosion", "ad_astra:orbit")
    .itemInput(Item.of("ftbskies:mega_tnt", 1))
    .itemTagInput("forge:ingots/calorite", 8)
    .itemOutput(Item.of("ad_astra:calorite_plate", 8))
    .build();

  event
    .shaped(
      Item.of("custommachinery:custom_machine_item", 1, { machine: "ftbskies:fabrication_matrix" }),
      ["PAP", "TCT", "PAP"],
      {
        P: {
          item: "ftbskies:ldpe_sheet",
        },
        A: {
          item: "create_new_age:overcharged_golden_sheet",
        },
        T: {
          item: "mekanism:basic_fluid_tank",
        },
        C: {
          item: "mekanism:personal_chest",
        },
      }
    )
    .id("ftbskies:fabrication_matrix");

  event
    .shaped("ftbskies_companion:liquid_crystallizer", ["IPI", "LCL", "DMD"], {
      I: {
        item: "ftbskies:ldpe_sheet",
      },
      P: {
        item: "create:fluid_pipe",
      },
      L: {
        item: "botania:livingrock",
      },
      D: {
        item: "botania:mana_diamond",
      },
      M: {
        item: "create:precision_mechanism",
      },
      C: {
        item: "create:cogwheel",
      },
    })
    .id("ftbskies:liquid_crystallizer");

  event
    .shaped(
      Item.of("custommachinery:custom_machine_item", 1, { machine: "ftbskies:rtg_generator" }),
      ["PAP", "TCT", "PAP"],
      {
        P: {
          item: "redstone_arsenal:flux_plating",
        },
        A: {
          item: "mekanism:elite_control_circuit",
        },
        T: {
          item: "ftbskies:rad_shielding",
        },
        C: {
          item: "mekanism:crystal_uranium",
        },
      }
    )
    .id("ftbskies:rtg_generator");

  event
    .shaped(
      Item.of("custommachinery:custom_machine_item", 2, { machine: "ftbskies:quantum_assembler" }),
      ["PAP", "TCT", "PAP"],
      {
        P: {
          tag: "forge:plates/desh",
        },
        A: {
          tag: "forge:circuits/advanced",
        },
        T: {
          item: "createteleporters:quantum_mechanism",
        },
        C: {
          item: "thermal:machine_frame",
        },
      }
    )
    .id("ftbskies:quantum_assembler");

  event
    .shaped(
      Item.of("custommachinery:custom_machine_item", 1, { machine: "ftbskies:microfusion_extrapolator" }),
      ["PAP", "TCT", "PAP"],
      {
        P: {
          item: "ftbskies:cryo_infused_osmium_ingot",
        },
        A: {
          item: "mekanism:ultimate_induction_provider",
        },
        T: {
          item: "createteleporters:quantum_mechanism",
        },
        C: {
          item: "mekanism:quantum_entangloporter",
        },
      }
    )
    .id("ftbskies:microfusion_extrapolator");

  event
    .shaped(
      Item.of("custommachinery:custom_machine_item", 1, { machine: "ftbskies:advanced_mixer" }),
      ["DDD", "PCP", "DDD"],
      {
        D: {
          item: "mekanism:dynamic_tank",
        },
        P: {
          item: "thermal:lumium_plate",
        },
        C: {
          item: "jaopca:processors.ostrum",
        },
      }
    )
    .id("ftbskies:advanced_mixer");

  quantumAssemblerRecipe(event, 400, "ftbskies:sfm_cable")
    .energyInput(50000)
    .itemInput(Item.of("thermal:energy_duct", 1))
    .itemInput(Item.of("mekanism:ultimate_pressurized_tube", 1))
    .itemInput(Item.of("mekanism:ultimate_logistical_transporter", 1))
    .itemInput(Item.of("mekanism:ultimate_universal_cable", 1))
    .itemInput(Item.of("mekanism:ultimate_mechanical_pipe", 1))
    .fluidInput(Fluid.of("createteleporters:quantum_fluid", 160))
    .itemOutput(Item.of("sfm:cable", 32))
    .build();

  //Netherite Coils
  quantumAssemblerRecipe(event, 400, "ftbskies:netherite_coils")
    .energyInput(500000)
    .itemInput(Item.of("create_new_age:fluxuated_magnetite", 1))
    .itemInput(Item.of("thermal:blizz_powder", 4))
    .itemInput(Item.of("jaopca:plates.osmium", 1))
    .itemInput(Item.of("thermal:netherite_plate", 1))
    .fluidInput(Fluid.of("ftbskies:resonant_liquid", 100))
    .itemOutput(Item.of("create_new_age:netherite_magnet", 1))
    .build();

  //Quantum Bridge Card
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_quantum_bridge")
    .energyInput(50000)
    .itemInput(Item.of("createteleporters:quantum_mechanism", 4))
    .itemInput(Item.of("ftbskies:calorite_space_plate", 1))
    .itemInput(Item.of("ae2:advanced_card", 1))
    .fluidInput(Fluid.of("ftbskies:stabilized_fire", 1000))
    .fluidInput(Fluid.of("createteleporters:quantum_fluid", 1000))
    .itemOutput(Item.of("ae2wtlib:quantum_bridge_card", 1))
    .build();

  //Machine Frame Recipes ========================================================================

  // Thermal's Machine Frame
  quantumAssemblerRecipe(event, 100, "ftbskies:quantum_assembler_machine_frame")
    .energyInput(50000)
    .itemInput(Item.of("pneumaticcraft:ingot_iron_compressed", 4))
    .itemInput(Item.of("immersiveengineering:rs_engineering", 1))
    .itemInput(Item.of("immersiveengineering:light_engineering", 1))
    .itemInput(Item.of("industrialforegoing:machine_frame_pity", 1))
    .itemInput(Item.of("immersiveengineering:heavy_engineering", 1))
    .itemOutput(Item.of("thermal:machine_frame", 4))
    .build();

  //RFTools Machine Frame
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_rftools_machine_frame")
    .energyInput(50000)
    .itemInput(Item.of("industrialforegoing:plastic", 4))
    .itemInput(Item.of("create_new_age:overcharged_iron_sheet", 2))
    .itemInput(Item.of("industrialforegoing:machine_frame_pity", 1))
    .itemInput(Item.of("immersiveengineering:component_electronic", 2))
    .itemOutput(Item.of("rftoolsbase:machine_frame", 2))
    .build();

  //Supreme Machine Frame (Industrial Foregoing)
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_industrialforegoing_supreme_machine_frame")
    .energyInput(18000)
    .itemInput(Item.of("industrialforegoing:machine_frame_advanced", 1))
    .itemInput(Item.of("industrialforegoing:plastic", 2))
    .itemInput(Item.of("minecraft:netherite_ingot", 2))
    .itemInput(Item.of("minecraft:diamond", 2))
    .itemInput(Item.of("thermal:diamond_gear", 1))
    .fluidInput(Fluid.of("industrialforegoing:ether_gas", 135))
    .itemOutput(Item.of("industrialforegoing:machine_frame_supreme", 2))
    .build();

  //Advanced Machine Frame (Industrial Foregoing)
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_industrialforegoing_advanced_machine_frame")
    .energyInput(18000)
    .itemInput(Item.of("industrialforegoing:machine_frame_simple", 1))
    .itemInput(Item.of("industrialforegoing:plastic", 2))
    .itemInput(Item.of("minecraft:netherite_scrap", 2))
    .itemInput(Item.of("minecraft:gold_ingot", 2))
    .itemInput(Item.of("thermal:diamond_gear", 1))
    .fluidInput(Fluid.of("industrialforegoing:pink_slime", 500))
    .itemOutput(Item.of("industrialforegoing:machine_frame_advanced", 2))
    .build();

  //Simple Machine Frame (Industrial Foregoing)
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_industrialforegoing_simple_machine_frame")
    .energyInput(18000)
    .itemInput(Item.of("thermal:machine_frame", 1))
    .itemInput(Item.of("industrialforegoing:plastic", 2))
    .itemInput(Item.of("immersiveengineering:plate_duroplast", 2))
    .itemInput(Item.of("mekanism:ingot_steel", 2))
    .itemInput(Item.of("thermal:gold_gear", 1))
    .fluidInput(Fluid.of("industrialforegoing:latex", 250))
    .itemOutput(Item.of("industrialforegoing:machine_frame_simple", 2))
    .build();

  //Pity Machine Frame (Industrial Foregoing)
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_industrialforegoing_pity_machine_frame")
    .energyInput(18000)
    .itemInput(Item.of("minecraft:redstone_block", 1))
    .itemTagInput("minecraft:logs", 4)
    .itemTagInput("forge:plates/iron", 4)
    .itemOutput(Item.of("industrialforegoing:machine_frame_pity", 2))
    .build();

  //Mekanism Machine Frame (Or Casing I guess)
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_mekanism_casing")
    .energyInput(50000)
    .itemInput(Item.of("immersiveengineering:plate_steel", 4))
    .itemTagInput("forge:glass", 4)
    .itemTagInput("forge:ingots/osmium", 1)
    .itemOutput(Item.of("mekanism:steel_casing", 2))
    .build();

  //Powah Machine Frame (Or Casing I guess)
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_powah_casing")
    .energyInput(50000)
    .itemInput(Item.of("immersiveengineering:plate_steel", 4))
    .itemInput(Item.of("powah:dielectric_rod_horizontal", 2))
    .itemInput(Item.of("powah:dielectric_rod", 2))
    .itemOutput(Item.of("powah:dielectric_casing", 2))
    .build();

  // ==============================================================================================

  // Circuits amd Related Content in the Quantum Assembler ========================================

  //Empty PCB
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_empty_pcb")
    .energyInput(50000)
    .itemInput(Item.of("immersiveengineering:logic_circuit", 1))
    .fluidInput(Fluid.of("thermal:redstone", 500))
    .itemOutput(Item.of("pneumaticcraft:empty_pcb", 2))
    .build();

  //Variable Card
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_variable_card")
    .energyInput(50000)
    .itemInput(Item.of("ars_nouveau:blank_parchment", 1))
    .itemInput(Item.of("immersiveengineering:component_electronic", 1))
    .fluidInput(Fluid.of("integrateddynamics:menril_resin", 500))
    .itemOutput(Item.of("integrateddynamics:variable", 64))
    .build();

  //Electronic Component
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_electronic_component")
    .energyInput(50000)
    .itemTagInput("forge:treated_wood_slab", 1)
    .itemTagInput("forge:gems/quartz", 1)
    .itemTagInput("forge:dusts/redstone", 1)
    .itemTagInput("forge:wires/gold", 1)
    .itemOutput(Item.of("immersiveengineering:component_electronic", 2))
    .build();

  //Circuit Backplane
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_circuit_backplane")
    .energyInput(50000)
    .itemInput(Item.of("immersiveengineering:plate_duroplast", 1))
    .itemTagInput("forge:plates/copper", 1)
    .itemOutput(Item.of("immersiveengineering:circuit_board", 2))
    .build();

  // ==============================================================================================

  let dieselGen = Item.of("custommachinery:custom_machine_item", '{machine:"ftbskies:diesel_generator"}');
  let advancedDieselGen = Item.of(
    "custommachinery:custom_machine_item",
    '{machine:"ftbskies:advanced_diesel_generator"}'
  );
  let turboDieselGen = Item.of("custommachinery:custom_machine_item", '{machine:"ftbskies:turbo_diesel_generator"}');
  let hyperDieselGen = Item.of("custommachinery:custom_machine_item", '{machine:"ftbskies:hyper_diesel_generator"}');

  event
    .shaped(advancedDieselGen, ["DDD", "DCD", "DDD"], {
      D: dieselGen.strongNBT(),
      C: "mekanism:advanced_control_circuit",
    })
    .id("ftbskies:advanced_diesel_generator");

  event
    .shaped(turboDieselGen, ["DDD", "DCD", "DDD"], {
      D: advancedDieselGen.strongNBT(),
      C: "mekanism:elite_control_circuit",
    })
    .id("ftbskies:turbo_diesel_generator");

  event
    .shaped(hyperDieselGen, ["DDD", "DCD", "DDD"], {
      D: turboDieselGen.strongNBT(),
      C: "mekanism:ultimate_control_circuit",
    })
    .id("ftbskies:hyper_diesel_generator");

  //Modular Diesel Engine
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_modular_diesel_engine")
    .energyInput(50000)
    .itemInput(Item.of("create:mechanical_piston", 4))
    .itemInput(Item.of("create:brass_sheet", 2))
    .itemInput(Item.of("create:sturdy_sheet", 2))
    .itemInput(Item.of("immersiveengineering:rs_engineering", 1))
    .itemInput(Item.of("immersiveengineering:light_engineering", 1))
    .itemInput(Item.of("create:fluid_tank", 1))
    .itemInput(Item.of("create:fluid_pipe", 1))
    .itemOutput(dieselGen)
    .build();

  // Create Teleporters in the Quantum Assembler ==================================================

  //Quantum Fluid
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_quantum_fluid")
    .energyInput(50000)
    .itemInput(Item.of("minecraft:ender_pearl", 1))
    .fluidInput(Fluid.of("starbunclemania:source_fluid", 250))
    .fluidOutput(Fluid.of("createteleporters:quantum_fluid", 2000))
    .build();

  //Quantum Casing
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_quantum_casing")
    .energyInput(50000)
    .itemInput(Item.of("create:brass_casing", 1))
    .fluidInput(Fluid.of("createteleporters:quantum_fluid", 1000))
    .itemOutput(Item.of("createteleporters:quantum_casing", 2))
    .build();

  //Redstone Pearl
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_redstone_pearl")
    .energyInput(50000)
    .itemInput(Item.of("minecraft:redstone", 4))
    .itemInput(Item.of("minecraft:ender_pearl", 4))
    .itemOutput(Item.of("createteleporters:redstone_pearl", 8))
    .build();

  //Conductive Alloy
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_conductive_alloy")
    .energyInput(50000)
    .itemInput(Item.of("minecraft:copper_ingot", 1))
    .itemInput(Item.of("mekanism:ingot_tin", 6))
    .itemInput(Item.of("minecraft:redstone", 2))
    .itemOutput(Item.of("ftbskies:conductive_soldering_alloy", 2))
    .build();


  //Ender Drawers
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_ender_drawers")
    .energyInput(50000)
    .itemTagInput("functionalstorage:drawer", 2)
    .itemInput(Item.of("integrateddynamics:proto_chorus", 1))
    .itemInput(Item.of("jaopca:plates.manasteel", 4))
    .itemOutput(Item.of("functionalstorage:ender_drawer", 2))
    .build();

  //Pocket Dimension Remote
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_pocket_remote")
    .energyInput(50000)
    .itemInput(Item.of("createteleporters:quantum_casing", 12))
    .itemInput(Item.of("createteleporters:quantum_mechanism", 5))
    .itemInput(Item.of("createteleporters:adv_tplink", 2))
    .itemInput(Item.of("createteleporters:teleporter", 1))
    .itemInput(Item.of("createteleporters:gravity_stab", 1))
    .itemOutput(Item.of("createteleporters:pocket_dimension_remote", 1))
    .build();

  //Teleporter
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_teleporter")
    .energyInput(50000)
    .itemInput(Item.of("create:brass_casing", 16))
    .itemInput(Item.of("createteleporters:quantum_mechanism", 4))
    .itemInput(Item.of("createteleporters:redstone_pearl", 1))
    .itemOutput(Item.of("createteleporters:teleporter", 2))
    .build();

  //Custom Portal
  quantumAssemblerRecipe(event, 50, "ftbskies:quantum_assembler_custom_portal")
    .energyInput(50000)
    .itemInput(Item.of("createteleporters:quantum_casing", 24))
    .itemInput(Item.of("create:fluid_tank", 12))
    .itemInput(Item.of("createteleporters:quantum_mechanism", 4))
    .itemInput(Item.of("createteleporters:teleporter", 4))
    .itemOutput(Item.of("createteleporters:custom_portal", 2))
    .build();

  //End Portal Recipe
  quantumAssemblerRecipe(event, 50, "ftbskies:end_portal_frame")
    .energyInput(1000000)
    .fluidInput(Fluid.of("ftbskies:polytetrafluoroethylene", 1000))
    .fluidInput(Fluid.of("thermal:ender", 6250))
    .fluidInput(Fluid.of("ftbskies:ultramafic_lava", 10000))
    .itemInput(Item.of("powah:crystal_spirited", 4))
    .itemInput(Item.of("ftbskies:enigmatic_circuit", 2))
    .itemInput(Item.of("ftbskies:cryo_infused_osmium_ingot", 4))
    .itemInput(Item.of("ftbskies:stabilized_void_ingot", 4))
    .itemInput(Item.of("create_new_age:fluxuated_magnetite", 1))
    .itemInput(Item.of("unusualend:purpur_embedded_end_stone", 1))
    .itemOutput(Item.of("minecraft:end_portal_frame", 1))
    .build();

  //Electric Motor
  quantumAssemblerRecipe(event, 50, "ftbskies:electric_motor_quantum_assembler")
    .energyInput(50000)
    .itemInput(Item.of("immersiveengineering:coil_lv", 3))
    .itemTagInput("forge:plates/brass", 6)
    .itemTagInput("forge:rods/iron", 1)
    .itemInput(Item.of("createaddition:capacitor", 1))
    .itemInput(Item.of("create:andesite_alloy", 1))
    .itemOutput(Item.of("createaddition:electric_motor", 2))
    .build();

  //Radiation Shielding
  implosionRecipe(event, 20, "ftbskies:weak_rad_implosion", "ad_astra:orbit")
    .itemInput(Item.of("ftbskies:nitro_tnt", 1))
    .itemInput(Item.of("ftbskies:weak_rad_shielding", 1))
    .itemOutput(Item.of("ftbskies:rad_shielding", 1))
    .build();

  implosionRecipe(event, 20, "ftbskies:weak_rad_implosion2", "ad_astra:orbit")
    .itemInput(Item.of("ftbskies:mega_tnt", 1))
    .itemInput(Item.of("ftbskies:weak_rad_shielding", 4))
    .itemOutput(Item.of("ftbskies:rad_shielding", 4))
    .build();

  //Advanced Mixer Recipes ========================================================================

  var default_advanced_mixer_rf_cost = 4000;
  var default_advanced_mixer_tick_time = 100;

  //IE's Concrete
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/concrete")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemTagInput("forge:sand", 2)
    .itemTagInput("forge:gravel", 1)
    .itemTagInput("forge:clay", 1)
    .fluidInput(Fluid.of("minecraft:water", 500))
    .fluidOutput(Fluid.of("immersiveengineering:concrete", 500))
    .build();

  //Leaded Concrete
  advancedMixerRecipe(event, 10, "ftbskies:advanced_mixer/concrete/leaded")
    .energyInput(20000)
    .itemTagInput("forge:plates/lead", 1)
    .fluidInput(Fluid.of("immersiveengineering:concrete", 500))
    .itemOutput(Item.of("immersiveengineering:concrete_leaded", 1))
    .build();

  //Rotor blade
  quantumAssemblerRecipe(event, 100, "ftbskies:turbine_blade")
    .energyInput(200000)
    .itemTagInput("forge:plates/steel", 16)
    .itemInput("mekanism:alloy_reinforced", 2)
    .itemTagInput("forge:plates/swift_alloy", 1)
    .itemOutput(Item.of("mekanismgenerators:turbine_blade", 1))
    .build();

  //Turbine Rotor
  quantumAssemblerRecipe(event, 100, "ftbskies:turbine_rotor")
    .energyInput(200000)
    .itemInput("immersiveengineering:graphite_electrode", 8)
    .itemInput("mekanism:alloy_atomic", 1)
    .itemInput("powah:steel_energized", 4)
    .itemOutput(Item.of("mekanismgenerators:turbine_rotor", 1))
    .build();

  //Turbine casing
  quantumAssemblerRecipe(event, 100, "ftbskies:turbine_casing")
    .energyInput(200000)
    .itemInput("jaopca:plates.osmium", 1)
    .itemInput("mekanism:alloy_atomic", 2)
    .itemInput("ftbskies:rad_shielding", 16)
    .fluidInput(Fluid.of("ftbskies:ultramafic_lava", 2000))
    .itemOutput(Item.of("mekanismgenerators:turbine_casing", 4))
    .build();

  //Turbine Valvle
  quantumAssemblerRecipe(event, 200, "ftbskies:turbine_valve")
    .energyInput(200000)
    .itemInput("mekanismgenerators:turbine_casing", 1)
    .itemInput("ftbskies:enigmatic_circuit", 1)
    .fluidInput(Fluid.of("ftbskies:ultramafic_lava", 500))
    .itemOutput(Item.of("mekanismgenerators:turbine_valve", 1))
    .build();

  //Superheating Element
  quantumAssemblerRecipe(event, 200, "ftbskies:superheating_element")
    .energyInput(200000)
    .itemInput("mekanism:steel_casing", 1)
    .itemInput("ad_astra:ostrum_plate", 2)
    .itemInput("immersiveengineering:coil_lv", 16)
    .fluidInput(Fluid.of("ftbskies:stabilized_pyrotheum", 250))
    .itemOutput(Item.of("mekanism:superheating_element", 1))
    .build();

  //Pressure Disperser
  quantumAssemblerRecipe(event, 100, "ftbskies:pressure_disperser")
    .energyInput(200000)
    .itemInput("ftbskies:ptfe_sheet", 1)
    .itemInput("mekanism:alloy_atomic", 1)
    .itemInput("pneumaticcraft:air_grate_module", 8)
    .itemOutput(Item.of("mekanism:pressure_disperser", 1))
    .build();

  //Boiler Valve
  quantumAssemblerRecipe(event, 100, "ftbskies:boiler_valve")
    .energyInput(200000)
    .itemInput("mekanism:boiler_casing", 1)
    .itemInput("ftbskies:enigmatic_circuit", 1)
    .itemInput("create:fluid_valve", 2)
    .itemOutput(Item.of("mekanism:boiler_valve", 1))
    .build();

  //Structural Glass
  quantumAssemblerRecipe(event, 100, "ftbskies:structural_glass")
    .energyInput(40000)
    .itemInput("ftbskies:weak_rad_shielding", 6)
    .itemInput("jaopca:plates.osmium", 1)
    .itemInput("immersiveengineering:slag_glass", 3)
    .itemOutput(Item.of("mekanism:structural_glass", 3))
    .build();

  //Boiler Casing
  quantumAssemblerRecipe(event, 100, "ftbskies:boiler_casing")
    .energyInput(500000)
    .itemInput("ftbskies:weak_rad_shielding", 6)
    .itemInput("immersiveengineering:component_steel", 3)
    .itemInput("jaopca:plates.osmium", 1)
    .itemOutput(Item.of("mekanism:boiler_casing", 3))
    .build();

  //turbine vent
  quantumAssemblerRecipe(event, 100, "ftbskies:turbine_vent")
    .energyInput(500000)
    .itemInput("mekanismgenerators:turbine_casing", 2)
    .itemInput("immersiveengineering:component_steel", 2)
    .itemInput("ad_astra:vent", 2)
    .itemInput("mekanism:alloy_reinforced", 1)
    .itemOutput(Item.of("mekanismgenerators:turbine_vent", 2))
    .build();
  //From PNC Mixer ==============================

  //Acetadeylde
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/acetaldehyde")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("pneumaticcraft:ethanol", 250))
    .fluidInput(Fluid.of("ftbskies:molten_silver", 250))
    .fluidOutput(Fluid.of("immersiveengineering:acetaldehyde", 500))
    .build();
  //Phenolic Resin
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/phenolic")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("industrialforegoing:latex", 500))
    .fluidInput(Fluid.of("immersiveengineering:acetaldehyde", 750))
    .fluidOutput(Fluid.of("immersiveengineering:phenolic_resin", 1000))
    .build();
  //Polyethylene
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/polyethylene")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("mekanism:ethene", 250))
    .fluidInput(Fluid.of("industrialforegoing:latex", 250))
    .fluidOutput(Fluid.of("ftbskies:polyethylene", 500))
    .build();
  //Fuel
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/fuel")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("pneumaticcraft:biodiesel", 25))
    .fluidInput(Fluid.of("starbunclemania:source_fluid", 25))
    .fluidOutput(Fluid.of("ad_astra:fuel", 50))
    .build();
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/fuel")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("pneumaticcraft:diesel", 25))
    .fluidInput(Fluid.of("starbunclemania:source_fluid", 25))
    .fluidOutput(Fluid.of("ad_astra:fuel", 50))
    .build();
  //Obsidian
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/obsidian")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("minecraft:water", 1000))
    .fluidInput(Fluid.of("minecraft:lava", 1000))
    .itemOutput(Item.of("minecraft:obsidian", 1))
    .build();
  //Biodiesel
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/biodiesel")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("pneumaticcraft:ethanol", 25))
    .fluidInput(Fluid.of("pneumaticcraft:vegetable_oil", 25))
    .fluidOutput(Fluid.of("pneumaticcraft:biodiesel", 100))
    .itemOutput(Item.of("pneumaticcraft:glycerol", 1))
    .build();

  advancedMixerRecipe(event, 200, "ftbskies:advanced_mixer/pina_colada")
    .energyInput(500000)
    .heatInput(5000)
    .fluidInput(Fluid.of("pneumaticcraft:ethanol", 25))
    .fluidInput(Fluid.of("ftbskies:virgin_pina_colada", 50))
    .fluidOutput(Fluid.of("ftbskies:pina_colada", 50))
    .build();

  advancedMixerRecipe(event, 100, "ftbskies:signalum_processor_alt")
    .energyInput(500000)
    .itemInput(Item.of("mekanism:basic_control_circuit", 1))
    .itemInput(Item.of("thermal:signalum_plate", 1))
    .fluidInput(Fluid.of("thermal:redstone", 25))
    .itemOutput(Item.of("jaopca:processors.signalum", 1))
    .build();

  // ============================================

  //From PNC Thermo-Pneumatic Processing Plant ==

  //Lubricant
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/lubricant")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("pneumaticcraft:diesel", 1000))
    .itemInput(Item.of("minecraft:redstone", 1))
    .fluidOutput(Fluid.of("pneumaticcraft:lubricant", 1000))
    .build();
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/lubricant_bio")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("pneumaticcraft:biodiesel", 1000))
    .itemInput(Item.of("minecraft:redstone", 1))
    .fluidOutput(Fluid.of("pneumaticcraft:lubricant", 1000))
    .build();
  //TNT
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/tnt")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("mekanism:sulfuric_acid", 250))
    .itemInput(Item.of("ftbskies:gelled_toluene", 1))
    .itemOutput(Item.of("minecraft:tnt", 1))
    .build();
  //Proto Chorus
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/proto_chorus")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("createteleporters:quantum_fluid", 1000))
    .itemInput(Item.of("integrateddynamics:menril_berries", 1))
    .itemOutput(Item.of("integrateddynamics:proto_chorus", 1))
    .build();
  //Ethanol
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/ethanol_potato")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("pneumaticcraft:yeast_culture", 100))
    .itemInput(Item.of("minecraft:potato", 1))
    .fluidOutput(Fluid.of("pneumaticcraft:ethanol", 50))
    .build();
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/ethanol_poisonous_potato")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("pneumaticcraft:yeast_culture", 100))
    .itemInput(Item.of("minecraft:poisonous_potato", 1))
    .fluidOutput(Fluid.of("pneumaticcraft:ethanol", 100))
    .build();
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/ethanol_sugar")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("pneumaticcraft:yeast_culture", 100))
    .itemInput(Item.of("minecraft:sugar", 1))
    .fluidOutput(Fluid.of("pneumaticcraft:ethanol", 100))
    .build();
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/ethanol_mendosteen_pod")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("pneumaticcraft:yeast_culture", 100))
    .itemInput(Item.of("ars_nouveau:mendosteen_pod", 1))
    .fluidOutput(Fluid.of("pneumaticcraft:ethanol", 200))
    .build();
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/ethanol_sweet_berries")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("pneumaticcraft:yeast_culture", 100))
    .itemInput(Item.of("minecraft:sweet_berries", 1))
    .fluidOutput(Fluid.of("pneumaticcraft:ethanol", 40))
    .build();
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/ethanol_apple")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("pneumaticcraft:yeast_culture", 100))
    .itemInput(Item.of("minecraft:apple", 1))
    .fluidOutput(Fluid.of("pneumaticcraft:ethanol", 100))
    .build();
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/ethanol_melon_slice")
    .energyInput(default_advanced_mixer_rf_cost)
    .fluidInput(Fluid.of("pneumaticcraft:yeast_culture", 100))
    .itemInput(Item.of("minecraft:melon_slice", 1))
    .fluidOutput(Fluid.of("pneumaticcraft:ethanol", 20))
    .build();
  //Vegetable Oil
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/vegetable_oil_crops")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemTagInput("forge:crops", 1)
    .fluidOutput(Fluid.of("pneumaticcraft:vegetable_oil", 20))
    .build();
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/vegetable_oil_seeds")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemTagInput("forge:seeds", 1)
    .fluidOutput(Fluid.of("pneumaticcraft:vegetable_oil", 50))
    .build();
  //Yeast Culture
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/yeast_culture")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemTagInput("forge:mushrooms", 1)
    .fluidInput(Fluid.of("minecraft:water", 1000))
    .fluidOutput(Fluid.of("pneumaticcraft:yeast_culture", 250))
    .build();
  //Cryotheum
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/cryotheum")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemInput(Item.of("thermal:blizz_powder", 1))
    .fluidInput(Fluid.of("ad_astra:cryo_fuel", 1000))
    .itemOutput(Item.of("ftbskies:cryotheum", 1))
    .build();
  //Ethylene
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/ethylene")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemTagInput("forge:dusts/sulfur", 1)
    .fluidInput(Fluid.of("pneumaticcraft:ethanol", 250))
    .fluidOutput(Fluid.of("mekanism:ethene", 250))
    .build();
  //Volatile Redstone
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/volatile_redstone")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemTagInput("forge:dusts/redstone", 1)
    .fluidInput(Fluid.of("immersiveengineering:acetaldehyde", 250))
    .fluidOutput(Fluid.of("ftbskies:volatile_redstone", 250))
    .build();
  //Resonant Ether
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/resonant_liquid")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemInput(Item.of("rftoolsbase:dimensionalshard", 1))
    .fluidInput(Fluid.of("industrialforegoing:ether_gas", 250))
    .fluidOutput(Fluid.of("ftbskies:resonant_liquid", 250))
    .build();
  //Quicksilver
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/quicksilver")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemTagInput("forge:gems/cinnabar", 1)
    .fluidInput(Fluid.of("integrateddynamics:menril_resin", 10))
    .fluidOutput(Fluid.of("hexerei:quicksilver_fluid", 250))
    .build();
  //Force-Infused Oil
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/force_infused_oil")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemTagInput("forge:gems/force", 1)
    .fluidInput(Fluid.of("pneumaticcraft:oil", 1000))
    .fluidOutput(Fluid.of("ftbskies:force_infused_oil", 1000))
    .build();
  //Force-Infused Bio Diesel
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/force_infused_biodiesel")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemTagInput("forge:gems/force", 1)
    .fluidInput(Fluid.of("pneumaticcraft:biodiesel", 1000))
    .fluidOutput(Fluid.of("ftbskies:force_infused_biodiesel", 1000))
    .build();
  //Force-Infused Diesel
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/force_infused_diesel")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemTagInput("forge:gems/force", 1)
    .fluidInput(Fluid.of("pneumaticcraft:diesel", 1000))
    .fluidOutput(Fluid.of("ftbskies:force_infused_diesel", 1000))
    .build();

  //Force-Infused Diesel
  advancedMixerRecipe(event, 30, "ftbskies:advanced_mixer/force_infused_diesel_from_force")
    .energyInput(50000)
    .itemInput(Item.of("redstone_arsenal:flux_gem", 1))
    .fluidInput(Fluid.of("ftbskies:force_infused_diesel", 2000))
    .fluidOutput(Fluid.of("ftbskies:flux_diesel", 2000))
    .build();

  //Flux-Infused Oil
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/flux_infused_oil")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemInput(Item.of("redstone_arsenal:flux_gem", 1))
    .fluidInput(Fluid.of("pneumaticcraft:oil", 2000))
    .fluidOutput(Fluid.of("ftbskies:flux_oil", 2000))
    .build();

  // ============================================

  //From Create's Mixer ==
  //Magical Imbued Soil
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/magical_imbued_soil")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemInput(Item.of("ftbskies:lightly_magical_imbued_soil", 1))
    .itemInput(Item.of("ars_nouveau:earth_essence", 1))
    .itemInput(Item.of("hexerei:moon_dust", 1))
    .fluidInput(Fluid.of("sliceanddice:fertilizer", 1000))
    .itemOutput(Item.of("ftbskies:magical_imbued_soil", 1))
    .build();
  //Icing
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/icing")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemInput(Item.of("minecraft:sweet_berries", 2))
    .itemInput(Item.of("minecraft:sugar", 3))
    .fluidInput(Fluid.of("minecraft:milk", 1000))
    .fluidOutput(Fluid.of("ftbskies:icing", 1000))
    .build();
  //Andesite Alloy
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/andesite_alloy_iron")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemInput(Item.of("minecraft:andesite", 1))
    .itemInput(Item.of("minecraft:iron_nugget", 1))
    .itemOutput(Item.of("create:andesite_alloy", 1))
    .build();
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/andesite_alloy_zinc")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemInput(Item.of("minecraft:andesite", 1))
    .itemInput(Item.of("create:zinc_nugget", 1))
    .itemOutput(Item.of("create:andesite_alloy", 1))
    .build();
  //Etching Acid
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/etching_acid")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemInput(Item.of("minecraft:spider_eye", 1))
    .itemInput(Item.of("minecraft:rotten_flesh", 1))
    .itemInput(Item.of("minecraft:gunpowder", 1))
    .fluidInput(Fluid.of("immersiveengineering:redstone_acid", 500))
    .fluidOutput(Fluid.of("pneumaticcraft:etching_acid", 500))
    .build();
  //Cake Batter
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/cake_batter")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemTagInput("forge:eggs", 2)
    .itemInput(Item.of("minecraft:sugar", 3))
    .itemInput(Item.of("create:wheat_flour", 3))
    .fluidInput(Fluid.of("minecraft:milk", 500))
    .fluidOutput(Fluid.of("ftbskies:cake_batter", 1000))
    .build();
  //Cognitive Flux
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/cognitive_flux")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemTagInput("forge:dusts/quartz", 1)
    .itemInput(Item.of("spirit:soul_powder", 1))
    .fluidTagInput("forge:experience", 500)
    .itemOutput(Item.of("experienceobelisk:cognitive_flux", 2))
    .build();
  //Primitive Slurry
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/primitive_slurry")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemTagInput("forge:gravel", 4)
    .fluidOutput(Fluid.of("ftbskies:primitive_slurry", 1000))
    .build();
  //Stabilized Fire
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/stabilized_fire")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemInput(Item.of("cyclic:fireball", 1))
    .itemInput(Item.of("ftbskies:venus_blaze_dust", 1))
    .fluidInput(Fluid.of("ftbskies:liquid_elemental_fire", 250))
    .fluidOutput(Fluid.of("ftbskies:stabilized_fire", 250))
    .build();
  //Brass Gilded Lapis
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/brass_gilded_lapis")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemTagInput("forge:gems/lapis", 1)
    .itemTagInput("forge:ingots/brass", 1)
    .itemOutput(Item.of("compressedcreativity:brass_gilded_lapis_lazuli", 1))
    .build();

  //Chocolate
  advancedMixerRecipe(event, default_advanced_mixer_tick_time, "ftbskies:advanced_mixer/chocolate")
    .energyInput(default_advanced_mixer_rf_cost)
    .itemInput(Item.of("minecraft:sugar", 1))
    .itemInput(Item.of("minecraft:cocoa_beans", 1))
    .fluidInput(Fluid.of("minecraft:milk", 200))
    .fluidOutput(Fluid.of("create:chocolate", 250))
    .build();

  //Uranium Crystal's Alternative
  advancedMixerRecipe(event, 3600, "ftbskies:advanced_mixer/uranium_crystal_alternative")
    .energyInput(1000000)
    .itemInput(Item.of("mekanism:crystal_lead", 1))
    .itemInput(Item.of("redstone_arsenal:flux_gem", 1))
    .fluidInput(Fluid.of("ftbskies:liquid_elemental_earth", 500))
    .fluidInput(Fluid.of("ftbskies:ultramafic_lava", 500))
    .itemOutput(Item.of("mekanism:crystal_uranium"))
    .build();

  // ============================================

  // ==============================================================================================
});
