ServerEvents.recipes((event) => {
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: false,
      output: {
        item: "cyclic:ender_book",
      },
      pedestalItems: [
        {
          item: "minecraft:ender_eye",
        },
        {
          item: "minecraft:ender_eye",
        },
        {
          item: "minecraft:ender_eye",
        },
        {
          item: "minecraft:ender_eye",
        },
        {
          item: "integrateddynamics:crystalized_chorus_chunk",
        },
        {
          item: "integrateddynamics:crystalized_chorus_chunk",
        },
        {
          item: "integrateddynamics:crystalized_chorus_chunk",
        },
      ],
      reagent: [
        {
          item: "minecraft:writable_book",
        },
      ],
      sourceCost: 10000,
    })
    .id("ftbskies:enderbook");


  event.custom({
    "type": "elementalcraft:infusion",
    "element_amount": 50,
    "element_type": "earth",
    "input": {
      "item": "minecraft:bone_meal"
    },
    "output": {
      "item": "cyclic:biomass"
    }
  }).id("ftbskies:biomass_infusion");


  event
    .custom({
      type: "cyclic:generator_item",
      fuel: {
        item: "cyclic:peat_fuel_enriched",
      },
      energy: {
        ticks: 2500,
        rfpertick: 80,
      },
      conditions: [
        {
          values: [
            {
              modid: "cyclic",
              type: "forge:mod_loaded",
            },
            {
              item: "cyclic:generator_item",
              type: "forge:item_exists",
            },
          ],
          type: "forge:and",
        },
      ],
    })
    .id("ftbskies:peat_enriched");

  event
    .custom({
      type: "cyclic:generator_item",
      fuel: {
        item: "cyclic:peat_fuel",
      },
      energy: {
        ticks: 2500,
        rfpertick: 40,
      },
      conditions: [
        {
          values: [
            {
              modid: "cyclic",
              type: "forge:mod_loaded",
            },
            {
              item: "cyclic:generator_item",
              type: "forge:item_exists",
            },
          ],
          type: "forge:and",
        },
      ],
    })
    .id("ftbskies:peat");

  //Terra Preta Recipe
  event
    .shaped("4x cyclic:terra_preta", ["BBB", "BWB", "BBB"], {
      W: "cyclic:peat_baked",
      B: "cyclic:biomass",
    })
    .id("ftbskies:terra_preta");

  event
    .shaped("cyclic:user", ["GDG", "TCT", "FFF"], {
      G: "#forge:plates/gold",
      D: "minecraft:dispenser",
      T: "minecraft:tripwire_hook",
      C: "mekanism:advanced_control_circuit",
      F: "#forge:storage_blocks/flint",
    })
    .id("ftbskies:user");

  event
    .shaped("cyclic:wireless_item", ["CPC", "CMC", "CIC"], {
      C: "jaopca:plates.compressed_iron",
      P: "createteleporters:quantum_mechanism",
      M: "industrialforegoing:machine_frame_pity",
      I: "create_new_age:overcharged_iron_sheet",
    })
    .id("ftbskies:wireless_item");

  event
    .shaped("cyclic:wireless_fluid", ["CPC", "CMC", "CIC"], {
      C: "jaopca:plates.compressed_iron",
      P: "createteleporters:quantum_mechanism",
      M: "industrialforegoing:machine_frame_pity",
      I: "create_new_age:overcharged_gold_sheet",
    })
    .id("ftbskies:wireless_fluid");

  event
    .shaped("cyclic:wireless_energy", ["CPC", "CMC", "CIC"], {
      C: "jaopca:plates.compressed_iron",
      P: "createteleporters:quantum_mechanism",
      M: "industrialforegoing:machine_frame_pity",
      I: "create_new_age:overcharged_diamond",
    })
    .id("ftbskies:wireless_energy");

  //Glistering Chorus Fruit
  event.shaped("2x cyclic:chorus_flight", ["CGC", "GEG", "CGC"], {
      G: "minecraft:glow_ink_sac",
      C: "integrateddynamics:proto_chorus",
      E: "ars_nouveau:mendosteen_pod"
    }).id("ftbskies:glistering_chorus_fruit");

  event.shaped("4x cyclic:chorus_flight", ["CGC", "GEG", "CGC"], {
      G: "minecraft:glow_ink_sac",
      C: "minecraft:chorus_fruit",
      E: "ars_nouveau:mendosteen_pod"
    }).id("ftbskies:glistering_chorus_fruit_1");


  event.custom({
    "type": "immersiveengineering:coke_oven",
    "creosote": 50,
    "input": {
      "item": "cyclic:peat_baked"
    },
    "result": {
      "item": "cyclic:peat_fuel",
      "count": 2
    },
    "time": 400
  }).id('ftbskies:cove_oven/peat')
});
