ServerEvents.recipes((event) => {
  //Drenched Iron
  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 500,
      element_type: "water",
      input: {
        tag: "forge:ingots/steel",
      },
      output: {
        item: "elementalcraft:drenched_iron_ingot",
      },
    })
    .id("ftbskies:drenched");

  //Mana Synthesizer
    event
    .shaped("elementalcraft:mana_synthesizer", ["LSL", "EPE", "LGL"], {
      E: "#forge:plates/elementium",
      S: "elementalcraft:solar_prism",
      L: "botania:livingrock",
      P: "botania:mana_pool",
      G: "#forge:gears/swift_alloy",
    })
    .id("ftbskies:mana_synthesizer");

  //springaline shard
  event
    .custom({
      type: "elementalcraft:infusion",
      element_amount: 2500,
      element_type: "water",
      input: {
        item: "minecraft:amethyst_shard",
      },
      output: {
        item: "elementalcraft:springaline_shard",
      },
    })
    .id("ftbskies:springalinecrystal");

  //Saoryn Rune
  event
    .custom({
      type: "elementalcraft:inscription",
      element_amount: 5000,
      element_type: "earth",
      ingredients: [
        {
          tag: "elementalcraft:gems/crude_earth",
        },
        {
          item: "minecraft:brick",
        },
        {
          item: "ars_nouveau:earth_essence",
        },
      ],
      output: {
        item: "elementalcraft:rune",
        nbt: {
          elementalcraft: {
            rune: "elementalcraft:soaryn",
          },
        },
      },
      slate: {
        item: "elementalcraft:minor_rune_slate",
      },
    })
    .id("ftbskies:soaryn_rune");

  //Springaline Dust
  event
    .custom({
      type: "occultism:crushing",
      ingredient: {
        item: "elementalcraft:springaline_shard",
      },
      result: {
        item: "ftbskies:springaline_dust",
        count: 1,
      },
      crushing_time: 200,
    })
    .id("ftbskies:springaline_dust");

  //claptrap Rune
  event
    .custom({
      type: "elementalcraft:inscription",
      element_amount: 5000,
      element_type: "water",
      ingredients: [
        {
          tag: "elementalcraft:gems/crude_water",
        },
        {
          item: "minecraft:snowball",
        },
        {
          item: "ars_nouveau:water_essence",
        },
      ],
      output: {
        item: "elementalcraft:rune",
        nbt: {
          elementalcraft: {
            rune: "elementalcraft:claptrap",
          },
        },
      },
      slate: {
        item: "elementalcraft:minor_rune_slate",
      },
    })
    .id("ftbskies:claptrap_rune");

  //Manx Rune
  event
    .custom({
      type: "elementalcraft:inscription",
      element_amount: 5000,
      element_type: "fire",
      ingredients: [
        {
          tag: "elementalcraft:gems/crude_fire",
        },
        {
          item: "minecraft:fire_charge",
        },
        {
          item: "ars_nouveau:fire_essence",
        },
      ],
      output: {
        item: "elementalcraft:rune",
        nbt: {
          elementalcraft: {
            rune: "elementalcraft:manx",
          },
        },
      },
      slate: {
        item: "elementalcraft:minor_rune_slate",
      },
    })
    .id("ftbskies:manx_rune");

  //Wii Rune
  event
    .custom({
      type: "elementalcraft:inscription",
      element_amount: 5000,
      element_type: "air",
      ingredients: [
        {
          tag: "elementalcraft:gems/crude_air",
        },
        {
          item: "minecraft:feather",
        },
        {
          item: "ars_nouveau:air_essence",
        },
      ],
      output: {
        item: "elementalcraft:rune",
        nbt: {
          elementalcraft: {
            rune: "elementalcraft:wii",
          },
        },
      },
      slate: {
        item: "elementalcraft:minor_rune_slate",
      },
    })
    .id("ftbskies:wii_rune");

  event
    .custom({
      type: "elementalcraft:crystallization",
      element_type: "air",
      element_amount: 5000,
      ingredients: {
        crystal: {
          item: "elementalcraft:elementpipe",
        },
        gem: {
          item: "elementalcraft:small_container",
        },
        shard: [],
      },
      outputs: [
        {
          weight: 1.0,
          result: {
            Count: 1,
            id: "elementalcraft:container",
          },
        },
      ],
    })
    .id("ftbskies:small_container_upgrade");


    event.custom({
      type: "ftbskies_companion:crystallization",
      input: {
        ingredient: {
          fluid: "ftbskies:liquid_elemental_water",
        },
        millibuckets: 15,
      },
      mana: 500,
      processTime: 200,
      output: {
        id: "elementalcraft:water_shard",
      },
    }).id("ftbskies:water_shard");
  
    event.custom({
      type: "ftbskies_companion:crystallization",
      input: {
        ingredient: {
          fluid: "ftbskies:liquid_elemental_fire",
        },
        millibuckets: 15,
      },
      mana: 500,
      processTime: 200,
      output: {
        id: "elementalcraft:fire_shard",
      },
    }).id("ftbskies:fire_shard");
  
    event.custom({
      type: "ftbskies_companion:crystallization",
      input: {
        ingredient: {
          fluid: "ftbskies:liquid_elemental_air",
        },
        millibuckets: 15,
      },
      mana: 500,
      processTime: 200,
      output: {
        id: "elementalcraft:air_shard",
      },
    }).id("ftbskies:air_shard");
  
    event.custom({
      type: "ftbskies_companion:crystallization",
      input: {
        ingredient: {
          fluid: "ftbskies:liquid_elemental_earth",
        },
        millibuckets: 15,
      },
      mana: 500,
      processTime: 200,
      output: {
        id: "elementalcraft:earth_shard",
      },
    }).id("ftbskies:earth_shard");
  
    event.custom({
      type: "ftbskies_companion:crystallization",
      input: {
        ingredient: {
          fluid: "ftbskies:liquid_elemental_void",
        },
        millibuckets: 15,
      },
      mana: 500,
      processTime: 200,
      output: {
        id: "ftbskies:void_shard",
      },
    }).id("ftbskies:void_shard");

});
