ServerEvents.recipes((event) => {
  event
    .custom({
      type: "mekanism:metallurgic_infusing",
      chemicalInput: {
        amount: 40,
        tag: "mekanism:redstone",
      },
      itemInput: {
        ingredient: {
          tag: "forge:dusts/obsidian",
        },
      },
      output: {
        item: "fluxnetworks:flux_dust",
      },
    })
    .id("ftbskies:flux");

  event
    .shaped("fluxnetworks:flux_point", [" A ", "APA", " A "], {
      P: "mekanism:alloy_infused",
      A: "fluxnetworks:flux_core",
    })
    .id("ftbskies:flux_point");

  event
    .shaped("fluxnetworks:flux_plug", [" A ", "APA", " A "], {
      P: "thermal:flux_capacitor",
      A: "fluxnetworks:flux_core",
    })
    .id("ftbskies:flux_plug");

  event
    .shaped("fluxnetworks:basic_flux_storage", ["FFF", "GIG", "FFF"], {
      F: "fluxnetworks:flux_block",
      G: "#forge:glass_panes",
      I: "mekanism:advanced_induction_cell",
    })
    .id("ftbskies:basicfluxstorage");

  event
    .shaped("fluxnetworks:herculean_flux_storage", ["FFF", "GIG", "FFF"], {
      F: "fluxnetworks:basic_flux_storage",
      G: "#forge:glass_panes",
      I: "mekanism:elite_induction_cell",
    })
    .id("ftbskies:herculeanfluxstorage");

  event
    .shaped("fluxnetworks:gargantuan_flux_storage", ["FFF", "GIG", "FFF"], {
      F: "fluxnetworks:herculean_flux_storage",
      G: "#forge:glass_panes",
      I: "mekanism:ultimate_induction_cell",
    })
    .id("ftbskies:gargantuanfluxstorage");
});
