// Priority: -1000

ServerEvents.recipes((event) => {
  const ftbsba = event.recipes.ftbsba;
  event.forEachRecipe({ type: "cyclic:solidifier" }, (recipe) => {
    let recipeJson = JSON.parse(recipe.json.toString());

    let input = [];
    let fluid = "";

    for (const ingredient of recipeJson.ingredients) {
      if (ingredient.tag) {
        input.push("#" + ingredient.tag);
      } else {
        input.push(ingredient.item);
      }
    }

    if (recipeJson.mix) {
      if (recipeJson.mix.tag) {
        fluid = `${recipeJson.mix.tag}`;
        switch (fluid) {
          case "forge:wax":
            fluid = "cyclic:wax";
            break;
          case "forge:biomass":
            fluid = "cyclic:biomass";
            break;
          case "forge:slime":
            fluid = "cyclic:slime";
            break;
          case "forge:honey":
            fluid = "productivebees:honey";
            break;
          case "forge:magma":
            fluid = "cyclic:magma";
            break;
          case "forge:experience":
            fluid = "experienceobelisk:cognitium";
            break;
          case "forge:milk":
            fluid = "minecraft:milk";
            break;
        }
      } else {
        fluid = `${recipeJson.mix.fluid}`;
      }

      let fluidInput = `${recipeJson.mix.count}` + 'x ' + `${fluid}`
      let outputItem = `${recipeJson.result.count}` + 'x ' + `${recipeJson.result.item}`;
      /*console.log(
        "Converting Supercooler Recipe: " +
          recipe.id +
          " Input Fluid: " +
          fluidInput +
          ", Item Inputs: " +
          input +
          " Output Items: " +
          outputItem
      );*/

      ftbsba.super_cooler(
        outputItem,
        input,
        Fluid.of(fluid, recipeJson.mix.count),
        {
          fePerTick: `${recipeJson.energy.rfpertick}`,
          ticksToProcess: `${recipeJson.energy.ticks}`,
        }
      );
    }
  });

  event.forEachRecipe({ type: "cyclic:melter" }, (recipe) => {
    let recipeJson = JSON.parse(recipe.json.toString());

    let input = [];

    for (const ingredient of recipeJson.ingredients) {
      if (ingredient.tag) {
        input.push("#" + ingredient.tag);
      } else {
        input.push(ingredient.item);
      }
    }

    let outputFluid = recipeJson.result.fluid;
    if (outputFluid == "cyclic:honey") 
       outputFluid = "productivebees:honey";

    /*console.log(  
    let outputFluid = `${recipeJson.result.count}` + 'x ' + `${recipeJson.result.fluid}`;
      "Converting SlowMelter Recipe: " +
        recipe.id +
        " Input Items: " +
        input +
        " Output Fluid " +
        outputFluid
    );*/

    ftbsba.fusing_machine(Fluid.of(outputFluid, recipeJson.result.count), input, {
      fePerTick: `${recipeJson.energy.rfpertick}`,
      ticksToProcess: `${recipeJson.energy.ticks}`,
    });
  });
  event.remove({ type: "cyclic:solidifier" });
  event.remove({ type: "cyclic:melter" });

  ftbsba
    .super_cooler(
      "2x mekanism:shard_gold",
      ["minecraft:redstone", "minecraft:redstone"],
      Fluid.of("ftbskies:primitive_slurry", 500),
      {
        fePerTick: 80,
        ticksToProcess: 120,
      }
    )
    .id("ftbskies:cooler/primitive_slurry_mekanism_shard_gold");

  ftbsba.super_cooler(
    "12x cyclic:peat_unbaked",
    ["cyclic:biomass", "forge:carbon_dusts", "minecraft:dirt"],
    Fluid.of("cyclic:biomass", 500),
    {
      fePerTick: 50,
      ticksToProcess: 60,
    }
  );

  ftbsba
    .super_cooler(
      "7x create:zinc_nugget",
      ["minecraft:gunpowder", "minecraft:gunpowder"],
      Fluid.of("ftbskies:primitive_slurry", 500),
      {
        fePerTick: 80,
        ticksToProcess: 120,
      }
    )
    .id("ftbskies:cooler/primitive_slurry_create_zinc_nugget");

  ftbsba.super_cooler("2x create:zinc_ingot", ["ftbskies:zinccatalyst"], Fluid.of("ftbskies:primitive_slurry", 250), {
    fePerTick: 80,
    ticksToProcess: 120,
  });

  ftbsba
    .super_cooler("2x minecraft:iron_ingot", ["ftbskies:ironcatalyst"], Fluid.of("ftbskies:primitive_slurry", 250), {
      fePerTick: 80,
      ticksToProcess: 120,
    })
    .id("ftbskies:cooler/iron_ingot");

  ftbsba
    .super_cooler("2x minecraft:gold_ingot", ["ftbskies:goldcatalyst"], Fluid.of("ftbskies:primitive_slurry", 250), {
      fePerTick: 80,
      ticksToProcess: 120,
    })
    .id("ftbskies:cooler/gold_ingot");

  ftbsba
    .super_cooler(
      "2x minecraft:copper_ingot",
      ["ftbskies:coppercatalyst"],
      Fluid.of("ftbskies:primitive_slurry", 250),
      {
        fePerTick: 80,
        ticksToProcess: 120,
      }
    )
    .id("ftbskies:cooler/copper_ingot");

  ftbsba
    .super_cooler(
      "2x ars_nouveau:purple_archwood_sapling",
      ["minecraft:purple_dye", "#forge:sapling", "#botania:petals"],
      Fluid.of("experienceobelisk:cognitium", 1000),
      {
        fePerTick: 100,
        ticksToProcess: 400,
      }
    )
    .id("ftbskies:cooler/purple_archwood_sapling");

  ftbsba
    .super_cooler(
      "2x ars_nouveau:green_archwood_sapling",
      ["minecraft:lime_dye", "#forge:sapling", "#botania:petals"],
      Fluid.of("experienceobelisk:cognitium", 1000),
      {
        fePerTick: 100,
        ticksToProcess: 400,
      }
    )
    .id("ftbskies:cooler/green_archwood_sapling");

  ftbsba.super_cooler(
    "2x ars_nouveau:blue_archwood_sapling",
    ["minecraft:blue_dye", "#forge:sapling", "#botania:petals"],
    Fluid.of("experienceobelisk:cognitium", 1000),
    {
      fePerTick: 100,
      ticksToProcess: 400,
    }
  );

  ftbsba
    .super_cooler(
      "2x ars_nouveau:red_archwood_sapling",
      ["minecraft:red_dye", "#forge:sapling", "#botania:petals"],
      Fluid.of("experienceobelisk:cognitium", 1000),
      {
        fePerTick: 100,
        ticksToProcess: 400,
      }
    )
    .id("ftbskies:cooler/red_archwood_sapling");

  ftbsba.super_cooler("occultism:raw_silver", ["botania:mana_powder"], Fluid.of("hexerei:quicksilver_fluid", 1000), {
    fePerTick: 1000,
    ticksToProcess: 40,
  });

  ftbsba
    .super_cooler(
      "24x cyclic:peat_unbaked",
      ["cyclic:biomass", "#forge:dusts/coal_coke", "minecraft:dirt"],
      Fluid.of("cyclic:biomass", 500),
      {
        fePerTick: 50,
        ticksToProcess: 60,
      }
    )
    .id("ftbskies:cooler/peat_unbaked");

  ftbsba.super_cooler(
    "12x cyclic:peat_unbaked",
    ["cyclic:biomass", "#forge:carbon_dusts", "minecraft:dirt"],
    Fluid.of("cyclic:biomass", 500),
    {
      fePerTick: 100,
      ticksToProcess: 120,
    }
  );

  ftbsba.fusing_machine(
    Fluid.of("integrateddynamics:menril_resin", 200),
    ["integrateddynamics:crystalized_menril_chunk", "integrateddynamics:crystalized_menril_chunk"],
    {
      fePerTick: 70,
      ticksToProcess: 60,
    }
  );

  ftbsba.fusing_machine(
    Fluid.of("integrateddynamics:menril_resin", 100),
    ["integrateddynamics:crystalized_menril_chunk"],
    {
      fePerTick: 35,
      ticksToProcess: 60,
    }
  );

});
