//Input, Output, Soil
const clocheAdditions = [
  ["ars_nouveau:bombegranate_pod", "ars_nouveau:bombegranate_pod", "minecraft:dirt"],
  ["ars_nouveau:bombegranate_pod", "ars_nouveau:bombegranate_pod", "ftbskies:lightly_magical_imbued_soil"],
  ["ars_nouveau:bombegranate_pod", "ars_nouveau:bombegranate_pod", "ftbskies:magical_imbued_soil"],
  ["ars_nouveau:bombegranate_pod", "ars_nouveau:bombegranate_pod", "ftbskies:densely_magical_imbued_soil"],

  ["ars_nouveau:frostaya_pod", "ars_nouveau:frostaya_pod", "minecraft:dirt"],
  ["ars_nouveau:frostaya_pod", "ars_nouveau:frostaya_pod", "ftbskies:lightly_magical_imbued_soil"],
  ["ars_nouveau:frostaya_pod", "ars_nouveau:frostaya_pod", "ftbskies:magical_imbued_soil"],
  ["ars_nouveau:frostaya_pod", "ars_nouveau:frostaya_pod", "ftbskies:densely_magical_imbued_soil"],

  ["ars_nouveau:bastion_pod", "ars_nouveau:bastion_pod", "minecraft:dirt"],
  ["ars_nouveau:bastion_pod", "ars_nouveau:bastion_pod", "ftbskies:lightly_magical_imbued_soil"],
  ["ars_nouveau:bastion_pod", "ars_nouveau:bastion_pod", "ftbskies:magical_imbued_soil"],
  ["ars_nouveau:bastion_pod", "ars_nouveau:bastion_pod", "ftbskies:densely_magical_imbued_soil"],

  ["ars_nouveau:mendosteen_pod", "ars_nouveau:mendosteen_pod", "minecraft:dirt"],
  ["ars_nouveau:mendosteen_pod", "ars_nouveau:mendosteen_pod", "ftbskies:lightly_magical_imbued_soil"],
  ["ars_nouveau:mendosteen_pod", "ars_nouveau:mendosteen_pod", "ftbskies:magical_imbued_soil"],
  ["ars_nouveau:mendosteen_pod", "ars_nouveau:mendosteen_pod", "ftbskies:densely_magical_imbued_soil"],
  
  ["ars_nouveau:source_berry", "ars_nouveau:source_berry", "minecraft:dirt"],
  ["ars_nouveau:source_berry", "ars_nouveau:source_berry", "ftbskies:lightly_magical_imbued_soil"],
  ["ars_nouveau:source_berry", "ars_nouveau:source_berry", "ftbskies:magical_imbued_soil"],
  ["ars_nouveau:source_berry", "ars_nouveau:source_berry", "ftbskies:densely_magical_imbued_soil"],

];

const clocheAdditionsWithSeeds = [
  ["ars_nouveau:magebloom_crop", "ars_nouveau:magebloom", "minecraft:dirt"],
  ["ars_nouveau:magebloom_crop", "ars_nouveau:magebloom", "ftbskies:lightly_magical_imbued_soil"],
  ["ars_nouveau:magebloom_crop", "ars_nouveau:magebloom", "ftbskies:magical_imbued_soil"],
  ["ars_nouveau:magebloom_crop", "ars_nouveau:magebloom", "ftbskies:densely_magical_imbued_soil"],
];

//Input, Output, RenderedCrop, Soil
const clocheAdditionsWithSpecificRenders = [
  ["supplementaries:flax_seeds", "supplementaries:flax", "supplementaries:wild_flax", "minecraft:dirt"],
  ["supplementaries:flax_seeds", "supplementaries:flax", "supplementaries:wild_flax", "ftbskies:lightly_magical_imbued_soil"],
  ["supplementaries:flax_seeds", "supplementaries:flax", "supplementaries:wild_flax", "ftbskies:magical_imbued_soil"],
  ["supplementaries:flax_seeds", "supplementaries:flax", "supplementaries:wild_flax", "ftbskies:densely_magical_imbued_soil"],
];

const disabledMultiblockRecipes = [
  "immersiveengineering:refinery",
  "immersiveengineering:squeezer",
  "immersiveengineering:fermenter",
  "immersiveengineering:sawmill",
];

ServerEvents.recipes((event) => {
  clocheAdditions.forEach((recipe) => {

    if (`${recipe[2]}` == "ftbskies:lightly_magical_imbued_soil") {
      event.custom({
        "type": "immersiveengineering:cloche",
        "input": { "item": `${recipe[0]}` },
        "render": { "type": "generic", "block": "minecraft:sweet_berry_bush" },
        "results": [
          { "count": 2, "item": `${recipe[1]}` }
        ],
        "soil": { "item": `${recipe[2]}` },
        "time": 480
      })
    }
    if (`${recipe[2]}` == "ftbskies:magical_imbued_soil") {
      event.custom({
        "type": "immersiveengineering:cloche",
        "input": { "item": `${recipe[0]}` },
        "render": { "type": "generic", "block": "minecraft:sweet_berry_bush" },
        "results": [
          { "count": 2, "item": `${recipe[1]}` }
        ],
        "soil": { "item": `${recipe[2]}` },
        "time": 320
      })
    }
    if (`${recipe[2]}` == "ftbskies:densely_magical_imbued_soil") {
      event.custom({
        "type": "immersiveengineering:cloche",
        "input": { "item": `${recipe[0]}` },
        "render": { "type": "generic", "block": "minecraft:sweet_berry_bush" },
        "results": [
          { "count": 2, "item": `${recipe[1]}` }
        ],
        "soil": { "item": `${recipe[2]}` },
        "time": 160
      })
    }
    if (`${recipe[2]}` == "minecraft:dirt") {
      event.custom({
        "type": "immersiveengineering:cloche",
        "input": { "item": `${recipe[0]}` },
        "render": { "type": "generic", "block": "minecraft:sweet_berry_bush" },
        "results": [
          { "count": 2, "item": `${recipe[1]}` }
        ],
        "soil": { "item": `${recipe[2]}` },
        "time": 640
      })
    }
  });

  clocheAdditionsWithSeeds.forEach((recipe) => {

    if (`${recipe[2]}` == "minecraft:dirt") {
      event.custom({
        "type": "immersiveengineering:cloche",
        "input": { "item": `${recipe[0]}` },
        "render": { "type": "crop", "block": `${recipe[0]}` },
        "results": [
          { "count": 1, "item": `${recipe[1]}` },
          { "item": `${recipe[0]}` }
        ],
        "soil": { "item": `${recipe[2]}` },
        "time": 640
      })
    }
    
    if (`${recipe[2]}` == "ftbskies:lightly_magical_imbued_soil") {
      event.custom({
        "type": "immersiveengineering:cloche",
        "input": { "item": `${recipe[0]}` },
        "render": { "type": "crop", "block": `${recipe[0]}` },
        "results": [
          { "count": 1, "item": `${recipe[1]}` },
          { "item": `${recipe[0]}` }
        ],
        "soil": { "item": `${recipe[2]}` },
        "time": 480
      })
    }
    
    if (`${recipe[2]}` == "ftbskies:magical_imbued_soil") {
      event.custom({
        "type": "immersiveengineering:cloche",
        "input": { "item": `${recipe[0]}` },
        "render": { "type": "crop", "block": `${recipe[0]}` },
        "results": [
          { "count": 1, "item": `${recipe[1]}` },
          { "item": `${recipe[0]}` }
        ],
        "soil": { "item": `${recipe[2]}` },
        "time": 320
      })
    }
    
    if (`${recipe[2]}` == "ftbskies:densely_magical_imbued_soil") {
      event.custom({
        "type": "immersiveengineering:cloche",
        "input": { "item": `${recipe[0]}` },
        "render": { "type": "crop", "block": `${recipe[0]}` },
        "results": [
          { "count": 1, "item": `${recipe[1]}` },
          { "item": `${recipe[0]}` }
        ],
        "soil": { "item": `${recipe[2]}` },
        "time": 160
      })
    }
  });

  clocheAdditionsWithSpecificRenders.forEach((recipe) => {

    if (`${recipe[2]}` == "minecraft:dirt") {
      event.custom({
        "type": "immersiveengineering:cloche",
        "input": { "item": `${recipe[0]}` },
        "render": { "type": "generic", "block": `${recipe[0]}` },
        "results": [
          { "count": 1, "item": `${recipe[1]}` },
          { "item": `${recipe[0]}` }
        ],
        "soil": { "item": `${recipe[2]}` },
        "time": 640
      })
    }
    
    if (`${recipe[2]}` == "ftbskies:lightly_magical_imbued_soil") {
      event.custom({
        "type": "immersiveengineering:cloche",
        "input": { "item": `${recipe[0]}` },
        "render": { "type": "generic", "block": `${recipe[0]}` },
        "results": [
          { "count": 1, "item": `${recipe[1]}` },
          { "item": `${recipe[0]}` }
        ],
        "soil": { "item": `${recipe[2]}` },
        "time": 480
      })
    }
    
    if (`${recipe[2]}` == "ftbskies:magical_imbued_soil") {
      event.custom({
        "type": "immersiveengineering:cloche",
        "input": { "item": `${recipe[0]}` },
        "render": { "type": "generic", "block": `${recipe[0]}` },
        "results": [
          { "count": 1, "item": `${recipe[1]}` },
          { "item": `${recipe[0]}` }
        ],
        "soil": { "item": `${recipe[2]}` },
        "time": 320
      })
    }
    
    if (`${recipe[2]}` == "ftbskies:densely_magical_imbued_soil") {
      event.custom({
        "type": "immersiveengineering:cloche",
        "input": { "item": `${recipe[0]}` },
        "render": { "type": "generic", "block": `${recipe[0]}` },
        "results": [
          { "count": 1, "item": `${recipe[1]}` },
          { "item": `${recipe[0]}` }
        ],
        "soil": { "item": `${recipe[2]}` },
        "time": 160
      })
    }
  });

  //Disabled Multiblocks
  disabledMultiblockRecipes.forEach((recipeType) => {
    event.forEachRecipe({ type: recipeType }, (r) => {
      r.remove();
    });
  });

  //Hop Ingots
  event
    .custom({
      type: "occultism:crushing",
      ingredient: {
        item: "thermal:coal_coke_block",
      },
      result: {
        item: "immersiveengineering:dust_hop_graphite",
        count: 1,
      },
      crushing_time: 200,
    })
    .id("ftbskies:hop_ingot");

  //blueprints
  event
    .custom({
      type: "create:compacting",
      ingredients: [
        {
          item: "ars_nouveau:blank_parchment",
        },
        {
          tag: "forge:dyes/blue",
        },
        {
          item: "mekanism:shard_iron",
        },
      ],
      results: [
        {
          item: "immersiveengineering:blueprint",
          nbt: '{blueprint:"components"}',
        },
      ],
      heatRequirement: "heated",
    })
    .id("ftbskies:blueprint_components");



  //heavy engineering block
  event
    .shaped("4x immersiveengineering:heavy_engineering", ["SCS", "CIC", "SCS"], {
      I: "create_new_age:overcharged_iron",
      S: "immersiveengineering:sheetmetal_steel",
      C: "immersiveengineering:component_steel",
    })
    .id("ftbskies:heavy_engineering");

  //HV Wire
  event.custom({
      type: "thermal:smelter",
      ingredients: [
        {
          item: "immersiveengineering:wirecoil_electrum",
          amount: 4,
        },
        {
          item: "immersiveengineering:wire_aluminum",
          amount: 2,
        },
        {
          item: "immersiveengineering:wire_steel",
          amount: 2,
        }
      ],
      result: [
        {
          item: "immersiveengineering:wirecoil_steel",
          amount: 4,
        },
      ],
      energy: 25000,
  }).id("ftbskies:hv_wirecoil");

});
