ServerEvents.recipes((event) => {
  //Conveyor Belt
  event
    .shaped("industrialforegoing:conveyor", ["PPP", "IRI", "PPP"], {
      I: "#forge:plates/iron",
      R: "minecraft:redstone",
      P: "thermal:cured_rubber",
    })
    .id("ftbskies:industrial_foregoing_conveyor");

  event
    .shaped("4x industrialforegoing:conveyor", ["PPP", "IRI", "PPP"], {
      I: "#forge:plates/iron",
      R: "minecraft:redstone",
      P: "industrialforegoing:plastic",
    })
    .id("ftbskies:industrial_foregoing_conveyor_1");

  //Conveyor Belt Extractor Upgrade
  event
    .shaped("industrialforegoing:conveyor_extraction_upgrade", ["IPI", "IHI", "ICI"], {
      I: "#forge:plates/iron",
      H: "minecraft:hopper",
      P: "thermal:cured_rubber",
      C: "industrialforegoing:conveyor",
    })
    .id("ftbskies:industrial_foregoing_conveyor_extraction_upgrade");

  event
    .shaped("industrialforegoing:conveyor_extraction_upgrade", ["IPI", "IHI", "ICI"], {
      I: "#forge:plates/iron",
      H: "minecraft:hopper",
      P: "industrialforegoing:plastic",
      C: "industrialforegoing:conveyor",
    })
    .id("ftbskies:industrial_foregoing_conveyor_extraction_upgrade_1");

  //Conveyor Belt Insertion Upgrade
  event
    .shaped("industrialforegoing:conveyor_insertion_upgrade", ["IPI", "IDI", "ICI"], {
      I: "#forge:plates/iron",
      D: "minecraft:dispenser",
      P: "thermal:cured_rubber",
      C: "industrialforegoing:conveyor",
    })
    .id("ftbskies:industrial_foregoing_conveyor_insertion_upgrade");

  event
    .shaped("industrialforegoing:conveyor_insertion_upgrade", ["IPI", "IDI", "ICI"], {
      I: "#forge:plates/iron",
      D: "minecraft:dispenser",
      P: "industrialforegoing:plastic",
      C: "industrialforegoing:conveyor",
    })
    .id("ftbskies:industrial_foregoing_conveyor_insertion_upgrade_1");

  //Fluid extractor
  event
    .shaped("industrialforegoing:fluid_extractor", ["IPI", "SHS", "ICI"], {
      I: "#forge:plates/iron",
      H: "industrialforegoing:machine_frame_pity",
      P: "cyclic:hopper_fluid",
      C: "industrialforegoing:conveyor",
      S: "#forge:cobblestone",
    })
    .id("ftbskies:id_fluid_extractor");

  //Dissolution Chamber
  event
    .shaped("industrialforegoing:dissolution_chamber", ["LPL", "EME", "TAT"], {
      L: "ftbskies:ldpe_sheet",
      P: "create:precision_mechanism",
      E: "#forge:gears/electrum",
      M: "thermal:machine_frame",
      T: "pneumaticcraft:small_tank",
      A: "#forge:gears/aluminum",
    })
    .id("ftbskies:dissolution_chamber");

  //Simple Frame
  event.custom({
    type: "industrialforegoing:dissolution_chamber",
    input: [
      {
        tag: "forge:plastic",
      },
      {
        item: "thermal:machine_frame",
      },
      {
        tag: "forge:plastic",
      },
      {
        item: "immersiveengineering:plate_duroplast",
      },
      {
        item: "immersiveengineering:plate_duroplast",
      },
      {
        tag: "forge:ingots/steel",
      },
      {
        tag: "forge:gears/gold",
      },
      {
        tag: "forge:ingots/steel",
      },
    ],
    inputFluid: '{Amount:250,FluidName:"industrialforegoing:latex"}',
    output: {
      count: 1,
      item: "industrialforegoing:machine_frame_simple",
    },
    processingTime: 300,
  });
  // #Saturated Peat Gives 4mb/t
  event
    .custom({
      type: "industrialforegoing:fluid_extractor",
      breakChance: 0.01,
      defaultRecipe: false,
      input: {
        item: "cyclic:peat_baked",
      },
      output: '{Amount:4,FluidName:"ftbskies:methane"}',
      result: "minecraft:sand",
    })
    .id("ftbskies:saturated_peat_methane_extraction");

  // #Terra Preta Gives 6mb/t
  event
    .custom({
      type: "industrialforegoing:fluid_extractor",
      breakChance: 0.01,
      defaultRecipe: false,
      input: {
        item: "cyclic:terra_preta",
      },
      output: '{Amount:6,FluidName:"ftbskies:methane"}',
      result: "cyclic:peat_baked",
    })
    .id("ftbskies:terra_preta_methane_extraction");
});
