ServerEvents.recipes((event) => {
  //wrench
  event
    .shaped("integrateddynamics:wrench", [" MS", " RM", "R  "], {
      M: "integrateddynamics:crystalized_menril_chunk",
      S: "thermal:redstone_servo",
      R: "jaopca:rods.invar",
    })
    .id("ftbskies:integrateddynamics_wrench");

  //Water block for SFM
  event
    .custom({
      type: "integrateddynamics:mechanical_drying_basin",
      fluid: {
        fluid: "integrateddynamics:menril_resin",
        amount: 1000,
      },
      item: {
        item: "elementalcraft:powerful_water_shard",
      },
      duration: 20,
      result: {
        item: "sfm:water_tank",
      },
    })
    .id("ftbskies:water_block");

  event
    .custom({
      type: "integrateddynamics:drying_basin",
      fluid: {
        fluid: "integrateddynamics:menril_resin",
        amount: 1000,
      },
      item: {
        item: "elementalcraft:powerful_water_shard",
      },
      duration: 20,
      result: {
        item: "sfm:water_tank",
      },
    })
    .id("ftbskies:water_block_standard");

  //Menril liquid from crystalized chunks
  event
    .custom({
      type: "thermal:crucible",
      ingredient: {
        item: "integrateddynamics:crystalized_menril_chunk",
      },
      result: [
        {
          fluid: "integrateddynamics:menril_resin",
          amount: 100,
        },
      ],
      energy: 2000,
    })
    .id("ftbskies:menril_liquid_from_chunks");
    
    //Menril liquid from crystalized blocks
    event
      .custom({
        type: "thermal:crucible",
        ingredient: {
          item: "integrateddynamics:crystalized_menril_block",
        },
        result: [
          {
            fluid: "integrateddynamics:menril_resin",
            amount: 900,
          },
        ],
        energy: 2000,
      })
      .id("ftbskies:menril_liquid_from_crystallized_blocks");

  //Chorus liquid from crystalized chunks
  event
    .custom({
      type: "thermal:crucible",
      ingredient: {
        item: "integrateddynamics:crystalized_chorus_chunk",
      },
      result: [
        {
          fluid: "integrateddynamics:liquid_chorus",
          amount: 125,
        },
      ],
      energy: 2225,
    })
    .id("ftbskies:chorus_liquid_from_chunks");
    
    //Chorus liquid from crystalized chorus blocks
    event
      .custom({
        type: "thermal:crucible",
        ingredient: {
          item: "integrateddynamics:crystalized_chorus_block",
        },
        result: [
          {
            fluid: "integrateddynamics:liquid_chorus",
            amount: 1125,
          },
        ],
        energy: 2225,
      })
      .id("ftbskies:chorus_liquid_from_crystallized_blocks");
  //variable cards
  event
    .custom({
      type: "create:sequenced_assembly",
      ingredient: {
        item: "ars_nouveau:blank_parchment",
      },
      transitionalItem: {
        item: "ftbskies:incomplete_variable_card",
      },
      loops: 1,
      sequence: [
        {
          type: "create:filling",
          ingredients: [
            {
              item: "ftbskies:incomplete_variable_card",
            },
            {
              fluid: "integrateddynamics:menril_resin",
              amount: 1000,
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_variable_card",
            },
          ],
        },
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "ftbskies:incomplete_variable_card",
            },
            {
              item: "immersiveengineering:component_electronic",
            },
          ],
          results: [
            {
              item: "ftbskies:incomplete_variable_card",
            },
          ],
        },
      ],
      results: [
        {
          item: "integrateddynamics:variable",
          count: 32,
        },
      ],
    })
    .id("ftbskies:id_variable_card");

  //Logic Programmer
  event
    .custom({
      type: "create:mechanical_crafting",
      pattern: ["#Q#", "GUG", "###"],
      key: {
        "#": {
          tag: "forge:plates/manasteel",
        },
        Q: {
          item: "immersiveengineering:logic_circuit",
        },
        G: {
          item: "integratedterminals:menril_glass",
        },
        U: {
          item: "immersiveengineering:logic_unit",
        },
      },
      result: {
        item: "integrateddynamics:logic_programmer",
      },
    })
    .id("ftbskies:logic_programmer");

  //variable store
  event
    .shaped("integrateddynamics:variablestore", ["PCP", "GSG", "PPP"], {
      P: "#forge:plates/manasteel",
      C: "immersiveengineering:logic_circuit",
      G: "integratedterminals:menril_glass",
      S: "mekanism:qio_drive_base",
    })
    .id("ftbskies:integrateddynamics_variable_store");

  //Mechanical basin
  event
    .shaped("integrateddynamics:mechanical_drying_basin", ["PCP", "GBG", "POP"], {
      P: "#forge:plates/manasteel",
      C: "immersiveengineering:logic_circuit",
      G: "integratedterminals:menril_glass",
      O: "minecraft:obsidian",
      B: "integrateddynamics:drying_basin",
    })
    .id("ftbskies:integrateddynamics_mechanical_basin");

  //Mechanical Squeezer
  event
    .shaped("integrateddynamics:mechanical_squeezer", ["PCP", "GBG", "POP"], {
      P: "#forge:plates/manasteel",
      C: "immersiveengineering:logic_circuit",
      G: "integratedterminals:menril_glass",
      O: "minecraft:obsidian",
      B: "integrateddynamics:squeezer",
    })
    .id("ftbskies:integrateddynamics_mechanical_squeezer");

  //cables
  event
    .shaped("16x integrateddynamics:cable", ["PQP", "GSG", "PQP"], {
      P: "#forge:plates/manasteel",
      Q: "#forge:gems/quartz",
      G: "integratedterminals:menril_glass",
      S: "#forge:rods/invar",
    })
    .id("ftbskies:integrateddynamics_cables");

  //Proto chorus
  event
    .custom({
      type: "pneumaticcraft:thermo_plant",
      air_use_multiplier: 3.0,
      exothermic: false,
      fluid_input: {
        type: "pneumaticcraft:fluid",
        amount: 1000,
        fluid: "createteleporters:quantum_fluid",
      },
      item_input: {
        item: "integrateddynamics:menril_berries",
      },
      item_output: {
        item: "integrateddynamics:proto_chorus",
      },
      pressure: 3.0,
      speed: 0.5,
      temperature: {
        max_temp: 73,
        min_temp: 0,
      },
    })
    .id("ftbskies:proto_chorus");

  //lava
  event
    .custom({
      type: "integrateddynamics:drying_basin",
      item: "minecraft:magma_block",
      duration: 1000,
      result: {
        item: "minecraft:netherrack",
      },
    })
    .id("ftbskies:magma_to_netherrack");

    event.shaped('4x integratedtunnels:part_interface_energy', ['KDK', 'KKK'], {
      D: "mekanism:basic_energy_cube",
      K: "integrateddynamics:crystalized_menril_chunk"
    }).id('ftbskies:energy_interface')

  //Logic Director
  event.shaped("4x integrateddynamics:logic_director", ["KMK", "CLC", "KMK"], {
      C: "integrateddynamics:crystalized_chorus_block",
      M: "integrateddynamics:crystalized_menril_chunk",
      L: "immersiveengineering:logic_circuit",
      K: "integrateddynamics:crystalized_chorus_chunk"
    })
    .id("ftbskies:crafting/logic_director");

});
