const removeQIOByID = ["mekanism:qio_drive_array", "mekanism:qio_drive_base"];

ServerEvents.recipes((event) => {
  removeQIOByID.forEach((remove) => {
    event.remove({ id: remove });
  });

  event
    .custom({
      type: "mekanism:enriching",
      input: {
        ingredient: {
          item: "ae2:flawed_budding_quartz",
        },
      },
      output: {
        count: 1,
        item: "ae2:flawless_budding_quartz",
      },
    })
    .id("ftbskies:flawless_budding_quartz");

  //universal cables
  event
    .custom({
      type: "thermal:smelter",
      ingredients: [
        {
          value: [
            {
              item: "thermal:energy_duct",
            },
          ],
          count: 4,
        },
        {
          tag: "mekanism:alloys/infused",
          count: 1,
        },
        {
          value: [
            {
              tag: "forge:dusts/certus_quartz",
            },
          ],
          count: 1,
        },
      ],
      result: [
        {
          item: "mekanism:basic_universal_cable",
          count: 8,
        },
      ],
      energy: 32000,
    })
    .id("ftbskies:universal_cable");

  //baisc alloy
  event
    .custom({
      type: "mekanism:metallurgic_infusing",
      chemicalInput: { amount: 20, tag: "mekanism:redstone" },
      itemInput: { ingredient: { tag: "forge:plates/signalum" } },
      output: { item: "mekanism:alloy_infused" },
    })
    .id("ftbskies:basic_alloy");

  event
    .custom({
      type: "mekanism:metallurgic_infusing",
      chemicalInput: { amount: 20, infuse_type: "kubejs:source" },
      itemInput: { ingredient: { tag: "forge:alloys/ultimate" } },
      output: { item: "createteleporters:quantum_mechanism", count: 4 },
    })
    .id("ftbskies:quantum_mechanism");

  //reinforced alloy
  event
    .custom({
      type: "mekanism:metallurgic_infusing",
      chemicalInput: { amount: 60, tag: "mekanism:diamond" },
      itemInput: { ingredient: { tag: "mekanism:alloys/infused" } },
      output: { item: "mekanism:alloy_reinforced" },
    })
    .id("ftbskies:reinforced_alloy");

  event.custom({
    type: "mekanism:metallurgic_infusing",
    chemicalInput: { amount: 50, tag: "mekanism:diamond" },
    itemInput: { ingredient: { tag: "forge:ingots/iesnium" } },
    output: { item: "ftbskies:platinum_ingot" },
  });

  event
    .shaped("mekanism:configurator", [" L ", "RCR", " S "], {
      L: "minecraft:lapis_lazuli",
      R: "minecraft:repeater",
      C: "immersiveengineering:component_electronic",
      S: "immersiveengineering:stick_iron",
    })
    .id("ftbskies:configurator");

  //qio disk array
  event
    .shaped("mekanism:qio_drive_array", ["PDP", "GBG", "PQP"], {
      P: "#forge:plates/drenched_iron",
      D: "#forge:dusts/diamond",
      G: "#forge:circuits/advanced",
      B: "mekanism:personal_barrel",
      Q: "createteleporters:quantum_mechanism",
    })
    .id("ftbskies:qio_drive_array");

  //qio drive
  event
    .custom({
      type: "create:mechanical_crafting",
      pattern: ["#C#", "CQC", "#C#"],
      key: {
        "#": {
          tag: "forge:plates/invar",
        },
        Q: {
          item: "createteleporters:quantum_mechanism",
        },
        C: {
          tag: "forge:circuits/basic",
        },
      },
      result: {
        item: "mekanism:qio_drive_base",
      },
    })
    .id("ftbskies:qio_drive_base");

  event
    .shaped("mekanism:logistical_sorter", ["IPI", "ICI", "III"], {
      I: "minecraft:iron_ingot",
      P: "#forge:pistons",
      C: "immersiveengineering:component_electronic",
    })
    .id("ftbskies:logistical_sorter");

  event
    .shaped("8x mekanism:basic_logistical_transporter", ["   ", "SCS", "   "], {
      S: "#forge:plates/steel",
      C: "immersiveengineering:component_electronic",
    })
    .id("ftbskies:logistical_sorter_pipe");

  event
    .custom({
      type: "mekanism:infusion_conversion",
      input: {
        ingredient: [{ item: "ars_nouveau:source_gem" }],
      },
      output: { amount: 40, infuse_type: "kubejs:source" },
    })
    .id("ftbskies:infusion_conversion_source");

  event
    .custom({
      type: "mekanism:infusion_conversion",
      input: {
        ingredient: [{ item: "thermal:signalum_ingot" }],
      },
      output: { amount: 20, infuse_type: "kubejs:volatile_redstone_gas" },
    })
    .id("ftbskies:infusion_conversion_volatile_red");

  //circuits
  //Electronic control circuit
  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "immersiveengineering:logic_circuit",
        },
        {
          fluid: "integrateddynamics:menril_resin",
          amount: 250,
        },
      ],
      result: [
        {
          item: "mekanism:basic_control_circuit",
          amount: 1,
        },
      ],
      energy: 20000,
    })
    .id("ftbskies:advanced_electronic_component");

  //Signalum Processor
  event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          type: "pneumaticcraft:stacked_item",
          count: 2,
          item: "mekanism:basic_control_circuit",
        },
        {
          type: "pneumaticcraft:stacked_item",
          count: 1,
          item: "thermal:signalum_ingot",
        },

        {
          type: "pneumaticcraft:stacked_item",
          count: 1,
          item: "ae2:printed_silicon",
        },
      ],
      pressure: 2.5,
      results: [
        {
          item: "jaopca:processors.signalum",
        },
      ],
    })
    .id("ftbskies:signalum_processor");

  //Advanced control circuit
  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "jaopca:processors.signalum",
        },
        {
          fluid: "ftbskies:volatile_redstone",
          amount: 250,
        },
      ],
      result: [
        {
          item: "mekanism:advanced_control_circuit",
          amount: 1,
        },
      ],
      energy: 50000,
    })
    .id("ftbskies:advanced_control_circuit");

  event
    .custom({
      type: "industrialforegoing:dissolution_chamber",
      input: [
        {
          tag: "forge:circuits/advanced",
        },
        {
          tag: "forge:circuits/advanced",
        },
        {
          tag: "forge:circuits/advanced",
        },
        {
          tag: "forge:circuits/advanced",
        },
        {
          tag: "forge:ingots/platinum",
        },
        {
          tag: "forge:ingots/platinum",
        },
        {
          item: "ae2:engineering_processor",
        },
      ],
      inputFluid: '{Amount:100,FluidName:"industrialforegoing:ether_gas"}',
      output: {
        count: 1,
        item: "mekanism:elite_control_circuit",
      },
      processingTime: 300,
    })
    .id("ftbskies:elite_control_circuit");

  //osmium ingot
  event
    .custom({
      type: "immersiveengineering:arc_furnace",
      energy: 819200,
      additives: [{ item: "ftbskies:everburnair" }],
      input: { tag: "forge:dusts/osmium" },
      results: [{ tag: "forge:ingots/osmium" }],
      time: 150,
    })
    .id("ftbskies:osmium_ingot");

  event
    .shaped("jaopca:processors.enderium", ["CCC", "CPC", "CCC"], {
      C: "#forge:plates/enderium",
      P: "ftbskies:enigmatic_circuit",
    })
    .id("ftbskies:enderium_processor");

  //PTFE
  event
    .custom({
      type: "mekanism:reaction",
      duration: 1600,
      energyRequired: 7500,
      fluidInput: { amount: 100, fluid: "ftbskies:methane" },
      gasInput: { amount: 100, gas: "mekanism:hydrofluoric_acid" },
      gasOutput: { amount: 10, gas: "mekanism:hydrogen" },
      itemInput: { amount: 1, ingredient: { item: "mekanism:hdpe_sheet" } },
      itemOutput: { item: "ftbskies:ptfe_sheet" },
    })
    .id("ftbskies:ptfe_sheet");

  //molten PTFE
  event
    .custom({
      type: "thermal:crucible",
      ingredient: {
        item: "ftbskies:ptfe_sheet",
      },
      result: [
        {
          fluid: "ftbskies:polytetrafluoroethylene",
          amount: 100,
        },
      ],
      energy: 200000,
    })
    .id("ftbskies:ptfe_sheet_crucible");

  //Ultimate circuit
  event
    .custom({
      type: "mekanism:reaction",
      duration: 1600,
      energyRequired: 2500,
      fluidInput: { amount: 2000, fluid: "ftbskies:stabilized_pyrotheum" },
      gasInput: { amount: 100, gas: "kubejs:cryo_gas" },
      gasOutput: { amount: 10, gas: "mekanism:oxygen" },
      itemInput: { amount: 4, ingredient: { item: "jaopca:processors.enderium" } },
      itemOutput: { item: "mekanism:ultimate_control_circuit" },
    })
    .id("ftbskies:ultimate_control_circuit");

  // Cryo infused ingot
  event
    .custom({
      type: "mekanism:reaction",
      duration: 1600,
      energyRequired: 5000,
      fluidInput: { amount: 1000, fluid: "ftbskies:methane" },
      gasInput: { amount: 100, gas: "kubejs:cryo_gas" },
      gasOutput: { amount: 10, gas: "kubejs:carbon_dioxide" },
      itemInput: { amount: 1, ingredient: { item: "mekanism:ingot_osmium" } },
      itemOutput: { item: "ftbskies:cryo_infused_osmium_ingot" },
    })
    .id("ftbskies:cryo_infused_osmium_ingot");

  //Carbon Dioxide Recipe
  event
    .custom({
      type: "mekanism:reaction",
      duration: 1600,
      energyRequired: 5000,
      itemInput: { amount: 1, ingredient: { item: "mekanism:enriched_carbon" } },
      fluidInput: { amount: 1000, fluid: "minecraft:water" },
      gasInput: { amount: 100, gas: "mekanism:oxygen" },
      gasOutput: { amount: 250, gas: "kubejs:carbon_dioxide" },
    })
    .id("ftbskies:carbon_dioxide_reaction");

  //Refining Sulfuric Gas into Refinery Gas Recipe
  event
    .custom({
      type: "mekanism:reaction",
      duration: 1600,
      energyRequired: 5000,
      itemInput: { amount: 1, ingredient: { item: "mekanism:bio_fuel" } },
      fluidInput: { amount: 100, fluid: "ftbskies:sulfuric_gas" },
      gasInput: { amount: 100, gas: "mekanism:hydrogen" },
      gasOutput: { amount: 100, gas: "kubejs:refinery_gas" },
      itemOutput: { item: "thermal:bitumen" },
    })
    .id("ftbskies:sulfuric_gas_reaction");

  //Ethane with C0² → Ethylene Recipe
  event
    .custom({
      type: "mekanism:reaction",
      duration: 1600,
      energyRequired: 5000,
      itemInput: { amount: 1, ingredient: { item: "minecraft:glowstone_dust" } },
      fluidInput: { amount: 100, fluid: "ftbskies:ethane" },
      gasInput: { amount: 100, gas: "kubejs:carbon_dioxide" },
      gasOutput: { amount: 100, gas: "mekanism:ethene" },
      itemOutput: { item: "minecraft:redstone" },
    })
    .id("ftbskies:ethane_ethylene_reaction");

  // Custom Gases Conversion ============================================================

  //Carbon Dioxide Conversion
  event
    .custom({
      type: "mekanism:rotary",
      fluidInput: {
        amount: 1,
        fluid: "ftbskies:nitro_diesel",
      },
      fluidOutput: {
        amount: 1,
        fluid: "ftbskies:nitro_diesel",
      },
      gasInput: {
        amount: 1,
        gas: "kubejs:nitro_gas",
      },
      gasOutput: {
        amount: 1,
        gas: "kubejs:nitro_gas",
      },
    })
    .id("ftbskies:nitro_gas_conversion");

  //Carbon Dioxide Conversion
  event
    .custom({
      type: "mekanism:rotary",
      fluidInput: {
        amount: 1,
        fluid: "ftbskies:carbon_dioxide",
      },
      fluidOutput: {
        amount: 1,
        fluid: "ftbskies:carbon_dioxide",
      },
      gasInput: {
        amount: 1,
        gas: "kubejs:carbon_dioxide",
      },
      gasOutput: {
        amount: 1,
        gas: "kubejs:carbon_dioxide",
      },
    })
    .id("ftbskies:carbon_dioxide_conversion");

  //Sulfuric Gas Conversion
  event
    .custom({
      type: "mekanism:rotary",
      fluidInput: {
        amount: 1,
        fluid: "ftbskies:sulfuric_gas",
      },
      fluidOutput: {
        amount: 1,
        fluid: "ftbskies:sulfuric_gas",
      },
      gasInput: {
        amount: 1,
        gas: "kubejs:sulfuric_gas",
      },
      gasOutput: {
        amount: 1,
        gas: "kubejs:sulfuric_gas",
      },
    })
    .id("ftbskies:sulfuric_gas_conversion");

  //Refinery Gas Conversion
  event
    .custom({
      type: "mekanism:rotary",
      fluidInput: {
        amount: 1,
        fluid: "ftbskies:refinery_gas",
      },
      fluidOutput: {
        amount: 1,
        fluid: "ftbskies:refinery_gas",
      },
      gasInput: {
        amount: 1,
        gas: "kubejs:refinery_gas",
      },
      gasOutput: {
        amount: 1,
        gas: "kubejs:refinery_gas",
      },
    })
    .id("ftbskies:refinery_gas_conversion");

  //Methane Gas Conversion
  event
    .custom({
      type: "mekanism:rotary",
      fluidInput: {
        amount: 1,
        fluid: "ftbskies:methane",
      },
      fluidOutput: {
        amount: 1,
        fluid: "ftbskies:methane",
      },
      gasInput: {
        amount: 1,
        gas: "kubejs:methane_gas",
      },
      gasOutput: {
        amount: 1,
        gas: "kubejs:methane_gas",
      },
    })
    .id("ftbskies:methane_gas_conversion");

  //Fluorine Gas Conversion
  event
    .custom({
      type: "mekanism:rotary",
      fluidInput: {
        amount: 1,
        fluid: "ftbskies:fluorine",
      },
      fluidOutput: {
        amount: 1,
        fluid: "ftbskies:fluorine",
      },
      gasInput: {
        amount: 1,
        gas: "kubejs:fluorine_gas",
      },
      gasOutput: {
        amount: 1,
        gas: "kubejs:fluorine_gas",
      },
    })
    .id("ftbskies:fluorine_gas_conversion");

  //Benzene Gas Conversion
  event
    .custom({
      type: "mekanism:rotary",
      fluidInput: {
        amount: 1,
        fluid: "ftbskies:benzene",
      },
      fluidOutput: {
        amount: 1,
        fluid: "ftbskies:benzene",
      },
      gasInput: {
        amount: 1,
        gas: "kubejs:benzene_gas",
      },
      gasOutput: {
        amount: 1,
        gas: "kubejs:benzene_gas",
      },
    })
    .id("ftbskies:benzene_gas_conversion");

  //Ethane Gas Conversion
  event
    .custom({
      type: "mekanism:rotary",
      fluidInput: {
        amount: 1,
        fluid: "ftbskies:ethane",
      },
      fluidOutput: {
        amount: 1,
        fluid: "ftbskies:ethane",
      },
      gasInput: {
        amount: 1,
        gas: "kubejs:ethane_gas",
      },
      gasOutput: {
        amount: 1,
        gas: "kubejs:ethane_gas",
      },
    })
    .id("ftbskies:ethane_gas_conversion");

    // ====================================================================================

    event
      .shaped("mekanismgenerators:advanced_solar_generator", ["CAC", "CAC", "DDD"], {
        C: "pneumaticcraft:solar_cell",
        A: "mekanism:alloy_infused",
        D: "ad_astra:desh_plate",
      })
      .id("ftbskies:advanced_solar_generator");
    
    //Chemical Dissolution Chamber
    event.shaped("mekanism:chemical_dissolution_chamber", ["RTR", "ESE", "RTR"], {
      R: "#forge:plates/refined_obsidian",
      T: "mekanism:elite_chemical_tank",
      E: "mekanism:elite_control_circuit",
      S: "mekanism:steel_casing",
    }).id("ftbskies:chemical_dissolution_chamber");

  //Installers Rework =============================================================================

    //Basic
    event.shaped("mekanism:basic_tier_installer", ["RCR", "SFS", "RCR"], {
      F: "immersiveengineering:treated_scaffold",
      R: "create:electron_tube",
      S: "#forge:plates/steel",
      C: "mekanism:basic_control_circuit",
    }).id("ftbskies:basic_tier_installer");

    //Advanced
    event.shaped("mekanism:advanced_tier_installer", ["RCR", "SFS", "RCR"], {
      F: "mekanism:basic_tier_installer",
      R: "mekanism:alloy_infused",
      S: "#forge:plates/osmium",
      C: "mekanism:advanced_control_circuit",
    }).id("ftbskies:advanced_tier_installer");

    //Elite
    event.shaped("mekanism:elite_tier_installer", ["RCR", "SFS", "RCR"], {
      F: "mekanism:advanced_tier_installer",
      R: "mekanism:alloy_reinforced",
      S: "ftbskies:platinum_plate",
      C: "mekanism:elite_control_circuit",
    }).id("ftbskies:elite_tier_installer");

    //Ultimate
    event.shaped("mekanism:ultimate_tier_installer", ["RCR", "SFS", "RCR"], {
      F: "mekanism:elite_tier_installer",
      R: "mekanism:alloy_atomic",
      S: "#forge:plates/enderium",
      C: "mekanism:ultimate_control_circuit",
    }).id("ftbskies:ultimate_tier_installer");

  // ====================================================================================

  //Enrichment Chamber
  event.shaped("mekanism:enrichment_chamber", ["SCS", "RFR", "SCS"], {
    F: "mekanism:steel_casing",
    R: "create:electron_tube",
    S: "#forge:plates/steel",
    C: "mekanism:basic_control_circuit",
  }).id("ftbskies:enrichment_chamber");

  //Osmium Compressor
  event.shaped("mekanism:osmium_compressor", ["RCR", "SFS", "RCR"], {
    F: "mekanism:steel_casing",
    R: "mekanism:alloy_infused",
    S: "pneumaticcraft:pneumatic_cylinder",
    C: "mekanism:advanced_control_circuit",
  }).id("ftbskies:osmium_compressor");

  //Combiner
  event.shaped("mekanism:combiner", ["RCR", "SFS", "RCR"], {
    F: "mekanism:steel_casing",
    R: "mekanism:alloy_reinforced",
    S: "ftbskies:compressed_cobblestone",
    C: "mekanism:elite_control_circuit",
  }).id("ftbskies:combiner");

  //Crusher
  event.shaped("mekanism:crusher", ["RCR", "DFS", "RCR"], {
    F: "mekanism:steel_casing",
    R: "create:electron_tube",
    D: "pneumaticcraft:drill_bit_compressed_iron",
    S: "#forge:sawblades",
    C: "mekanism:basic_control_circuit",
  }).id("ftbskies:crusher");

  //Purification Chamber
  event.shaped("mekanism:purification_chamber", ["RCR", "SFS", "RCR"], {
    F: "mekanism:steel_casing",
    R: "mekanism:alloy_infused",
    S: "elementalcraft:purecrystal",
    C: "mekanism:advanced_control_circuit",
  }).id("ftbskies:purification_chamber");

  //Energized Smelter
  event.shaped("mekanism:energized_smelter", ["RCR", "SFS", "RCR"], {
    F: "mekanism:steel_casing",
    R: "mekanism:alloy_infused",
    S: "thermal:rf_coil",
    C: "#forge:plates/steel",
  }).id("ftbskies:energized_smelter");

  //Chargepad
  event.shaped("mekanism:chargepad", ["   ", "PPP", "SBS"], {
    P: "minecraft:polished_blackstone_pressure_plate",
    B: "#forge:batteries",
    S: "#forge:plates/steel",
  }).id("ftbskies:chargepad");

  //Chemical Washer
  event.shaped("mekanism:chemical_washer", ["RTR", "UFU", "RCR"], {
    F: "mekanism:steel_casing",
    T: "mekanism:ultimate_fluid_tank",
    C: "mekanism:ultimate_chemical_tank",
    R: "#forge:plates/refined_obsidian",
    U: "ftbskies:enigmatic_circuit",
  }).id("ftbskies:chemical_washer");

  //Chemical Crystallizer
  event.shaped("mekanism:chemical_crystallizer", ["RTR", "UFU", "RTR"], {
    F: "mekanism:steel_casing",
    T: "#forge:gems/fluorite",
    R: "#forge:plates/refined_obsidian",
    U: "ftbskies:enigmatic_circuit",
  }).id("ftbskies:chemical_crystallizer");

  //Pressurized Reaction Chamber
  event.shaped("mekanism:pressurized_reaction_chamber", ["SAS", "UFU", "CTC"], {
    F: "mekanism:enrichment_chamber",
    S: "#forge:plates/steel",
    A: "mekanism:alloy_infused",
    U: "mekanism:basic_control_circuit",
    T: "cyclic:unbreakable_reactive",
    C: "mekanism:basic_chemical_tank"
  }).id("ftbskies:pressurized_reaction_chamber");

  // Hazmat Suit Pieces ===========================================================================

  //Helmet
  event.shaped("mekanism:hazmat_mask", ["CCC", "CLC", "LOL"], {
    L: "#forge:plates/lead",
    C: "handcrafted:orange_cushion",
    O: "handcrafted:orange_sheet"
  }).id("ftbskies:hazmat_mask");

  //Chestplate
  event.shaped("mekanism:hazmat_gown", ["LCL", "LLL", "OLO"], {
    L: "#forge:plates/lead",
    C: "handcrafted:orange_cushion",
    O: "handcrafted:orange_sheet"
  }).id("ftbskies:hazmat_gown");

  //Leggings
  event.shaped("mekanism:hazmat_pants", ["LLL", "LCL", "O O"], {
    L: "#forge:plates/lead",
    C: "handcrafted:orange_cushion",
    O: "handcrafted:orange_sheet"
  }).id("ftbskies:hazmat_pants");

  //Boots
  event.shaped("mekanism:hazmat_boots", ["C C", "L L", "R R"], {
    L: "#forge:plates/lead",
    C: "handcrafted:black_cushion",
    R: "thermal:cured_rubber"
  }).id("ftbskies:hazmat_boots");

  // ==============================================================================================

  //Robit
  event.shaped("mekanism:robit", [" S ", "EAE", "RPR"], {
    S: "#forge:plates/steel",
    A: "mekanism:alloy_atomic",
    E: "#forge:batteries",
    R: "#forge:plates/refined_obsidian",
    P: "#mekanism:personal_storage"
  }).id("ftbskies:robit");

  //Network Reader
  event.shaped("mekanism:network_reader", ["RGR", "IEI", "SSS"], {
    S: "#forge:plates/steel",
    R: "#forge:rods/steel",
    G: "#forge:glass/colorless",
    I: "mekanism:alloy_infused",
    E: "mekanism:energy_tablet"
  }).id("ftbskies:network_reader");

  //Seismic Reader
  event.shaped("mekanism:seismic_reader", ["SLS", "SES", "SSS"], {
    S: "#forge:plates/steel",
    L: "#forge:gems/lapis",
    E: "mekanism:energy_tablet"
  }).id("ftbskies:seismic_reader");
  
  //Gauge Dropper
  event.shaped("mekanism:gauge_dropper", [" R ", "G G", "GGG"], {
    R: "thermal:cured_rubber",
    G: "#forge:glass_panes/colorless"
  }).id("ftbskies:gauge_dropper");

  //Geiger Counter
  event.shaped("mekanism:geiger_counter", ["BLB", "LCL", "BLB"], {
    C: "#forge:circuits/basic",
    B: "#forge:plates/brass",
    L: "#forge:plates/lead"
  }).id("ftbskies:geiger_counter");

  //Dosimeter
  event.shaped("mekanism:dosimeter", ["BLB", "LSL", "BLB"], {
    B: "#forge:plates/bronze",
    L: "#forge:plates/lead",
    S: "thermal:redstone_servo"
  }).id("ftbskies:dosimeter");

  //Canteen
  event.shaped("mekanism:canteen", [" A ", "SBS", "SSS"], {
    B: "handcrafted:wood_bowl",
    A: "#forge:plates/aluminum",
    S: "#forge:sheetmetals/aluminum"
  }).id("ftbskies:canteen");

  //Atomic Dissasembler
  event.shaped("mekanism:atomic_disassembler", ["AEA", "AUA", " R "], {
    E: "#forge:batteries",
    R: "#forge:plates/refined_obsidian",
    A: "mekanism:alloy_infused",
    U: "mekanism:alloy_atomic"
  }).id("ftbskies:atomic_disassembler");

  //Electric Bow
  event.shaped("mekanism:electric_bow", ["ST ", "S E", "ST "], {
    E: "#forge:batteries",
    S: "botania:mana_string",
    T: "#forge:rods/treated_wood"
  }).id("ftbskies:electric_bow");

  //Flamethrower
  event.shaped("mekanism:flamethrower", ["III", "ITF", "CAC"], {
    I: "#forge:plates/invar",
    T: "mekanism:basic_chemical_tank",
    F: "cyclic:fireball",
    A: "mekanism:advanced_control_circuit",
    C: "#forge:plates/constantan"
  }).id("ftbskies:flamethrower");

  //Scuba Mask
  event.shaped("mekanism:scuba_mask", ["NSN", "GCG", "SES"], {
    S: "#forge:plates/steel",
    N: "#forge:plates/nickel",
    G: "#forge:glass/light_blue",
    C: "#forge:circuits/basic",
    E: "#forge:gears/nickel"
  }).id("ftbskies:scuba_mask");
  
  //Scuba Tank
  event.shaped("mekanism:scuba_tank", ["SCS", "NTN", "NSN"], {
    S: "#forge:plates/steel",
    C: "#forge:circuits/basic",
    N: "#forge:plates/nickel",
    T: "mekanism:basic_chemical_tank"
  }).id("ftbskies:scuba_tank");
  
  //Jetpack
  event.shaped("mekanism:jetpack", ["SCS", "BTB", "F F"], {
    S: "#forge:plates/steel",
    C: "#forge:circuits/basic",
    B: "#forge:plates/bronze",
    T: "mekanism:basic_chemical_tank",
    F: "create:encased_fan"
  }).id("ftbskies:jetpack");
  
  //Free Runners
  event.shaped("mekanism:free_runners", ["C C", "ERE", "S S"], {
    E: "#forge:batteries",
    S: "immersiveengineering:slab_storage_steel",
    R: "#forge:rods/steel",
    C: "#forge:circuits/basic"
  }).id("ftbskies:free_runners");

  //Armored Jetpack
  event.shaped("mekanism:jetpack_armored", ["DAD", "BCB", " J "], {
    B: "#forge:plates/bronze",
    J: "mekanism:jetpack",
    C: Item.of('immersiveengineering:armor_steel_chest', '{Damage:0}'),
    D: "#forge:dusts/diamond",
    A: "handcrafted:black_cushion"
  }).id("ftbskies:jetpack_armored");

  //Armored Free Runners
  event.shaped("mekanism:free_runners_armored", ["ACA", "DFD", "B B"], {
    B: "#forge:plates/bronze",
    F: "mekanism:free_runners",
    C: Item.of('immersiveengineering:armor_steel_feet', '{Damage:0}'),
    D: "#forge:dusts/diamond",
    A: "handcrafted:black_cushion"
  }).id("ftbskies:free_runners_armored");

  //Upgrades Reworks ==============================================================================

  //Speed
  event.shaped("mekanism:upgrade_speed", ["SWS", "ACA", "SUS"], {
    W: "thermal:rf_coil",
    S: "#forge:plates/steel",
    A: "mekanism:alloy_infused",
    C: "#forge:dusts/electrum",
    U: "pneumaticcraft:upgrade_matrix"
  }).id("ftbskies:upgrade/speed");
  
  //Energy
  event.shaped("mekanism:upgrade_energy", ["SWS", "ACA", "SUS"], {
    W: "thermal:rf_coil",
    S: "#forge:plates/steel",
    A: "mekanism:alloy_infused",
    C: "#forge:dusts/osmium",
    U: "pneumaticcraft:upgrade_matrix"
  }).id("ftbskies:upgrade/energy");

  //Filter
  event.shaped("mekanism:upgrade_filter", ["SWS", "ACA", "SUS"], {
    W: "thermal:rf_coil",
    S: "#forge:plates/steel",
    A: "mekanism:alloy_infused",
    C: "sophisticatedbackpacks:filter_upgrade",
    U: "pneumaticcraft:upgrade_matrix"
  }).id("ftbskies:upgrade/filter");

  //Muffling
  event.shaped("32x mekanism:upgrade_muffling", ["SWS", "ACA", "SUS"], {
    W: "thermal:rf_coil",
    S: "#forge:plates/steel",
    A: "mekanism:alloy_infused",
    C: "cyclic:soundproofing",
    U: "pneumaticcraft:upgrade_matrix"
  }).id("ftbskies:upgrade/muffling");

  //Gas
  event.shaped("mekanism:upgrade_gas", ["SWS", "ACA", "SUS"], {
    W: "thermal:rf_coil",
    S: "#forge:plates/steel",
    A: "mekanism:alloy_infused",
    C: "mekanism:electrolytic_core",
    U: "pneumaticcraft:upgrade_matrix"
  }).id("ftbskies:upgrade/gas");

  //Stone Generator
  event.shaped("mekanism:upgrade_stone_generator", ["SWS", "ACA", "SUS"], {
    W: "thermal:rf_coil",
    S: "#forge:plates/steel",
    A: "mekanism:alloy_infused",
    C: "ftbskies:compressed_cobblestone",
    U: "pneumaticcraft:upgrade_matrix"
  }).id("ftbskies:upgrade/stone_generator");

  // ==============================================================================================

  //Fixing Inconsistencies in the Crusher =========================================================

  //Gold Dust 
  event.custom({
    type: "mekanism:crushing",
    input: {
      ingredient: {
        item: "minecraft:gold_ingot",
      },
    },
    output: {
      item: "occultism:gold_dust",
    },
  });

  //Iron Dust
  event.custom({
    type: "mekanism:crushing",
    input: {
      ingredient: {
        item: "minecraft:iron_ingot",
      },
    },
    output: {
      item: "occultism:iron_dust",
    },
  });

  //Steel Dust
  event.custom({
    type: "mekanism:crushing",
    input: {
      ingredient: {
        item: "mekanism:ingot_steel",
      },
    },
    output: {
      item: "mekanism:dust_steel",
    },
  });

  //Constantan Dust
  event.custom({
    type: "mekanism:crushing",
    input: {
      ingredient: {
        item: "thermal:constantan_ingot",
      },
    },
    output: {
      item: "thermal:constantan_dust",
    },
  });

  //Signalum Dust
  event.custom({
    type: "mekanism:crushing",
    input: {
      ingredient: {
        item: "thermal:signalum_ingot",
      },
    },
    output: {
      item: "thermal:signalum_dust",
    },
  });
  
});
