ServerEvents.recipes((event) => {
  event
    .custom({
      type: "occultism:ritual",
      ritual_type: "occultism:summon_spirit_with_job",
      activation_item: {
        item: "occultism:book_of_binding_bound_foliot",
      },
      pentacle_id: "occultism:summon_foliot",
      duration: 60,
      spirit_max_age: 32400,
      spirit_job_type: "occultism:crush_tier1",
      entity_to_summon: "occultism:foliot",
      ritual_dummy: {
        item: "occultism:ritual_dummy/summon_foliot_crusher",
      },
      ingredients: [
        {
          item: "spirit:soul_steel_ingot",
        },
        {
          item: "minecraft:copper_ingot",
        },
        {
          item: "thermal:iron_plate",
        },
        {
          item: "create:andesite_alloy",
        },
      ],
      result: {
        item: "occultism:jei_dummy/none",
      },
    })
    .id("ftbskies:foliot");

  //whiterock
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: false,
      output: {
        item: "occultism:spirit_attuned_crystal",
      },
      pedestalItems: [
        {
          item: "occultism:spirit_attuned_gem",
        },
        {
          item: "occultism:spirit_attuned_gem",
        },
        {
          item: "occultism:spirit_attuned_gem",
        },
        {
          item: "occultism:spirit_attuned_gem",
        },

        {
          item: "occultism:obsidian_dust",
        },
      ],
      reagent: [
        {
          item: "elementalcraft:burnt_glass",
        },
      ],
      sourceCost: 1500,
    })
    .id("ftbskies:spirit_attuned_crystal");

  //Iesnium
  centrifugeRecipe(event, 100, "ftbskies:iesnium", true)
    .energyInput(100000)
    .itemInput(Item.of("occultism:silver_dust", 16))
    .fluidInput(Fluid.of("forcecraft:fluid_force_source", 1000))
    .itemOutput(Item.of("occultism:iesnium_dust", 1))
    .build();

  //Fixing Crushing Spirit Inconsistencies

  //Signalum
  event.custom({
    type: "occultism:crushing",
    crushing_time: 200,
    ignore_crushing_multiplier: false,
    ingredient: {
      item: "thermal:signalum_ingot",
    },
    result: {
      count: 1,
      item: "thermal:signalum_dust",
    },
  });

  //Constantan
  event.custom({
    type: "occultism:crushing",
    crushing_time: 200,
    ignore_crushing_multiplier: false,
    ingredient: {
      item: "thermal:constantan_ingot",
    },
    result: {
      count: 1,
      item: "thermal:constantan_dust",
    },
  });
  
  //Steel
  event.custom({
    type: "occultism:crushing",
    crushing_time: 200,
    ignore_crushing_multiplier: false,
    ingredient: {
      item: "mekanism:ingot_steel",
    },
    result: {
      count: 1,
      item: "mekanism:dust_steel",
    },
  });

});
