ServerEvents.recipes((event) => {
  //alternate tube recipe
  event
    .shaped("4x pneumaticcraft:pressure_tube", ["   ", "SGS", "   "], {
      S: "#forge:plates/obsidian",
      G: "#forge:glass",
    })
    .id("ftbskies:alternate_pressure_tube");

  //speed upgrade
  event
    .shaped("2x pneumaticcraft:speed_upgrade", ["UIU", "SGS", "USU"], {
      I: "#forge:gears/invar",
      U: "pneumaticcraft:upgrade_matrix",
      S: "ae2:silicon",
      G: "pneumaticcraft:glycerol",
    })
    .id("ftbskies:pnc_speed_upgrade");

  //Plastic Bricks Smelting back into Plastic from IF
  event.smelting("industrialforegoing:plastic", "#pneumaticcraft:plastic_bricks");
  event.smelting("industrialforegoing:plastic", "#pneumaticcraft:smooth_plastic_bricks");

  //sturdy sheet explosion
  event
    .custom({
      type: "pneumaticcraft:explosion_crafting",
      input: {
        tag: "forge:dusts/obsidian",
      },
      loss_rate: 80,
      results: [
        {
          item: "create:sturdy_sheet",
        },
      ],
    })
    .id("ftbskies:sturdy_explosion");

  //Phenolic Resin
  event
    .custom({
      type: "pneumaticcraft:fluid_mixer",
      fluid_output: {
        amount: 1000,
        fluid: "immersiveengineering:phenolic_resin",
      },
      input1: {
        type: "pneumaticcraft:fluid",
        amount: 500,
        tag: "forge:latex",
      },
      input2: {
        type: "pneumaticcraft:fluid",
        amount: 750,
        tag: "forge:acetaldehyde",
      },
      pressure: 4.0,
      time: 300,
    })
    .id("ftbskies:phenolic");

  //Acetaldehyde
  event
    .custom({
      type: "pneumaticcraft:fluid_mixer",
      fluid_output: {
        amount: 500,
        fluid: "immersiveengineering:acetaldehyde",
      },
      input1: {
        type: "pneumaticcraft:fluid",
        amount: 250,
        tag: "forge:ethanol",
      },
      input2: {
        type: "pneumaticcraft:fluid",
        amount: 250,
        tag: "forge:molten/silver",
      },
      pressure: 2.0,
      time: 300,
    })
    .id("ftbskies:acetaldehyde");

  //Volatile Redstone
  event
    .custom({
      type: "pneumaticcraft:thermo_plant",
      exothermic: true,
      fluid_input: {
        type: "pneumaticcraft:fluid",
        amount: 250,
        tag: "forge:acetaldehyde",
      },
      fluid_output: {
        amount: 250,
        fluid: "ftbskies:volatile_redstone",
      },
      item_input: {
        tag: "forge:dusts/redstone",
      },
      temperature: {
        min_temp: 1400,
      },
      pressure: 4.0,
      speed: 0.5,
    })
    .id("ftbskies:volatile_redstone");

  //capacitor
  event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          type: "pneumaticcraft:stacked_item",
          count: 2,
          tag: "forge:nuggets/gold",
        },
        {
          tag: "forge:slimeballs",
        },
        {
          item: "industrialforegoing:plastic",
        },
      ],
      pressure: 1.0,
      results: [
        {
          item: "pneumaticcraft:capacitor",
        },
      ],
    })
    .id("ftbskies:pneumaticcraft_capacitor");

  //transistor
  event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          type: "pneumaticcraft:stacked_item",
          count: 3,
          tag: "forge:nuggets/gold",
        },
        {
          tag: "forge:dusts/redstone",
        },
        {
          item: "industrialforegoing:plastic",
        },
      ],
      pressure: 1.0,
      results: [
        {
          item: "pneumaticcraft:transistor",
        },
      ],
    })
    .id("ftbskies:pneumaticcraft_transistor");

  //Reinforced Pressure Tube
  event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          type: "pneumaticcraft:stacked_item",
          tag: "forge:plastic",
          count: 2,
        },
        {
          item: "pneumaticcraft:pressure_tube",
        },
      ],
      pressure: 3.0,
      results: [
        {
          item: "pneumaticcraft:reinforced_pressure_tube",
        },
      ],
    })
    .id("ftbskies:reinforced_pressure_tube");

  //Avanced Pressure Tube
  event
    .custom({
      type: "thermal:smelter",
      ingredients: [
        {
          value: [
            {
              item: "pneumaticcraft:reinforced_pressure_tube",
            },
          ],
          count: 2,
        },
        {
          tag: "forge:dusts/desh",
          count: 1,
        },
        {
          value: [
            {
              tag: "forge:dusts/lapis",
            },
          ],
          count: 2,
        },
      ],
      result: [
        {
          item: "pneumaticcraft:advanced_pressure_tube",
          count: 1,
        },
      ],
      energy: 16000,
    })
    .id("ftbskies:advanced_pressure_tube");

  //Space material
  event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          item: "immersiveengineering:plate_aluminum",
        },
        {
          item: "thermal:copper_plate",
        },
        {
          item: "immersiveengineering:plate_steel",
        },
      ],
      pressure: 2.0,
      results: [
        {
          item: "ftbskies:space_material",
        },
      ],
    })
    .id("ftbskies:space_material");

  //Vector Plate
  event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          item: "darkutils:vector_plate_fast",
        },
        {
          item: "minecraft:sugar",
          amount: 2,
        },
      ],
      pressure: 2.0,
      results: [
        {
          item: "darkutils:vector_plate_extreme",
        },
      ],
    })
    .id("ftbskies:extreme_vector_plate");

  //Ethylene
  event
    .custom({
      type: "pneumaticcraft:thermo_plant",
      exothermic: true,
      fluid_input: {
        type: "pneumaticcraft:fluid",
        amount: 250,
        tag: "forge:ethanol",
      },
      fluid_output: {
        amount: 250,
        fluid: "mekanism:ethene",
      },
      item_input: {
        tag: "forge:dusts/sulfur",
      },
      temperature: {
        min_temp: 500,
      },
      pressure: 4.0,
      speed: 0.5,
    })
    .id("ftbskies:ethylene");

  //polyethylene
  event
    .custom({
      type: "pneumaticcraft:fluid_mixer",
      fluid_output: {
        amount: 500,
        fluid: "ftbskies:polyethylene",
      },
      input1: {
        type: "pneumaticcraft:fluid",
        amount: 250,
        tag: "forge:ethene",
      },
      input2: {
        type: "pneumaticcraft:fluid",
        amount: 250,
        tag: "forge:latex",
      },
      pressure: 2.0,
      time: 300,
    })
    .id("ftbskies:polyethylene");

  //launch pad
  event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          type: "pneumaticcraft:stacked_item",
          count: 64,
          tag: "pneumaticcraft:reinforced_stone_bricks",
        },
        {
          type: "pneumaticcraft:stacked_item",
          count: 32,
          tag: "forge:rods/steel",
        },
        {
          type: "pneumaticcraft:stacked_item",
          count: 16,
          tag: "forge:plates/obsidian",
        },
        {
          item: "ars_nouveau:fire_essence",
        },
        {
          item: "ars_nouveau:earth_essence",
        },
      ],
      pressure: 4.0,
      results: [
        {
          item: "ad_astra:launch_pad",
        },
      ],
    })
    .id("ftbskies:launch_pad");

  //Space Plating
  event
    .custom({
      type: "pneumaticcraft:assembly_laser",
      input: {
        type: "pneumaticcraft:stacked_item",
        item: "ftbskies:space_material",
        count: 8,
      },
      program: "laser",
      result: {
        item: "ftbskies:space_plate",
        count: 8,
      },
    })
    .id("ftbskies:space_plate");

  //Flux-Infused Oil
  event
    .custom({
      type: "pneumaticcraft:thermo_plant",
      exothermic: true,
      fluid_input: {
        type: "pneumaticcraft:fluid",
        amount: 2000,
        tag: "forge:crude_oil",
      },
      item_input: {
        item: "redstone_arsenal:flux_gem",
      },
      fluid_output: {
        amount: 2000,
        fluid: "ftbskies:flux_oil",
      },
      temperature: {
        min_temp: 500,
      },
      pressure: 4.0,
      speed: 0.5,
    })
    .id("ftbskies:flux_oil");

  //Flux-infused Diesel
  event
    .custom({
      type: "pneumaticcraft:refinery",
      input: {
        type: "pneumaticcraft:fluid",
        amount: 100,
        tag: "ftbskies:flux_oil",
      },
      results: [
        {
          amount: 30,
          fluid: "ftbskies:flux_diesel",
        },
        {
          amount: 30,
          fluid: "ftbskies:benzene",
        },
        {
          amount: 20,
          fluid: "mekanism:ethene",
        },
        {
          amount: 20,
          fluid: "ftbskies:carbon_dioxide",
        },
      ],
      temperature: {
        min_temp: 373,
      },
    })
    .id("ftbskies:flux_oil_refining");

  //Force Infused Oil
    event
    .custom({
      type: "pneumaticcraft:thermo_plant",
      exothermic: true,
      fluid_input: {
        type: "pneumaticcraft:fluid",
        amount: 1000,
        tag: "forge:crude_oil",
      },
      fluid_output: {
        amount: 1000,
        fluid: "ftbskies:force_infused_oil",
      },
      item_input: {
        item: "forcecraft:force_gem",
      },
      pressure: 1.0,
      speed: 2.0,
    })
    .id("ftbskies:force_oil_pnc");

    event
    .custom({
      type: "pneumaticcraft:thermo_plant",
      exothermic: true,
      fluid_input: {
        type: "pneumaticcraft:fluid",
        amount: 1000,
        tag: "forge:diesel",
      },
      fluid_output: {
        amount: 1000,
        fluid: "ftbskies:force_infused_diesel",
      },
      item_input: {
        item: "forcecraft:force_gem",
      },
      pressure: 1.0,
      speed: 2.0,
    })
    .id("ftbskies:force_infused_diesel_pnc");

    event
    .custom({
      type: "pneumaticcraft:thermo_plant",
      exothermic: true,
      fluid_input: {
        type: "pneumaticcraft:fluid",
        amount: 1000,
        tag: "forge:biodiesel",
      },
      fluid_output: {
        amount: 1000,
        fluid: "ftbskies:force_infused_biodiesel",
      },
      item_input: {
        item: "forcecraft:force_gem",
      },
      pressure: 1.0,
      speed: 2.0,
    })
    .id("ftbskies:force_infused_bio_diesel_pnc");

  // Source -> Elemental Fluids
  event.custom({
    type: "pneumaticcraft:refinery",
    input: {
      type: "pneumaticcraft:fluid",
      amount: 4,
      tag: "forge:source",
    },
    results: [
      {
        amount: 1,
        fluid: "ftbskies:liquid_elemental_fire",
      },
      {
        amount: 1,
        fluid: "ftbskies:liquid_elemental_air",
      },
      {
        amount: 1,
        fluid: "ftbskies:liquid_elemental_earth",
      },
      {
        amount: 1,
        fluid: "ftbskies:liquid_elemental_water",
      },
    ],
    temperature: {
      min_temp: 373,
    },
  });

  event
    .custom({
      type: "immersiveengineering:blueprint",
      category: "components",
      inputs: [{ tag: "forge:plastic" }, { item: "immersiveengineering:logic_circuit" }, { item: "cyclic:laser" }],
      result: { count: 1, item: "pneumaticcraft:assembly_program_laser" },
    })
    .id("ftbskies:laser_blueprint");

  event
    .custom({
      type: "immersiveengineering:blueprint",
      category: "components",
      inputs: [
        { item: "immersiveengineering:logic_circuit" },
        { tag: "forge:plastic" },
        { item: "immersiveengineering:rockcutter" },
      ],
      result: { count: 1, item: "pneumaticcraft:assembly_program_drill" },
    })
    .id("ftbskies:drill_blueprint");

  //new heat source
  event
    .custom({
      type: "pneumaticcraft:heat_properties",
      description: "pneumaticcraft.gui.jei.description.create_blaze_burner.seething",
      block: "createaddition:liquid_blaze_burner",
      statePredicate: {
        blaze: "seething",
      },
      temperature: 1700,
      thermalResistance: 50,
    })
    .id("ftbskies:liquid_blaze_burner_pncheat");

    event
    .custom({
      type: "pneumaticcraft:heat_properties",
      description: "pneumaticcraft.gui.jei.description.create_blaze_burner.seething",
      block: "createaddition:liquid_blaze_burner",
      statePredicate: {
        blaze: "kindled",
      },
      temperature: 1027,
      thermalResistance: 100,
    })
    .id("ftbskies:liquid_blaze_burner_pncheat_lower");



  //Reinforced Stone
  event
    .custom({
      type: "ars_nouveau:enchanting_apparatus",
      keepNbtOfReagent: true,
      output: {
        count: 8,
        item: "pneumaticcraft:reinforced_stone",
      },
      pedestalItems: [
        {
          item: "minecraft:deepslate",
        },
        {
          item: "occultism:otherstone",
        },
        {
          item: "minecraft:deepslate",
        },
        {
          item: "occultism:otherstone",
        },
        {
          item: "minecraft:deepslate",
        },
        {
          item: "occultism:otherstone",
        },
        {
          item: "minecraft:deepslate",
        },
        {
          item: "occultism:otherstone",
        },
      ],
      reagent: [
        {
          item: "create:sturdy_sheet",
        },
      ],
      sourceCost: 5000,
    })
    .id("ftbskies:reinforced_stone");

  //flux compressor recipe
  event
    .shaped("pneumaticcraft:flux_compressor", ["PCP", "TMT", "PBP"], {
      P: "#forge:plates/electrum",
      C: "#forge:gears/compressed_iron",
      M: "createaddition:electric_motor",
      T: "pneumaticcraft:reinforced_pressure_tube",
      B: "immersiveengineering:coil_hv",
    })
    .id("ftbskies:flux_compressor");

  //Readding Oil Refining (Without Gasoline Output and LPG Output)
  event
    .custom({
      type: "pneumaticcraft:refinery",
      input: {
        type: "pneumaticcraft:fluid",
        amount: 10,
        tag: "forge:crude_oil",
      },
      results: [
        {
          amount: 8,
          fluid: "pneumaticcraft:diesel",
        },
        {
          amount: 2,
          fluid: "pneumaticcraft:kerosene",
        },
      ],
      temperature: {
        min_temp: 373,
      },
    })
    .id("ftbskies:pneumaticcraft_oil_refining");

  //Force-infused Oil Refining
  event
    .custom({
      type: "pneumaticcraft:refinery",
      input: {
        type: "pneumaticcraft:fluid",
        amount: 100,
        fluid: "ftbskies:force_infused_oil",
      },
      results: [
        {
          amount: 30,
          fluid: "ftbskies:force_infused_diesel",
        },
        {
          amount: 30,
          fluid: "ftbskies:toluene",
        },
        {
          amount: 40,
          fluid: "ftbskies:sulfuric_gas",
        },
      ],
      temperature: {
        min_temp: 373,
      },
    })
    .id("ftbskies:force_infused_oil_refining");

  //Refinery Gas Refining
  event
    .custom({
      type: "pneumaticcraft:refinery",
      input: {
        type: "pneumaticcraft:fluid",
        amount: 10,
        fluid: "ftbskies:refinery_gas",
      },
      results: [
        {
          amount: 3,
          fluid: "industrialforegoing:latex",
        },
        {
          amount: 3,
          fluid: "ftbskies:ethane",
        },
        {
          amount: 4,
          fluid: "ftbskies:methane",
        },
      ],
      temperature: {
        min_temp: 373,
      },
    })
    .id("ftbskies:refinery_gas_refining");

  //TNT Recipe
  event
    .custom({
      type: "pneumaticcraft:thermo_plant",
      exothermic: true,
      fluid_input: {
        type: "pneumaticcraft:fluid",
        amount: 250,
        tag: "forge:sulfuric_acid",
      },
      item_input: {
        item: "ftbskies:gelled_toluene",
      },
      item_output: {
        item: "minecraft:tnt",
      },
      temperature: {
        min_temp: 100,
      },
      speed: 0.75,
    })
    .id("ftbskies:tnt_recipe");

  //"Easy Acess" to SilkTouch
  event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          item: "minecraft:iron_pickaxe",
        },
        {
          type: "pneumaticcraft:stacked_item",
          count: 1,
          item: "elementalcraft:air_silk",
        },
        {
          type: "pneumaticcraft:stacked_item",
          count: 4,
          item: "minecraft:experience_bottle",
        },
        {
          type: "pneumaticcraft:stacked_item",
          count: 1,
          item: "elementalcraft:inert_crystal",
        },
      ],
      pressure: 3.5,
      results: [
        {
          item: "minecraft:iron_pickaxe",
          nbt: '{Enchantments:[{id:"minecraft:silk_touch",lvl:1s}]}',
        },
      ],
    })
    .id("ftbskies:easy_silk_iron_pickaxe");

  event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          item: "minecraft:iron_shovel",
        },
        {
          type: "pneumaticcraft:stacked_item",
          count: 1,
          item: "elementalcraft:air_silk",
        },
        {
          type: "pneumaticcraft:stacked_item",
          count: 4,
          item: "minecraft:experience_bottle",
        },
        {
          type: "pneumaticcraft:stacked_item",
          count: 1,
          item: "elementalcraft:inert_crystal",
        },
      ],
      pressure: 3.5,
      results: [
        {
          item: "minecraft:iron_shovel",
          nbt: '{Enchantments:[{id:"minecraft:silk_touch",lvl:1s}]}',
        },
      ],
    })
    .id("ftbskies:easy_silk_iron_shovel");

  //Micromissiles
  event
    .shaped("pneumaticcraft:micromissiles", [" G ", "PCP", "PFP"], {
      C: "pneumaticcraft:printed_circuit_board",
      G: "thermal:explosive_grenade",
      P: "industrialforegoing:plastic",
      F: "minecraft:fire_charge",
    })
    .id("ftbskies:micromissiles");

  //Stomp Upgrade
  event
    .shaped("pneumaticcraft:stomp_upgrade", ["UPU", "PGP", "UPU"], {
      U: "pneumaticcraft:upgrade_matrix",
      G: "thermal:explosive_grenade",
      P: "minecraft:piston",
    })
    .id("ftbskies:stomp_upgrade");

  //Nitro TNT
  event
    .custom({
      type: "pneumaticcraft:pressure_chamber",
      inputs: [
        {
          item: "minecraft:tnt",
        },
        {
          type: "pneumaticcraft:stacked_item",
          count: 8,
          item: "forcecraft:golden_power_source",
        },
        {
          type: "pneumaticcraft:stacked_item",
          count: 4,
          item: "minecraft:green_dye",
        },
      ],
      pressure: 2.0,
      results: [
        {
          item: "ftbskies:nitro_tnt",
        },
      ],
    })
    .id("ftbskies:nitro_tnt_on_the_pressure");
});
