//priority 50

//['','',''],
const beeConversions = [
  ["minecraft:bee", "productivebees:blazing", "botania:blaze_block"],
  ["productivebees:blazing", "productivebees:ghostly", "cyclic:charm_starvation"],
  ["productivebees:blazing", "productivebees:destabilized_redstone", "elementalcraft:fireite_ingot"],
  ["productivebees:blazing", "productivebees:glowing", "minecraft:glowstone"],
  ["productivebees:blazing", "productivebees:coal", "thermal:coal_coke_block"],
  ["productivebees:pure", "productivebees:experience", "ftbskies:sentient_steel"],
  ["productivebees:skeletal", "productivebees:amethyst", "minecraft:amethyst_block"],
  ["minecraft:bee", "productivebees:cinnabar", "thermal:cinnabar_block"],
  ["productivebees:blazing", "productivebees:creeper_bee", "mekanismadditions:obsidian_tnt"],
  ["minecraft:bee", "productivebees:plastic", "industrialforegoing:plastic"],
  ["minecraft:bee", "productivebees:dye_bee", "botania:fertilizer"],
  ["productivebees:desh", "productivebees:ostrum", "ftbskies:honeyed_mars_stone"],
  ["productivebees:iron", "productivebees:desh", "ftbskies:honeyed_moon_stone"],
  ["productivebees:crystalline", "productivebees:diamond", "quark:diamond_heart"],
  ["productivebees:diamond", "productivebees:inert_crystal", "elementalcraft:inertcrystal_block"],
  ["productivebees:iron", "productivebees:tin", "mekanism:block_tin"],
  ["minecraft:bee", "productivebees:iron", "mekanism:block_steel"],
  ["minecraft:bee", "productivebees:pure", "botania:pure_daisy"],
  ["productivebees:blazing", "productivebees:sulfur", "thermal:sulfur_block"],
  ["productivebees:diamond", "productivebees:fluorite", "mekanism:block_fluorite"],
  ["productivebees:diamond", "productivebees:resonant_ender", "thermal:ender_bucket"],
  ["minecraft:bee", "productivebees:brown_shroom", "minecraft:brown_mushroom"],
  ["minecraft:bee", "productivebees:frosty", "minecraft:blue_ice"],
  ["minecraft:bee", "productivebees:lumber_bee", "ars_nouveau:blue_archwood_sapling"],
  ["productivebees:ostrum", "productivebees:calorite", "ftbskies:honeyed_venus_stone"],
  ["productivebees:crystalline", "productivebees:silicon", "ae2:printed_silicon"],
  ["productivebees:skeletal", "productivebees:withered", "minecraft:nether_star"],
  ["minecraft:bee", "productivebees:lapis", "botanicadds:mana_lapis"],
  ["minecraft:bee", "productivebees:sugarbag", "minecraft:cake"],
  ["minecraft:bee", "productivebees:zombie", "minecraft:zombie_head"],
  ["minecraft:bee", "productivebees:skeletal", "minecraft:skeleton_skull"],
  ["minecraft:bee", "productivebees:slimy", "quark:slime_in_a_bucket"],
  ["productivebees:slimy", "productivebees:pink_slimy", "industrialforegoing:pink_slime_ingot"],
  ["minecraft:bee", "productivebees:silky", "minecraft:cobweb"],
  ["productivebees:withered", "productivebees:oily", "pneumaticcraft:oil_bucket"],
  ["productivebees:iron", "productivebees:copper", "ftbskies:mana_infused_copper"],
  ["productivebees:iron", "productivebees:gold", "create_new_age:overcharged_gold"],
  ["productivebees:iron", "productivebees:lead", "mekanism:block_lead"],
  ["productivebees:iron", "productivebees:silver", "occultism:silver_block"],
  ["productivebees:iron", "productivebees:aluminum", "immersiveengineering:storage_aluminum"],
  ["productivebees:iron", "productivebees:nickel", "thermal:nickel_block"],
  ["productivebees:iron", "productivebees:niter", "thermal:niter_block"],
  ["productivebees:resonant_ender", "productivebees:draconic", "apotheosis:infused_breath"],
  ["minecraft:bee", "productivebees:rancher_bee", "spirit:soul_steel_hoe"],
  ["productivebees:silicon", "productivebees:spacial", "ae2:charged_certus_quartz_crystal"],
  ["minecraft:bee", "productivebees:leafcutter_bee", "forcecraft:force_shears"],
  ["productivebees:amethyst", "productivebees:springaline", "elementalcraft:purecrystal"],
  ["minecraft:bee", "productivebees:farmer_bee", "thermal:phytogro"],
  ["minecraft:bee", "productivebees:menril", "integrateddynamics:proto_chorus"],
  ["minecraft:bee", "productivebees:apatite", "thermal:apatite_block"],
  ["productivebees:blazing", "productivebees:obsidian", "cyclic:gem_obsidian"],
  ["productivebees:farmer_bee", "productivebees:quarry_bee", "cyclic:unbreakable_block"],
  ["productivebees:pure", "productivebees:crystalline", "botania:quartz_mana"],
  ["productivebees:blazing", "productivebees:magmatic", "minecraft:magma_block"],
  ["productivebees:pure", "productivebees:redstone", "functionalstorage:redstone_upgrade"],
  ["minecraft:bee", "productivebees:sponge", "minecraft:sponge"],
  ["minecraft:bee", "productivebees:prismarine", "minecraft:prismarine_bricks"],
  ["productivebees:prismarine", "productivebees:mana", "jaopca:storage_blocks.mana"],
  ["productivebees:blazing", "productivebees:blizz", "ad_astra:ice_shard"],
  ["productivebees:blazing", "productivebees:blitz", "create_new_age:overcharged_diamond"],
  ["productivebees:blazing", "productivebees:basalz", "thermal:basalz_powder"],
  ["productivebees:desh", "productivebees:force", "forcecraft:force_gem"],
  ["productivebees:pure", "productivebees:lord_of_darkness", "integrateddynamics:proto_chorus"],
];

ServerEvents.recipes((event) => {
  beeConversions.forEach((conversion) => {
    let id = "ftbskies:bee_conversion_" + conversion[1].toString().substring(conversion[1].toString().indexOf(":") + 1);
    event
      .custom({
        type: "productivebees:bee_conversion",
        source: conversion[0],
        result: conversion[1],
        item: {
          item: conversion[2],
        },
      })
      .id(id);
  });

  //upgrade base
  event
    .custom({
      type: "pneumaticcraft:assembly_laser",
      input: {
        type: "pneumaticcraft:stacked_item",
        item: "thermal:electrum_plate",
        count: 4,
      },
      program: "laser",
      result: {
        item: "productivebees:upgrade_base",
        count: 4,
      },
    })
    .id("ftbskies:upgrade_base");

  //move recipes to centrifuge
  event.forEachRecipe({ type: "productivebees:centrifuge" }, (recipe) => {
    let recipeJson = JSON.parse(recipe.json.toString());

    const advRecipe = event.recipes.custommachinery.custom_machine("ftbskies:fabrication_matrix", 50);

    advRecipe.requireEnergyPerTick(120);
    advRecipe.requireItem(Item.of(recipeJson.ingredient.item, 1, recipeJson.ingredient.nbt));

    for (const output of recipeJson.outputs) {
      //console.log(`output: ${JSON.stringify(output)}`)
      let chance = output?.chance ? output.chance / 100 : 1.0;
      //console.log(chance)

      if (output.item) {
        if (output.item.tag) {
          advRecipe.produceItem(Ingredient.of(`#${output.item.tag}`).getDisplayStacks().getFirst()).chance(chance);
        } else {
          advRecipe.produceItem(Item.of(output.item.item)).chance(chance);
        }
      }

      if (output.fluid) {
        let fluidMatch = "";

        if (output.fluid.fluid) fluidMatch = output.fluid.fluid;
        if (output.fluid.tag) {
          switch (output.fluid.tag) {
            case "forge:wax":
              fluidMatch = "cyclic:wax";
              break;
            case "forge:biomass":
              fluidMatch = "cyclic:biomass";
              break;
            case "forge:slime":
              fluidMatch = "cyclic:slime";
              break;
            case "forge:honey":
              fluidMatch = "productivebees:honey";
              break;
            case "forge:magma":
              fluidMatch = "cyclic:magma";
              break;
            case "forge:experience":
              fluidMatch = "experienceobelisk:cognitium";
              break;
            case "forge:milk":
              fluidMatch = "minecraft:milk";
              break;
            case "forge:ender":
              fluidMatch = "thermal:ender";
              break;
            case "forge:pinkslime":
              fluidMatch = "industrialforegoing:pink_slime";
              break;
            case "forge:pink_slime":
              fluidMatch = "industrialforegoing:pink_slime";
              break;
            case "industrialforgoing:pinkslime":
              fluidMatch = "industrialforegoing:pink_slime";
              break;
            case "forge:redstone":
              fluidMatch = "thermal:redstone";
              break;
            case "forge:chocolate":
              fluidMatch = "create:chocolate";
              break;
          }
        }

        //console.log("Adding comb recipe with output fluid of " + fluidMatch + " and amount of " + output.amount)
        const outputFluid = Fluid.of(fluidMatch, parseInt(output.amount));
        if (!outputFluid.isEmpty()) {
          advRecipe.produceFluid(outputFluid);
        }
      }
    }

    advRecipe.jei();
  });

  event.remove({ input: /productivebees:configurable_honeycomb.*/, type: "create:mixing" });
  event.remove({ id: /productivebees:centrifuge.*/, type: "productivebees:centrifuge" });

  event
    .custom({
      type: "create:mixing",
      ingredients: [
        {
          item: "productivebees:configurable_honeycomb",
        },
      ],
      results: [
        {
          item: "productivebees:wax",
          chance: 0.4,
        },
        {
          fluid: "productivebees:honey",
          amount: 100,
        },
      ],
    })
    .id("ftbskies:wax_and_honey_mixing");

  event
    .custom({
      type: "create:mixing",
      ingredients: [
        {
          item: "minecraft:honeycomb",
        },
      ],
      results: [
        {
          item: "productivebees:wax",
          chance: 0.4,
        },
        {
          fluid: "productivebees:honey",
          amount: 100,
        },
      ],
    })
    .id("ftbskies:wax_and_honey_mixing_vanilla");

  //honeyed blocks

  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "ad_astra:moon_stone",
        },
        {
          fluid: "productivebees:honey",
          amount: 1000,
        },
      ],
      result: [
        {
          item: "ftbskies:honeyed_moon_stone",
          amount: 1,
        },
      ],
      energy: 30000,
    })
    .id("ftbskies:honeyed_moon_stone");

  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "thermal:tar_block",
        },
        {
          fluid: "productivebees:honey",
          amount: 1000,
        },
      ],
      result: [
        {
          item: "ftbskies:honeyed_tar",
          amount: 1,
        },
      ],
      energy: 30000,
    })
    .id("ftbskies:honeyed_tar");

  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "ad_astra:moon_stone",
        },
        {
          fluid: "forcecraft:fluid_force_source",
          amount: 1000,
        },
      ],
      result: [
        {
          item: "ftbskies:force_infused_moon_stone",
          amount: 1,
        },
      ],
      energy: 30000,
    })
    .id("ftbskies:forced_moon_stone");

  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "ad_astra:mars_stone",
        },
        {
          fluid: "productivebees:honey",
          amount: 1000,
        },
      ],
      result: [
        {
          item: "ftbskies:honeyed_mars_stone",
          amount: 1,
        },
      ],
      energy: 30000,
    })
    .id("ftbskies:honeyed_mars_stone");

  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "ad_astra:venus_stone",
        },
        {
          fluid: "productivebees:honey",
          amount: 1000,
        },
      ],
      result: [
        {
          item: "ftbskies:honeyed_venus_stone",
          amount: 1,
        },
      ],
      energy: 30000,
    })
    .id("ftbskies:honeyed_venus_stone");

  event.remove({ id: "productivebees:upgrades/comb_block" });
  event
    .shaped("productivebees:upgrade_comb_block", [" P ", "GCG", " P "], {
      P: "thermal:gold_plate",
      G: "thermal:invar_gear",
      C: "#forge:honeycombs",
    })
    .id("ftbskies:upgrade_comb_block");
});
