ServerEvents.recipes((event) => {

  //Upgrade Base
  event.shaped("sophisticatedbackpacks:upgrade_base", ["SIS", "ILI", "SIS"], {
    I: "#forge:plates/iron",
    S: "#forge:string",
    L: "immersiveengineering:ersatz_leather",
  }).id("ftbskies:backpack_upgrade_base");

  //Base Backpack
  event.shaped("sophisticatedbackpacks:backpack", ["SLS", "SCS", "LLL"], {
    S: "#forge:string",
    L: "immersiveengineering:ersatz_leather",
    C: "#forge:chests"
  }).id("ftbskies:backpack_basic");

  //Upgrades ======================================================================================

  //Filter Upgrade
  event.shaped("sophisticatedbackpacks:filter_upgrade", ["RSR", "SBS", "RSR"], {
    B: "sophisticatedbackpacks:upgrade_base",
    S: "createsifter:andesite_mesh",
    R: "#forge:dusts/redstone"
  }).id("ftbskies:backpack_filter_upgrade");

  //Advanced Filter Upgrade
  event.shaped("sophisticatedbackpacks:advanced_filter_upgrade", ["RSR", "SBS", "RSR"], {
    B: "sophisticatedbackpacks:upgrade_base",
    S: "ftbskies:mana_steel_mesh",
    R: "#forge:dusts/gold"
  }).id("ftbskies:backpack_advanced_filter_upgrade");

  //Pickup Upgrade
  event.shaped("sophisticatedbackpacks:pickup_upgrade", [" P ", "SBS", "RFR"], {
    B: "sophisticatedbackpacks:upgrade_base",
    P: "create:sticky_mechanical_piston",
    S: "#forge:fiber_hemp",
    R: "#forge:dusts/redstone",
    F: "sophisticatedbackpacks:filter_upgrade"
  }).id("ftbskies:backpack_pickup_upgrade");

  //Advanced Pickup Upgrade
  event.shaped("sophisticatedbackpacks:advanced_pickup_upgrade", [" D ", "SBS", "RFR"], {
    B: "sophisticatedbackpacks:pickup_upgrade",
    D: "#forge:gears/diamond",
    S: "ars_nouveau:blaze_fiber",
    R: "#forge:dusts/redstone",
    F: "sophisticatedbackpacks:advanced_filter_upgrade"
  }).id("ftbskies:backpack_advanced_pickup_upgrade");
  
  //Magnet Upgrade
  event.shaped("sophisticatedbackpacks:magnet_upgrade", ["ESE", "SBS", "CMC"], {
    B: "sophisticatedbackpacks:pickup_upgrade",
    E: "#forge:dusts/ender_pearl",
    M: "#forge:gears/manasteel",
    S: "#forge:plates/steel",
    C: "create_new_age:overcharged_iron_sheet"
  }).id("ftbskies:backpack_magnet_upgrade");

  //Feeding Upgrade
  event.custom({
    "type": "farmersdelight:cooking",
    "cookingtime": 400,
    "experience": 1.0,
    "container": {
        "item": "sophisticatedbackpacks:upgrade_base"
    },
    "ingredients": [
      {
        "item": "sophisticatedbackpacks:filter_upgrade"
      },
      {
        "item": "farmersdelight:hamburger"
      },
      {
        "item": "minecraft:golden_carrot"
      },
      {
        "item": "farmersdelight:honey_cookie"
      },
      {
        "item": "farmersdelight:melon_juice"
      },
      {
        "item": "farmersdelight:kelp_roll_slice"
      }
    ],
    "result": {
      "item": "sophisticatedbackpacks:feeding_upgrade"
    }
  }).id("ftbskies:backpack_feeding_upgrade");

  //Advancced Feeding Upgrade
  event.shaped("sophisticatedbackpacks:advanced_feeding_upgrade", [" D ", "SBS", "RFR"], {
    B: "sophisticatedbackpacks:feeding_upgrade",
    D: "#forge:gears/diamond",
    S: "ars_nouveau:blaze_fiber",
    R: "#forge:dusts/redstone",
    F: "sophisticatedbackpacks:advanced_filter_upgrade"
  }).id("ftbskies:backpack_advanced_feeding_upgrade");

  //Void Upgrade
  event.shaped("sophisticatedbackpacks:void_upgrade", ["OLO", "TBC", "OFO"], {
    B: "sophisticatedbackpacks:upgrade_base",
    F: "sophisticatedbackpacks:filter_upgrade",
    L: "alexsmobs:lava_bottle",
    O: "#forge:obsidian",
    T: "trashcans:item_trash_can",
    C: "thermal:machine_null_augment"
  }).id("ftbskies:backpack_void_upgrade");

  //Advanced Void Upgrade
  event.shaped("sophisticatedbackpacks:advanced_void_upgrade", [" D ", "SBS", "RFR"], {
    B: "sophisticatedbackpacks:void_upgrade",
    D: "#forge:gears/diamond",
    S: "ars_nouveau:blaze_fiber",
    R: "#forge:dusts/redstone",
    F: "sophisticatedbackpacks:advanced_filter_upgrade"
  }).id("ftbskies:backpack_advanced_void_upgrade");

  //Restock Upgrade
  event.shaped("sophisticatedbackpacks:restock_upgrade", ["PAP", "GBG", "PFP"], {
    B: "sophisticatedbackpacks:upgrade_base",
    F: "sophisticatedbackpacks:filter_upgrade",
    A: "create:mechanical_arm",
    G: "#forge:gears/brass",
    P: "#forge:plates/constantan"
  }).id("ftbskies:backpack_restock_upgrade");

  //Advanced Restock Upgrade
  event.shaped("sophisticatedbackpacks:advanced_restock_upgrade", [" D ", "SBS", "RFR"], {
    B: "sophisticatedbackpacks:restock_upgrade",
    D: "#forge:gears/diamond",
    S: "ars_nouveau:blaze_fiber",
    R: "#forge:dusts/redstone",
    F: "sophisticatedbackpacks:advanced_filter_upgrade"
  }).id("ftbskies:backpack_advanced_restock_upgrade");

  //Refill Upgrade
  event.shaped("sophisticatedbackpacks:refill_upgrade", ["CAC", "GBG", "CFC"], {
    B: "sophisticatedbackpacks:upgrade_base",
    F: "sophisticatedbackpacks:filter_upgrade",
    A: "create:mechanical_arm",
    G: "immersiveengineering:toolupgrade_shield_magnet",
    C: "cyclic:copper_bars"
  }).id("ftbskies:backpack_refill_upgrade");

  //Advanced refill Upgrade
  event.shaped("sophisticatedbackpacks:advanced_refill_upgrade", [" D ", "SBS", "RFR"], {
    B: "sophisticatedbackpacks:refill_upgrade",
    D: "#forge:gears/diamond",
    S: "ars_nouveau:blaze_fiber",
    R: "#forge:dusts/redstone",
    F: "sophisticatedbackpacks:advanced_filter_upgrade"
  }).id("ftbskies:backpack_advanced_refill_upgrade");

  //Crafting Upgrade
  event.shaped("sophisticatedbackpacks:crafting_upgrade", ["PWP", "IBI", "PCP"], {
    B: "sophisticatedbackpacks:upgrade_base",
    W: "#forge:workbench",
    P: "botania:pattern_1_1",
    I: "#forge:plates/iron",
    C: "immersiveengineering:conveyor_dropper"
  }).id("ftbskies:backpack_crafting_upgrade");

  //Tool Swap Upgrade
  event.shaped("sophisticatedbackpacks:tool_swapper_upgrade", ["RSR", "PBA", "IGI"], {
    B: "sophisticatedbackpacks:upgrade_base",
    I: "#forge:plates/iron",
    R: "#forge:dusts/redstone",
    G: "immersiveengineering:toolupgrade_shield_magnet",
    S: Item.of('mekanismtools:bronze_sword', '{Damage:0}'),
    P: Item.of('mekanismtools:bronze_pickaxe', '{Damage:0}'),
    A: Item.of('mekanismtools:bronze_axe', '{Damage:0}')
  }).id("ftbskies:backpack_tool_swapper_upgrade");

  //Advanced Tool Swap Upgrade
  event.shaped("sophisticatedbackpacks:advanced_tool_swapper_upgrade", [" D ", "SBS", "RFR"], {
    B: "sophisticatedbackpacks:tool_swapper_upgrade",
    D: "#forge:gears/diamond",
    S: "ars_nouveau:blaze_fiber",
    R: "#forge:dusts/redstone",
    F: "sophisticatedbackpacks:advanced_filter_upgrade"
  }).id("ftbskies:backpack_advanced_tool_swapper_upgrade");

  // ==============================================================================================

  //Chipped Upgrades ==============================================================================

  //Botanist
  event.shaped("sophisticatedbackpacks:chipped/botanist_workbench_upgrade", ["LWL", "IBI", "LRL"], {
    B: "sophisticatedbackpacks:upgrade_base",
    I: "#forge:plates/iron",
    W: "chipped:botanist_workbench",
    R: "#forge:dusts/redstone",
    L: "#chipped:oak_leaves"
  }).id("ftbskies:backpack_chipped/botanist_workbench_upgrade");

  //Glass Blower
  event.shaped("sophisticatedbackpacks:chipped/glassblower_workbench_upgrade", ["LWL", "IBI", "LRL"], {
    B: "sophisticatedbackpacks:upgrade_base",
    I: "#forge:plates/iron",
    W: "chipped:glassblower",
    R: "#forge:dusts/redstone",
    L: "#chipped:glass"
  }).id("ftbskies:backpack_chipped/glassblower_workbench_upgrade");

  //Carpenter
  event.shaped("sophisticatedbackpacks:chipped/carpenter_workbench_upgrade", ["LWL", "IBI", "LRL"], {
    B: "sophisticatedbackpacks:upgrade_base",
    I: "#forge:plates/iron",
    W: "chipped:carpenters_table",
    R: "#forge:dusts/redstone",
    L: "#chipped:oak_planks"
  }).id("ftbskies:backpack_chipped/carpenter_workbench_upgrade");

  //Loom Table
  event.shaped("sophisticatedbackpacks:chipped/shepherd_workbench_upgrade", ["LWL", "IBI", "LRL"], {
    B: "sophisticatedbackpacks:upgrade_base",
    I: "#forge:plates/iron",
    W: "chipped:loom_table",
    R: "#forge:dusts/redstone",
    L: "#chipped:white_wool"
  }).id("ftbskies:backpack_chipped/sheperd_workbench_upgrade");

  //Mason Table
  event.shaped("sophisticatedbackpacks:chipped/mason_workbench_upgrade", ["LWL", "IBI", "LRL"], {
    B: "sophisticatedbackpacks:upgrade_base",
    I: "#forge:plates/iron",
    W: "chipped:mason_table",
    R: "#forge:dusts/redstone",
    L: "#chipped:stone"
  }).id("ftbskies:backpack_chipped/mason_workbench_upgrade");

  //Philosopher's Table
  event.shaped("sophisticatedbackpacks:chipped/philosopher_workbench_upgrade", ["LWL", "IBI", "LRL"], {
    B: "sophisticatedbackpacks:upgrade_base",
    I: "#forge:plates/iron",
    W: "chipped:alchemy_bench",
    R: "#forge:dusts/redstone",
    L: "#chipped:glowstone"
  }).id("ftbskies:backpack_chipped/philosopher_workbench_upgrade");

  //Tinkerer's Table
  event.shaped("sophisticatedbackpacks:chipped/tinkerer_workbench_upgrade", ["LWL", "IBI", "LRL"], {
    B: "sophisticatedbackpacks:upgrade_base",
    I: "#forge:plates/iron",
    W: "chipped:tinkering_table",
    R: "#forge:dusts/redstone",
    L: "#chipped:iron_bars"
  }).id("ftbskies:backpack_chipped/tinkerer_workbench_upgrade");

  // ==============================================================================================
});