ServerEvents.recipes((event) => {


  event
    .custom({
      type: "spirit:soul_engulfing",
      input: {
        ingredient: {
          item: "minecraft:glass",
        },
        multiblock: {
          pattern: [
            ["   ", " @ ", "   "],
            ["GSG", "S&S", "GSG"],
          ],
          keys: {
            S: {
              block: "spirit:soul_powder_block",
            },
            G: {
              block: "occultism:otherstone",
            },
          },
        },
      },
      duration: 40,
      destroysStructure: false,
      outputItem: "spirit:soul_glass",
    })
    .id("ftbskies:spirit_soulglass");

  //Blaze summon
  event.custom({
      type: "spirit:soul_transmutation",
      entityInput: "minecraft:chicken",
      consumesActivator: false,
      itemInputs: [
        {
          item: "spirit:crude_soul_crystal",
        },
        {
          item: "cyclic:peat_fuel_enriched",
        },
        {
          tag: "minecraft:coals",
        },
        {
          item: "cyclic:peat_fuel_enriched",
        },
        {
          item: "spirit:soul_powder",
        },
        {
          item: "cyclic:peat_fuel_enriched",
        },
        {
          tag: "minecraft:coals",
        },
        {
          item: "cyclic:peat_fuel_enriched",
        },
      ],
      entityOutput: "minecraft:blaze",
      duration: 30,
      shouldSummonMob: true,
    }).id("ftbskies:blaze_summon");

  //Blizz summon
  event.custom({
      type: "spirit:soul_transmutation",
      entityInput: "minecraft:blaze",
      consumesActivator: false,
      itemInputs: [
        {
          item: "spirit:crude_soul_crystal",
        },
        {
          item: "minecraft:powder_snow_bucket",
        },
        {
          tag: "forge:ices/blue",
        },
        {
          item: "minecraft:powder_snow_bucket",
        },
        {
          item: "spirit:soul_powder",
        },
        {
          item: "minecraft:powder_snow_bucket",
        },
        {
          tag: "forge:ices/blue",
        },
        {
          item: "minecraft:powder_snow_bucket",
        },
      ],
      entityOutput: "thermal:blizz",
      duration: 30,
      shouldSummonMob: true,
    }).id("ftbskies:blizz_summon");

  //Basalz summon
  event.custom({
      type: "spirit:soul_transmutation",
      entityInput: "minecraft:blaze",
      consumesActivator: false,
      itemInputs: [
        {
          item: "spirit:crude_soul_crystal",
        },
        {
          item: "supplementaries:ash_brick",
        },
        {
          item: "minecraft:smooth_basalt",
        },
        {
          item: "supplementaries:ash_brick",
        },
        {
          item: "spirit:soul_powder",
        },
        {
          item: "supplementaries:ash_brick",
        },
        {
          item: "minecraft:smooth_basalt",
        },
        {
          item: "supplementaries:ash_brick",
        },
      ],
      entityOutput: "thermal:basalz",
      duration: 30,
      shouldSummonMob: true,
    }).id("ftbskies:basalz_summon");

  //Blitz summon
  event.custom({
      type: "spirit:soul_transmutation",
      entityInput: "minecraft:blaze",
      consumesActivator: false,
      itemInputs: [
        {
          item: "spirit:crude_soul_crystal",
        },
        {
          item: "elementalcraft:powerful_air_shard",
        },
        {
          item: "quark:bottled_cloud",
        },
        {
          item: "elementalcraft:powerful_air_shard",
        },
        {
          item: "spirit:soul_powder",
        },
        {
          item: "elementalcraft:powerful_air_shard",
        },
        {
          item: "quark:bottled_cloud",
        },
        {
          item: "elementalcraft:powerful_air_shard",
        },
      ],
      entityOutput: "thermal:blitz",
      duration: 30,
      shouldSummonMob: true,
    }).id("ftbskies:blitz_summon");

  //Warden summon
  event
    .custom({
      type: "spirit:soul_transmutation",
      entityInput: "ad_astra:martian_raptor",
      consumesActivator: false,
      itemInputs: [
        {
          item: "spirit:crude_soul_crystal",
        },
        {
          item: "minecraft:echo_shard",
        },
        {
          item: "minecraft:soul_lantern",
        },
        {
          item: "minecraft:echo_shard",
        },
        {
          item: "spirit:soul_powder",
        },
        {
          item: "minecraft:echo_shard",
        },
        {
          item: "minecraft:soul_lantern",
        },
        {
          item: "minecraft:echo_shard",
        },
      ],
      entityOutput: "minecraft:warden",
      duration: 30,
      shouldSummonMob: true,
    })
    .id("ftbskies:warden_summon");

  //Bee summon
  event
    .custom({
      type: "spirit:soul_transmutation",
      entityInput: "minecraft:chicken",
      consumesActivator: false,
      itemInputs: [
        {
          item: "spirit:crude_soul_crystal",
        },
        {
          tag: "hexerei:herbs",
        },
        {
          item: "minecraft:sugar",
        },
        {
          tag: "hexerei:herbs",
        },
        {
          item: "spirit:soul_powder",
        },
        {
          tag: "hexerei:herbs",
        },
        {
          item: "minecraft:sugar",
        },
        {
          tag: "hexerei:herbs",
        },
      ],
      entityOutput: "minecraft:bee",
      duration: 30,
      shouldSummonMob: true,
    })
    .id("ftbskies:bee_summon");

  //Cow summon
  event
    .custom({
      type: "spirit:soul_transmutation",
      entityInput: "minecraft:chicken",
      consumesActivator: false,
      itemInputs: [
        {
          item: "spirit:crude_soul_crystal",
        },
        {
          item: "minecraft:leather",
        },
        {
          item: "minecraft:egg",
        },
        {
          item: "minecraft:leather",
        },
        {
          item: "spirit:soul_powder",
        },
        {
          item: "minecraft:leather",
        },
        {
          item: "minecraft:egg",
        },
        {
          item: "minecraft:leather",
        },
      ],
      entityOutput: "minecraft:cow",
      duration: 30,
      shouldSummonMob: true,
    })
    .id("ftbskies:cow_summon");

  //Cow summon
  event
    .custom({
      type: "spirit:soul_transmutation",
      entityInput: "minecraft:chicken",
      consumesActivator: false,
      itemInputs: [
        {
          item: "spirit:crude_soul_crystal",
        },
        {
          item: "minecraft:carrot",
        },
        {
          item: "minecraft:egg",
        },
        {
          item: "minecraft:carrot",
        },
        {
          item: "spirit:soul_powder",
        },
        {
          item: "minecraft:carrot",
        },
        {
          item: "minecraft:egg",
        },
        {
          item: "minecraft:carrot",
        },
      ],
      entityOutput: "minecraft:rabbit",
      duration: 30,
      shouldSummonMob: true,
    })
    .id("ftbskies:rabbit_summon");


  //Chicken summon
  event
    .custom({
      type: "spirit:soul_transmutation",
      entityInput: "minecraft:witch",
      consumesActivator: false,
      itemInputs: [
        {
          item: "spirit:crude_soul_crystal",
        },
        {
          tag: "forge:seeds",
        },
        {
          tag: "forge:eggs",
        },
        {
          tag: "forge:seeds",
        },
        {
          item: "spirit:soul_powder",
        },
        {
          tag: "forge:seeds",
        },
        {
          tag: "forge:eggs",
        },
        {
          tag: "forge:seeds",
        },
      ],
      entityOutput: "minecraft:chicken",
      duration: 30,
      shouldSummonMob: true,
    })
    .id("ftbskies:chicken_summon");

  event
    .custom({
      type: "spirit:soul_transmutation",
      entityInput: "minecraft:pig",
      consumesActivator: false,
      itemInputs: [
        {
          item: "spirit:crude_soul_crystal",
        },
        {
          tag: "forge:gems/source",
        },
        {
          item: "minecraft:gold_ingot",
        },
        {
          tag: "forge:gems/source",
        },
        {
          item: "spirit:soul_powder",
        },
        {
          tag: "forge:gems/source",
        },
        {
          item: "minecraft:gold_ingot",
        },
        {
          tag: "forge:gems/source",
        },
      ],
      entityOutput: "ars_nouveau:starbuncle",
      duration: 30,
      shouldSummonMob: true,
    })
    .id("ftbskies:starbuncle_summon");

  event
    .custom({
      type: "spirit:soul_transmutation",
      entityInput: "minecraft:villager",
      consumesActivator: false,
      itemInputs: [
        {
          item: "spirit:crude_soul_crystal",
        },
        {
          tag: "ars_nouveau:wilden_drop",
        },
        {
          item: "minecraft:mossy_cobblestone",
        },
        {
          tag: "ars_nouveau:wilden_drop",
        },
        {
          item: "spirit:soul_powder",
        },
        {
          tag: "ars_nouveau:wilden_drop",
        },
        {
          item: "minecraft:mossy_cobblestone",
        },
        {
          tag: "ars_nouveau:wilden_drop",
        },
      ],
      entityOutput: "ars_nouveau:drygmy",
      duration: 30,
      shouldSummonMob: true,
    })
    .id("ftbskies:drygmy_summon");
        
    event
    .custom({
      type: "spirit:soul_transmutation",
      entityInput: "minecraft:villager",
      consumesActivator: false,
      itemInputs: [
        {
          item: "spirit:crude_soul_crystal",
        },
        {
          item: "occultism:datura",
        },
        {
          item: "ars_nouveau:magebloom_fiber",
        },
        {
          item: "ars_nouveau:magebloom_fiber",
        },
        {
          item: "spirit:soul_powder",
        },
        {
          item: "ars_nouveau:magebloom_fiber",
        },
        {
          item: "minecraft:lead",
        },
        {
          item: "occultism:datura",
        },
      ],
      entityOutput: "minecraft:wandering_trader",
      duration: 30,
      shouldSummonMob: true,
    })
    .id("ftbskies:trader_summon");
});
