//input, output, chance
const phytogenAdditions = [
  ["cyclic:flower_purple_tulip", "cyclic:flower_purple_tulip", 2.0],
  ["cyclic:flower_absalon_tulip", "cyclic:flower_absalon_tulip", 2.0],
  ["ars_nouveau:source_berry", "ars_nouveau:source_berry", 2.0],
  ["farmersdelight:rice_panicle", "farmersdelight:rice_panicle", 2.0],
  ["farmersdelight:onion", "farmersdelight:onion", 2.0],
  ["ars_nouveau:bombegranate_pod", "ars_nouveau:bombegranate_pod", 2.0],
  ["ars_nouveau:frostaya_pod", "ars_nouveau:frostaya_pod", 2.0],
  ["ars_nouveau:bastion_pod", "ars_nouveau:bastion_pod", 2.0],
  ["ars_nouveau:mendosteen_pod", "ars_nouveau:mendosteen_pod", 2.0],
];

//input, output, chance
const phytogenAdditionsWithSeeds = [
  ["supplementaries:flax_seeds", "supplementaries:flax", 1.5],
  ["farmersdelight:cabbage_seeds", "farmersdelight:cabbage", 1.5],
  ["ars_nouveau:magebloom_crop", "ars_nouveau:magebloom", 1.5],
  ["farmersdelight:tomato_seeds", "farmersdelight:tomato", 1.5],
  ["hexerei:sage_seed", "hexerei:sage", 2.1],
  ["occultism:datura_seeds", "occultism:datura", 1.5],
];

const phytogenTreeAdditions = [
  ["ars_nouveau:purple_archwood_sapling", "ars_nouveau:purple_archwood_log", 6.0],
  ["ars_nouveau:blue_archwood_sapling", "ars_nouveau:blue_archwood_log", 6.0],
  ["ars_nouveau:green_archwood_sapling", "ars_nouveau:green_archwood_log", 6.0],
  ["ars_nouveau:red_archwood_sapling", "ars_nouveau:red_archwood_log", 6.0],
  ["forcecraft:force_sapling", "forcecraft:force_log", 6.0],
  ["occultism:otherworld_sapling", "occultism:otherworld_log", 6.0],
  ["hexerei:willow_sapling", "hexerei:willow_log", 6.0],
  ["hexerei:mahogany_sapling", "hexerei:mahogany_log", 6.0],
  ["tropicraft:red_mangrove_propagule", "tropicraft:red_mangrove_log", 6.0],
  ["tropicraft:tall_mangrove_propagule", "tropicraft:light_mangrove_log", 6.0],
  ["tropicraft:tea_mangrove_propagule", "tropicraft:light_mangrove_log", 6.0],
  ["tropicraft:black_mangrove_propagule", "tropicraft:black_mangrove_log", 6.0],
  ["tropicraft:palm_sapling", "tropicraft:palm_log", 6.0],
  ["tropicraft:mahogany_sapling", "tropicraft:mahogany_log", 6.0],
  ["tropicraft:papaya_sapling", "tropicraft:papaya_log", 6.0],
];

ServerEvents.recipes((event) => {
  phytogenAdditions.forEach((recipe) => {
    event.custom({
      type: "thermal:insolator",
      ingredient: {
        item: `${recipe[0]}`,
      },

      result: [
        {
          item: `${recipe[1]}`,
          count: 2,
          chance: `${recipe[2]}`,
        },
      ],
    });
  });

  phytogenAdditionsWithSeeds.forEach((recipe) => {
    event.custom({
      type: "thermal:insolator",
      ingredient: {
        item: `${recipe[0]}`,
      },
      result: [
        {
          item: `${recipe[1]}`,
          chance: `${recipe[2]}`,
        },
        {
          item: `${recipe[0]}`,
          chance: 1.0,
        },
      ],
      water_mod: 0.5,
    });
  });

  phytogenTreeAdditions.forEach((recipe) => {
    event.custom({
      type: "thermal:insolator",
      ingredient: {
        item: `${recipe[0]}`,
      },
      result: [
        {
          item: `${recipe[1]}`,
          count: 6,
          chance: `${recipe[2]}`,
        },
        {
          item: `${recipe[0]}`,
          chance: 1.0,
        },
      ],
      water_mod: 0.5,
    });
  });

  //Hexerei Custom
  event
    .custom({
      type: "thermal:insolator",
      ingredient: {
        item: "hexerei:yellow_dock_bush",
      },
      result: [
        {
          item: "hexerei:yellow_dock_leaves",
          chance: 2.0,
        },
        {
          item: "hexerei:yellow_dock_flowers",
          chance: 1.0,
        },
        {
          item: "hexerei:yellow_dock_bush",
          chance: 1.0,
        },
      ],
      water_mod: 1.5,
    })
    .id("ftbskies:yellowdock");

  //Hexerei Custom
  event
    .custom({
      type: "thermal:insolator",
      ingredient: {
        item: "hexerei:mugwort_bush",
      },
      result: [
        {
          item: "hexerei:mugwort_leaves",
          chance: 2.0,
        },
        {
          item: "hexerei:mugwort_flowers",
          chance: 1.0,
        },
        {
          item: "hexerei:mugwort_bush",
          chance: 1.0,
        },
      ],
      water_mod: 1.5,
    })
    .id("ftbskies:mugwort");

  //Hexerei Custom
  event
    .custom({
      type: "thermal:insolator",
      ingredient: {
        item: "hexerei:mandrake_flower",
      },
      result: [
        {
          item: "hexerei:mandrake_flowers",
          chance: 2.0,
        },
        {
          item: "hexerei:mandrake_root",
          chance: 1.0,
        },
        {
          item: "hexerei:mandrake_flower",
          chance: 1.0,
        },
      ],
      water_mod: 1.5,
    })
    .id("ftbskies:mandrake");

  //Menril
  event
    .custom({
      type: "thermal:insolator",
      ingredient: {
        item: "integrateddynamics:menril_sapling",
      },
      result: [
        {
          item: "integrateddynamics:menril_log",
          count: 6,
          chance: 1.0,
        },
        {
          item: "integrateddynamics:crystalized_menril_chunk",
          chance: 0.5,
        },
        {
          item: "integrateddynamics:menril_berries",
          chance: 1.75,
        },
        {
          item: "integrateddynamics:menril_sapling",
          chance: 1.0,
        },
      ],
      water_mod: 1.0,
    })
    .id("ftbskies:menril");

  //filter augments
  event
    .shapeless("thermal:item_filter_augment", ["3x #forge:nuggets/tin", "pneumaticcraft:plastic_brick_blue"])
    .id("ftbskies:thermal_itemfilter");
  event
    .shapeless("thermal:fluid_filter_augment", ["3x #forge:nuggets/copper", "pneumaticcraft:plastic_brick_blue"])
    .id("ftbskies:thermal_fluidfilter");

  // Duroplast
  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "minecraft:paper",
        },
        {
          fluid: "immersiveengineering:phenolic_resin",
          amount: 200,
        },
      ],
      result: [
        {
          item: "immersiveengineering:plate_duroplast",
          amount: 1,
        },
      ],
      energy: 2000,
    })
    .id("ftbskies:duroplast");

  //energy cables
  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "ad_astra:steel_cable",
        },
        {
          fluid: "thermal:redstone",
          amount: 10,
        },
      ],
      result: [
        {
          item: "thermal:energy_duct",
          amount: 1,
        },
      ],
      energy: 2000,
    })
    .id("ftbskies:fluxcables");

  //molten silver
  event
    .custom({
      type: "thermal:crucible",
      ingredient: {
        item: "occultism:silver_ingot",
      },
      result: [
        {
          fluid: "ftbskies:molten_silver",
          amount: 125,
        },
      ],
      energy: 2000,
    })
    .id("ftbskies:silver_to_molten");

  //Empty PCB
  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "immersiveengineering:logic_circuit",
        },
        {
          fluid: "thermal:redstone",
          amount: 500,
        },
      ],
      result: [
        {
          item: "pneumaticcraft:empty_pcb",
        },
      ],
    })
    .id("ftbskies:empty_pcb");

  //volatile redstone to destab and acid
  event
    .custom({
      type: "thermal:refinery",
      ingredient: {
        fluid_tag: "forge:volatile_redstone",
        amount: 100,
      },
      result: [
        {
          fluid: "thermal:redstone",
          amount: 60,
        },
        {
          fluid: "immersiveengineering:redstone_acid",
          amount: 40,
        },
        {
          item: "mekanism:substrate",
          chance: 0.1,
        },
      ],
      energy: 5000,
    })
    .id("ftbskies:volatile_to_destab_and_acid");

  //Oil Unification =============================================================================
  
  //Disabled Bituminous Sand
  // event
  //   .custom({
  //     type: "thermal:centrifuge",
  //     ingredient: {
  //       item: "thermal:oil_red_sand",
  //     },
  //     result: [
  //       {
  //         item: "minecraft:red_sand",
  //         chance: 0.75,
  //         locked: true,
  //       },
  //       {
  //         item: "thermal:bitumen",
  //         chance: 1.5,
  //       },
  //       {
  //         item: "thermal:tar",
  //         chance: 1.0,
  //       },
  //       {
  //         fluid: "pneumaticcraft:oil",
  //         amount: 100,
  //       },
  //     ],
  //     energy: 20000,
  //   })
  //   .id("ftbskies:thermal_oil_red_sand");

  // event
  //   .custom({
  //     type: "thermal:centrifuge",
  //     ingredient: {
  //       item: "thermal:oil_sand",
  //     },
  //     result: [
  //       {
  //         item: "minecraft:sand",
  //         chance: 0.75,
  //         locked: true,
  //       },
  //       {
  //         item: "thermal:bitumen",
  //         chance: 1.5,
  //       },
  //       {
  //         item: "thermal:tar",
  //         chance: 1.0,
  //       },
  //       {
  //         fluid: "pneumaticcraft:oil",
  //         amount: 100,
  //       },
  //     ],
  //     energy: 20000,
  //   })
  //   .id("ftbskies:thermal_oil_sand");

  event
    .custom({
      type: "thermal:crucible",
      ingredient: {
        item: "thermal:bitumen",
      },
      result: [
        {
          fluid: "pneumaticcraft:oil",
          amount: 100,
        },
      ],
      energy: 2000,
    })
    .id("ftbskies:bitumen_to_oil");

  // ============================================================================================

  //marine fabric 1
  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "botania:manaweave_cloth",
        },
        {
          fluid: "thermal:latex",
          amount: 500,
        },
      ],
      result: [
        {
          item: "thermal:diving_fabric",
          amount: 1,
        },
      ],
      energy: 2000,
    })
    .id("ftbskies:marine_fabric_1");

  //marine fabric
  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "botania:manaweave_cloth",
        },
        {
          fluid: "industrialforegoing:latex",
          amount: 500,
        },
      ],
      result: [
        {
          item: "thermal:diving_fabric",
          amount: 1,
        },
      ],
      energy: 2000,
    })
    .id("ftbskies:marine_fabric");

  //protective fabric
  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          item: "thermal:diving_fabric",
        },
        {
          fluid: "ftbskies:polyethylene",
          amount: 500,
        },
      ],
      result: [
        {
          item: "thermal:hazmat_fabric",
          amount: 1,
        },
      ],
      energy: 2000,
    })
    .id("ftbskies:protective_fabric");

  //certus quartz
  event.custom({
    type: "thermal:crystallizer",
    ingredients: [
      {
        fluid: "minecraft:water",
        amount: 8000,
      },
      {
        item: "ae2:certus_quartz_dust",
      },
    ],
    result: [
      {
        item: "ae2:certus_quartz_crystal",
      },
    ],
    energy: 25000,
  });

  //new dusts
  event
    .shapeless("thermal:signalum_dust", [
      "#forge:dusts/electrum",
      "3x minecraft:redstone",
      "ftbskies:mana_infused_copper",
    ])
    .id("ftbskies:signalum_dust");
  event
    .shapeless("thermal:lumium_dust", ["#forge:dusts/signalum", "3x #forge:dusts/glowstone", "#forge:dusts/desh"])
    .id("ftbskies:lumium_dust");
  event
    .shapeless("thermal:enderium_dust", ["#forge:dusts/lumium", "3x #forge:dusts/ender_pearl", "#forge:dusts/ostrum"])
    .id("ftbskies:enderium_dust");

  //vacuumulator
  event
    .shaped("thermal:device_collector", ["IPI", "GCG", "ISI"], {
      I: "#forge:plates/iron",
      P: "minecraft:ender_pearl",
      G: "#forge:glass",
      C: "industrialforegoing:conveyor",
      S: "minecraft:redstone",
    })
    .id("ftbskies:collector");

  //charge bench
  event
    .shaped("thermal:charge_bench", ["III", "RAR", "LRL"], {
      I: "#forge:plates/electrum",
      L: "#forge:plates/lead",
      R: "thermal:rf_coil",
      A: "mekanism:alloy_infused",
    })
    .id("ftbskies:charge_bench");


  //fluxed rod
  event
    .shaped("redstone_arsenal:flux_obsidian_rod", ["  G", " I ", "G  "], {
      I: "#forge:ingots/refined_obsidian",
      G: "redstone_arsenal:flux_gem",
    })
    .id("ftbskies:fluxed_rod");

  //induction smelter
  event
    .shaped("thermal:machine_smelter", ["RAR", "VMV", "ISI"], {
      R: "immersiveengineering:blastbrick_reinforced",
      A: "createteleporters:advanced_part",
      V: "immersiveengineering:electron_tube",
      M: "thermal:machine_frame",
      I: "thermal:invar_gear",
      S: "thermal:rf_coil",
    })
    .id("thermal:machine_smelter");

  //signalum
  event
    .custom({
      type: "immersiveengineering:arc_furnace",
      additives: [],
      energy: 102400,
      input: { tag: "forge:dusts/signalum" },
      results: [{ tag: "forge:ingots/signalum" }],
      time: 200,
    })
    .id("ftbskies:signalum_ingot");

  //lumium
  event
    .custom({
      type: "immersiveengineering:arc_furnace",
      additives: [],
      energy: 204800,
      input: { tag: "forge:dusts/lumium" },
      results: [{ tag: "forge:ingots/lumium" }],
      time: 200,
    })
    .id("ftbskies:lumium_ingot");

  //enderium
  event
    .custom({
      type: "immersiveengineering:arc_furnace",
      additives: [],
      energy: 819200,
      input: { tag: "forge:dusts/enderium" },
      results: [{ tag: "forge:ingots/enderium" }],
      time: 200,
    })
    .id("ftbskies:enderium_ingot");

  // ======== Arboreal Extractor =================================================================

  event.remove({ id: "thermal:device_tree_extractor" });
  event.remove({ id: /thermal:devices\/tree_extractor\/tree_extractor_.*/ });
  event.remove({ id: /thermal:machines\/press\/press_.*_to_latex/ });


  //Redstone Glass
  event
    .custom({
      type: "thermal:smelter",
      ingredients: [
        {
          tag: "forge:ingots/zinc",
        },
        {
          tag: "forge:ingots/copper",
        },
      ],
      result: [
        {
          item: "create:brass_ingot",
          amount: 2,
        },
      ],
      energy: 25000,
    })
    .id("ftbskies:brass_ingot");

  //Redstone Glass
  event
    .custom({
      type: "thermal:smelter",
      ingredients: [
        {
          tag: "forge:dusts/redstone",
        },
        {
          tag: "forge:glass/colorless",
          amount: 4,
        },
      ],
      result: [
        {
          item: "glassential:glass_redstone",
          amount: 4,
        },
      ],
      energy: 25000,
    })
    .id("ftbskies:redstone_glass_induction_smelter");

  //Basalz Powder
  event
    .custom({
      type: "thermal:smelter",
      ingredients: [
        {
          item: "botania:blaze_block",
        },
        {
          item: "forcecraft:golden_power_source",
          amount: 16,
        },
      ],
      result: [
        {
          item: "thermal:basalz_powder",
          amount: 1,
        },
      ],
      energy: 10000,
    })
    .id("ftbskies:basalz_dust_induction_smelter");

  //evap tower
  event
    .custom({
      type: "thermal:smelter",
      ingredients: [
        {
          item: "powah:dielectric_paste",
        },
        {
          item: "jaopca:plates.compressed_iron",
          amount: 4,
        },
        {
          item: "thermal:copper_plate",
          amount: 8,
        },        
      ],
      result: [
        {
          item: "mekanism:thermal_evaporation_block",
          amount: 4,
        },
      ],
      energy: 40000,
    })
    .id("ftbskies:evap_tower");


  event
    .custom({
      type: "immersiveengineering:alloy",
      input0: { base_ingredient: { tag: "forge:glass/colorless" }, count: 4 },
      input1: { tag: "forge:dusts/redstone" },
      result: { base_ingredient: { item: "glassential:glass_redstone" }, count: 4 },
      time: 200,
    })
    .id("ftbskies:redstone_glass_alloy_kiln");

  //Toluene into Gelled Toluene
  event
    .custom({
      type: "thermal:chiller",
      ingredients: [{ fluid: "ftbskies:toluene", amount: 100 }, { item: "thermal:chiller_ball_cast" }],
      result: [{ item: "ftbskies:gelled_toluene", count: 1 }],
      energy: 2500,
    })
    .id("ftbskies:gelled_toluene_solidification");

  event
    .shaped("thermal:explosive_grenade", ["PGP", "GIG", "PGP"], {
      P: "spirit:soul_powder",
      G: "thermal:gunpowder_block",
      I: "thermal:iron_plate",
    })
    .id("ftbskies:grenade");

  event
    .shaped("thermal:flux_capacitor", ["ICI", "IRI", "ICI"], {
      I: "thermal:silver_plate",
      C: "mekanism:alloy_infused",
      R: "thermal:redstone_servo",
    })
    .id("ftbskies:flux_capacitor");

  //Coal Coke Block in the Pyrolyzer
  event
    .custom({
      type: "thermal:pyrolyzer",
      ingredient: {
        item: "minecraft:coal_block",
      },
      result: [
        {
          item: "thermal:coal_coke_block",
        },
        {
          item: "thermal:tar_block",
          chance: 0.25,
        },
        {
          fluid: "immersiveengineering:creosote",
          amount: 2250,
        },
      ],
      energy: 18000,
    })
    .id("ftbskies:coal_coke_block_pyrolyzer");

  //Platinum Plate with Thermal Expansion
  event
    .custom({
      type: "thermal:press",
      ingredient: {
        item: "ftbskies:platinum_ingot",
      },
      result: [
        {
          item: "ftbskies:platinum_plate",
        },
      ],
    })
    .id("ftbskies:thermal_platinum_plate");

  //Dry Rubber back into Latex ==================================================================

  //Tiny
  event
    .custom({
      type: "thermal:crucible",
      ingredient: {
        item: "industrialforegoing:tinydryrubber",
      },
      result: [
        {
          fluid: "industrialforegoing:latex",
          amount: 100,
        },
      ],
      energy: 2000,
    })
    .id("ftbskies:tiny_dry_rubber_recycling");

  //Normal
  event
    .custom({
      type: "thermal:crucible",
      ingredient: {
        item: "industrialforegoing:dryrubber",
      },
      result: [
        {
          fluid: "industrialforegoing:latex",
          amount: 900,
        },
      ],
      energy: 2000,
    })
    .id("ftbskies:dry_rubber_recycling");

  //Sheets
  event
    .custom({
      type: "thermal:crucible",
      ingredient: {
        item: "industrialforegoing:plastic",
      },
      result: [
        {
          fluid: "industrialforegoing:latex",
          amount: 900,
        },
      ],
      energy: 2000,
    })
    .id("ftbskies:plastic_recycling");

  // ============================================================================================

  //Stabilized Pyrotheum
  event
    .custom({
      type: "thermal:crucible",
      ingredient: {
        item: "ftbskies:venus_blaze_dust",
      },
      result: [
        {
          fluid: "ftbskies:stabilized_pyrotheum",
          amount: 250,
        },
      ],
      energy: 2000,
    })
    .id("ftbskies:stabilized_pyrotheum_melting");

  //Mega TNT
  event
    .custom({
      type: "thermal:chiller",
      ingredients: [{ fluid: "ftbskies:stabilized_pyrotheum", amount: 1000 }, { item: "ftbskies:nitro_tnt" }],
      result: [{ item: "ftbskies:mega_tnt", count: 1 }],
      energy: 4000,
    })
    .id("ftbskies:mega_tnt_chillin");

  //Treated Wood in the Encapsulator
  event
    .custom({
      type: "thermal:bottler",
      ingredients: [
        {
          tag: "minecraft:planks",
        },
        {
          fluid: "immersiveengineering:creosote",
          amount: 100,
        },
      ],
      result: [
        {
          item: "immersiveengineering:treated_wood_horizontal",
        },
      ],
      energy: 1000,
      time: 20,
    })
    .id("ftbskies:transposing_treated_wood");

  //energy cell
  event
    .custom({
      type: "mekanism:injecting",
      chemicalInput: { amount: 5, gas: "kubejs:volatile_redstone_gas" },
      itemInput: { ingredient: { item: "thermal:energy_cell_frame" } },
      output: { item: "thermal:energy_cell" },
    })
    .id("ftbskies:energy_cell_thermal");

  //Phytogenic Insolator
  event.shaped("thermal:machine_insolator", ["SDS", "GFG", "ECE"], {
    D: "ftbskies:compressed_dirt",
    G: "#thermal:glass/hardened",
    F: "thermal:machine_frame",
    E: "#forge:gears/electrum",
    S: "create_new_age:overcharged_golden_sheet",
    C: "thermal:rf_coil"
  }).id("ftbskies:machine_insolator");

  //Fixing Pulverizer Inconsistencies =============================================================

  //Signalum
  event.custom({
    type: "thermal:pulverizer",
    ingredient: {
      item: "thermal:signalum_ingot",
    },
    result: [
      {
        item: "thermal:signalum_dust"
      }
    ],
    experience: 0.1,
  });
  
  //Constantan
  event.custom({
    type: "thermal:pulverizer",
    ingredient: {
      item: "thermal:constantan_ingot",
    },
    result: [
      {
        item: "thermal:constantan_dust"
      }
    ],
    experience: 0.1,
  });
  
  //Steel
  event.custom({
    type: "thermal:pulverizer",
    ingredient: {
      item: "mekanism:ingot_steel",
    },
    result: [
      {
        item: "mekanism:dust_steel"
      }
    ],
    experience: 0.1,
  });
  // ==============================================================================================
});
