ServerEvents.recipes((event) => {
  // Pineapple Juice
  event
    .custom({
      type: "thermal:centrifuge",
      ingredient: {
        item: "tropicraft:pineapple",
      },
      result: [
        {
          fluid: "ftbskies:pineapple_juice",
          amount: 1000,
        },
      ],
      energy: 20000,
    })
    .id("ftbskies:pineapple_juice");

  // Virgin Pina Colada Gas
  event
    .custom({
      type: "mekanism:reaction",
      duration: 1600,
      energyRequired: 2500,
      fluidInput: {
        amount: 10,
        fluid: "ftbskies:pineapple_juice",
      },
      gasInput: {
        amount: 100,
        gas: "kubejs:cryo_gas",
      },
      gasOutput: {
        amount: 10,
        gas: "kubejs:virgin_pina_colada",
      },
      itemInput: {
        amount: 8,
        ingredient: {
          item: "tropicraft:coconut_chunk",
        },
      },
    })
    .id("ftbskies:virgin_pina_colada_gas");

  // Virgin Pina Colada
  event
    .custom({
      type: "mekanism:rotary",
      fluidInput: {
        amount: 1,
        fluid: "ftbskies:virgin_pina_colada",
      },
      fluidOutput: {
        amount: 1,
        fluid: "ftbskies:virgin_pina_colada",
      },
      gasInput: {
        amount: 1,
        gas: "kubejs:virgin_pina_colada",
      },
      gasOutput: {
        amount: 1,
        gas: "kubejs:virgin_pina_colada",
      },
    })
    .id("ftbskies:colada_gas");

  // Pina Colada
  event
    .custom({
      type: "create:sequenced_assembly",
      ingredient: {
        item: "tropicraft:bamboo_mug",
      },
      loops: 50,
      results: [
        {
          item: "tropicraft:pina_colada",
        },
      ],
      sequence: [
        {
          type: "create:filling",
          ingredients: [
            {
              item: "tropicraft:bamboo_mug",
            },
            {
              amount: 100,
              fluid: "ftbskies:pina_colada",
            },
          ],
          results: [
            {
              item: "tropicraft:bamboo_mug",
            },
          ],
        },
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "tropicraft:bamboo_mug",
            },
            {
              item: "botania:infinite_fruit",
            },
          ],
          results: [
            {
              item: "tropicraft:bamboo_mug",
            },
          ],
        },
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "tropicraft:bamboo_mug",
            },
            {
              item: "unusualend:chorus_tea",
            },
          ],
          results: [
            {
              item: "tropicraft:bamboo_mug",
            },
          ],
        },
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "tropicraft:bamboo_mug",
            },
            {
              item: "ftbskies:cryotheum",
            },
          ],
          results: [
            {
              item: "tropicraft:bamboo_mug",
            },
          ],
        },
        {
          type: "create:filling",
          ingredients: [
            {
              item: "tropicraft:bamboo_mug",
            },
            {
              amount: 100,
              fluid: "ftbskies:resonant_liquid",
            },
          ],
          results: [
            {
              item: "tropicraft:bamboo_mug",
            },
          ],
        },
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "tropicraft:bamboo_mug",
            },
            {
              item: "powah:charged_snowball",
            },
          ],
          results: [
            {
              item: "tropicraft:bamboo_mug",
            },
          ],
        },
        {
          type: "create:deploying",
          ingredients: [
            {
              item: "tropicraft:bamboo_mug",
            },
            {
              item: "bhc:blue_heart",
            },
          ],
          results: [
            {
              item: "tropicraft:bamboo_mug",
            },
          ],
        },
      ],
      transitionalItem: {
        item: "tropicraft:bamboo_mug",
      },
    })
    .id("ftbskies:pina_colada_item");

  // Pineapple
  event.custom({
    type: "mekanism:nucleosynthesizing",
    duration: 250,
    gasInput: {
      amount: 2,
      gas: "mekanism:antimatter",
    },
    itemInput: {
      ingredient: {
        item: "tropicraft:pineapple_cubes",
      },
    },
    output: {
      item: "tropicraft:pineapple",
    },
  });

  event
    .custom({
      type: "mekanism:injecting",
      chemicalInput: {
        amount: 10,
        gas: "mekanismgenerators:fusion_fuel",
      },
      itemInput: {
        ingredient: {
          item: "quark:bamboo_block",
        },
      },
      output: {
        item: "tropicraft:bamboo_stick",
      },
    })
    .id("ftbskies:tropicraft_stick");

  event.shaped("tropicraft:bamboo_mug", ["S S", "S S", "SSS"], {
    S: "tropicraft:bamboo_stick",
  });

  //Hand Recipe for Obtaining Coconut Chunks
  event.custom({
    type: "natprog:damage_tools",
    ingredients: [
      {
        item: "tropicraft:coconut"
      },
      {
        tag: "forge:swords"
      }
    ],
    result: {
      item: "tropicraft:coconut_chunk",
      count: 3
    },
    "group": "coconuts"
  }).id("ftbskies:coconut_chunks_by_hand");

});
