const recipesGears = [
  // True at the end means it add to all 3 instead of just creating create recipe
  ["forge:gems/diamond", "thermal:diamond_gear", true],
  ["forge:gems/emerald", "thermal:emerald_gear", true],
  ["forge:gems/lapis", "thermal:lapis_gear", true],
  ["forge:gems/quartz", "thermal:quartz_gear", true],
  ["forge:ingots/aluminum", "jaopca:gears.aluminum", false],
  ["forge:ingots/brass", "jaopca:gears.brass", false],
  ["forge:ingots/bronze", "thermal:bronze_gear", false],
  ["forge:ingots/compressed_iron", "pneumaticcraft:compressed_iron_gear", false],
  ["forge:ingots/constantan", "thermal:constantan_gear", false],
  ["forge:ingots/copper", "thermal:copper_gear", false],
  ["forge:ingots/desh", "jaopca:gears.desh", false],
  ["forge:ingots/electrum", "thermal:electrum_gear", false],
  ["forge:ingots/enderium", "thermal:enderium_gear", false],
  ["forge:ingots/flux", "redstone_arsenal:flux_gear", true],
  ["forge:ingots/force", "forcecraft:force_gear", false],
  ["forge:ingots/gold", "thermal:gold_gear", false],
  ["forge:ingots/invar", "thermal:invar_gear", false],
  ["forge:ingots/iron", "thermal:iron_gear", false],
  ["forge:ingots/lead", "thermal:lead_gear", false],
  ["forge:ingots/lumium", "thermal:lumium_gear", false],
  ["forge:ingots/manasteel", "jaopca:gears.manasteel", false],
  ["forge:ingots/netherite", "thermal:netherite_gear", false],
  ["forge:ingots/nickel", "thermal:nickel_gear", false],
  ["forge:ingots/signalum", "thermal:signalum_gear", false],
  ["forge:ingots/silver", "thermal:silver_gear", false],
  ["forge:ingots/steel", "jaopca:gears.steel", false],
  ["forge:ingots/swift_alloy", "jaopca:gears.swift_alloy", false],
  ["forge:ingots/tin", "thermal:tin_gear", false],
];

ServerEvents.recipes((event) => {
  recipesGears.forEach((recipe) => {
    //console.log("Gears:" + recipe[0] + " " + recipe[1]);
    if (recipe[2]) {
      // Thermal Press
      event.custom({
        type: "thermal:press",
        ingredients: [
          {
            tag: `${recipe[0]}`,
            count: 4,
          },
          {
            item: "immersiveengineering:mold_gear",
          },
        ],
        result: [
          {
            item: `${recipe[1]}`,
            count: 1,
          },
        ],
        energy: 800,
      });

      // Immersive Engineering Metal Press
      event.custom({
        type: "immersiveengineering:metal_press",
        input: {
          base_ingredient: {
            tag: `${recipe[0]}`,
          },
          count: 4,
        },
        result: {
          item: `${recipe[1]}`,
        },
        mold: "immersiveengineering:mold_gear",
        energy: 2400,
      });
    }

    event.custom({
      type: "create:mechanical_crafting",
      pattern: [" A ", "A A", " A "],
      key: {
        A: {
          tag: `${recipe[0]}`,
        },
      },
      result: {
        item: `${recipe[1]}`,
      },
    });
  });
});
