const recipesRods = [
  ["forge:ingots/iron", "immersiveengineering:stick_iron"],
  ["forge:ingots/brass", "createaddition:brass_rod"],
  ["forge:ingots/copper", "createaddition:copper_rod"],
  ["forge:ingots/desh", "jaopca:rods.desh"],
  ["forge:ingots/drenched_iron", "jaopca:rods.drenched_iron"],
  ["forge:ingots/electrum", "createaddition:electrum_rod"],
  ["forge:ingots/gold", "createaddition:gold_rod"],
  ["forge:ingots/invar", "jaopca:rods.invar"],
  ["forge:ingots/steel", "immersiveengineering:stick_steel"],
  ["forge:ingots/aluminum", "immersiveengineering:stick_aluminum"],
  ["forge:dusts/quartz", "ae2:quartz_fiber"],
];
ServerEvents.recipes((event) => {
  event
    .custom({
      type: "thermal:press",
      ingredients: [
        {
          tag: "forge:ingots/hop_graphite",
          count: 4,
        },
        {
          item: "immersiveengineering:mold_rod",
        },
      ],
      result: [
        {
          item: "immersiveengineering:graphite_electrode",
          count: 1,
        },
      ],
      energy: 10000,
    })
    .id("ftbskies:thermal_metal_press_graphite_electrode");

  event
    .custom({
      type: "immersiveengineering:metal_press",
      energy: 1000,
      input: {
        base_ingredient: { tag: "forge:ingots/hop_graphite" },
        count: 4,
      },
      mold: "immersiveengineering:mold_rod",
      result: {
        item: "immersiveengineering:graphite_electrode",
      },
    })
    .id("ftbskies:metal_press_graphite_electrode");

  recipesRods.forEach((recipe) => {
    event.custom({
      type: "thermal:press",
      ingredients: [
        {
          tag: `${recipe[0]}`,
        },
        {
          item: "immersiveengineering:mold_rod",
        },
      ],
      result: [
        {
          item: `${recipe[1]}`,
          count: 2,
        },
      ],
      energy: 800,
    });

    event.custom({
      type: "createaddition:rolling",
      input: {
        tag: `${recipe[0]}`,
      },
      result: {
        item: `${recipe[1]}`,
        count: 2,
      },
    });
  });
});
