const recipesUnpack = [
  // True at the end means it add to all 3 instead of just creating create recipe
  ["minecraft:diamond_block", "minecraft:diamond", true],
  ["minecraft:emerald_block", "minecraft:emerald", true],
  ["minecraft:lapis_block", "minecraft:lapis_lazuli", true],
  ["minecraft:iron_block", "minecraft:iron_ingot", true],
  ["minecraft:gold_block", "minecraft:gold_ingot", true],
  ["minecraft:copper_block", "minecraft:copper_ingot", true],
  ["mekanism:block_lead", "mekanism:ingot_lead", true],
  ["mekanism:block_tin", "mekanism:ingot_tin", true],
  ["mekanism:block_uranium", "mekanism:ingot_uranium", true],
  ["occultism:silver_block", "occultism:silver_ingot", true],
  ["immersiveengineering:storage_aluminum", "immersiveengineering:ingot_aluminum", true],
  ["thermal:sulfur_block", "thermal:sulfur", true],
  ["thermal:cinnabar_block", "thermal:cinnabar", true],
  ["thermal:apatite_block", "thermal:apatite", true],
  ["minecraft:bone_block", "minecraft:bone_meal", true],
  ["ad_astra:desh_block", "ad_astra:desh_ingot", true],
  ["ad_astra:ostrum_block", "ad_astra:ostrum_ingot", true],
  ["ad_astra:calorite_block", "ad_astra:calorite_ingot", true],
  ["minecraft:melon", "minecraft:melon_slice", true],
];

ServerEvents.recipes((event) => {
  recipesUnpack.forEach((recipe) => {
    //console.log("Unpack:" + recipe[0] + " " + recipe[1]);
    if (recipe[2]) {
      // Thermal Press
      event.custom({
        type: "thermal:press",
        ingredients: [
          {
            item: `${recipe[0]}`,
            count: 1,
          },
          {
            item: "immersiveengineering:mold_unpacking",
          },
        ],
        result: [
          {
            item: `${recipe[1]}`,
            count: 9,
          },
        ],
        energy: 800,
      });

      // Immersive Engineering Metal Press
      event.custom({
        type: "immersiveengineering:metal_press",
        input: {
          base_ingredient: {
            item: `${recipe[0]}`,
          },
          count: 1,
        },
        result: {
          item: `${recipe[1]}`,
          count: 9,
        },
        mold: "immersiveengineering:mold_unpacking",
        energy: 2400,
      });
    }
  });
});
