const recipesWires = [
  ["forge:plates/iron", "createaddition:iron_wire"],
  ["forge:plates/gold", "createaddition:gold_wire"],
  ["forge:plates/copper", "immersiveengineering:wire_copper"],
  ["forge:plates/electrum", "immersiveengineering:wire_electrum"],
  ["forge:plates/aluminum", "immersiveengineering:wire_aluminum"],
  ["forge:plates/steel", "immersiveengineering:wire_steel"],
  ["forge:plates/lead", "immersiveengineering:wire_lead"],
];

ServerEvents.recipes((event) => {
  recipesWires.forEach((recipe) => {
    event.custom({
      type: "thermal:press",
      ingredients: [
        {
          tag: `${recipe[0]}`,
          count: 1,
        },
        {
          item: "immersiveengineering:mold_wire",
        },
      ],
      result: [
        {
          item: `${recipe[1]}`,
          count: 2,
        },
      ],
      energy: 800,
    });

    event.custom({
      type: "immersiveengineering:metal_press",
      input: {
        base_ingredient: {
          tag: `${recipe[0]}`,
        },
        count: 1,
      },
      result: {
        item: `${recipe[1]}`,
        count: 2,
      },
      mold: "immersiveengineering:mold_wire",
      energy: 2400,
    });
  });
});
