const JavaAccessCompoundTag = Java.loadClass("net.minecraft.nbt.CompoundTag");

const allowedTypes = [
  "minecraft:cow",
  "minecraft:chicken",
  "minecraft:sheep",
  "minecraft:witch",
  "minecraft:zombie",
  "minecraft:skeleton",
  "minecraft:spider",
  "minecraft:creeper",
  "minecraft:enderman",
  "minecraft:blaze",
  "minecraft:ghast",
  "minecraft:slime",
  "minecraft:zombie_pigman",
  "minecraft:tropical_fish",
  "minecraft:cod",
  "minecraft:salmon",
  "minecraft:pufferfish",
  "ars_nouveau:wilden_stalker",
  "ars_nouveau:wilden_guardian",
  "ars_nouveau:wilden_hunter",
];

/**
 * This method will apply a custom NBT tag to the item in the offhand when the targeted entity
 * that is killed within the {@link allowedTypes}
 */
EntityEvents.death((event) => {
  if (event.entity.type !== "minecraft:player") {
    let player = event.source.player;
    if (player) {
      if (player.getOffHandItem() !== Item.of("pneumaticcraft:spawner_core")) {
        return;
      }

      if (allowedTypes.includes(event.entity.type)) {
        player.getOffHandItem().count--;

        const itemToGive = Item.of(`pneumaticcraft:spawner_core`);

        // This is needed because LatScript dones't seem to like the dynamic map key syntax of {[key.var]: value}
        const compound = new JavaAccessCompoundTag();
        compound.putInt(event.entity.type, 100);

        const itemTag = itemToGive.getOrCreateTag();
        itemTag.put("pneumaticcraft:SpawnerCoreStats", compound);

        player.give(itemToGive);
        return;
      }

      player.displayClientMessage(
        Text.translate("ftbskies.status_message.incorrect_blacklisted_entity_spawn_core"),
        true
      );
      console.log(Object.keys(player));
    }
  }
});
