// priority: 101

const lumberBeeBlacklist = ["forcecraft:force_log"];
const lumberBeeAdditions = [
  "tropicraft:red_mangrove_log",
  "tropicraft:light_mangrove_log",
  "tropicraft:black_mangrove_log",
];
const quarryBeeBlacklist = ["pneumaticcraft:reinforced_stone"];
const quarryBeeAdditions = [
  "pneumaticcraft:reinforced_stone",
  "ad_astra:sky_stone",
  "ad_astra:moon_stone",
  "ad_astra:mars_stone",
  "ad_astra:venus_sandstone",
  "ad_astra:mercury_stone",
  "ad_astra:glacio_stone",
];

const sifterItems = [
  "ftbskies:dust",
  "minecraft:gravel",
  "minecraft:sand",
  "minecraft:grass",
  "ftbskies:crushed_netherrack",
  "ftbskies:crushed_end_stone",
  "minecraft:dirt",
  "minecraft:mycelium",
  "minecraft:soul_sand",
  "minecraft:oak_leaves",
];

const jeiBlacklist = [
  "#ftb:spawn_eggs",
  "ae2:facade",
  "ars_nouveau:bucket_of_source",
  "create_new_age:advanced_solar_heating_plate",
  "create_new_age:basic_solar_heating_plate",
  "create_new_age:copper_wire",
  "create_new_age:electrical_connector",
  "create_new_age:heat_pipe",
  "create_new_age:heat_pump",
  "create_new_age:heater",
  "create_new_age:nuclear_fuel",
  "create_new_age:overcharged_diamond_wire",
  "create_new_age:overcharged_golden_wire",
  "create_new_age:overcharged_iron_wire",
  "create_new_age:radioactive_thorium",
  "create_new_age:reactor_casing",
  "create_new_age:reactor_fuel_acceptor",
  "create_new_age:reactor_glass",
  "create_new_age:reactor_heat_vent",
  "create_new_age:reactor_rod",
  "create_new_age:stirling_engine",
  "ftbskies:amethyst_mesh",
  "create_new_age:thorium",
  "create:steam_engine",
  "createaddition:alternator",
  "createaddition:bioethanol_bucket",
  "createaddition:bioethanol",
  "createaddition:connector",
  "createaddition:copper_spool",
  "createaddition:electrum_spool",
  "createaddition:festive_spool",
  "createaddition:gold_spool",
  "createaddition:large_connector",
  "createaddition:seed_oil_bucket",
  "createaddition:seed_oil",
  "createaddition:small_light_connector",
  "createaddition:spool",
  "createastracompat:crushed_desh_ore",
  "cyclic:crafter",
  "cyclic:sleeping_mat",
  "cyclic:tile_transporter_empty",
  "cyclic:uncrafter",
  "darkutils:crafting/vector_plate_extreme",
  "darkutils:crafting/vector_plate_fast",
  "darkutils:crafting/vector_plate",
  "darkutils:vector_plate_ultra",
  "farmersdelight:wheat_dough",
  "forcecraft:spoils_bag_t2",
  "forcecraft:spoils_bag_t3",
  "forcecraft:spoils_bag",
  "functionalstorage:armory_cabinet",
  "immersiveengineering:biodiesel_bucket",
  "immersiveengineering:ethanol_bucket",
  "immersiveengineering:plantoil_bucket",
  "industrialforegoing:biofuel_bucket",
  "mekanism:creative_chemical_tank",
  "mekanism:creative_fluid_tank",
  "mekanismgenerators:bioethanol_bucket",
  "pneumaticcraft:plastic",
  "pneumaticcraft:wheat_flour",
  //"productivebees:configurable_comb",
  //"productivebees:configurable_honeycomb",
  "thermal:chiller_ingot_cast",
  "thermal:chiller_rod_cast",
  "thermal:coal_coke",
  "thermal:creosote_bucket",
  "thermal:crude_oil_bucket",
  "thermal:device_tree_extractor",
  "thermal:latex_bucket",
  "thermal:press_gear_die",
  "thermal:press_packing_2x2_die",
  "thermal:press_packing_3x3_die",
  "thermal:press_unpacking_die",
  "tmted:wheat_flour",
  "tropicraft:acai_vine",
  "tropicraft:air_compressor",
  "tropicraft:anemone",
  "tropicraft:ashen_mask_bat_boy",
  "tropicraft:ashen_mask_enigma",
  "tropicraft:ashen_mask_headinator",
  "tropicraft:ashen_mask_horn_monkey",
  "tropicraft:ashen_mask_invader",
  "tropicraft:ashen_mask_mojo",
  "tropicraft:ashen_mask_oblongatron",
  "tropicraft:ashen_mask_screw_attack",
  "tropicraft:ashen_mask_square_horn",
  "tropicraft:ashen_mask_square_zord",
  "tropicraft:ashen_mask_the_brain",
  "tropicraft:ashen_mask_the_heart",
  "tropicraft:ashen_mask_warthog",
  "tropicraft:azurite_block",
  "tropicraft:azurite_gem",
  "tropicraft:azurite_ore",
  "tropicraft:black_coffee",
  "tropicraft:black_pearl",
  "tropicraft:blow_gun",
  "tropicraft:bromeliad",
  "tropicraft:caipirinha",
  "tropicraft:canna",
  "tropicraft:chunk_fence_gate",
  "tropicraft:chunk_fence",
  "tropicraft:chunk_slab",
  "tropicraft:chunk_stairs",
  "tropicraft:chunk_wall",
  "tropicraft:chunk",
  "tropicraft:cocktail",
  "tropicraft:coconut_water",
  "tropicraft:coffee_berry",
  "tropicraft:commelina_diffusa",
  "tropicraft:cooked_fish",
  "tropicraft:cooked_frog_leg",
  "tropicraft:cooked_ray",
  "tropicraft:coral_sand",
  "tropicraft:crocosmia",
  "tropicraft:croton",
  "tropicraft:dagger",
  "tropicraft:dracaena",
  "tropicraft:drink_mixer",
  "tropicraft:eel_grass_block",
  "tropicraft:eel_grass",
  "tropicraft:eudialyte_axe",
  "tropicraft:eudialyte_block",
  "tropicraft:eudialyte_gem",
  "tropicraft:eudialyte_hoe",
  "tropicraft:eudialyte_ore",
  "tropicraft:eudialyte_pickaxe",
  "tropicraft:eudialyte_shovel",
  "tropicraft:eudialyte_sword",
  "tropicraft:fern_seagrass_block",
  "tropicraft:fern_seagrass",
  "tropicraft:fire_boots",
  "tropicraft:fire_chestplate",
  "tropicraft:fire_helmet",
  "tropicraft:fire_leggings",
  "tropicraft:fishing_net",
  "tropicraft:flowering_eel_grass",
  "tropicraft:foamy_sand",
  "tropicraft:foliage",
  "tropicraft:fresh_marlin",
  "tropicraft:frog_leg",
  "tropicraft:frox_conch",
  "tropicraft:grapefruit",
  "tropicraft:iguana_leather",
  "tropicraft:iris",
  "tropicraft:lemon",
  "tropicraft:lemonade",
  "tropicraft:lime",
  "tropicraft:limeade",
  "tropicraft:love_tropics_shell",
  "tropicraft:magic_mushroom",
  "tropicraft:mai_tai",
  "tropicraft:manganese_block",
  "tropicraft:manganese_ingot",
  "tropicraft:manganese_ore",
  "tropicraft:matted_eel_grass",
  "tropicraft:matted_fern_seagrass",
  "tropicraft:matted_noodle_seagrass",
  "tropicraft:matted_sickle_seagrass",
  "tropicraft:mineral_sand",
  "tropicraft:mud_with_pianguas",
  "tropicraft:mud",
  "tropicraft:nigel_stache",
  "tropicraft:noodle_seagrass_block",
  "tropicraft:noodle_seagrass",
  "tropicraft:orange_anthurium",
  "tropicraft:orange",
  "tropicraft:orangeade",
  "tropicraft:orchid",
  "tropicraft:pab_shell",
  "tropicraft:packed_purified_sand",
  "tropicraft:pathos",
  "tropicraft:pianguas",
  "tropicraft:pink_pony_bottle",
  "tropicraft:pink_scuba_flippers",
  "tropicraft:pink_scuba_goggles",
  "tropicraft:pink_scuba_harness",
  "tropicraft:piranha_bucket",
  "tropicraft:poison_frog_skin",
  "tropicraft:purified_sand",
  "tropicraft:raw_coffee_bean",
  "tropicraft:raw_fish",
  "tropicraft:raw_ray",
  "tropicraft:red_anthurium",
  "tropicraft:reeds",
  "tropicraft:roasted_coffee_bean",
  "tropicraft:rube_nautilus",
  "tropicraft:sardine_bucket",
  "tropicraft:scale_boots",
  "tropicraft:scale_chestplate",
  "tropicraft:scale_helmet",
  "tropicraft:scale_leggings",
  "tropicraft:scale",
  "tropicraft:sea_urchin_roe",
  "tropicraft:seared_marlin",
  "tropicraft:shaka_block",
  "tropicraft:shaka_ingot",
  "tropicraft:shaka_ore",
  "tropicraft:sickle_seagrass_block",
  "tropicraft:sickle_seagrass",
  "tropicraft:sifter",
  "tropicraft:small_golden_leather_fern",
  "tropicraft:solonox_shell",
  "tropicraft:starfish",
  "tropicraft:toasted_nori",
  "tropicraft:tropical_fern",
  "tropicraft:tropical_fish_bucket",
  "tropicraft:turtle_shell",
  "tropicraft:volcanic_sand",
  "tropicraft:water_wand",
  "tropicraft:white_pearl",
  "tropicraft:yellow_pony_bottle",
  "tropicraft:yellow_scuba_flippers",
  "tropicraft:yellow_scuba_goggles",
  "tropicraft:yellow_scuba_harness",
  "tropicraft:zircon_axe",
  "tropicraft:zircon_block",
  "tropicraft:zircon_gem",
  "tropicraft:zircon_hoe",
  "tropicraft:zircon_ore",
  "tropicraft:zircon_pickaxe",
  "tropicraft:zircon_shovel",
  "tropicraft:zircon_sword",
  "tropicraft:zirconium_axe",
  "tropicraft:zirconium_block",
  "tropicraft:zirconium_gem",
  "tropicraft:zirconium_hoe",
  "tropicraft:zirconium_pickaxe",
  "tropicraft:zirconium_shovel",
  "tropicraft:zirconium_sword",
  "productivebees:stone_chip",
  "productivebees:wood_chip",
  "pneumaticcraft:gasoline_bucket",
  "pneumaticcraft:lpg_bucket",
  "cyclic:solidifier",
  "cyclic:melter",
  "create:honey_bucket",
  "cyclic:honey_bucket",
  "farmersdelight:bacon",
  "farmersdelight:cooked_bacon",
  "cyclic:emerald_boots",
	"cyclic:emerald_helmet",
	"cyclic:emerald_chestplate",
	"cyclic:emerald_sword",
	"cyclic:emerald_leggings",
	"cyclic:emerald_pickaxe",
	"cyclic:emerald_axe",
	"cyclic:emerald_hoe",
	"cyclic:emerald_shovel",
];

const seedBagAdditions = [
  "botania:grass_seeds",
  "botania:podzol_seeds",
  "botania:dry_seeds",
  "botania:golden_seeds",
  "botania:vivid_seeds",
  "botania:scorched_seeds",
  "botania:infused_seeds",
  "botania:mutated_seeds",
	"occultism:otherworld_sapling_natural",
	"integrateddynamics:menril_sapling",
	"minecraft:oak_sapling",
	"minecraft:spruce_sapling",
	"minecraft:birch_sapling",
	"minecraft:jungle_sapling",
	"minecraft:acacia_sapling",
	"minecraft:dark_oak_sapling",
	"ars_nouveau:blue_archwood_sapling",
	"ars_nouveau:purple_archwood_sapling",
	"ars_nouveau:green_archwood_sapling",
	"ars_nouveau:red_archwood_sapling",
	"forcecraft:force_sapling",
	"hexerei:mahogany_sapling",
	"hexerei:willow_sapling",
	"hexerei:witch_hazel_sapling",
	"occultism:otherworld_sapling",
	"tropicraft:palm_sapling",
	"tropicraft:mahogany_sapling",
	"tropicraft:papaya_sapling",
	"tropicraft:orange_sapling",
	"tropicraft:lime_sapling",
	"tropicraft:lemon_sapling",
	"tropicraft:grapefruit_sapling",
	"thermal:rubberwood_sapling"
]

ServerEvents.tags("item", (event) => {
 
  seedBagAdditions.forEach((item) => {
    event.get("quark:seed_pouch_holdable").add(item);
  });
 
  global["unUnified"].forEach((id) => {
    event.removeAllTagsFrom(id);
    event.add("c:hidden_from_recipe_viewers", id);
  });

  event.get("minecraft:piglin_loved").add("create:goggles");
  event.get("minecraft:piglin_loved").add("cyclic:glowing_helmet");

  quarryBeeBlacklist.forEach((block) => {
    event.get("productbees:flowers/quarry").remove(block);
  });

  lumberBeeBlacklist.forEach((block) => {
    event.get("productbees:flowers/lumber").remove(block);
  });

  quarryBeeAdditions.forEach((block) => {
    event.get("productbees:flowers/quarry").add(block);
  });

  lumberBeeAdditions.forEach((block) => {
    event.get("productbees:flowers/lumber").add(block);
  });

  event.add(
    "ftb:spawn_eggs",
    /\b(?!(cow|rabbit|starbuncle|drygmy|chicken|blizz|basalz|blitz|warden|blaze|bee|wandering_trader|productivebees.)_spawn_egg)\w+_spawn_egg\b/
  );
  event.add("ftb:spawn_eggs", /^.*:spawn_egg.*/);
  event.remove("ftb:spawn_eggs", "productivebees:spawn_egg_configurable_bee");
  [
    "ars_nouveau:whirlisprig_se",
    "ars_nouveau:wilden_guardian_se",
    "ars_nouveau:wilden_hunter_se",
    "ars_nouveau:wilden_stalker_se",
  ].forEach((item) => event.add("ftb:spawn_eggs", item));

  event.add("ftbskies:desh_food", ["ftbskies:honeyed_moon_stone"]);
  event.add("ftbskies:oil_food", ["ftbskies:honeyed_tar"]);
  event.add("ftbskies:ostrum_food", ["ftbskies:honeyed_mars_stone"]);
  event.add("ftbskies:calorite_food", ["ftbskies:honeyed_venus_stone"]);
  event.add("ftbskies:force_food", ["ftbskies:force_infused_moon_stone"]);
  event.add("forge:ingots/platinum", ["ftbskies:platinum_ingot"]);
  event.add("forge:dusts/platinum", ["ftbskies:platinum_dust"]);
  event.add("forge:nuggets/platinum", ["ftbskies:platinum_nugget"]);
  event.add("forge:ingots/flux", ["redstone_arsenal:flux_ingot"]);

  event.add("forge:plates", ["create_new_age:overcharged_iron_sheet", "create_new_age:overcharged_golden_sheet", 'ftbskies:platinum_plate']);
  event.add("forge:ingots", ["create_new_age:overcharged_iron", "create_new_age:overcharged_gold"]);

  event.add("forge:carbon_dusts", ["mekanism:dust_coal"]);
  event.add("forge:carbon_dusts", ["mekanism:dust_charcoal"]);

  event.remove("forge:coal_coke", ["thermal:coal_coke"]);

  //Removing Uranium from the Earth's Boon
  event.remove("forge:ores_in_ground/stone", ["mekanism:uranium_ore"]);
  event.remove("forge:ores_in_ground/deepslate", ["mekanism:uranium_ore"]);

  //Fixing Deepslate Tag
  event.add("forge:deepslate", ['minecraft:deepslate']);

  //Bacon Unification
  event.remove("forge:raw_bacon", ["farmersdelight:bacon"]);
  event.remove("forge:raw_pork", ["farmersdelight:bacon"]);
  event.remove("farmersdelight:cabbage_roll_ingredients", ["farmersdelight:bacon"]);
  event.remove("forge:cooked_bacon", ["farmersdelight:cooked_bacon"]);
  event.remove("forge:cooked_pork", ["farmersdelight:cooked_bacon"]);

  event.add("forge:raw_bacon", ["forcecraft:raw_bacon"]);
  event.add("forge:raw_pork", ["forcecraft:raw_bacon"]);
  event.add("farmersdelight:cabbage_roll_ingredients", ["forcecraft:raw_bacon"]);
  event.add("forge:cooked_bacon", ["forcecraft:cooked_bacon"]);
  event.add("forge:cooked_pork", ["forcecraft:cooked_bacon"]);

  //Adding Tags to Drills that don't have the pickaxe tag
  event.add("natprog:considered_as_axe", ["pneumaticcraft:jackhammer"]);
  event.add("natprog:considered_as_pickaxe", ["pneumaticcraft:jackhammer"]);
  event.add("natprog:considered_as_axe", ["immersiveengineering:drill"]);
  event.add("natprog:considered_as_pickaxe", ["immersiveengineering:drill"]);

  //Petrochem Tags
  event.add("forge:kaboom_gel", ["ftbskies:gelled_toluene"]);

  event.add("itemfilters:check_nbt", [
    "patchouli:guide_book",
    "apotheosis:potion_charm",
    "tetra:modular_double",
    "productivebees:configurable_honeycomb",
  ]);

  event.add("thermal:crafting/dies", [
    "immersiveengineering:mold_plate",
    "immersiveengineering:mold_gear",
    "immersiveengineering:mold_rod",
    "immersiveengineering:mold_bullet_casing",
    "immersiveengineering:mold_wire",
    "immersiveengineering:mold_packing_4",
    "immersiveengineering:mold_packing_9",
    "immersiveengineering:mold_unpacking",
  ]);

  event.add("c:hidden_from_recipe_viewers", jeiBlacklist);
  event.add("ftbskies:siftable", sifterItems);
  event.add("forge:experience", ["experienceobelisk:raw_experience_bucket"]);

  event.remove("pneumaticcraft:upgrade_components", ["minecraft:lapis_lazuli"]);
  event.remove("forge:buckets/honey", ["create:honey_bucket"]);


  event.add("ftb:rods", [
    "createaddition:brass_rod",
    "createaddition:copper_rod",
    "createaddition:electrum_rod",
    "createaddition:gold_rod",
    "elementalcraft:hardened_handle",
    "ad_astra:iron_rod",
    "createaddition:iron_rod",
    "jaopca:rods.brick",
    "jaopca:rods.bronze",
    "jaopca:rods.calorite",
    "jaopca:rods.compressed_iron",
    "jaopca:rods.constantan",
    "jaopca:rods.desh",
    "jaopca:rods.drenched_iron",
    "jaopca:rods.elementium",
    "jaopca:rods.enderium",
    "jaopca:rods.fireite",
    "jaopca:rods.hop_graphite",
    "jaopca:rods.iesnium",
    "jaopca:rods.invar",
    "jaopca:rods.lead",
    "jaopca:rods.lumium",
    "jaopca:rods.manasteel",
    "jaopca:rods.manganese",
    "jaopca:rods.nether_brick",
    "jaopca:rods.netherite",
    "jaopca:rods.nickel",
    "jaopca:rods.osmium",
    "jaopca:rods.ostrum",
    "jaopca:rods.refined_glowstone",
    "jaopca:rods.refined_obsidian",
    "jaopca:rods.shaka",
    "jaopca:rods.signalum",
    "jaopca:rods.silver",
    "jaopca:rods.swift_alloy",
    "jaopca:rods.terrasteel",
    "jaopca:rods.tin",
    "jaopca:rods.unstable",
    "jaopca:rods.uranium",
    "jaopca:rods.zinc",
    "immersiveengineering:stick_iron",
  ]);
});
const arsBlacklist = [
  "trashcans:energy_trash_can",
  "trashcans:item_trash_can",
  "trashcans:ultimate_trash_can",
  "trashcans:liquid_trash_can",
  "ad_astra:launch_pad",
  "experienceobelisk:experience_obelisk",
  "angelblockrenewed:angel_block",
  "integratedtunnels:part_interface_item",
  "integratedtunnels:part_interface_filter_item",
  "integratedtunnels:part_importer_item",
  "integratedtunnels:part_exporter_item",
  "integratedtunnels:part_importer_world_item",
  "integratedtunnels:part_exporter_world_item",
  "custommachinery:custom_machine_block",

];

const arsInteractionBlacklist = [
  "create:hand_crank",
];
const naturalProgressionBlacklist = [
  "create:brass_casing",
  "create:copper_casing",
  "create:railway_casing",
  "create:andesite_casing",
  "ftbricketyww:rickety_water_wheel",
];

const additionaFramedBlocks = [
  "spirit:soul_glass",
  "spirit:soul_slate",
  "spirit:soul_steel_block",
  "spirit:soul_powder_block",
  "spirit:compressed_soul_powder_block",
  "spirit:compressed_soul_sand",
  "spirit:soul_glass_3",
  "spirit:soul_glass_1",
  "spirit:soul_glass_2",
  "spirit:soul_glass_5",
  "spirit:soul_glass_6",
  "spirit:soul_glass_7",
  "spirit:soul_glass_8",
  "spirit:soul_glass_9",
  "spirit:soul_glass_10",
  "spirit:soul_glass_11",
  "spirit:soul_glass_12",
  "spirit:soul_glass_13",
];


const craftStationBlacklist = [
  "create:item_vault",
  "create:item_vault",
"hexerei:witch_hazel_altar",
"hexerei:willow_altar",
"hexerei:book_of_shadows_altar",       
"rftoolsstorage:modular_storage",
];


const buildingGadgetsBlacklist = [
  "pneumaticcraft:heat_pipe",
  "pneumaticcraft:heat_pipe",
  "pneumaticcraft:pressure_tube",
  "pneumaticcraft:reinforced_pressure_tube",
  "pneumaticcraft:advanced_pressure_tube",
  
];

ServerEvents.tags("block_entity_type", (event) => {
  arsBlacklist.forEach((block) => {
    event.get("craftingstation:blacklisted").add(block);
  });
});



ServerEvents.tags("block", (event) => {
  arsBlacklist.forEach((block) => {
    event.get("ars_nouveau:no_break_drop").add(block);
  });

  buildingGadgetsBlacklist.forEach((block) => {
    event.get("buildinggadgets:blacklist/generic").add(block);
  });

  event.get("minecraft:mineable/shovel").add("cyclic:terra_preta");
  event.get("minecraft:mineable/paxel").add("cyclic:terra_preta");

  additionaFramedBlocks.forEach((block) => {
    event.get("framedblocks:frameable").add(block);
  });

  arsInteractionBlacklist.forEach((block) => {
    event.get("ars_nouveau:ignore_tile").add(block);
  });

  quarryBeeBlacklist.forEach((block) => {
    event.get("productbees:flowers/quarry").remove(block);
  });
  lumberBeeBlacklist.forEach((block) => {
    event.get("productbees:flowers/lumber").remove(block);
  });

  quarryBeeAdditions.forEach((block) => {
    event.get("productbees:flowers/quarry").add(block);
  });

  lumberBeeAdditions.forEach((block) => {
    event.get("productbees:flowers/lumber").add(block);
  });

  event.add("ftbskies:lod_food",["botania:purple_petal_block"])
  event.add("ftbskies:desh_food", ["ftbskies:honeyed_moon_stone"]);
  event.add("ftbskies:ostrum_food", ["ftbskies:honeyed_mars_stone"]);
  event.add("ftbskies:calorite_food", ["ftbskies:honeyed_venus_stone"]);
  event.add("ftbskies:force_food", ["ftbskies:force_infused_moon_stone"]);
  event.add("ftbskies:peat_fuel", ["cyclic:peat_fuel", "cyclic:peat_fuel_enriched"]);
  event.add("ftbskies:peat", ["cyclic:peat_fuel"]);
  event.add("ftbskies:enriched_peat", ["cyclic:peat_fuel_enriched"]);

  naturalProgressionBlacklist.forEach((block) => {
    event.get("natprog:ignored_wood_blocks").add(block);
  });

  event.remove("minecraft:needs_iron_tool", "@antiblocksrechiseled");
  event.remove("create_new_age:magnet", "minecraft:respawn_anchor");
  event.add("minecraft:needs_stone_tool", "@antiblocksrechiseled");
  event.add("ftbskies:plastic_bricks", ["#pneumaticcraft:plastic_bricks", "#pneumaticcraft:smooth_plastic_bricks"]);

  event.add("ad_astra:blocks_flood_fill", [
    "mekanism:basic_energy_cube",
    "mekanism:advanced_energy_cube",
    "mekanism:elite_energy_cube",
    "mekanism:ultimate_energy_cube",
    "mekanism:creative_energy_cube",
  ]);
});

const notWater = [
  "ad_astra:fuel",
  "ad_astra:flowing_fuel",
  "ad_astra:cryo_fuel",
  "ad_astra:flowing_cryo_fuel",
  "createaddition:bioethanol",
  "createaddition:flowing_bioethanol",
  "createaddition:flowing_seed_oil",
  "sliceanddice:fertilizer",
  "sliceanddice:flowing_fertilizer",
  "cyclic:xpjuice",
  "cyclic:xpjuice_flowing",
  "cyclic:biomass",
  "cyclic:biomass_flowing",
  "cyclic:honey_flowing",
  "cyclic:honey",
  "hexerei:blood_fluid",
  "hexerei:tallow_fluid",
  "hexerei:blood_flowing",
  "hexerei:tallow_flowing",
  "mekanism:steam",
  "mekanism:water_vapor",
  "mekanism:heavy_water",
  "createteleporters:quantum_fluid",
  "createteleporters:flowing_quantum_fluid",
];

const removeFuels = [
  "immersiveengineering:biodiesel",
  "thermal:refined_fuel",
  "industrialforegoing:biofuel",
  "createaddition:bioethanol",
];
ServerEvents.tags("fluid", (event) => {
  notWater.forEach((fluid) => {
    event.remove("minecraft:water", fluid);
  });

  event.remove("minecraft:lava", "hexerei:quicksilver_fluid");
  event.remove("minecraft:lava", "hexerei:quicksilver_flowing");
  event.add("forge:pinkslime", ["industrialforegoing:pink_slime"]);
  event.add("forge:force_biodiesel", ["ftbskies:force_infused_biodiesel"]);
  event.add("kubejs:source", ["kubejs:source"]);
  event.add("forge:biodiesel", ["pneumaticcraft:biodiesel"]);
  event.add("forge:molten/silver", ["ftbskies:molten_silver"]);
  event.add("forge:latex", ["thermal:latex"]);
  event.add("forge:latex", ["industrialforegoing:latex"]);
  event.add("forge:volatile_redstone", ["ftbskies:volatile_redstone"]);
  event.add("forge:etching_acid", ["pneumaticcraft:etching_acid"]);
  event.add("forge:redstone_acid", ["immersiveengineering:redstone_acid"]);
  event.add("forge:source", ["starbunclemania:source_fluid"]);
  event.add("ftbskies:water", ["minecraft:water"]);

  event.add("forge:plates",["thermalendergy:melodium_plate","thermalendergy:stellarium_plate","thermalendergy:prismalium_plate","ftbskies:osmium_infused_ostrum_plate"])

  //Petrochem Tags
  event.add("forge:force_oil", ["ftbskies:force_infused_oil"]);
  event.add("forge:force_diesel", ["ftbskies:force_infused_diesel"]);

  event.add("forge:flux_diesel", ["ftbskies:flux_diesel"]);
  event.add("forge:nitro_diesel", ["ftbskies:nitro_diesel"]);

  event.add("forge:sulfuric_gas", ["ftbskies:sulfuric_gas"]);
  event.add("forge:refinery_gas", ["ftbskies:refinery_gas"]);
  event.add("forge:ethane", ["ftbskies:ethane"]);
  event.add("forge:fluorine", ["ftbskies:fluorine"]);
  event.add("forge:methane", ["ftbskies:methane"]);
  event.add("forge:benzene", ["ftbskies:benzene"]);
  event.add("forge:toluene", ["ftbskies:toluene"]);
  event.add("forge:carbon_dioxide_gas", ["ftbskies:carbon_dioxide"]);

  event.remove("pneumaticcraft:plastic", ["pneumaticcraft:plastic"]);

  //Oil Unification
  event.remove("forge:oil", ["ad_astra:oil"]);
  event.remove("ad_astra:oil", ["ad_astra:oil"]);
  event.remove("minecraft:water", ["ad_astra:oil"]);
  event.remove("pneumaticcraft:seismic_sensor_interesting", ["ad_astra:oil"]);
  event.remove("ad_astra_platform:fuel", ["ad_astra:oil"]);
  event.remove("forge:crude_oil", ["ad_astra:oil"]);
  event.remove("forge:oil", ["ad_astra:flowing_oil"]);
  event.remove("ad_astra:oil", ["ad_astra:flowing_oil"]);
  event.remove("minecraft:water", ["ad_astra:flowing_oil"]);
  event.remove("pneumaticcraft:seismic_sensor_interesting", ["ad_astra:flowing_oil"]);
  event.remove("ad_astra_platform:fuel", ["ad_astra:flowing_oil"]);
  event.remove("forge:crude_oil", ["ad_astra:flowing_oil"]);

  event.remove("forge:oil", ["thermal:crude_oil"]);
  event.remove("ad_astra:oil", ["thermal:crude_oil"]);
  event.remove("pneumaticcraft:seismic_sensor_interesting", ["thermal:crude_oil"]);
  event.remove("ad_astra_platform:fuel", ["thermal:crude_oil"]);
  event.remove("forge:crude_oil", ["thermal:crude_oil"]);
  
  //Diesel and Bio Diesel Unification

  removeFuels.forEach((fluid) => {
    event.remove("forge:diesel", fluid);
    event.remove("forge:fuel", fluid);
    event.remove("forge:biodiesel", fluid);
    event.remove("ad_astra:fuel", fluid);
    event.remove("ad_astra_platform:fuel", fluid);
  });

  event.remove("forge:fuel", "pneumaticcraft:diesel");
  event.remove("forge:fuel", "pneumaticcraft:biodiesel");

  event.remove("forge:biofuel", ["industrialforegoing:biofuel"]);

    event.remove("forge:biodiesel", ["immersiveengineering:biodiesel"]);
  event.remove("immersiveengineering:drill_fuel", ["immersiveengineering:biodiesel"]);

  
  //Ethanol Unification
  event.remove("forge:ethanol", ["immersiveengineering:ethanol"]);

  //Plant Oil/Seed Oil Unification
  event.remove("forge:plantoil", ["immersiveengineering:plantoil"]);
  event.remove("forge:plantoil", ["createaddition:seed_oil"]);
  event.remove("forge:plantoil", ["createaddition:flowing_seed_oil"]);
  event.remove("minecraft:water", ["createaddition:seed_oil"]);

  //Creosote Unification
  event.remove("forge:creosote", ["thermal:creosote"]);

  //Gasoline Removal
  event.remove("forge:gasoline", ["pneumaticcraft:gasoline"]);

  //LPG Removal
  event.remove("forge:lpg", ["pneumaticcraft:lpg"]);

  //Honey Unification
  event.remove("forge:honey", ["cofh_core:honey"]);
  event.remove("forge:honey", ["create:honey"]);
  event.remove("forge:honey", ["cyclic:honey"]);
});

const $ForgeRegistries = Java.loadClass("net.minecraftforge.registries.ForgeRegistries");

const allEntities = $ForgeRegistries.ENTITY_TYPES.getKeys();
const entityWhitelist = [
  "minecraft:cat",
  "minecraft:chicken",
  "minecraft:cow",
  "minecraft:donkey",
  "minecraft:fox",
  "minecraft:goat",
  "minecraft:horse",
  "minecraft:lama",
  "minecraft:mule",
  "minecraft:ocelot",
  "minecraft:panda",
  "minecraft:parrot",
  "minecraft:pig",
  "minecraft:rabbit",
  "minecraft:sheep",
  "minecraft:turtle",
  "minecraft:wolf",
];
const spaceMobs = [
  'ftbskies:venus_blaze',
  'minecraft:blaze'
]
ServerEvents.tags("entity_type", (event) => {
  event.add("mob_grinding_utils:no_dirt_spawn", [
    "ars_nouveau:drygmy",
    "ars_nouveau:starbuncle",
    "ars_nouveau:whirlisprig",
    "mutantmonsters:mutant_creeper",
    "mutantmonsters:mutant_enderman",
    "mutantmonsters:mutant_skeleton",
    "mutantmonsters:mutant_snow_golem",
    "mutantmonsters:mutant_zombie",
  ]);
  event.add("mob_grinding_utils:no_delightful_spawn", allEntities);
  event.remove("mob_grinding_utils:no_delightful_spawn", entityWhitelist);
  event.add("ad_astra:entities/lives_without_oxygen", spaceMobs)

});