// priority: 0
const $IntegerProperty = Java.loadClass("net.minecraft.world.level.block.state.properties.IntegerProperty");
const compressingBlocks = ["dirt", "cobblestone", "gravel"];

StartupEvents.registry("block", (event) => {
  event.create("ftbskies:crushed_end_stone").material("sand").hardness(0.4).displayName("Crushed End Stone");
  event.create("ftbskies:crushed_netherrack").material("sand").hardness(0.4).displayName("Crushed Netherrack");
  event.create("ftbskies:dust").material("sand").hardness(0.4).displayName("Dust");
  event
    .create("ftbskies:contained_charcoal")
    .material("stone")
    .hardness(0.4)
    .displayName("Contained Crystal Charcoal Block");
  event
    .create("ftbskies:faux_amethyst_block")
    .material("stone")
    .hardness(0.4)
    .displayName("Block of Amethyst (Faux)")
    .textureAll("minecraft:block/amethyst_block")
    .soundType(SoundType.AMETHYST);
    event
    .create("ftbskies:space_station")
    .material("bedrock")
    .hardness(0.4)
    .displayName("Recipe Disabled (Just enter orbit for a free space station)")
    .textureAll("minecraft:block/bedrock");

    event
    .create("ftbskies:magic_steel_block")
    .material("metal")
    .hardness(1)
    .lightLevel(4)
    .displayName("Magically Inclined Steel Block");
  event.create("ftbskies:space_plating_block").material("metal").hardness(1).displayName("Space Plating Block");
  event
    .create("ftbskies:fluxed_infused_desh_block")
    .material("metal")
    .hardness(1)
    .displayName("Flux-Infused Desh Block");
  event
    .create("ftbskies:deco_space_plating")
    .material("metal")
    .hardness(1)
    .displayName("Decorative Space Plating Block");
  event
    .create("ftbskies:deco_space_plating_pipe")
    .material("metal")
    .hardness(1)
    .displayName("Decorative Space Plating (Pipe)");
  event
    .create("ftbskies:deco_space_plating_broken_fan")
    .material("metal")
    .hardness(1)
    .displayName("Decorative Space Plating (Fan)");
  event
    .create("ftbskies:desh_space_plating_block")
    .material("metal")
    .hardness(1)
    .displayName("Desh Space Plating Block");
  event
    .create("ftbskies:ostrum_space_plating_block")
    .material("metal")
    .hardness(1)
    .displayName("Ostrum Space Plating Block");
  event
    .create("ftbskies:calorite_space_plating_block")
    .material("metal")
    .hardness(1)
    .displayName("Calorite Space Plating Block");


  event
    .create("ftbskies:honeyed_moon_stone")
    .material("stone")
    .hardness(1)
    .displayName("Honeyed Moon Stone Block");

    event
    .create("ftbskies:honeyed_tar")
    .material("slime")
    .hardness(1)
    .displayName("Honeyed Tar Block");

  event
    .create("ftbskies:honeyed_mars_stone")
    .material("stone")
    .hardness(1)
    .displayName("Honeyed Mars Stone Block");

  event
    .create("ftbskies:honeyed_venus_stone")
    .material("stone")
    .hardness(1)
    .displayName("Honeyed Venus Stone Block");

  event
    .create("ftbskies:force_infused_moon_stone")
    .material("stone")
    .hardness(1)
    .displayName("Force-Infused Moon Stone Block");

  //Custom TNT's ==========================================
  event.create("ftbskies:nitro_tnt").material("metal").hardness(1).displayName("Nitro TNT");
  event.create("ftbskies:mega_tnt").material("metal").hardness(1).displayName("Mega TNT");

  // ======================================================

  //Custom Soils ==================================================================================

  event.create('ftbskies:lightly_magical_imbued_soil').displayName('§aLightly Imbued Magical Soil').grassSoundType().mapColor('grass').hardness(0.6);
  event.create('ftbskies:magical_imbued_soil').displayName('§aModerately Imbued Magical Soil').grassSoundType().mapColor('grass').hardness(0.6);
  event.create('ftbskies:densely_magical_imbued_soil').displayName('§2Densely Imbued Magical Soil').grassSoundType().mapColor('grass').hardness(0.6);

  // ==============================================================================================

  compressingBlocks.forEach((block) => {

    event
      .create(`ftbskies:compressed_${block}`)
      .material("stone")
      .hardness(1)
      .displayName(`Compacted ${block.charAt(0).toUpperCase() + block.slice(1)}`)
      .property($IntegerProperty.create("compressedage", 0, 5))
      .randomTick((tick) => {
        const block = tick.block;
        const properties = block.properties;
        const age = Number(properties.compressedage);
        let chance = Math.floor(Math.random() * 100);
        if (chance < 40) return;
        if (age == 5) {
          block.set(`minecraft:${block.id.split("_")[1]}`);
        } else {
          block.set(`${block.id}`, { compressedage: `${age + 1}` });
        }
      });
  });
});
