global.Math = {
    lerp: (start, end, t) => {
        return start * (1 - t) + end * t;
    },
    FrontVectors: (entity, dr, dp, distance, mode) => {
        const angle = mode === 1 ? dr + entity.yaw : dr;
        const pitch = (mode === 1 ? -entity.pitch + dp : dp) * JavaMath.PI / 180;
    
        const dx = -Math.sin(angle * JavaMath.PI / 180) * (distance * Math.cos(pitch));
        const dy = Math.sin(pitch) * distance;
        const dz = Math.cos(angle * JavaMath.PI / 180) * (distance * Math.cos(pitch));
    
        return [dx, dy, dz];
    },
    GetPlayerRotation: (npc, player) => {
        let dx = npc.x - player.x;
        let dz = player.z - npc.z;
        let angle = 0
        if (dz >= 0) {
            angle = Math.atan(dx / dz) * 180 / JavaMath.PI;
            angle = angle < 0 ? 360 + angle : angle;
        } else {
            angle = 180 - (Math.atan(dx / dz) * 180 / JavaMath.PI);
        }
        return angle;
    },
    Dvectors: (horizontalAngle, verticalAngle, radius, pos) =>{
        let x = radius * Math.sin(verticalAngle) * Math.cos(horizontalAngle) + pos.x;
        let y = radius * Math.cos(verticalAngle);
        let z = radius * Math.sin(verticalAngle) * Math.sin(horizontalAngle) + pos.z;
        return [x, y, z];
    }
}