const $CustomBossEvent = Java.loadClass('net.minecraft.server.bossevents.CustomBossEvent');
const $CustomBossEvents = Java.loadClass("net.minecraft.server.bossevents.CustomBossEvents")
const $BossEvent = Java.loadClass('net.minecraft.world.BossEvent');
const $TargetingConditions = Java.loadClass("net.minecraft.world.entity.ai.targeting.TargetingConditions")
const $Blaze = Java.loadClass("net.minecraft.world.entity.monster.Blaze")
// const $BossBarColor = Java.loadClass('net.minecraft.world.BossEvent.BossBarColor');
StartupEvents.registry('entity_type', event => {
    event.create('ftbskies:venus_blaze', 'entityjs:mob')
    .eggItem(item => {
        item.backgroundColor(0);
        item.highlightColor(0);
        item.glow(true);
        
    })



    // SCALING
        .sized(1.75, 4)
        // .modelSize(1, 3.25)
        .scaleModelForRender(context => {

            let x = 1.5
            let y = 2
            let z = 1.5
            return context.poseStack.scale(x, y, z);
        })
        // .scale(entity => {
        //     return global.venus_blaze.scale(entity)
        // })
        // .render(context => { return global.venus_blaze.render(context) })
    //

    // ANIMATION
        .addAnimationController('exampleController', 10, event => {
            return global.venus_blaze.animationController(event)
        })
    // 

    // AI AND TICK
        .aiStep(entity => { return global.venus_blaze.aiStep(entity) })
        .tick(entity => { return global.venus_blaze.tick(entity) })
    // 

    // ONEVENT
        .onAddedToWorld(entity => { return global.venus_blaze.onAddedToWorld(entity) })
        .onHurt(ctx => { global.venus_blaze.onHurt(ctx) })
        .onDeath(ctx => { global.venus_blaze.onDeath(ctx) })
        .doAutoAttackOnTouch(context => {
            // Attack the target entity with a damage value of 1
            context.entity.doHurtTarget(context.target)
        })
    //

    // ATRIBUTES
        .setStandingEyeHeight(ctx => {return global.venus_blaze.setStandingEyeHeight(ctx)})
        .isInvulnerableTo(ctx => {return global.venus_blaze.isInvulnerableTo(ctx)} )
        .isPersistenceRequired(true)
        .fireImmune(true)
        .immuneTo("minecraft:magma_block")
        .lavaHurt(entity => {
            entity.heal(20);
        })
        .clientTrackingRange(20)

    // 

    // SOUNDS
        .setAmbientSound("minecraft:entity.blaze.ambient")
        .setDeathSound("minecraft:entity.blaze.death")
        .setHurtSound(context => {
            const {entity, damageSource} = context;
            return "minecraft:entity.blaze.hurt"
        })
    // 

})

global.venus_blaze = { 
    nextHeightOffsetChangeTick: 0,
    allowedHeightOffset: 0,
    customBossEvent: null,
    animationController: event => {
        const {entity} = event;
        //addTriggerableAnimation(animationName, callbackName, AnimationType)
        event.addTriggerableAnimation('move', 'move', 'loop');
        event.addTriggerableAnimation("spin-attack" , "spin", "default")
        event.addTriggerableAnimation("hands-up", "hands", "default")
        if(entity.hurtTime > 0){
        }else{
            event.thenLoop("move")
        }
        
        return true; 
    },
    scale: entity => {
        return 1
    },
    setStandingEyeHeight: ctx => {
        return 2.5
    },
    isInvulnerableTo: ctx => {
        const {entity, damageSource} = ctx;
        if(damageSource.isFire()) return true
        if(entity.health < entity.maxHealth/2){
            if(damageSource.isProjectile()) return true
        } 
        return false;
    },
    isImmobile: entity => {
        return false
    },
    aiStep: entity => {
        let pData = entity.getPersistentData()

        if(entity.level.isClientSide){
            if(entity.random.nextInt(24) == 0 && !entity.isSilent()){
                entity.playSound("minecraft:entity.blaze.burn", 0.5 + entity.random.nextFloat(), entity.random.nextFloat() * 0.5 + 0.1)
            }
            for(let i = 0; i < 2; i++){
                let x = entity.x + entity.random.nextGaussian() * 0.02
                let y = entity.y + entity.random.nextGaussian() * 0.02
                let z = entity.z + entity.random.nextGaussian() * 0.02
                entity.level.addParticle("minecraft:large_smoke", entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 0, 0, 0)
            }
        }
        if(pData.nextHeightOffsetChangeTick <= 0){
            pData.nextHeightOffsetChangeTick = 100;
            pData.allowedHeightOffset = entity.random.triangle(0.5, 1.5)
        }
        let target = entity.getTarget()
        if(target != null && target.getEyeHeight() > entity.getEyeHeight() + pData.allowedHeightOffset && entity.canAttack(target)){
            let vec3 = entity.getDeltaMovement()
            entity.setDeltaMovement(entity.getDeltaMovement().add(0, (0.3 - vec3.y), 0))
        }
    },
    render: context => {

        let x = 1.5
        let y = 2
        let z = 1.5
        return context.poseStack.scale(x, y, z);
    },
    onAddedToWorld: entity => {
        entity.maxHealth = 200;
        entity.health = 200;
        entity.aggressive = true;
        let pData = entity.getPersistentData()
        pData.buffTrigger = 75
        pData.spawn = {}
        pData.spawn.x = entity.x
        pData.spawn.y = entity.y
        pData.spawn.z = entity.z
        pData.nextHeightOffsetChangeTick = 0
        pData.allowedHeightOffset = 0

        entity.setAggressive(true)

        
    },
    tick: entity => {

        if(entity.health < entity.maxHealth/2){
            entity.setAggressive(true)
        }
        // Health Regen (0.5% per second)
        if(entity.age % 20 == 0 && entity.health < entity.maxHealth && entity.health > 0){
            entity.health += entity.maxHealth/200
        }
    },
    onHurt: ctx => {
        const {entity, damageSource, damageAmount} = ctx;
        if(entity.health-damageAmount <= 0) return;

        if(!damageSource.isProjectile()){

            let randomChance = Math.floor(Math.random() * 100)
            if(randomChance < 50){
                entity.triggerAnimation("exampleController", "spin")
                let flameParticle = new Particle("minecraft:flame")
                flameParticle.range = 3;
                flameParticle.vSpread = 1;
                flameParticle.yOffset = 2;
                flameParticle.hSpread = 0.5;
                flameParticle.amount = 50;
                flameParticle.attack = true;
                flameParticle.attackDamage = 10;
                Utils.server.scheduleInTicks(20, event => {
                    global.attacks.castCircleWall(entity, flameParticle)
                })
            }
            
        }
        console.log(entity.health/entity.maxHealth*100, entity.persistentData.buffTrigger)
        if((entity.health/entity.maxHealth)*100 < entity.persistentData.buffTrigger){
            entity.persistentData.buffTrigger -= 25
            global.attacks.summonAds(entity, 'minecraft:blaze', 4, 5)
        }

    },
    onDeath: ctx => {
        const {entity, damageSource} = ctx;
        global.attacks.castParticleBall(entity, new Particle('minecraft:large_smoke'), 2)
    }
}


global.spawnAnimation = entity => {

    let smokeParticle = new Particle('minecraft:large_smoke')
    let flameParticle = new Particle('minecraft:flame')
    
    let delay = 5
    let ballrange = 2
    smokeParticle.hSpread = 0.2
    smokeParticle.vSpread = 0.2
    let castingBlock = entity.level.getBlock(entity.x-1, entity.y, entity.z)
    Utils.server.scheduleInTicks(20, event => {entity.playSound("minecraft:entity.wither.ambient", 1, 1)})
    const {x, y, z} = entity
    Utils.server.scheduleInTicks(40, event=>{

        entity.getLevel().getEntitiesWithin(AABB.of(x - 20, y - 20, z - 20, x + 20, y + 20, z + 20)).forEach(entity => {
            if (entity.isPlayer()) {
                let distance = entity.getDistance(x, y, z)
                distance = 20 - distance
                distance = distance / 20 * 2
                // entity.sendData('screenshake', { i1: distance * 0.6, i2: distance, i3: distance * 0.2, duration: 15 })
                global.pushBack(castingBlock, entity, 3, 0.6)
    
            }
    
        })
        let size = 0
        for (let j = 0; j < 8; j++) {
            Utils.server.scheduleInTicks(delay*j/2, event =>{
                size++;
                castParticleBall(entity, flameParticle, ballrange+size)
                castParticleBall(entity, smokeParticle, ballrange+size)
    
            })
            if(j >= 6){
                Utils.server.scheduleInTicks(delay*j/2, event =>{
                    castParticleBall(entity, smokeParticle, ballrange+size)
    
                    // server.runCommandSilent(`execute at @e[type=customnpcs:customnpc] in minecraft:the_end run playsound minecraft:entity.wither.death master @p[distance=..25]`)
    
                    // player.playSound('minecraft:entity.generic.explode')
    
                })
            }
        }
    })

}

