const $smallFireBall = Java.loadClass("net.minecraft.world.entity.projectile.SmallFireball")

global.FrontVectors = (entity, dr, dp, distance, mode) => {
    const angle = mode === 1 ? dr + entity.yaw : dr;
    const pitch = (mode === 1 ? -entity.pitch + dp : dp) * JavaMath.PI / 180;

    const dx = -Math.sin(angle * JavaMath.PI / 180) * (distance * Math.cos(pitch));
    const dy = Math.sin(pitch) * distance;
    const dz = Math.cos(angle * JavaMath.PI / 180) * (distance * Math.cos(pitch));

    return [dx, dy, dz];
};
global.GetPlayerRotation = (npc, player) => {
	let dx = npc.x - player.x;
	let dz = player.z - npc.z;
	let angle = 0
	if (dz >= 0) {
		angle = Math.atan(dx / dz) * 180 / JavaMath.PI;
		angle = angle < 0 ? 360 + angle : angle;
	} else {
		angle = 180 - (Math.atan(dx / dz) * 180 / JavaMath.PI);
	}
	return angle;
}


global.pushBack = (npc, player, Intensity, Height) => {
    let d = global.FrontVectors(npc, global.GetPlayerRotation(npc, player), 0, Intensity, 0)
    player.addMotion(d[0], Height, d[2])
    player.hurtMarked = true

}
global.lerp = (start, end, t) => {
    return start * (1 - t) + end * t;
}

function castParticleBall(entity, particle, radius){
    let heightOffset = 5; // in case you want it above you
    let resolution = 15 //resolution of the line

    for (let i = 0; i <= 360; i += resolution) {
        let horizontalAngle = i * JavaMath.PI / 180;

        for (let j = 0; j <= 180; j += resolution) {
            let verticalAngle = j * JavaMath.PI / 180;
            let d = Dvectors(horizontalAngle, verticalAngle, radius, entity);
            particle.hSpread = 0.5
            particle.vSpread = 0.5
            particle.cast({x:d[0], y:entity.y + heightOffset + d[1], z:d[2], level:{dimension:entity.level.dimension}})
        }
    }
}
function Dvectors(horizontalAngle, verticalAngle, radius, pos) {
	let x = radius * Math.sin(verticalAngle) * Math.cos(horizontalAngle) + pos.x;
	let y = radius * Math.cos(verticalAngle);
	let z = radius * Math.sin(verticalAngle) * Math.sin(horizontalAngle) + pos.z;
	return [x, y, z];
}
global.TrueDistanceCoord = (x1, y1, z1, x2, y2, z2) => {
    var dx = x1 - x2
    var dy = y1 - y2
    var dz = z1 - z2
    var R = Math.pow((dx * dx + dy * dy + dz * dz), 0.5)
    return R;
}
global.particleLine = (entity, pos1, pos2, resolution, speed, particle, damage) => {
    damage = damage ?? false;

    let particleTotal = Math.round(global.TrueDistanceCoord(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z) * resolution)
    // console.log(particleTotal)
    let data = 0
    for(let i = 0; i < particleTotal; i++){
        Utils.server.scheduleInTicks(i*speed, event => {

            let x = (pos1.x + (pos2.x - pos1.x) * data / particleTotal).toFixed(2)
            let y = (pos1.y + (pos2.y - pos1.y) * data / particleTotal).toFixed(2)
            let z = (pos1.z + (pos2.z - pos1.z) * data / particleTotal).toFixed(2)
            particle.cast({x:x, y:y, z:z, level:{dimension:entity.level.dimension}})
            if(damage){
                entity.level.getEntitiesWithin(AABB.of(
                    x - particle.attackRange, y - particle.attackRange, z - particle.attackRange, 
                    x + particle.attackRange, y + particle.attackRange, z + particle.attackRange
                    )).forEach(attacked => {
                        if(attacked != entity){
                            attacked.attack(entity, particle.attackDamage)
                            // global.pushBack(entity, attacked, 3, 0.6)
                        }
                })
            }
            data+
            data++
    
        })


    }

}
global.getNearbyPlayers = (entity, range) => {
    const {x, y, z} = entity
    let players = []
    entity.getLevel().getEntitiesWithin(AABB.of(x - range, y - range, z - range, x + range, y + range, z + range)).forEach(entity => {
        if (entity.isPlayer()) {
            players.push(entity)
        }
    })
    return players
    
}

/**
 * Represents a particle with various attributes and methods for casting and attacking.
 * @constructor
 * @param {string} type - The type of particle.
 */
function Particle(type) {
	// Particle Attributes
	this.type = type ?? "minecraft:dust"
	this.color = 0xffffff
	this.endcolor = 0xffffff
	this.size = 1
	this.material = "minecraft:dirt"
	this.amount = 1
	this.hSpread = 0
	this.vSpread = 0
	this.speed = 0
	this.xOffset = 0
	this.zOffset = 0
	this.yOffset = 0

	// Casting Attributes
	this.delay = 0
	this.x = 0
	this.y = 0
	this.z = 0
	this.range = 0
	this.debug = false

	// Attacking Attributes
	this.attack = false  //attack default false, set to true, to hurt other entities
	this.attackDamage = 1
	this.attackRange = 2

	this.cast = function (caster) {
		this.x = caster.x + this.xOffset
		this.y = caster.y + this.yOffset
		this.z = caster.z + this.zOffset
		let dimension = caster.level.dimension
		switch (this.type) {
			case 'minecraft:dust': {
				this.type = this.type + " " + hexToNormalizedColor(this.color) + " " + this.size
				break
			}
			case 'minecraft:dust_color_transition': {
				this.type = this.type + " " + hexToNormalizedColor(this.color) + " " + this.size + " " + hexToNormalizedColor(this.endcolor)
				break
			}
			case 'minecraft:block':
			case 'minecraft:block_marker':
			case 'minecraft:falling_dust':
			case 'minecraft:item': {
				this.type = this.type + " " + this.material
				break
			}
		}

		let command = `execute in ${dimension} run particle ${this.type} ${this.x} ${this.y} ${this.z} ${this.hSpread} ${this.vSpread} ${this.hSpread} ${this.speed} ${this.amount} force`
		if (this.debug) console.log(command)
		Utils.server.runCommandSilent(command)

	}

}

global.inspect = (obj) => {
  if (typeof obj !== 'undefined') {
    let resultArray = []

    let propertiesArray = []
    let functionsArray = []
    Object.keys(obj).forEach(key => {
        let keyType = typeof obj[key]
        if (keyType === 'string' || keyType === 'number' || keyType === 'object') {
            propertiesArray.push(`  ${key}: ${obj[key]}`)
        } else if (keyType === 'function' && !key.startsWith('func_')) {
            functionsArray.push(`  ${key}: unknown`)
        } else if (keyType === 'undefined') {
            propertiesArray.push(`  ${key}: undefined`)
        }
    })

    propertiesArray.sort()
    propertiesArray.unshift('=== Properties ===')
    functionsArray.sort()
    functionsArray.unshift('=== Functions ===')

    resultArray.push(propertiesArray.join('\n'))
    resultArray.push(functionsArray.join('\n'))
    console.info(resultArray.join('\n'))
  } else console.info('inspected object is undefined')
}

global.attacks ={

    /**
     * Casts a circle wall of particles around an entity.
     * @param {Internal.BaseLivingEntityJSBuilder} entity - The entity around which the circle wall is cast.
     * @param {Object} particle - The particle object.
     */
    castCircleWall: (entity, particle) => {
        let data = 0;
        for (let angle = 0; angle < 360; angle += 10) {
            Utils.server.scheduleInTicks(angle / 20, event => {
                particle.xOffset = -Math.sin(data * 10 * JavaMath.PI / 180) * particle.range;
                particle.zOffset = Math.cos(data * 10 * JavaMath.PI / 180) * particle.range;
                particle.cast(entity);
                const {x, y, z, attackRange, attackDamage} = particle;
                entity.level.getEntitiesWithin(AABB.of(
                    x - attackRange, y - attackRange, z - attackRange, 
                    x + attackRange, y + attackRange, z + attackRange
                    )).forEach(attacked => {
                        if(attacked.isPlayer()){
                            attacked.attack(entity, attackDamage)
                            global.pushBack(entity, attacked, 50, 0.3)
                        }
                })
                data++;
            });
        }
    },
    magicSlash: (entity, particle) =>{
        let linesBefore = 5; 
        let linesAfter = 2;
        let lines = [];
        let resolution = 10;
        let speed = 0.2;
        let p1 = new Particle("minecraft:large_smoke");
        
        let p2 = new Particle("minecraft:flame");
        p2.hSpread = 0.2;
        p2.vSpread = 2;
        p2.yOffset = 1;
        p2.amount = 100;

        let target = entity.getTarget();
        if(target == null) return;

        for(let i = 0; i < linesBefore+linesAfter; i++){
            let lerpX = Math.floor(global.lerp(entity.x, target.x, i/(linesBefore)));
            let lerpZ = Math.floor(global.lerp(entity.z, target.z, i/(linesBefore)));
            let lerpY = Math.floor(global.lerp(entity.y, target.y, i/(linesBefore)));

            let x1 = lerpX + (Math.floor(Math.random() *2)+2) * (Math.round(Math.random() * 2 - 1));
            let z1 = lerpZ + (Math.floor(Math.random() *2)+2) * (Math.round(Math.random() * 2 - 1))
            let x2 = lerpX + (Math.floor(Math.random() *2)+2) * (Math.round(Math.random() * 2 - 1))
            let z2 = lerpZ + (Math.floor(Math.random() *2)+2) * (Math.round(Math.random() * 2 - 1))

            lines.push({x1:x1, z1:z1, x2:x2, z2:z2});
        }
        let data = 0;
        for(let i  = 0; i < lines.length; i++){
            Utils.server.scheduleInTicks(i*2, event => {
                global.particleLine(entity, {x:lines[data].x1, y:target.y+0.1, z:lines[data].z1}, {x:lines[data].x2, y:target.y+0.1, z:lines[data].z2}, resolution, speed, p1);
                
                let data2 = data;
                Utils.server.scheduleInTicks(20, callback => {
                    global.particleLine(entity, {x:lines[data2].x1, y:target.y+0.5, z:lines[data2].z1}, {x:lines[data2].x2, y:target.y+0.5, z:lines[data2].z2}, resolution, speed, p2, true)
                })
                
                data++;
            })
        }
    },
    magmaBlocks: (entity, particle) => {
        let randomBlocks = []
        let fallingBlocks = []
        let originalBlocks = []
        let amount = 20;
        let playerSearchRange = 64;
        let magmaBlockRange = 10;
        let tries = 50;
        particle.amount = 20;
        particle.speed = 0.1
        let players = global.getNearbyPlayers(entity, playerSearchRange);
        while(randomBlocks.length < amount){
            let randomPlayer = players[Math.floor(Math.random() * players.length)];
            if(randomPlayer.length == 0) return;
            let randomX = Math.floor(randomPlayer.x + (Math.random() * magmaBlockRange * (Math.random() < 0.5 ? -1 : 1)));
            let randomZ = Math.floor(randomPlayer.z + (Math.random() * magmaBlockRange * (Math.random() < 0.5 ? -1 : 1)));
            let randomBlock = randomPlayer.level.getBlock(randomX, randomPlayer.y-1, randomZ);
            if(randomBlock.up.id == 'minecraft:air' && randomBlock.id != 'minecraft:air' && randomBlock.id != 'minecraft:magma_block'){
                randomBlocks.push(randomBlock);
                originalBlocks.push(randomBlock.id)

                let fallingBlockEntity = entity.level.createEntity('minecraft:falling_block')
                fallingBlockEntity.setNoGravity(true)
                fallingBlockEntity.x = randomX+0.5;
                fallingBlockEntity.y = randomPlayer.y;
                fallingBlockEntity.z = randomZ+0.5;
                let nbt = fallingBlockEntity.nbt
                nbt.BlockState = {Name: randomBlock.id}
                nbt.Motion = [0, 0.1, 0]
                fallingBlockEntity.nbt = nbt
                fallingBlocks.push(fallingBlockEntity)
            }else{
                tries--;
                if(tries <= 0){
                    break;
                }
            }
        }
        let delay = 5
        randomBlocks.forEach(block =>{
            Utils.server.scheduleInTicks(delay, callback =>{
    
                particle.cast({x:block.x, y:block.y+0.5, z:block.z, level:{dimension:entity.level.dimension}})
                Utils.server.scheduleInTicks(10, callback =>{
                    let fallingBlock = fallingBlocks[randomBlocks.indexOf(block)]
                    fallingBlock.spawn()
                    let lavaOrMagma = Math.random() < 0.1 ? 'minecraft:lava' : 'minecraft:magma_block'
                    block.set(lavaOrMagma)
                    Utils.server.scheduleInTicks(100, callback =>{
                        let randomPlayer = players[Math.floor(Math.random() * players.length)];

                        let d = fallingBlock.distanceToSqr(randomPlayer)
                        let x = randomPlayer.x - fallingBlock.x
                        let y = randomPlayer.y - fallingBlock.y
                        let z = randomPlayer.z - fallingBlock.z
                        let h = JavaMath.sqrt(JavaMath.sqrt(d) * 0.5)
                        let smallFireBall = new $smallFireBall(entity.level, entity, entity.getRandom().triangle(x, 2.297 * h), y, entity.getRandom().triangle(z, 2.297 * h))
                        smallFireBall.setPos(fallingBlock.x, fallingBlock.y, fallingBlock.z)
                        mob.playSound("minecraft:entity.blaze.shoot", 1.0 + mob.random.nextFloat(), mob.random.nextFloat() * 0.7 + 0.3)
                        entity.level.addFreshEntity(smallFireBall)


                        fallingBlock.discard()
                    })
                })
            })

            delay+=4;
            Utils.server.scheduleInTicks(400, callback =>{
                block.set(originalBlocks[randomBlocks.indexOf(block)])
            })
        })

    },
    castParticleBall: (entity, particle, radius) => {
        let heightOffset = 2; // in case you want it above you
        let resolution = 15 //resolution of the line
    
        for (let i = 0; i <= 360; i += resolution) {
            let horizontalAngle = i * JavaMath.PI / 180;
    
            for (let j = 0; j <= 180; j += resolution) {
                let verticalAngle = j * JavaMath.PI / 180;
                let d = Dvectors(horizontalAngle, verticalAngle, radius, entity);
                particle.hSpread = 0.5
                particle.vSpread = 0.5
                particle.cast({x:d[0], y:entity.y + heightOffset + d[1], z:d[2], level:{dimension:entity.level.dimension}})
            }
        }
    },
    summonAds: (entity, ad, range, amount) => {
        let maxTries = 50;
        let spawned = 0;

        while(spawned < amount){
            let randomX = Math.floor(entity.x + (Math.random() * range * (Math.random() < 0.5 ? -1 : 1)));
            let randomZ = Math.floor(entity.z + (Math.random() * range * (Math.random() < 0.5 ? -1 : 1)));
            let randomY = Math.floor(entity.y + (Math.random() * range * (Math.random() < 0.5 ? -1 : 1)));
            if(isSpawnable(entity.level, {x:randomX, y:entity.y, z:randomZ}))
            {
                let adEntity = entity.level.createEntity(ad)
                adEntity.x = randomX
                adEntity.z = randomZ
                adEntity.y = entity.y
                adEntity.spawn()
                spawned++;
            }
            maxTries--;
            if(maxTries <= 0){
                console.log(`Could not spawn ${amount-spawned} ${ad} entities`)
                break;
            }
        }
        
    }
}
function isSpawnable(level, pos){
    let block = level.getBlock(pos.x, pos.y-1, pos.z)
    console.log(block.id, block.up.id, block.up.up.id)
    if(block != 'minecraft:air' && block.up.id == 'minecraft:air' && block.up.up.id == 'minecraft:air'){
        return true;
    }
    return false;

}