// priority: 1000

function checkForBlockInCube(targetBlock, level, cubeSize, sx, sy, sz) {
  for (let x = -Math.abs(cubeSize); x <= cubeSize; x++) {
    for (let y = -Math.abs(cubeSize); y <= cubeSize; y++) {
      for (let z = -Math.abs(cubeSize); z <= cubeSize; z++) {
        const block = level.getBlock(sx + x, sy + y, sz + z);
        if (block.id === targetBlock) {
          return block;
        }
      }
    }
  }
  return "";
}

function swapItem(player, oldItem, newItem) {
  const inventory = player.inventory;
  for (let i = 0; i < inventory.containerSize; i++) {
    if (inventory.getItem(i) === oldItem) {
      inventory.setItem(i, newItem);
    }
  }
  player.sendInventoryUpdate();
}

global["unUnified"] = [
  "ad_astra:coal_generator",
  "ad_astra:compressor",
  "ad_astra:solar_panel",
  "ad_astra:steel_ingot",
  "ae2:calculation_processor_press",
  "jaopca:storage_blocks.obsidian",
  "ae2:charger",
  "ae2:crank",
  "mekanism:oredictionificator",
  "ae2:engineering_processor_press",
  "ae2:logic_processor_press",
  "ae2:silicon_press",
  "thermal:rf_potato",
  "ae2:tiny_tnt",
  "ars_creo:starbuncle_wheel",
  "botania:floating_orechid_ignem",
  "botania:floating_orechid",
  "botania:mana_fluxfield",
  "mekanismtools:steel_helmet",
  "mekanismtools:steel_boots",
  "mekanismtools:steel_chestplate",
  "mekanismtools:steel_leggings",
  "botania:orechid_ignem",
  "mekanism:dust_quartz",
  "create:large_water_wheel",
  "botania:orechid",
  "botanicadds:elven_fluxfield",
  "create:crushed_raw_aluminum",
  "create:crushed_raw_copper",
  "create:crushed_raw_gold",
  "create:crushed_raw_iron",
  "create:crushed_raw_lead",
  "create:crushed_raw_nickel",
  "create:crushed_raw_osmium",
  "create:crushed_raw_silver",
  "create:crushed_raw_tin",
  "mekanism:raw_tin",
  "cataclysm:mech_eye",
  "create:crushed_raw_uranium",
  "create:crushed_raw_zinc",
  "create:crushing_wheel",
  "create:deepslate_zinc_ore",
  "createaddition:alternator",
  "createaddition:modular_accumulator",
  "createastracompat:crushed_calorite_ore",
  "createastracompat:crushed_ostrum_ore",
  "createsifter:advanced_brass_mesh",
  "createsifter:advanced_custom_mesh",
  "createsifter:brass_mesh",
  "createsifter:custom_mesh",
  "createsifter:zinc_mesh",
  "create_new_age:basic_motor",
  "create_new_age:advanced_motor",
  "create_new_age:reinforced_motor",
  "create_new_age:basic_motor_extension",
  "create_new_age:advanced_motor_extension",
  "cyclic:apple_ender",
  "cyclic:battery_clay",
  "cyclic:battery",
  "cyclic:cask",
  "cyclic:conveyor",
  "cyclic:crusher",
  "cyclic:ender_eye_reuse",
  "cyclic:energy_pipe",
  "cyclic:fluid_pipe",
  "cyclic:forester",
  "cyclic:generator_fluid",
  "cyclic:generator_food",
  "cyclic:generator_fuel",
  "cyclic:generator_solar",
  "cyclic:harvester",
  "cyclic:item_pipe",
  "cyclic:spikes_curse",
  "cyclic:spikes_diamond",
  "cyclic:spikes_fire",
  "cyclic:spikes_iron",
  "dankstorage:1_to_2",
  "dankstorage:2_to_3",
  "dankstorage:3_to_4",
  "dankstorage:4_to_5",
  "dankstorage:5_to_6",
  "dankstorage:6_to_7",
  "dankstorage:dock",
  "dankstorage:red_print",
  "easy_villagers:breeder",
  "easy_villagers:converter",
  "easy_villagers:farmer",
  "easy_villagers:iron_farm",
  "elementalcraft:artificial_air_source_seed",
  "elementalcraft:artificial_earth_source_seed",
  "elementalcraft:artificial_fire_source_seed",
  "elementalcraft:artificial_water_source_seed",
  "elementalcraft:broken_source_displacement_plate",
  "elementalcraft:deepslate_inert_crystal_ore",
  "elementalcraft:element_holder_air",
  "elementalcraft:element_holder_earth",
  "elementalcraft:element_holder_fire",
  "elementalcraft:element_holder_water",
  "elementalcraft:extractor_improved",
  "elementalcraft:extractor",
  "elementalcraft:natural_air_source_seed",
  "elementalcraft:natural_earth_source_seed",
  "elementalcraft:natural_fire_source_seed",
  "elementalcraft:natural_water_source_seed",
  "elementalcraft:pure_element_holder_core",
  "elementalcraft:pure_element_holder",
  "elementalcraft:source_breeder_pedestal",
  "elementalcraft:source_breeder",
  "elementalcraft:source_displacement_plate_air",
  "elementalcraft:source_displacement_plate_earth",
  "elementalcraft:source_displacement_plate_fire",
  "elementalcraft:source_displacement_plate_water",
  "elementalcraft:source",
  "forcecraft:deepslate_power_ore",
  "forcecraft:force_engine",
  "forcecraft:heat_core",
  "forcecraft:power_ore",
  "ftbsba:stone_crook",
  "immersiveengineering:capacitor_hv",
  "immersiveengineering:capacitor_lv",
  "immersiveengineering:capacitor_mv",
  "immersiveengineering:deepslate_ore_aluminum",
  "immersiveengineering:dynamo",
  "immersiveengineering:generator",
  "immersiveengineering:thermoelectric_generator",
  "immersiveengineering:watermill",
  "immersiveengineering:waterwheel_segment",
  "immersiveengineering:windmill_blade",
  "immersiveengineering:windmill_sail",
  "immersiveengineering:windmill",
  "industrialforegoing:biofuel_generator",
  "industrialforegoing:bioreactor",
  "industrialforegoing:black_hole_controller",
  "industrialforegoing:fluid_sieving_machine",
  "industrialforegoing:laser_lens0",
  "industrialforegoing:laser_lens11",
  "industrialforegoing:laser_lens12",
  "industrialforegoing:laser_lens13",
  "industrialforegoing:laser_lens2",
  "industrialforegoing:laser_lens5",
  "industrialforegoing:laser_lens7",
  "industrialforegoing:laser_lens8",
  "industrialforegoing:laser_lens9",
  "industrialforegoing:mycelial_crimed",
  "industrialforegoing:mycelial_culinary",
  "industrialforegoing:mycelial_death",
  "industrialforegoing:mycelial_disenchantment",
  "industrialforegoing:mycelial_ender",
  "industrialforegoing:mycelial_explosive",
  "industrialforegoing:mycelial_frosty",
  "industrialforegoing:mycelial_furnace",
  "industrialforegoing:mycelial_halitosis",
  "industrialforegoing:mycelial_magma",
  "industrialforegoing:mycelial_meatallurgic",
  "industrialforegoing:mycelial_netherstar",
  "industrialforegoing:mycelial_pink",
  "industrialforegoing:mycelial_potion",
  "industrialforegoing:mycelial_reactor",
  "industrialforegoing:mycelial_rocket",
  "industrialforegoing:mycelial_slimey",
  "industrialforegoing:pitiful_generator",
  "industrialforegoing:washing_factory",
  "integrateddynamics:coal_generator",
  "integrateddynamics:energy_battery",
  "integrateddynamics:part_entity_writer",
  "integrateddynamics:part_inventory_writer",
  "integrateddynamics:part_machine_writer",
  "integratedterminals:part_terminal_crafting_job",
  "integratedterminals:terminal_storage_portable",
  "jaopca:gears.brick",
  "jaopca:gears.calorite",
  "jaopca:gears.drenched_iron",
  "jaopca:gears.elementium",
  "jaopca:gears.fireite",
  "jaopca:gears.hop_graphite",
  "jaopca:gears.iesnium",
  "jaopca:gears.manganese",
  "jaopca:gears.nether_brick",
  "jaopca:gears.osmium",
  "jaopca:gears.ostrum",
  "jaopca:gears.refined_glowstone",
  "jaopca:gears.refined_obsidian",
  "jaopca:gears.shaka",
  "jaopca:gears.terrasteel",
  "jaopca:gears.unstable",
  "jaopca:gears.uranium",
  "jaopca:gears.zinc",
  "jaopca:plates.brick",
  "jaopca:plates.fireite",
  "jaopca:plates.hop_graphite",
  "jaopca:plates.iesnium",
  "jaopca:plates.manganese",
  "jaopca:plates.manganese",
  "jaopca:plates.nether_brick",
  "jaopca:plates.refined_glowstone",
  "jaopca:plates.shaka",
  "jaopca:plates.shaka",
  "jaopca:plates.terrasteel",
  "jaopca:processors.aluminum",
  "jaopca:processors.azurite",
  "jaopca:processors.iesnium",
  "jaopca:raw_storage_blocks.iesnium",
  "jaopca:rods.brick",
  "jaopca:rods.bronze",
  "jaopca:rods.calorite",
  "jaopca:rods.compressed_iron",
  "jaopca:rods.constantan",
  "jaopca:rods.drenched_iron",
  "jaopca:rods.elementium",
  "jaopca:rods.enderium",
  "jaopca:rods.fireite",
  "jaopca:rods.hop_graphite",
  "jaopca:rods.iesnium",
  "jaopca:rods.lead",
  "jaopca:rods.lumium",
  "jaopca:rods.manasteel",
  "jaopca:rods.manganese",
  "jaopca:rods.nether_brick",
  "jaopca:rods.netherite",
  "jaopca:rods.nickel",
  "jaopca:rods.osmium",
  "jaopca:rods.ostrum",
  "jaopca:rods.refined_glowstone",
  "jaopca:rods.refined_obsidian",
  "jaopca:rods.shaka",
  "jaopca:rods.signalum",
  "jaopca:rods.silver",
  "jaopca:rods.swift_alloy",
  "jaopca:rods.terrasteel",
  "jaopca:rods.tin",
  "jaopca:rods.unstable",
  "jaopca:rods.uranium",
  "jaopca:rods.zinc",
  "mekanism:block_raw_osmium",
  "mekanism:deepslate_fluorite_ore",
  "mekanism:deepslate_osmium_ore",
  "mekanism:deepslate_tin_ore",
  "mekanism:deepslate_uranium_ore",
  "mekanism:fluorite_ore",
  "mekanism:osmium_ore",
  "mekanism:raw_osmium",
  "mekanismgenerators:bio_generator",
  "mekanismgenerators:gas_burning_generator",
  "mekanismgenerators:heat_generator",
  "mekanismgenerators:solar_generator",
  "mekanismgenerators:wind_generator",
  "minecraft:deepslate_coal_ore",
  "minecraft:deepslate_copper_ore",
  "minecraft:deepslate_diamond_ore",
  "minecraft:deepslate_emerald_ore",
  "minecraft:deepslate_gold_ore",
  "minecraft:deepslate_iron_ore",
  "minecraft:deepslate_lapis_ore",
  "minecraft:deepslate_redstone_ore",
  "mob_grinding_utils:entity_spawner",
  "mob_grinding_utils:fan_upgrade_height",
  "mob_grinding_utils:fan_upgrade_speed",
  "mob_grinding_utils:fan_upgrade_width",
  "mob_grinding_utils:fan",
  "mob_grinding_utils:gm_chicken_feed",
  "mob_grinding_utils:golden_egg",
  "mob_grinding_utils:jumbo_tank",
  "mob_grinding_utils:mob_swab_used",
  "mob_grinding_utils:mob_swab",
  "mob_grinding_utils:null_sword",
  "mob_grinding_utils:rotten_egg",
  "mob_grinding_utils:spawner_upgrade_height",
  "mob_grinding_utils:spawner_upgrade_width",
  "mob_grinding_utils:tank_sink",
  "mob_grinding_utils:tank",
  "occultism:miner_afrit_deeps",
  "occultism:miner_djinni_ores",
  "occultism:miner_marid_master",
  "pedestals:upgrade_pedestal_generator",
  "pneumaticcraft:advanced_air_compressor",
  "pneumaticcraft:advanced_liquid_compressor",
  "pneumaticcraft:air_compressor",
  "pneumaticcraft:amadron_tablet",
  "pneumaticcraft:electrostatic_compressor",
  "pneumaticcraft:liquid_compressor",
  "pneumaticcraft:manual_compressor",
  "pneumaticcraft:pneumatic_dynamo",
  "pneumaticcraft:solar_compressor",
  "pneumaticcraft:thermal_compressor",
  "powah:aerial_pearl",
  "powah:battery_basic",
  "powah:battery_blazing",
  "powah:battery_hardened",
  "powah:battery_niotic",
  "powah:battery_nitro",
  "powah:battery_spirited",
  "powah:battery_starter",
  "powah:binding_card_dim",
  "powah:binding_card",
  "powah:blank_card",
  "powah:book",
  "powah:deepslate_uraninite_ore_dense",
  "powah:deepslate_uraninite_ore_poor",
  "powah:deepslate_uraninite_ore",
  "powah:ender_cell_basic",
  "powah:ender_cell_blazing",
  "powah:ender_cell_hardened",
  "powah:ender_cell_niotic",
  "powah:ender_cell_nitro",
  "powah:ender_cell_spirited",
  "powah:ender_cell_starter",
  "powah:ender_gate_basic",
  "powah:ender_gate_blazing",
  "powah:ender_gate_hardened",
  "powah:ender_gate_niotic",
  "powah:ender_gate_nitro",
  "powah:ender_gate_spirited",
  "powah:ender_gate_starter",
  "powah:energy_cable_basic",
  "powah:energy_cable_blazing",
  "powah:energy_cable_hardened",
  "powah:energy_cable_niotic",
  "powah:energy_cable_nitro",
  "powah:energy_cable_spirited",
  "powah:energy_cable_starter",
  "powah:energy_cell_basic",
  "powah:energy_cell_blazing",
  "powah:energy_cell_creative",
  "powah:energy_cell_hardened",
  "powah:energy_cell_niotic",
  "powah:energy_cell_nitro",
  "powah:energy_cell_spirited",
  "powah:energy_cell_starter",
  "powah:energy_discharger_basic",
  "powah:energy_discharger_blazing",
  "powah:energy_discharger_hardened",
  "powah:energy_discharger_niotic",
  "powah:energy_discharger_nitro",
  "powah:energy_discharger_spirited",
  "powah:energy_discharger_starter",
  "powah:energy_hopper_basic",
  "powah:energy_hopper_blazing",
  "powah:energy_hopper_hardened",
  "powah:energy_hopper_niotic",
  "powah:energy_hopper_nitro",
  "powah:energy_hopper_spirited",
  "powah:energy_hopper_starter",
  "powah:furnator_basic",
  "powah:furnator_blazing",
  "powah:furnator_hardened",
  "powah:furnator_niotic",
  "powah:furnator_nitro",
  "powah:furnator_spirited",
  "powah:furnator_starter",
  "powah:lens_of_ender",
  "powah:magmator_basic",
  "powah:magmator_blazing",
  "powah:magmator_hardened",
  "powah:magmator_niotic",
  "powah:magmator_nitro",
  "powah:magmator_spirited",
  "powah:magmator_starter",
  "powah:photoelectric_pane",
  "powah:player_aerial_pearl",
  "powah:player_transmitter_basic",
  "powah:player_transmitter_blazing",
  "powah:player_transmitter_hardened",
  "powah:player_transmitter_niotic",
  "powah:player_transmitter_nitro",
  "powah:player_transmitter_spirited",
  "powah:player_transmitter_starter",
  "powah:reactor_basic",
  "powah:reactor_blazing",
  "powah:reactor_hardened",
  "powah:reactor_niotic",
  "powah:reactor_nitro",
  "powah:reactor_spirited",
  "powah:reactor_starter",
  "powah:solar_panel_basic",
  "powah:solar_panel_blazing",
  "powah:solar_panel_hardened",
  "powah:solar_panel_niotic",
  "powah:solar_panel_nitro",
  "powah:solar_panel_spirited",
  "powah:solar_panel_starter",
  "powah:thermo_generator_basic",
  "powah:thermo_generator_blazing",
  "powah:thermo_generator_hardened",
  "powah:thermo_generator_niotic",
  "powah:thermo_generator_nitro",
  "powah:thermo_generator_spirited",
  "powah:thermo_generator_starter",
  "powah:uraninite_ore_dense",
  "powah:uraninite_ore_poor",
  "powah:uraninite_ore",
  "powah:uraninite_raw",
  "powah:uraninite",
  "productivebees:acacia_wood_nest",
  "productivebees:bamboo_hive",
  "productivebees:birch_wood_nest",
  "productivebees:catcher",
  "productivebees:centrifuge",
  "productivebees:coarse_dirt_nest",
  "productivebees:crimson_bee_nest",
  "productivebees:dark_oak_wood_nest",
  "productivebees:end_stone_nest",
  "productivebees:glowstone_nest",
  "productivebees:gravel_nest",
  "productivebees:heated_centrifuge",
  "productivebees:honey_generator",
  "productivebees:jungle_wood_nest",
  "productivebees:nest_locator",
  "productivebees:nether_brick_nest",
  "productivebees:nether_gold_nest",
  "productivebees:nether_quartz_nest",
  "productivebees:oak_wood_nest",
  "productivebees:obsidian_nest",
  "productivebees:sand_nest",
  "productivebees:slimy_nest",
  "productivebees:snow_nest",
  "productivebees:soul_sand_nest",
  "productivebees:spruce_wood_nest",
  "productivebees:stone_nest",
  "productivebees:sugar_cane_nest",
  "productivebees:sugarbag_nest",
  "productivebees:warped_bee_nest",
  "refinedstorage:silicon",
  "rftoolsstorage:storage_module6",
  "rftoolsutility:matter_beamer",
  "rftoolsutility:peaceful_module",
  "rftoolsutility:spawner",
  "supplementaries:flint_block",
  "technobauble:charger",
  "technobauble:receiver",
  "thermal:bamboo_block",
  "thermal:bronze_coin",
  "thermal:constantan_coin",
  "thermal:copper_coin",
  "thermal:deepslate_cinnabar_ore",
  "thermal:deepslate_nickel_ore",
  "thermal:deepslate_niter_ore",
  "thermal:deepslate_silver_ore",
  "thermal:deepslate_sulfur_ore",
  "thermal:dynamo_compression",
  "thermal:dynamo_disenchantment",
  "thermal:dynamo_fuel_augment",
  "thermal:dynamo_gourmand",
  "thermal:dynamo_lapidary",
  "thermal:dynamo_magmatic",
  "thermal:dynamo_numismatic",
  "thermal:dynamo_output_augment",
  "thermal:dynamo_stirling",
  "thermal:dynamo_throttle_augment",
  "thermal:gold_coin",
  "thermal:iron_coin",
  "thermal:lead_coin",
  "thermal:netherite_coin",
  "thermal:nickel_coin",
  "thermal:silver_coin",
  "thermal:tin_coin",
  "thermal:tin_plate",
  "mekanism:fuelwood_heater",
  "mekanism:resistive_heater",
  "cyclic:packager",
  "cyclic:hopper_gold",
  "thermal:oil_sand",
  "thermal:oil_red_sand",
  "ae2:ender_dust"
];

global["circuitRemovals"] = [
  "jaopca:circuits.aluminum",
  "jaopca:circuits.azurite",
  "jaopca:circuits.calorite",
  "jaopca:circuits.desh",
  "jaopca:circuits.desh",
  "jaopca:circuits.dragonstone",
  "jaopca:circuits.drenched_iron",
  "jaopca:circuits.elementium",
  "jaopca:circuits.fireite",
  "jaopca:circuits.fluix",
  "jaopca:circuits.fluorite",
  "jaopca:circuits.force",
  "jaopca:circuits.iesnium",
  "jaopca:circuits.lumium",
  "jaopca:circuits.mana_diamond",
  "jaopca:circuits.manganese",
  "jaopca:circuits.netherite",
  "jaopca:circuits.ruby",
  "jaopca:circuits.sapphire",
  "jaopca:circuits.shaka",
  "jaopca:circuits.signalum",
  "jaopca:circuits.swift_alloy",
  "jaopca:circuits.terrasteel",
  "jaopca:circuits.unstable",
  "jaopca:circuits.zircon",
  "jaopca:circuits.zirconium",
  "jaopca:create_crushed_ores.calorite",
  "jaopca:create_crushed_ores.desh",
  "jaopca:create_crushed_ores.iesnium",
  "jaopca:create_crushed_ores.manganese",
  "jaopca:create_crushed_ores.ostrum",
  "jaopca:create_crushed_ores.shaka",
  "jaopca:processors.calorite",
  "jaopca:processors.dragonstone",
  "jaopca:processors.drenched_iron",
  "jaopca:processors.elementium",
  "jaopca:processors.enderium",
  "jaopca:processors.fireite",
  "jaopca:processors.fluix",
  "jaopca:processors.fluorite",
  "jaopca:processors.force",
  "jaopca:processors.lumium",
  "jaopca:processors.mana_diamond",
  "jaopca:processors.manasteel",
  "jaopca:processors.manganese",
  "jaopca:processors.netherite",
  "jaopca:processors.osmium",
  "jaopca:processors.ruby",
  "jaopca:processors.sapphire",
  "jaopca:processors.shaka",
  "jaopca:processors.source",
  "jaopca:processors.swift_alloy",
  "jaopca:processors.terrasteel",
  "jaopca:processors.unstable",
  "jaopca:processors.zircon",
  "jaopca:processors.zirconium"
];

global["hideOres"] = [];

global["startingItems"] = [
  "5x minecraft:oak_sapling",
  "5x minecraft:apple",
  "supplementaries:flax_seeds",
  "64x minecraft:bone_meal",
  "ftbquests:book",
];

global.specialPlayers = {
  "lashmak": {
    message: "Welcome Lashmak! Cobbee has been waiting for you!",
    items:
      [
        Item.of('productivebees:spawn_egg_configurable_bee', '{EntityTag:{type:"productivebees:cobbee"}}'),
      ]
  },
  "systemcollapse": {
    message: "Welcome Systemcollapse! FTB has given you a little present!",
    items:
      [
        Item.of('minecraft:wooden_sword', "{Damage:0,RepairCost:0,display:{Name:'{\"text\":\"Bane of Elyria\"}'}}")
      ]
  },
  "threefold": {
    message: "Welcome Threefold! Tazz has left you a little present!",
    items:
      [
        Item.of('botania:cosmetic_thinking_hand', "{RepairCost:0,display:{Name:'{\"text\":\"Threefold\\'s Thinking Finger\"}'}}")
      ]
  },
  "matrixis": {
    message: "Welcome Matrixis! FTB has given you a little present!",
    items:
      [
        Item.of('botania:cosmetic_groucho_glasses', "{RepairCost:0,display:{Name:'{\"text\":\"Matrixis\\'s Nose\"}'}}")
      ]
  },
  "xobias": {
    message: "Welcome Xobias! FTB has given you a little present!",
    items:
      [
        Item.of('minecraft:stick', "{RepairCost:0,display:{Name:'{\"text\":\"Xobias, you\\'re a stick\"}'}}")
      ]
  },
  "button": {
    message: "Welcome Button! FTB has given you a little present!",
    items:
      [
        Item.of('minecraft:stone_button', "{RepairCost:0,display:{Name:'{\"text\":\"Here, have a Button :D\"}'}}")
      ]
  },
  "reninsane": {
    message: "Welcome Reninsane! FTB has given you a little present!",
    items:
      [
        Item.of('create:builders_tea', "{RepairCost:0,display:{Name:'{\"text\":\"Totally not a Bottle of Rum\"}'}}")
      ]
  },
  "errormikey": {
    message: "[Sunekaer] Oh No you Twat!",
    items: ['alexsmobs:stink_bottle']
  },
  "slowpoke101": {
    message: "Slowpoke! Here's a perfectly balanced clay! Just for you.",
    items:
      [
        Item.of('minecraft:clay_ball', "{RepairCost:0,display:{Name:'{\"text\":\"Perfectly Balanced Clay\"}'}}").enchant('minecraft:unbreaking', 1)
      ]
  },
  "chosenarchitect": {
    message: "[Saereth] Here, have a guide to become a real Pro!",
    items:
      [
        Item.of('minecraft:written_book', '{author:"ChosenArchitect",pages:[\'{"text":"New Pack who dis?"}\'],resolved:1b,title:"*broken* Guide to Chosens Modded Adventure"}')
      ]
  },
  "direwolf20": {
    message: "[Slowpoke] We made you some special food! Try it!",
    items:
      [
        "ftbskies:wolf_sushi"
      ]
  },
  "theonlytazz": {
    message: "test",
    items:
      [
        "minecraft:stick"
      ]
  },
  'ectorvynk': {
    message: "[TheonlyTazz] Hey! I have a little gift for you!",
    items: [
      'alexsmobs:centipede_leg',
      'alexsmobs:centipede_leg',
      'alexsmobs:centipede_leg',
      'alexsmobs:centipede_leg',
      'alexsmobs:centipede_leg',
      'alexsmobs:centipede_leg',
      'alexsmobs:centipede_leg',
      Item.of('alexsmobs:centipede_leggings', '{Damage:0}').enchant("minecraft:unbreaking", 3)
    ]
  },
  "cpw11": {
    message: "[TheonlyTazz] Hey, I heared your Mobfarm burned up, take this!",
    items: [
      'mob_grinding_utils:dreadful_dirt',
      'mob_grinding_utils:dreadful_dirt',
      'mob_grinding_utils:dreadful_dirt',
      'mob_grinding_utils:dreadful_dirt',
      'mob_grinding_utils:dreadful_dirt'
    ]
  }
}

global.endermanDialogue = [
  `["","[ Enderman ]",{"text":" Who is this!?","obfuscated":true,"color":"dark_red","hoverEvent":{"action":"show_text","contents":["Who is this!?"]}}]`,
  `["","[ Enderman ]",{"text":" I see you...","obfuscated":true,"color":"dark_purple","hoverEvent":{"action":"show_text","contents":["I see you..."]}}]`,
  `["","[ Enderman ]",{"text":" What are you doing here?","obfuscated":true,"color":"dark_red","hoverEvent":{"action":"show_text","contents":["What are you doing here?"]}}]`,
  `["","[ Enderman ]",{"text":" I'm tired of this player!","obfuscated":true,"color":"dark_purple","hoverEvent":{"action":"show_text","contents":["I'm tired of this player!"]}}]`,
  `["","[ Enderman ]",{"text":" They keep meddling with our blocks!","obfuscated":true,"color":"dark_red","hoverEvent":{"action":"show_text","contents":["They keep meddling with our blocks!"]}}]`,
  `["","[ Enderman ]",{"text":" It's so annoying!","obfuscated":true,"color":"dark_purple","hoverEvent":{"action":"show_text","contents":["It's so annoying!"]}}]`,
  `["","[ Enderman ]",{"text":" We need to teach them a lesson.","obfuscated":true,"color":"dark_red","hoverEvent":{"action":"show_text","contents":["We need to teach them a lesson."]}}]`,
  `["","[ Enderman ]",{"text":" Agreed! Let's get him!.","obfuscated":true,"color":"dark_purple","hoverEvent":{"action":"show_text","contents":["Agreed! Let's get him!"]}}]`,
];

global.spawnEndermanPrison = (player) => {
  let y = 350
  let kuLevel = new Ku.Level(player.getLevel())
  let blockPos = new BlockPos(player.x - 3, y, player.z - 3)
  let oldPos = { x: player.x, y: player.y, z: player.z }
  kuLevel.spawnStructure('ftbskies:prison', blockPos)
  player.stages.add('in_prison')
  Utils.server.runCommandSilent(`execute as ${player.username} at ${player.username} run playsound minecraft:entity.enderman.teleport master @a ~ ~ ~ 1 1`)
  player.teleportTo(player.x, y + 1, player.z)
  player.potionEffects.add("minecraft:darkness", 20 * 14, 0)
  let counter = 0
  for (let i = 0; i < global.endermanDialogue.length; i++) {
    Utils.server.scheduleInTicks(20 * i, chat => {
      Utils.server.runCommandSilent(`execute as ${player.username} at ${player.username} run playsound minecraft:entity.enderman.scream master @a ~ ~ ~ 1 1`)
      let cmd = `/tellraw ${player.username} ${global.endermanDialogue[counter]}`
      counter++
      Utils.server.runCommand(cmd)
    })
  }
  Utils.server.scheduleInTicks(20 * global.endermanDialogue.length + 10, callback => {
    if (Object.keys(global.specialPlayers).includes(player.username.toLowerCase())) {
      let cmd = `/tellraw ${player.username} ["","[ Enderman ] ",{"text":"Oh this is ${player.username}! The famous Content Creator! Can i get an autograph!?","obfuscated":true,"color":"yellow","hoverEvent":{"action":"show_text","contents":["Oh this is ${player.username}! The Famous Content Creator! Can i get an autograph!?"]}}]`
      Utils.server.runCommand(cmd)
    }
  })

  Utils.server.scheduleInTicks(20 * global.endermanDialogue.length + 20 * 5, callback => {
    Utils.server.runCommandSilent(`execute as ${player.username} at ${player.username} run playsound minecraft:entity.enderman.teleport master @a ~ ~ ~ 1 1`)

    player.teleportTo(oldPos.x, oldPos.y, oldPos.z)
    player.stages.remove('in_prison')
    kuLevel.findEntitiesWithinRadius("minecraft:enderman", blockPos, 10).forEach(entity => {
      entity.discard()
    })
    kuLevel.spawnStructure('ftbskies:prison_air', blockPos)
  })
}