const batteries = ["cyclic:battery", "cyclic:battery_clay", "integrateddynamics:energy_battery"];

ItemEvents.modification((event) => {
  // Make batteries unstackable
  batteries.forEach((battery) => {
    event.modify(battery, (item) => {
      item.maxStackSize = 1;
    });
  });

  event.modify("immersiveengineering:logic_circuit", (item) => {
    item.maxStackSize = 64;
  });
  
  event.modify("artifacts:eternal_steak", (item) => {
    item.foodProperties = (food) => {
      food.saturation(0).fastToEat(false);
    };
  });
  event.modify("artifacts:everlasting_beef", (item) => {
    item.foodProperties = (food) => {
      food.saturation(0).hunger(1).fastToEat(false);
    };
  });

  event.modify("ftbskies:tiny_coal", (item) => (item.burnTime = 200));
  event.modify("ftbskies:tiny_charcoal", (item) => (item.burnTime = 200));
});
