/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Random;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BlockFluidFinite
extends BlockFluidBase {
    public BlockFluidFinite(Fluid fluid, awt material) {
        super(fluid, material);
    }

    @Override
    public int getQuantaValue(ahl world, int x, int y2, int z2) {
        if (world.a(x, y2, z2).isAir(world, x, y2, z2)) {
            return 0;
        }
        if (world.a(x, y2, z2) != this) {
            return -1;
        }
        int quantaRemaining = world.e(x, y2, z2) + 1;
        return quantaRemaining;
    }

    @Override
    public boolean a(int meta, boolean fullHit) {
        return fullHit && meta == this.quantaPerBlock - 1;
    }

    @Override
    public int getMaxRenderHeightMeta() {
        return this.quantaPerBlock - 1;
    }

    public void a(ahb world, int x, int y2, int z2, Random rand) {
        int quantaRemaining;
        boolean changed = false;
        int prevRemaining = quantaRemaining = world.e(x, y2, z2) + 1;
        if ((quantaRemaining = this.tryToFlowVerticallyInto(world, x, y2, z2, quantaRemaining)) < 1) {
            return;
        }
        if (quantaRemaining != prevRemaining) {
            changed = true;
            if (quantaRemaining == 1) {
                world.a(x, y2, z2, quantaRemaining - 1, 2);
                return;
            }
        } else if (quantaRemaining == 1) {
            return;
        }
        int lowerthan = quantaRemaining - 1;
        if (this.displaceIfPossible(world, x, y2, z2 - 1)) {
            world.b(x, y2, z2 - 1, ajn.a);
        }
        if (this.displaceIfPossible(world, x, y2, z2 + 1)) {
            world.b(x, y2, z2 + 1, ajn.a);
        }
        if (this.displaceIfPossible(world, x - 1, y2, z2)) {
            world.b(x - 1, y2, z2, ajn.a);
        }
        if (this.displaceIfPossible(world, x + 1, y2, z2)) {
            world.b(x + 1, y2, z2, ajn.a);
        }
        int north = this.getQuantaValueBelow((ahl)world, x, y2, z2 - 1, lowerthan);
        int south = this.getQuantaValueBelow((ahl)world, x, y2, z2 + 1, lowerthan);
        int west = this.getQuantaValueBelow((ahl)world, x - 1, y2, z2, lowerthan);
        int east = this.getQuantaValueBelow((ahl)world, x + 1, y2, z2, lowerthan);
        int total = quantaRemaining;
        int count = 1;
        if (north >= 0) {
            ++count;
            total += north;
        }
        if (south >= 0) {
            ++count;
            total += south;
        }
        if (west >= 0) {
            ++count;
            total += west;
        }
        if (east >= 0) {
            ++count;
            total += east;
        }
        if (count == 1) {
            if (changed) {
                world.a(x, y2, z2, quantaRemaining - 1, 2);
            }
            return;
        }
        int each = total / count;
        int rem = total % count;
        if (north >= 0) {
            int newnorth = each;
            if (rem == count || rem > 1 && rand.nextInt(count - rem) != 0) {
                ++newnorth;
                --rem;
            }
            if (newnorth != north) {
                if (newnorth == 0) {
                    world.b(x, y2, z2 - 1, ajn.a);
                } else {
                    world.d(x, y2, z2 - 1, (aji)this, newnorth - 1, 2);
                }
                world.a(x, y2, z2 - 1, (aji)this, this.tickRate);
            }
            --count;
        }
        if (south >= 0) {
            int newsouth = each;
            if (rem == count || rem > 1 && rand.nextInt(count - rem) != 0) {
                ++newsouth;
                --rem;
            }
            if (newsouth != south) {
                if (newsouth == 0) {
                    world.b(x, y2, z2 + 1, ajn.a);
                } else {
                    world.d(x, y2, z2 + 1, (aji)this, newsouth - 1, 2);
                }
                world.a(x, y2, z2 + 1, (aji)this, this.tickRate);
            }
            --count;
        }
        if (west >= 0) {
            int newwest = each;
            if (rem == count || rem > 1 && rand.nextInt(count - rem) != 0) {
                ++newwest;
                --rem;
            }
            if (newwest != west) {
                if (newwest == 0) {
                    world.b(x - 1, y2, z2, ajn.a);
                } else {
                    world.d(x - 1, y2, z2, (aji)this, newwest - 1, 2);
                }
                world.a(x - 1, y2, z2, (aji)this, this.tickRate);
            }
            --count;
        }
        if (east >= 0) {
            int neweast = each;
            if (rem == count || rem > 1 && rand.nextInt(count - rem) != 0) {
                ++neweast;
                --rem;
            }
            if (neweast != east) {
                if (neweast == 0) {
                    world.b(x + 1, y2, z2, ajn.a);
                } else {
                    world.d(x + 1, y2, z2, (aji)this, neweast - 1, 2);
                }
                world.a(x + 1, y2, z2, (aji)this, this.tickRate);
            }
            --count;
        }
        if (rem > 0) {
            ++each;
        }
        world.a(x, y2, z2, each - 1, 2);
    }

    public int tryToFlowVerticallyInto(ahb world, int x, int y2, int z2, int amtToInput) {
        int otherY = y2 + this.densityDir;
        if (otherY < 0 || otherY >= world.R()) {
            world.b(x, y2, z2, ajn.a);
            return 0;
        }
        int amt2 = this.getQuantaValueBelow((ahl)world, x, otherY, z2, this.quantaPerBlock);
        if (amt2 >= 0) {
            if ((amt2 += amtToInput) > this.quantaPerBlock) {
                world.d(x, otherY, z2, (aji)this, this.quantaPerBlock - 1, 3);
                world.a(x, otherY, z2, (aji)this, this.tickRate);
                return amt2 - this.quantaPerBlock;
            }
            if (amt2 > 0) {
                world.d(x, otherY, z2, (aji)this, amt2 - 1, 3);
                world.a(x, otherY, z2, (aji)this, this.tickRate);
                world.b(x, y2, z2, ajn.a);
                return 0;
            }
            return amtToInput;
        }
        int density_other = BlockFluidFinite.getDensity((ahl)world, x, otherY, z2);
        if (density_other == Integer.MAX_VALUE) {
            if (this.displaceIfPossible(world, x, otherY, z2)) {
                world.d(x, otherY, z2, (aji)this, amtToInput - 1, 3);
                world.a(x, otherY, z2, (aji)this, this.tickRate);
                world.b(x, y2, z2, ajn.a);
                return 0;
            }
            return amtToInput;
        }
        if (this.densityDir < 0) {
            if (density_other < this.density) {
                BlockFluidBase block = (BlockFluidBase)world.a(x, otherY, z2);
                int otherData = world.e(x, otherY, z2);
                world.d(x, otherY, z2, (aji)this, amtToInput - 1, 3);
                world.d(x, y2, z2, (aji)block, otherData, 3);
                world.a(x, otherY, z2, (aji)this, this.tickRate);
                world.a(x, y2, z2, (aji)block, block.a(world));
                return 0;
            }
        } else if (density_other > this.density) {
            BlockFluidBase block = (BlockFluidBase)world.a(x, otherY, z2);
            int otherData = world.e(x, otherY, z2);
            world.d(x, otherY, z2, (aji)this, amtToInput - 1, 3);
            world.d(x, y2, z2, (aji)block, otherData, 3);
            world.a(x, otherY, z2, (aji)this, this.tickRate);
            world.a(x, y2, z2, (aji)block, block.a(world));
            return 0;
        }
        return amtToInput;
    }

    @Override
    public FluidStack drain(ahb world, int x, int y2, int z2, boolean doDrain) {
        if (doDrain) {
            world.b(x, y2, z2, ajn.a);
        }
        return new FluidStack(this.getFluid(), qh.d((float)(this.getQuantaPercentage((ahl)world, x, y2, z2) * 1000.0f)));
    }

    @Override
    public boolean canDrain(ahb world, int x, int y2, int z2) {
        return true;
    }
}

