/*
 * Decompiled with CFR 0.152.
 */
package gravestone.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravestone.config.GraveStoneConfig;
import gravestone.core.GSTabs;
import gravestone.core.TimeHelper;
import gravestone.particle.EntityGreenFlameFX;
import gravestone.tileentity.TileEntityGSCandle;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGSCandle
extends BlockContainer {
    public BlockGSCandle() {
        super(Material.field_151593_r);
        this.func_149672_a(Block.field_149775_l);
        this.func_149663_c("candle");
        this.func_149711_c(0.0f);
        this.func_149715_a(1.0f);
        this.func_149752_b(0.0f);
        this.func_149658_d("snow");
        this.func_149647_a(GSTabs.otherItemsTab);
        this.func_149676_a(0.4f, 0.0f, 0.4f, 0.6f, 0.6f, 0.6f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        double xPos = (double)x + 0.5;
        double yPos = (double)y + 0.5;
        double zPos = (double)z + 0.5;
        long dayTime = TimeHelper.getDayTime(world);
        if (dayTime < 13000L || dayTime > 23000L) {
            world.func_72869_a("flame", xPos, yPos, zPos, 0.0, 0.0, 0.0);
        } else {
            EntityGreenFlameFX entityfx = new EntityGreenFlameFX(world, xPos, yPos, zPos, 0.0, 0.0, 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)entityfx);
        }
        world.func_72869_a("smoke", xPos, yPos, zPos, 0.0, 0.0, 0.0);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return GraveStoneConfig.candleRenderID;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return this.canPlaceCandleOn(world, x, y - 1, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.canPlaceCandleOn(world, x, y - 1, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    private boolean canPlaceCandleOn(World world, int x, int y, int z) {
        if (World.func_147466_a((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        return block != null && block.canPlaceTorchOnTop(world, x, y, z);
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityGSCandle();
    }
}

