/*
 * Decompiled with CFR 0.152.
 */
package gravestone.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravestone.ModGraveStone;
import gravestone.block.GraveStoneHelper;
import gravestone.block.enums.EnumGraves;
import gravestone.config.GraveStoneConfig;
import gravestone.core.GSTabs;
import gravestone.core.logger.GSLogger;
import gravestone.inventory.GraveInventory;
import gravestone.tileentity.DeathMessageInfo;
import gravestone.tileentity.TileEntityGSGraveStone;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGSGraveStone
extends BlockContainer {
    public static final byte[] TAB_PLAYER_GRAVES = new byte[]{(byte)EnumGraves.WOODEN_VERTICAL_PLATE.ordinal(), (byte)EnumGraves.SANDSTONE_VERTICAL_PLATE.ordinal(), (byte)EnumGraves.STONE_VERTICAL_PLATE.ordinal(), (byte)EnumGraves.MOSSY_VERTICAL_PLATE.ordinal(), (byte)EnumGraves.IRON_VERTICAL_PLATE.ordinal(), (byte)EnumGraves.GOLDEN_VERTICAL_PLATE.ordinal(), (byte)EnumGraves.DIAMOND_VERTICAL_PLATE.ordinal(), (byte)EnumGraves.EMERALD_VERTICAL_PLATE.ordinal(), (byte)EnumGraves.LAPIS_VERTICAL_PLATE.ordinal(), (byte)EnumGraves.REDSTONE_VERTICAL_PLATE.ordinal(), (byte)EnumGraves.OBSIDIAN_VERTICAL_PLATE.ordinal(), (byte)EnumGraves.QUARTZ_VERTICAL_PLATE.ordinal(), (byte)EnumGraves.ICE_VERTICAL_PLATE.ordinal(), (byte)EnumGraves.WOODEN_CROSS.ordinal(), (byte)EnumGraves.SANDSTONE_CROSS.ordinal(), (byte)EnumGraves.STONE_CROSS.ordinal(), (byte)EnumGraves.MOSSY_CROSS.ordinal(), (byte)EnumGraves.IRON_CROSS.ordinal(), (byte)EnumGraves.GOLDEN_CROSS.ordinal(), (byte)EnumGraves.DIAMOND_CROSS.ordinal(), (byte)EnumGraves.EMERALD_CROSS.ordinal(), (byte)EnumGraves.LAPIS_CROSS.ordinal(), (byte)EnumGraves.REDSTONE_CROSS.ordinal(), (byte)EnumGraves.OBSIDIAN_CROSS.ordinal(), (byte)EnumGraves.QUARTZ_CROSS.ordinal(), (byte)EnumGraves.ICE_CROSS.ordinal(), (byte)EnumGraves.WOODEN_HORISONTAL_PLATE.ordinal(), (byte)EnumGraves.SANDSTONE_HORISONTAL_PLATE.ordinal(), (byte)EnumGraves.STONE_HORISONTAL_PLATE.ordinal(), (byte)EnumGraves.MOSSY_HORISONTAL_PLATE.ordinal(), (byte)EnumGraves.IRON_HORISONTAL_PLATE.ordinal(), (byte)EnumGraves.GOLDEN_HORISONTAL_PLATE.ordinal(), (byte)EnumGraves.DIAMOND_HORISONTAL_PLATE.ordinal(), (byte)EnumGraves.EMERALD_HORISONTAL_PLATE.ordinal(), (byte)EnumGraves.LAPIS_HORISONTAL_PLATE.ordinal(), (byte)EnumGraves.REDSTONE_HORISONTAL_PLATE.ordinal(), (byte)EnumGraves.OBSIDIAN_HORISONTAL_PLATE.ordinal(), (byte)EnumGraves.QUARTZ_HORISONTAL_PLATE.ordinal(), (byte)EnumGraves.ICE_HORISONTAL_PLATE.ordinal()};
    public static final byte[] TAB_PETS_GRAVES = new byte[]{(byte)EnumGraves.WOODEN_DOG_STATUE.ordinal(), (byte)EnumGraves.SANDSTONE_DOG_STATUE.ordinal(), (byte)EnumGraves.STONE_DOG_STATUE.ordinal(), (byte)EnumGraves.MOSSY_DOG_STATUE.ordinal(), (byte)EnumGraves.IRON_DOG_STATUE.ordinal(), (byte)EnumGraves.GOLDEN_DOG_STATUE.ordinal(), (byte)EnumGraves.DIAMOND_DOG_STATUE.ordinal(), (byte)EnumGraves.EMERALD_DOG_STATUE.ordinal(), (byte)EnumGraves.LAPIS_DOG_STATUE.ordinal(), (byte)EnumGraves.REDSTONE_DOG_STATUE.ordinal(), (byte)EnumGraves.OBSIDIAN_DOG_STATUE.ordinal(), (byte)EnumGraves.QUARTZ_DOG_STATUE.ordinal(), (byte)EnumGraves.ICE_DOG_STATUE.ordinal(), (byte)EnumGraves.WOODEN_CAT_STATUE.ordinal(), (byte)EnumGraves.SANDSTONE_CAT_STATUE.ordinal(), (byte)EnumGraves.STONE_CAT_STATUE.ordinal(), (byte)EnumGraves.MOSSY_CAT_STATUE.ordinal(), (byte)EnumGraves.IRON_CAT_STATUE.ordinal(), (byte)EnumGraves.GOLDEN_CAT_STATUE.ordinal(), (byte)EnumGraves.DIAMOND_CAT_STATUE.ordinal(), (byte)EnumGraves.EMERALD_CAT_STATUE.ordinal(), (byte)EnumGraves.LAPIS_CAT_STATUE.ordinal(), (byte)EnumGraves.REDSTONE_CAT_STATUE.ordinal(), (byte)EnumGraves.OBSIDIAN_CAT_STATUE.ordinal(), (byte)EnumGraves.QUARTZ_CAT_STATUE.ordinal(), (byte)EnumGraves.ICE_CAT_STATUE.ordinal(), (byte)EnumGraves.WOODEN_HORSE_STATUE.ordinal(), (byte)EnumGraves.SANDSTONE_HORSE_STATUE.ordinal(), (byte)EnumGraves.STONE_HORSE_STATUE.ordinal(), (byte)EnumGraves.MOSSY_HORSE_STATUE.ordinal(), (byte)EnumGraves.IRON_HORSE_STATUE.ordinal(), (byte)EnumGraves.GOLDEN_HORSE_STATUE.ordinal(), (byte)EnumGraves.DIAMOND_HORSE_STATUE.ordinal(), (byte)EnumGraves.EMERALD_HORSE_STATUE.ordinal(), (byte)EnumGraves.LAPIS_HORSE_STATUE.ordinal(), (byte)EnumGraves.REDSTONE_HORSE_STATUE.ordinal(), (byte)EnumGraves.OBSIDIAN_HORSE_STATUE.ordinal(), (byte)EnumGraves.QUARTZ_HORSE_STATUE.ordinal(), (byte)EnumGraves.ICE_HORSE_STATUE.ordinal()};
    private static final Random rand = new Random();

    public BlockGSGraveStone() {
        super(Material.field_151576_e);
        this.field_149758_A = true;
        this.func_149672_a(Block.field_149769_e);
        this.func_149663_c("GraveStone");
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149647_a(GSTabs.gravesTab);
        this.func_149675_a(GraveStoneConfig.removeEmptyGraves);
        this.func_149658_d("stone");
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        GraveStoneHelper.replaceGround(world, x, y - 1, z);
        int direction = MathHelper.func_76141_d((float)player.field_70177_z);
        if (direction < 0) {
            direction = 360 + direction;
        }
        int metadata = GraveStoneHelper.getMetadataBasedOnRotation(direction);
        world.func_72921_c(x, y, z, metadata, 2);
        TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
        if (tileEntity != null && itemStack.field_77990_d != null) {
            if (itemStack.field_77990_d.func_74764_b("GraveType")) {
                tileEntity.setGraveType(itemStack.field_77990_d.func_74771_c("GraveType"));
            } else {
                tileEntity.setGraveType((byte)0);
            }
            if (itemStack.field_77990_d.func_74764_b("isLocalized") && itemStack.field_77990_d.func_74767_n("isLocalized")) {
                tileEntity.getDeathTextComponent().setLocalized();
                if (itemStack.field_77990_d.func_74764_b("name") && itemStack.field_77990_d.func_74764_b("KillerName")) {
                    tileEntity.getDeathTextComponent().setName(itemStack.field_77990_d.func_74779_i("name"));
                    tileEntity.getDeathTextComponent().setKillerName(itemStack.field_77990_d.func_74779_i("KillerName"));
                }
            }
            if (itemStack.field_77990_d.func_74764_b("DeathText")) {
                tileEntity.getDeathTextComponent().setDeathText(itemStack.field_77990_d.func_74779_i("DeathText"));
            }
            if (itemStack.field_77990_d.func_74764_b("Age")) {
                tileEntity.setAge(itemStack.field_77990_d.func_74762_e("Age"));
            }
            if (itemStack.field_77990_d.func_74764_b("Sword")) {
                tileEntity.setSword(ItemStack.func_77949_a((NBTTagCompound)itemStack.func_77978_p().func_74775_l("Sword")));
            }
            if (itemStack.field_77990_d.func_74764_b("Enchanted")) {
                tileEntity.setEnchanted(itemStack.field_77990_d.func_74767_n("Enchanted"));
            }
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return GraveStoneHelper.canPlaceBlockAt(world, x, y - 1, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        int meta = access.func_72805_g(x, y, z);
        TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)access.func_147438_o(x, y, z);
        EnumGraves graveType = tileEntity != null ? tileEntity.getGraveType() : EnumGraves.STONE_VERTICAL_PLATE;
        block0 : switch (graveType) {
            case WOODEN_VERTICAL_PLATE: 
            case SANDSTONE_VERTICAL_PLATE: 
            case STONE_VERTICAL_PLATE: 
            case MOSSY_VERTICAL_PLATE: 
            case IRON_VERTICAL_PLATE: 
            case GOLDEN_VERTICAL_PLATE: 
            case DIAMOND_VERTICAL_PLATE: 
            case EMERALD_VERTICAL_PLATE: 
            case LAPIS_VERTICAL_PLATE: 
            case REDSTONE_VERTICAL_PLATE: 
            case OBSIDIAN_VERTICAL_PLATE: 
            case QUARTZ_VERTICAL_PLATE: 
            case ICE_VERTICAL_PLATE: {
                switch (meta) {
                    case 0: {
                        this.func_149676_a(0.125f, 0.0f, 0.0625f, 0.875f, 0.9375f, 0.1875f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(0.125f, 0.0f, 0.8125f, 0.875f, 0.9375f, 0.9375f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.0625f, 0.0f, 0.125f, 0.1875f, 0.9375f, 0.875f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.8125f, 0.0f, 0.125f, 0.9375f, 0.9375f, 0.875f);
                    }
                }
                break;
            }
            case WOODEN_CROSS: 
            case SANDSTONE_CROSS: 
            case STONE_CROSS: 
            case MOSSY_CROSS: 
            case IRON_CROSS: 
            case GOLDEN_CROSS: 
            case DIAMOND_CROSS: 
            case EMERALD_CROSS: 
            case LAPIS_CROSS: 
            case REDSTONE_CROSS: 
            case OBSIDIAN_CROSS: 
            case QUARTZ_CROSS: 
            case ICE_CROSS: {
                switch (meta) {
                    case 0: {
                        this.func_149676_a(0.125f, 0.0f, 0.0625f, 0.875f, 1.0f, 0.1875f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(0.125f, 0.0f, 0.8125f, 0.875f, 1.0f, 0.9375f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.0625f, 0.0f, 0.125f, 0.1875f, 1.0f, 0.875f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.8125f, 0.0f, 0.125f, 0.9375f, 1.0f, 0.875f);
                    }
                }
                break;
            }
            case WOODEN_HORISONTAL_PLATE: 
            case SANDSTONE_HORISONTAL_PLATE: 
            case STONE_HORISONTAL_PLATE: 
            case MOSSY_HORISONTAL_PLATE: 
            case IRON_HORISONTAL_PLATE: 
            case GOLDEN_HORISONTAL_PLATE: 
            case DIAMOND_HORISONTAL_PLATE: 
            case EMERALD_HORISONTAL_PLATE: 
            case LAPIS_HORISONTAL_PLATE: 
            case REDSTONE_HORISONTAL_PLATE: 
            case OBSIDIAN_HORISONTAL_PLATE: 
            case QUARTZ_HORISONTAL_PLATE: 
            case ICE_HORISONTAL_PLATE: {
                switch (meta) {
                    case 0: {
                        this.func_149676_a(0.09375f, 0.0f, 0.0625f, 0.90625f, 0.0625f, 0.9375f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(0.09375f, 0.0f, 0.0625f, 0.90625f, 0.0625f, 0.9375f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.0625f, 0.0f, 0.09375f, 0.9375f, 0.0625f, 0.90625f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.0625f, 0.0f, 0.09375f, 0.9375f, 0.0625f, 0.90625f);
                    }
                }
                break;
            }
            case WOODEN_DOG_STATUE: 
            case SANDSTONE_DOG_STATUE: 
            case STONE_DOG_STATUE: 
            case MOSSY_DOG_STATUE: 
            case IRON_DOG_STATUE: 
            case GOLDEN_DOG_STATUE: 
            case DIAMOND_DOG_STATUE: 
            case EMERALD_DOG_STATUE: 
            case LAPIS_DOG_STATUE: 
            case REDSTONE_DOG_STATUE: 
            case OBSIDIAN_DOG_STATUE: 
            case QUARTZ_DOG_STATUE: 
            case ICE_DOG_STATUE: {
                switch (meta) {
                    case 0: {
                        this.func_149676_a(0.35f, 0.0f, 0.3f, 0.6f, 0.5f, 0.9f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(0.35f, 0.0f, 0.7f, 0.6f, 0.5f, 0.1f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.3f, 0.0f, 0.35f, 0.9f, 0.5f, 0.6f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.7f, 0.0f, 0.35f, 0.1f, 0.5f, 0.6f);
                    }
                }
                break;
            }
            case WOODEN_CAT_STATUE: 
            case SANDSTONE_CAT_STATUE: 
            case STONE_CAT_STATUE: 
            case MOSSY_CAT_STATUE: 
            case IRON_CAT_STATUE: 
            case GOLDEN_CAT_STATUE: 
            case DIAMOND_CAT_STATUE: 
            case EMERALD_CAT_STATUE: 
            case LAPIS_CAT_STATUE: 
            case REDSTONE_CAT_STATUE: 
            case OBSIDIAN_CAT_STATUE: 
            case QUARTZ_CAT_STATUE: 
            case ICE_CAT_STATUE: {
                switch (meta) {
                    case 0: {
                        this.func_149676_a(0.43f, 0.0f, 0.3f, 0.57f, 0.5f, 0.75f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(0.43f, 0.0f, 0.7f, 0.57f, 0.5f, 0.25f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.3f, 0.0f, 0.43f, 0.75f, 0.5f, 0.57f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.7f, 0.0f, 0.43f, 0.25f, 0.5f, 0.57f);
                    }
                }
                break;
            }
            case SWORD: {
                switch (meta) {
                    case 0: 
                    case 1: {
                        this.func_149676_a(0.375f, 0.0f, 0.4375f, 0.625f, 0.9f, 0.5625f);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.func_149676_a(0.4375f, 0.0f, 0.375f, 0.5625f, 0.9f, 0.625f);
                    }
                }
                break;
            }
            case WOODEN_HORSE_STATUE: 
            case SANDSTONE_HORSE_STATUE: 
            case STONE_HORSE_STATUE: 
            case MOSSY_HORSE_STATUE: 
            case IRON_HORSE_STATUE: 
            case GOLDEN_HORSE_STATUE: 
            case DIAMOND_HORSE_STATUE: 
            case EMERALD_HORSE_STATUE: 
            case LAPIS_HORSE_STATUE: 
            case REDSTONE_HORSE_STATUE: 
            case OBSIDIAN_HORSE_STATUE: 
            case QUARTZ_HORSE_STATUE: 
            case ICE_HORSE_STATUE: {
                switch (meta) {
                    case 0: 
                    case 1: {
                        this.func_149676_a(0.375f, 0.0f, 0.275f, 0.625f, 0.85f, 0.725f);
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        this.func_149676_a(0.275f, 0.0f, 0.375f, 0.725f, 0.85f, 0.625f);
                    }
                }
            }
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int metadata, EntityPlayer player) {
        player.func_71020_j(0.025f);
        GraveStoneHelper.spawnMob(world, x, y, z);
        TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            if (tileEntity.hasFlower()) {
                tileEntity.dropFlower();
            }
            if (EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
                this.dropBlock(world, x, y, z);
            } else {
                this.dropBlockWithoutInfo(world, x, y, z);
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(this.getBlockItemStack(world, x, y, z));
        return ret;
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int metadata) {
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return GraveStoneConfig.graveRenderID;
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        GraveStoneHelper.spawnMob(world, x, y, z);
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return this.func_149638_a(par1Entity);
    }

    public float func_149638_a(Entity par1Entity) {
        return 1.8E7f;
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntityGSGraveStone te = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
        if (te != null) {
            String deathText;
            if (player.field_71071_by.func_70448_g() != null) {
                ItemStack item = player.field_71071_by.func_70448_g();
                if (item.func_77973_b() instanceof ItemSpade) {
                    if (!world.field_72995_K) {
                        GSLogger.logInfoGrave(player.func_70005_c_() + " loot grave at " + x + "/" + y + "/" + z);
                        player.openGui((Object)ModGraveStone.instance, 0, world, x, y, z);
                    }
                    return false;
                }
                if (te.hasFlower()) {
                    if (item.func_77973_b() instanceof ItemShears) {
                        if (!world.field_72995_K) {
                            te.dropFlower();
                        }
                        te.setFlower(null);
                        return false;
                    }
                } else if (GraveStoneHelper.FLOWERS.contains(Block.func_149634_a((Item)item.func_77973_b())) && GraveStoneHelper.canFlowerBePlaced(world, x, y, z, item, te)) {
                    te.setFlower(new ItemStack(item.func_77973_b(), 1, item.func_77960_j()));
                    --player.field_71071_by.func_70448_g().field_77994_a;
                    return true;
                }
            }
            if (world.field_72995_K && (deathText = te.getDeathTextComponent().getDeathText()).length() != 0) {
                if (te.getDeathTextComponent().isLocalized()) {
                    String name = ModGraveStone.proxy.getLocalizedEntityName(te.getDeathTextComponent().getName());
                    String killerName = ModGraveStone.proxy.getLocalizedEntityName(te.getDeathTextComponent().getKillerName());
                    if (killerName.length() == 0) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[]{name}));
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[]{name, killerName}));
                    }
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[0]));
                }
                if (te.getAge() > 0) {
                    StringBuilder ageStr = new StringBuilder();
                    ageStr.append(ModGraveStone.proxy.getLocalizedString("item.grave.age")).append(" ").append(te.getAge()).append(" ").append(ModGraveStone.proxy.getLocalizedString("item.grave.days"));
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation(ageStr.toString(), new Object[0]));
                }
            }
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityGSGraveStone(world);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        GraveStoneHelper.replaceGround(world, x, y - 1, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            tileEntity.dropAllItems();
        }
        super.func_149749_a(world, x, y, z, block, par6);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.isSideSolid(x, y - 1, z, ForgeDirection.DOWN, true)) {
            this.dropBlockWithoutInfo(world, x, y, z);
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        }
    }

    public int func_149692_a(int metadata) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item gravestone, CreativeTabs tabs, List list) {
        NBTTagCompound nbt;
        ItemStack stack;
        int i;
        for (i = 0; i < TAB_PLAYER_GRAVES.length; i = (int)((byte)(i + 1))) {
            stack = new ItemStack(gravestone, 1, 0);
            nbt = new NBTTagCompound();
            nbt.func_74774_a("GraveType", TAB_PLAYER_GRAVES[i]);
            stack.func_77982_d(nbt);
            list.add(stack);
        }
        for (i = 0; i < TAB_PETS_GRAVES.length; i = (int)((byte)(i + 1))) {
            stack = new ItemStack(gravestone, 1, 0);
            nbt = new NBTTagCompound();
            nbt.func_74774_a("GraveType", TAB_PETS_GRAVES[i]);
            stack.func_77982_d(nbt);
            list.add(stack);
        }
        for (Item sword : GraveStoneHelper.swordsList) {
            list.add(GraveStoneHelper.getSwordAsGrave(gravestone, new ItemStack(sword, 1)));
        }
        for (Item sword : GraveStoneHelper.swordsList) {
            try {
                ItemStack swordStack = new ItemStack(sword, 1);
                EnchantmentHelper.func_77504_a((Random)new Random(), (ItemStack)swordStack, (int)5);
                ItemStack graveStoneStack = GraveStoneHelper.getSwordAsGrave(gravestone, swordStack);
                list.add(graveStoneStack);
            }
            catch (IllegalArgumentException exception) {
                GSLogger.logError("Can't create enchanted sword gravestone");
                exception.printStackTrace();
            }
        }
    }

    private void dropBlock(World world, int x, int y, int z) {
        ItemStack itemStack = this.getBlockItemStack(world, x, y, z);
        if (itemStack != null) {
            this.func_149642_a(world, x, y, z, itemStack);
        }
    }

    private void dropBlockWithoutInfo(World world, int x, int y, int z) {
        ItemStack itemStack = this.func_149644_j(0);
        TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            if (tileEntity.isSwordGrave()) {
                tileEntity.dropSword();
            } else if (itemStack != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74774_a("GraveType", tileEntity.getGraveTypeNum());
                itemStack.func_77982_d(nbt);
                this.func_149642_a(world, x, y, z, itemStack);
            }
        }
    }

    private ItemStack getBlockItemStack(World world, int x, int y, int z) {
        ItemStack itemStack = this.func_149644_j(0);
        TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("GraveType", tileEntity.getGraveTypeNum());
            if (tileEntity.getDeathTextComponent().isLocalized()) {
                nbt.func_74757_a("isLocalized", true);
                nbt.func_74778_a("name", tileEntity.getDeathTextComponent().getName());
                nbt.func_74778_a("KillerName", tileEntity.getDeathTextComponent().getKillerName());
            }
            nbt.func_74778_a("DeathText", tileEntity.getDeathTextComponent().getDeathText());
            nbt.func_74768_a("Age", tileEntity.getAge());
            if (tileEntity.isSwordGrave()) {
                GraveStoneHelper.addSwordInfo(nbt, tileEntity.getSword());
            }
            nbt.func_74757_a("Enchanted", tileEntity.isEnchanted());
            itemStack.func_77982_d(nbt);
        }
        return itemStack;
    }

    public void createOnDeath(Entity entity, World world, int x, int y, int z, DeathMessageInfo deathInfo, int direction, List<ItemStack> items, int age, EnumGraveType entityType, DamageSource damageSource) {
        if (direction < 0) {
            direction = 360 + direction;
        }
        byte graveType = 0;
        ItemStack sword = null;
        if (GraveStoneConfig.generateSwordGraves && world.field_73012_v.nextInt(4) == 0 && entityType.equals((Object)EnumGraveType.PLAYER_GRAVES)) {
            sword = GraveStoneHelper.oldCheckSword(items);
        }
        switch (entityType) {
            case PLAYER_GRAVES: {
                graveType = GraveStoneHelper.getRandomGrave(GraveStoneHelper.getPlayerGraveForLevel(entity), rand);
                if (graveType != 0) break;
                if (sword == null) {
                    graveType = GraveStoneHelper.getRandomGrave(GraveStoneHelper.getPlayerGraveForDeath(damageSource, damageSource.field_76373_n), rand);
                    if (graveType != 0) break;
                    graveType = GraveStoneHelper.getRandomGrave(GraveStoneHelper.getPlayerGraveTypes(world, x, z), rand);
                    break;
                }
                graveType = (byte)EnumGraves.SWORD.ordinal();
                break;
            }
            case DOGS_GRAVES: {
                graveType = GraveStoneHelper.getRandomGrave(GraveStoneHelper.getDogGraveForDeath(damageSource, damageSource.field_76373_n), rand);
                if (graveType != 0) break;
                graveType = GraveStoneHelper.getRandomGrave(GraveStoneHelper.getDogGraveTypes(world, x, z), rand);
                break;
            }
            case CATS_GRAVES: {
                graveType = GraveStoneHelper.getRandomGrave(GraveStoneHelper.getCatGraveForDeath(damageSource, damageSource.field_76373_n), rand);
                if (graveType != 0) break;
                graveType = GraveStoneHelper.getRandomGrave(GraveStoneHelper.getCatGraveTypes(world, x, z), rand);
                break;
            }
            case HORSE_GRAVES: {
                graveType = GraveStoneHelper.getRandomGrave(GraveStoneHelper.getHorseGraveForDeath(damageSource, damageSource.field_76373_n), rand);
                if (graveType != 0) break;
                graveType = GraveStoneHelper.getRandomGrave(GraveStoneHelper.getHorseGraveTypes(world, x, z), rand);
            }
        }
        boolean isMagic = GraveStoneHelper.isMagicDamage(damageSource, damageSource.field_76373_n);
        int[] graveCoordinates = GraveStoneHelper.findPlaceForGrave(world, x, y, z);
        if (graveCoordinates != null) {
            x = graveCoordinates[0];
            y = graveCoordinates[1];
            z = graveCoordinates[2];
            world.func_147465_d(x, y, z, (Block)this, GraveStoneHelper.getMetadataBasedOnRotation(direction), 2);
            TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
            if (tileEntity != null) {
                if (sword != null) {
                    tileEntity.setSword(sword);
                }
                tileEntity.getDeathTextComponent().setLocalized();
                tileEntity.getDeathTextComponent().setName(deathInfo.getName());
                tileEntity.getDeathTextComponent().setDeathText(deathInfo.getDeathMessage());
                tileEntity.getDeathTextComponent().setKillerName(deathInfo.getKillerName());
                tileEntity.setItems(items);
                tileEntity.setGraveType(graveType);
                tileEntity.setAge(age);
                tileEntity.setEnchanted(isMagic);
            }
            GSLogger.logInfoGrave("Create " + deathInfo.getName() + "'s grave at " + x + "x" + y + "x" + z);
        } else {
            ItemStack itemStack = this.func_149644_j(0);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("GraveType", graveType);
            nbt.func_74757_a("isLocalized", true);
            nbt.func_74778_a("name", deathInfo.getName());
            nbt.func_74778_a("DeathText", deathInfo.getDeathMessage());
            nbt.func_74778_a("KillerName", deathInfo.getKillerNameForTE());
            nbt.func_74757_a("Enchanted", isMagic);
            nbt.func_74768_a("Age", age);
            if (graveType == EnumGraves.SWORD.ordinal()) {
                GraveStoneHelper.addSwordInfo(nbt, sword);
            }
            itemStack.func_77982_d(nbt);
            this.func_149642_a(world, x, y, z, itemStack);
            if (items != null) {
                for (int i = 0; i < items.size(); ++i) {
                    if (items.get(i) == null) continue;
                    GraveInventory.dropItem(items.get(i), world, x, y, z);
                }
            }
            GSLogger.logInfoGrave("Can not create " + deathInfo.getName() + "'s grave at " + x + "x" + y + "x" + z);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack itemStack = this.func_149644_j(0);
        TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
        if (tileEntity != null && itemStack != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("GraveType", tileEntity.getGraveTypeNum());
            itemStack.func_77982_d(nbt);
            if (tileEntity.isSwordGrave()) {
                GraveStoneHelper.addSwordInfo(nbt, tileEntity.getSword());
            }
        }
        return itemStack;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        TileEntityGSGraveStone tileEntity;
        if (GraveStoneConfig.removeEmptyGraves && !world.field_72995_K && (tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z)) != null && !tileEntity.isSwordGrave() && tileEntity.isEmpty()) {
            if (GraveStoneConfig.showGravesRemovingMessages) {
                GSLogger.logInfoGrave("Remove empty grave at " + x + "/" + y + "/" + z);
            }
            world.func_147475_p(x, y, z);
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        }
    }

    public static enum EnumGraveType {
        ALL_GRAVES,
        PLAYER_GRAVES,
        PETS_GRAVES,
        DOGS_GRAVES,
        CATS_GRAVES,
        HORSE_GRAVES;

    }
}

