/*
 * Decompiled with CFR 0.152.
 */
package gravestone.core.compatibility;

import gravestone.config.GraveStoneConfig;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import twilightforest.item.TFItems;

public class GSCompatibilityTwilightForest {
    protected static boolean isInstalled = false;

    private GSCompatibilityTwilightForest() {
    }

    public static boolean handleCharmsOfKeeping(List<ItemStack> items, EntityPlayer player) {
        int[] keepingData;
        if (GSCompatibilityTwilightForest.isInstalled() && GraveStoneConfig.enableTwilightForestKeeping && (keepingData = GSCompatibilityTwilightForest.checkForCharmOfKeeping(player))[0] > 0) {
            Iterator<ItemStack> it = items.iterator();
            while (it.hasNext()) {
                ItemStack item = it.next();
                if (item == null || !item.func_77942_o()) continue;
                byte slot = item.func_77978_p().func_74771_c("slot");
                if (keepingData[0] == 1) {
                    if (slot != player.field_71071_by.field_70461_c) continue;
                    it.remove();
                    break;
                }
                if (keepingData[0] == 2) {
                    if (slot >= 9) continue;
                    it.remove();
                    continue;
                }
                if (keepingData[0] != 3 || slot >= 40) continue;
                it.remove();
            }
            for (ItemStack item : items) {
                if (item == null || !item.func_77942_o()) continue;
                byte slot = item.func_77978_p().func_74771_c("slot");
                if (slot == keepingData[1]) {
                    player.field_71071_by.func_70299_a((int)slot, item.func_77979_a(1));
                    if (item.field_77994_a > 0) continue;
                    item = null;
                    continue;
                }
                player.field_71071_by.func_70299_a((int)slot, null);
            }
            return true;
        }
        return false;
    }

    public static void addSlotTags(List<ItemStack> items) {
        if (GSCompatibilityTwilightForest.isInstalled() && GraveStoneConfig.enableTwilightForestKeeping) {
            for (int i = 0; i < items.size(); ++i) {
                NBTTagCompound nbt;
                ItemStack item = items.get(i);
                if (item == null || (nbt = item.func_77978_p()) == null && (nbt = new NBTTagCompound()).func_74764_b("slot")) continue;
                nbt.func_74774_a("slot", (byte)i);
                item.func_77982_d(nbt);
            }
        }
    }

    public static void removeSlotTags(List<ItemStack> items) {
        if (GSCompatibilityTwilightForest.isInstalled() && GraveStoneConfig.enableTwilightForestKeeping && items.size() > 0) {
            for (int i = 0; i < items.size(); ++i) {
                ItemStack item = items.get(i);
                if (item == null || !item.func_77942_o()) continue;
                NBTTagCompound nbt = item.func_77978_p();
                nbt.func_82580_o("slot");
                if (!nbt.func_82582_d()) continue;
                item.func_77982_d(null);
            }
        }
    }

    private static int[] checkForCharmOfKeeping(EntityPlayer player) {
        int max = 0;
        int slot = -1;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack stack = player.field_71071_by.field_70462_a[i];
            if (stack == null) continue;
            if (stack.func_77973_b() == TFItems.charmOfKeeping1) {
                if (max >= 1) continue;
                max = 1;
                slot = i;
                continue;
            }
            if (stack.func_77973_b() == TFItems.charmOfKeeping2) {
                if (max >= 2) continue;
                max = 2;
                slot = i;
                continue;
            }
            if (stack.func_77973_b() != TFItems.charmOfKeeping3 || max >= 3) continue;
            max = 3;
            slot = i;
        }
        return new int[]{max, slot};
    }

    public static boolean isInstalled() {
        return isInstalled;
    }
}

