/*
 * Decompiled with CFR 0.152.
 */
package gravestone.entity.monster;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravestone.core.Resources;
import gravestone.entity.ai.EntityAIAttackLivingHorse;
import gravestone.entity.monster.EntityUndeadCat;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityZombieCat
extends EntityUndeadCat {
    private static final byte CAT_TYPES = 4;
    protected boolean isGreen = false;

    public EntityZombieCat(World world) {
        this(world, world.field_73012_v.nextBoolean());
    }

    public EntityZombieCat(World world, boolean isGreen) {
        super(world);
        this.isGreen = isGreen;
        this.texture = isGreen ? Resources.GREEN_ZOMBIE_OZELOT : Resources.ZOMBIE_OZELOT;
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityVillager.class, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityWolf.class, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityOcelot.class, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackLivingHorse((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityWolf.class, 0, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityOcelot.class, 0, false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityChicken.class, 0, false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityHorse.class, 0, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTexture() {
        if (this.isGreen) {
            switch (this.getSkin()) {
                case 1: {
                    return Resources.GREEN_ZOMBIE_CAT_BLACK;
                }
                case 2: {
                    return Resources.GREEN_ZOMBIE_CAT_RED;
                }
                case 3: {
                    return Resources.GREEN_ZOMBIE_CAT_SIAMESE;
                }
            }
            return Resources.GREEN_ZOMBIE_OZELOT;
        }
        switch (this.getSkin()) {
            case 1: {
                return Resources.ZOMBIE_CAT_BLACK;
            }
            case 2: {
                return Resources.ZOMBIE_CAT_RED;
            }
            case 3: {
                return Resources.ZOMBIE_CAT_SIAMESE;
            }
        }
        return Resources.ZOMBIE_OZELOT;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("ZombieCatType", this.getSkin());
        nbt.func_74757_a("IsGreen", this.isGreen);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSkin(nbt.func_74762_e("ZombieCatType"));
        if (nbt.func_74764_b("IsGreen")) {
            this.isGreen = nbt.func_74767_n("IsGreen");
        }
    }

    protected String func_70639_aQ() {
        return this.field_70146_Z.nextInt(4) == 0 ? "mob.cat.purreow" : "mob.cat.meow";
    }

    protected String func_70621_aR() {
        return "mob.cat.hitt";
    }

    protected String func_70673_aS() {
        return "mob.cat.hitt";
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Items.field_151078_bh;
    }

    public int getSkin() {
        return this.field_70180_af.func_75683_a(18);
    }

    public void setSkin(int par1) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)par1));
    }

    public void func_70074_a(EntityLivingBase entityLiving) {
        super.func_70074_a(entityLiving);
        if (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL || this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
            this.spawnZombieMob(entityLiving);
        }
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        this.setSkin(new Random().nextInt(4));
        return super.func_110161_a(data);
    }
}

