/*
 * Decompiled with CFR 0.152.
 */
package gravestone.item.corpse;

import gravestone.ModGraveStone;
import gravestone.core.GSItem;
import gravestone.item.corpse.CatCorpseHelper;
import gravestone.item.corpse.DogCorpseHelper;
import gravestone.item.corpse.HorseCorpseHelper;
import gravestone.item.corpse.VillagerCorpseHelper;
import gravestone.item.enums.EnumCorpse;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;

public abstract class CorpseHelper {
    protected static void setMobName(EntityLiving entity, NBTTagCompound nbtTag) {
        if (nbtTag.func_74764_b("Name") && nbtTag.func_74779_i("Name").length() != 0) {
            entity.func_94058_c(nbtTag.func_74779_i("Name"));
        }
    }

    protected static void setName(EntityLiving entity, NBTTagCompound nbtTag) {
        if (entity.func_94056_bM()) {
            nbtTag.func_74778_a("Name", entity.func_94057_bL());
        }
    }

    protected static void spawnMob(EntityLiving entity, World world, int x, int y, int z) {
        entity.func_70107_b((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
        world.func_72838_d((Entity)entity);
        entity.func_70690_d(new PotionEffect(Potion.field_76428_l.func_76396_c(), 300));
    }

    protected static void addNameInfo(List list, NBTTagCompound nbtTag) {
        if (nbtTag.func_74764_b("Name") && nbtTag.func_74779_i("Name").length() != 0) {
            list.add(ModGraveStone.proxy.getLocalizedString("item.corpse.entity_name") + " " + nbtTag.func_74779_i("Name"));
        }
    }

    public static void addInfo(int corpseType, List list, NBTTagCompound nbtTag) {
        switch (EnumCorpse.values()[corpseType]) {
            case VILLAGER: {
                VillagerCorpseHelper.addInfo(list, nbtTag);
                break;
            }
            case HORSE: {
                HorseCorpseHelper.addInfo(list, nbtTag);
                break;
            }
            case DOG: {
                DogCorpseHelper.addInfo(list, nbtTag);
                break;
            }
            case CAT: {
                CatCorpseHelper.addInfo(list, nbtTag);
            }
        }
    }

    public static List<ItemStack> getDefaultCorpse(Item item, int corpseType) {
        switch (EnumCorpse.values()[corpseType]) {
            case HORSE: {
                return HorseCorpseHelper.getDefaultCorpses(item, corpseType);
            }
            case DOG: {
                return DogCorpseHelper.getDefaultCorpses(item, corpseType);
            }
            case CAT: {
                return CatCorpseHelper.getDefaultCorpses(item, corpseType);
            }
        }
        return VillagerCorpseHelper.getDefaultCorpses(item, corpseType);
    }

    public static List<ItemStack> getCorpse(Entity entity, EnumCorpse type) {
        NBTTagCompound nbtTag = new NBTTagCompound();
        switch (type) {
            case VILLAGER: {
                VillagerCorpseHelper.setNbt((EntityVillager)entity, nbtTag);
                break;
            }
            case HORSE: {
                HorseCorpseHelper.setNbt((EntityHorse)entity, nbtTag);
                break;
            }
            case DOG: {
                DogCorpseHelper.setNbt((EntityWolf)entity, nbtTag);
                break;
            }
            case CAT: {
                CatCorpseHelper.setNbt((EntityOcelot)entity, nbtTag);
            }
        }
        ArrayList<ItemStack> corpse = new ArrayList<ItemStack>();
        ItemStack stack = new ItemStack(GSItem.corpse, 1, type.ordinal());
        stack.func_77982_d(nbtTag);
        corpse.add(stack);
        return corpse;
    }

    public static void spawnMob(int type, World world, int x, int y, int z, NBTTagCompound nbtTag, EntityPlayer player) {
        if (!world.field_72995_K) {
            switch (EnumCorpse.values()[type]) {
                case VILLAGER: {
                    VillagerCorpseHelper.spawnVillager(world, x, y, z, nbtTag);
                    break;
                }
                case HORSE: {
                    HorseCorpseHelper.spawnHorse(world, x, y, z, nbtTag, player);
                    break;
                }
                case DOG: {
                    DogCorpseHelper.spawnDog(world, x, y, z, nbtTag, player);
                    break;
                }
                case CAT: {
                    CatCorpseHelper.spawnCat(world, x, y, z, nbtTag, player);
                }
            }
        }
    }

    public static boolean canSpawnMob(EntityPlayer player, int damage) {
        if (player.field_70170_p.func_72912_H().func_76077_q().equals((Object)WorldSettings.GameType.CREATIVE)) {
            return true;
        }
        return player.field_71068_ca >= CorpseHelper.getRequiredLevel(damage);
    }

    public static void getExperience(EntityPlayer player, int damage) {
        player.func_82242_a(-CorpseHelper.getRequiredLevel(damage));
    }

    public static int getRequiredLevel(int damage) {
        switch (EnumCorpse.getById((byte)damage)) {
            case VILLAGER: {
                return 20;
            }
            case DOG: 
            case CAT: {
                return 7;
            }
            case HORSE: {
                return 15;
            }
        }
        return 0;
    }

    public static int getRequiredLevel(ItemStack itemStack) {
        if (itemStack != null) {
            return CorpseHelper.getRequiredLevel(itemStack.func_77960_j());
        }
        return 0;
    }
}

