/*
 * Decompiled with CFR 0.152.
 */
package gravestone.renderer.tileentity;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravestone.block.enums.EnumMemorials;
import gravestone.models.block.ModelMemorial;
import gravestone.models.block.memorials.ModelAngelStatueMemorial;
import gravestone.models.block.memorials.ModelBurningStake;
import gravestone.models.block.memorials.ModelCatStatueMemorial;
import gravestone.models.block.memorials.ModelCreeperStatueMemorial;
import gravestone.models.block.memorials.ModelDogStatueMemorial;
import gravestone.models.block.memorials.ModelGibbet;
import gravestone.models.block.memorials.ModelMemorialCross;
import gravestone.models.block.memorials.ModelMemorialObelisk;
import gravestone.models.block.memorials.ModelSteveStatueMemorial;
import gravestone.models.block.memorials.ModelStocks;
import gravestone.models.block.memorials.ModelVillagerMemorial;
import gravestone.renderer.tileentity.TileEntityGSRenderer;
import gravestone.tileentity.TileEntityGSMemorial;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityGSMemorialRenderer
extends TileEntityGSRenderer {
    public static ModelMemorial cross = new ModelMemorialCross();
    public static ModelMemorial obelisk = new ModelMemorialObelisk();
    public static ModelMemorial steveStatue = new ModelSteveStatueMemorial();
    public static ModelMemorial villagerStatue = new ModelVillagerMemorial();
    public static ModelMemorial angelStatue = new ModelAngelStatueMemorial();
    public static ModelMemorial dogStatue = new ModelDogStatueMemorial();
    public static ModelMemorial catStatue = new ModelCatStatueMemorial();
    public static ModelMemorial creeperStatue = new ModelCreeperStatueMemorial();
    public static ModelMemorial gibbet = new ModelGibbet();
    public static ModelMemorial stocks = new ModelStocks();
    public static ModelMemorial burningStake = new ModelBurningStake();
    private final Map<EnumMemorials, ModelMemorial> MODELS_MAP = ImmutableMap.builder().put((Object)EnumMemorials.STONE_CROSS, (Object)cross).put((Object)EnumMemorials.QUARTZ_OBELISK, (Object)obelisk).put((Object)EnumMemorials.STONE_STEVE_STATUE, (Object)steveStatue).put((Object)EnumMemorials.STONE_VILLAGER_STATUE, (Object)villagerStatue).put((Object)EnumMemorials.STONE_ANGEL_STATUE, (Object)angelStatue).put((Object)EnumMemorials.STONE_DOG_STATUE, (Object)dogStatue).put((Object)EnumMemorials.STONE_CAT_STATUE, (Object)catStatue).put((Object)EnumMemorials.STONE_CREEPER_STATUE, (Object)creeperStatue).put((Object)EnumMemorials.WOODEN_CROSS, (Object)cross).put((Object)EnumMemorials.SANDSTONE_CROSS, (Object)cross).put((Object)EnumMemorials.MOSSY_CROSS, (Object)cross).put((Object)EnumMemorials.IRON_CROSS, (Object)cross).put((Object)EnumMemorials.GOLDEN_CROSS, (Object)cross).put((Object)EnumMemorials.DIAMOND_CROSS, (Object)cross).put((Object)EnumMemorials.EMERALD_CROSS, (Object)cross).put((Object)EnumMemorials.LAPIS_CROSS, (Object)cross).put((Object)EnumMemorials.REDSTONE_CROSS, (Object)cross).put((Object)EnumMemorials.OBSIDIAN_CROSS, (Object)cross).put((Object)EnumMemorials.QUARTZ_CROSS, (Object)cross).put((Object)EnumMemorials.ICE_CROSS, (Object)cross).put((Object)EnumMemorials.WOODEN_OBELISK, (Object)obelisk).put((Object)EnumMemorials.SANDSTONE_OBELISK, (Object)obelisk).put((Object)EnumMemorials.STONE_OBELISK, (Object)obelisk).put((Object)EnumMemorials.MOSSY_OBELISK, (Object)obelisk).put((Object)EnumMemorials.IRON_OBELISK, (Object)obelisk).put((Object)EnumMemorials.GOLDEN_OBELISK, (Object)obelisk).put((Object)EnumMemorials.DIAMOND_OBELISK, (Object)obelisk).put((Object)EnumMemorials.EMERALD_OBELISK, (Object)obelisk).put((Object)EnumMemorials.LAPIS_OBELISK, (Object)obelisk).put((Object)EnumMemorials.REDSTONE_OBELISK, (Object)obelisk).put((Object)EnumMemorials.OBSIDIAN_OBELISK, (Object)obelisk).put((Object)EnumMemorials.ICE_OBELISK, (Object)obelisk).put((Object)EnumMemorials.WOODEN_STEVE_STATUE, (Object)steveStatue).put((Object)EnumMemorials.SANDSTONE_STEVE_STATUE, (Object)steveStatue).put((Object)EnumMemorials.MOSSY_STEVE_STATUE, (Object)steveStatue).put((Object)EnumMemorials.IRON_STEVE_STATUE, (Object)steveStatue).put((Object)EnumMemorials.GOLDEN_STEVE_STATUE, (Object)steveStatue).put((Object)EnumMemorials.DIAMOND_STEVE_STATUE, (Object)steveStatue).put((Object)EnumMemorials.EMERALD_STEVE_STATUE, (Object)steveStatue).put((Object)EnumMemorials.LAPIS_STEVE_STATUE, (Object)steveStatue).put((Object)EnumMemorials.REDSTONE_STEVE_STATUE, (Object)steveStatue).put((Object)EnumMemorials.OBSIDIAN_STEVE_STATUE, (Object)steveStatue).put((Object)EnumMemorials.QUARTZ_STEVE_STATUE, (Object)steveStatue).put((Object)EnumMemorials.ICE_STEVE_STATUE, (Object)steveStatue).put((Object)EnumMemorials.WOODEN_VILLAGER_STATUE, (Object)villagerStatue).put((Object)EnumMemorials.SANDSTONE_VILLAGER_STATUE, (Object)villagerStatue).put((Object)EnumMemorials.MOSSY_VILLAGER_STATUE, (Object)villagerStatue).put((Object)EnumMemorials.IRON_VILLAGER_STATUE, (Object)villagerStatue).put((Object)EnumMemorials.GOLDEN_VILLAGER_STATUE, (Object)villagerStatue).put((Object)EnumMemorials.DIAMOND_VILLAGER_STATUE, (Object)villagerStatue).put((Object)EnumMemorials.EMERALD_VILLAGER_STATUE, (Object)villagerStatue).put((Object)EnumMemorials.LAPIS_VILLAGER_STATUE, (Object)villagerStatue).put((Object)EnumMemorials.REDSTONE_VILLAGER_STATUE, (Object)villagerStatue).put((Object)EnumMemorials.OBSIDIAN_VILLAGER_STATUE, (Object)villagerStatue).put((Object)EnumMemorials.QUARTZ_VILLAGER_STATUE, (Object)villagerStatue).put((Object)EnumMemorials.ICE_VILLAGER_STATUE, (Object)villagerStatue).put((Object)EnumMemorials.WOODEN_ANGEL_STATUE, (Object)angelStatue).put((Object)EnumMemorials.SANDSTONE_ANGEL_STATUE, (Object)angelStatue).put((Object)EnumMemorials.MOSSY_ANGEL_STATUE, (Object)angelStatue).put((Object)EnumMemorials.IRON_ANGEL_STATUE, (Object)angelStatue).put((Object)EnumMemorials.GOLDEN_ANGEL_STATUE, (Object)angelStatue).put((Object)EnumMemorials.DIAMOND_ANGEL_STATUE, (Object)angelStatue).put((Object)EnumMemorials.EMERALD_ANGEL_STATUE, (Object)angelStatue).put((Object)EnumMemorials.LAPIS_ANGEL_STATUE, (Object)angelStatue).put((Object)EnumMemorials.REDSTONE_ANGEL_STATUE, (Object)angelStatue).put((Object)EnumMemorials.OBSIDIAN_ANGEL_STATUE, (Object)angelStatue).put((Object)EnumMemorials.QUARTZ_ANGEL_STATUE, (Object)angelStatue).put((Object)EnumMemorials.ICE_ANGEL_STATUE, (Object)angelStatue).put((Object)EnumMemorials.WOODEN_DOG_STATUE, (Object)dogStatue).put((Object)EnumMemorials.SANDSTONE_DOG_STATUE, (Object)dogStatue).put((Object)EnumMemorials.MOSSY_DOG_STATUE, (Object)dogStatue).put((Object)EnumMemorials.IRON_DOG_STATUE, (Object)dogStatue).put((Object)EnumMemorials.GOLDEN_DOG_STATUE, (Object)dogStatue).put((Object)EnumMemorials.DIAMOND_DOG_STATUE, (Object)dogStatue).put((Object)EnumMemorials.EMERALD_DOG_STATUE, (Object)dogStatue).put((Object)EnumMemorials.LAPIS_DOG_STATUE, (Object)dogStatue).put((Object)EnumMemorials.REDSTONE_DOG_STATUE, (Object)dogStatue).put((Object)EnumMemorials.OBSIDIAN_DOG_STATUE, (Object)dogStatue).put((Object)EnumMemorials.QUARTZ_DOG_STATUE, (Object)dogStatue).put((Object)EnumMemorials.ICE_DOG_STATUE, (Object)dogStatue).put((Object)EnumMemorials.WOODEN_CAT_STATUE, (Object)catStatue).put((Object)EnumMemorials.SANDSTONE_CAT_STATUE, (Object)catStatue).put((Object)EnumMemorials.MOSSY_CAT_STATUE, (Object)catStatue).put((Object)EnumMemorials.IRON_CAT_STATUE, (Object)catStatue).put((Object)EnumMemorials.GOLDEN_CAT_STATUE, (Object)catStatue).put((Object)EnumMemorials.DIAMOND_CAT_STATUE, (Object)catStatue).put((Object)EnumMemorials.EMERALD_CAT_STATUE, (Object)catStatue).put((Object)EnumMemorials.LAPIS_CAT_STATUE, (Object)catStatue).put((Object)EnumMemorials.REDSTONE_CAT_STATUE, (Object)catStatue).put((Object)EnumMemorials.OBSIDIAN_CAT_STATUE, (Object)catStatue).put((Object)EnumMemorials.QUARTZ_CAT_STATUE, (Object)catStatue).put((Object)EnumMemorials.ICE_CAT_STATUE, (Object)catStatue).put((Object)EnumMemorials.WOODEN_CREEPER_STATUE, (Object)creeperStatue).put((Object)EnumMemorials.SANDSTONE_CREEPER_STATUE, (Object)creeperStatue).put((Object)EnumMemorials.MOSSY_CREEPER_STATUE, (Object)creeperStatue).put((Object)EnumMemorials.IRON_CREEPER_STATUE, (Object)creeperStatue).put((Object)EnumMemorials.GOLDEN_CREEPER_STATUE, (Object)creeperStatue).put((Object)EnumMemorials.DIAMOND_CREEPER_STATUE, (Object)creeperStatue).put((Object)EnumMemorials.EMERALD_CREEPER_STATUE, (Object)creeperStatue).put((Object)EnumMemorials.LAPIS_CREEPER_STATUE, (Object)creeperStatue).put((Object)EnumMemorials.REDSTONE_CREEPER_STATUE, (Object)creeperStatue).put((Object)EnumMemorials.OBSIDIAN_CREEPER_STATUE, (Object)creeperStatue).put((Object)EnumMemorials.QUARTZ_CREEPER_STATUE, (Object)creeperStatue).put((Object)EnumMemorials.ICE_CREEPER_STATUE, (Object)creeperStatue).put((Object)EnumMemorials.GIBBET, (Object)gibbet).put((Object)EnumMemorials.STOCKS, (Object)stocks).put((Object)EnumMemorials.BURNING_STAKE, (Object)burningStake).build();
    public static TileEntityGSMemorialRenderer instance;

    public TileEntityGSMemorialRenderer() {
        instance = this;
    }

    @Override
    public void func_147500_a(TileEntity te, double x, double y, double z, float f) {
        TileEntityGSMemorial tileEntity = (TileEntityGSMemorial)te;
        EnumMemorials memorialType = tileEntity.getMemorialType();
        int meta = tileEntity.func_145831_w() != null ? tileEntity.func_145832_p() : 0;
        this.bindTextureByName(memorialType.getTexture());
        GL11.glPushMatrix();
        if (tileEntity.func_145831_w() != null) {
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        } else {
            switch (memorialType) {
                case WOODEN_CROSS: 
                case SANDSTONE_CROSS: 
                case STONE_CROSS: 
                case MOSSY_CROSS: 
                case IRON_CROSS: 
                case GOLDEN_CROSS: 
                case DIAMOND_CROSS: 
                case EMERALD_CROSS: 
                case LAPIS_CROSS: 
                case REDSTONE_CROSS: 
                case OBSIDIAN_CROSS: 
                case QUARTZ_CROSS: 
                case ICE_CROSS: 
                case WOODEN_OBELISK: 
                case SANDSTONE_OBELISK: 
                case STONE_OBELISK: 
                case MOSSY_OBELISK: 
                case IRON_OBELISK: 
                case GOLDEN_OBELISK: 
                case DIAMOND_OBELISK: 
                case EMERALD_OBELISK: 
                case LAPIS_OBELISK: 
                case REDSTONE_OBELISK: 
                case OBSIDIAN_OBELISK: 
                case QUARTZ_OBELISK: 
                case ICE_OBELISK: {
                    GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
                    GL11.glScalef((float)0.4f, (float)-0.4f, (float)-0.4f);
                    break;
                }
                default: {
                    GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.8f), (float)((float)z + 0.5f));
                    GL11.glScalef((float)0.7f, (float)-0.7f, (float)-0.7f);
                }
            }
        }
        switch (TileEntityGSMemorialRenderer.getMemorialDirection(meta)) {
            case 0: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 1: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        ModelMemorial model = this.MODELS_MAP.get(memorialType);
        model.setPedestalTexture(memorialType.getPedestalTexture());
        switch (memorialType) {
            case WOODEN_CREEPER_STATUE: 
            case SANDSTONE_CREEPER_STATUE: 
            case STONE_CREEPER_STATUE: 
            case MOSSY_CREEPER_STATUE: 
            case IRON_CREEPER_STATUE: 
            case GOLDEN_CREEPER_STATUE: 
            case DIAMOND_CREEPER_STATUE: 
            case EMERALD_CREEPER_STATUE: 
            case LAPIS_CREEPER_STATUE: 
            case REDSTONE_CREEPER_STATUE: 
            case OBSIDIAN_CREEPER_STATUE: 
            case QUARTZ_CREEPER_STATUE: 
            case ICE_CREEPER_STATUE: {
                model.customRender(tileEntity.isEnchanted());
                break;
            }
            case WOODEN_STEVE_STATUE: 
            case SANDSTONE_STEVE_STATUE: 
            case STONE_STEVE_STATUE: 
            case MOSSY_STEVE_STATUE: 
            case IRON_STEVE_STATUE: 
            case GOLDEN_STEVE_STATUE: 
            case DIAMOND_STEVE_STATUE: 
            case EMERALD_STEVE_STATUE: 
            case LAPIS_STEVE_STATUE: 
            case REDSTONE_STEVE_STATUE: 
            case OBSIDIAN_STEVE_STATUE: 
            case QUARTZ_STEVE_STATUE: 
            case ICE_STEVE_STATUE: {
                model.customRender(memorialType, tileEntity.isEnchanted());
                break;
            }
            case GIBBET: 
            case STOCKS: 
            case BURNING_STAKE: {
                model.customRender(memorialType, tileEntity.getHangedMob(), tileEntity.getHangedVillagerProfession());
                break;
            }
            default: {
                if (tileEntity.isEnchanted()) {
                    model.renderEnchanted();
                    break;
                }
                model.renderAll();
            }
        }
        GL11.glPopMatrix();
    }

    private static int getMemorialDirection(int meta) {
        switch (meta) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 1;
            }
        }
        return 2;
    }
}

