/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.bspkrscore.fml.bspkrsCoreMod;
import bspkrs.treecapitator.CommonProxy;
import bspkrs.treecapitator.config.TCConfigHandler;
import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.forge.ForgeEventHandler;
import bspkrs.treecapitator.registry.ModConfigRegistry;
import bspkrs.treecapitator.registry.RegistryNBTManager;
import bspkrs.treecapitator.registry.ThirdPartyModConfig;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.CommonUtils;
import bspkrs.util.Const;
import bspkrs.util.ModVersionChecker;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="Treecapitator", name="Treecapitator", version="1.7.10", dependencies="required-after:bspkrsCore@[6.15,)", useMetadata=true, guiFactory="bspkrs.treecapitator.fml.gui.ModGuiFactoryHandler")
public class TreecapitatorMod {
    public static ModVersionChecker versionChecker;
    private final String versionURL = Const.VERSION_URL + "/Minecraft/" + Const.MCVERSION + "/treecapitator.version";
    private final String mcfTopic = "http://www.minecraftforum.net/topic/1009577-";
    private RegistryNBTManager nbtManager;
    @Mod.Metadata(value="Treecapitator")
    public static ModMetadata metadata;
    @SidedProxy(clientSide="bspkrs.treecapitator.ClientProxy", serverSide="bspkrs.treecapitator.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="Treecapitator")
    public static TreecapitatorMod instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        metadata = event.getModMetadata();
        File file = event.getSuggestedConfigurationFile();
        if (!CommonUtils.isObfuscatedEnv()) {
            // empty if block
        }
        TCConfigHandler.setInstance(file);
        if (!CommonUtils.isObfuscatedEnv()) {
            TCSettings.allowDebugLogging = true;
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandler());
        FMLCommonHandler.instance().bus().register((Object)TCConfigHandler.instance());
        proxy.init(event);
        if (bspkrsCoreMod.instance.allowUpdateCheck) {
            versionChecker = new ModVersionChecker(TreecapitatorMod.metadata.name, TreecapitatorMod.metadata.version, this.versionURL, "http://www.minecraftforum.net/topic/1009577-");
            versionChecker.checkVersionWithLogging();
        }
    }

    @Mod.EventHandler
    public void processIMCMessages(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages().asList()) {
            if (msg.isNBTMessage() && msg.key.equals("EyeNotification")) continue;
            if (msg.isNBTMessage()) {
                TCLog.info("Received IMC message from mod %s.", msg.getSender());
                if (ThirdPartyModConfig.isValidNBT(msg.getNBTValue())) {
                    ModConfigRegistry.instance().registerIMCModConfig(msg.getSender(), ThirdPartyModConfig.readFromNBT(msg.getNBTValue()));
                    continue;
                }
                TCLog.severe("Validation failed for IMC message sent by %s", msg.getSender());
                continue;
            }
            TCLog.warning("Mod %s sent an IMC message, but it is not an NBT object message. The message will be ignored.", msg.getSender());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModConfigRegistry.instance().applyPrioritizedModConfigs();
        this.nbtManager();
    }

    public RegistryNBTManager nbtManager() {
        if (this.nbtManager == null) {
            this.nbtManager = new RegistryNBTManager();
        }
        return this.nbtManager;
    }
}

