/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import minetweaker.IUndoableAction;
import minetweaker.mc1710.util.MineTweakerHacks;
import net.minecraft.util.StringTranslate;

public class SetTranslationAction
implements IUndoableAction {
    private static final StringTranslate INSTANCE = MineTweakerHacks.getStringTranslateInstance();
    private static final Charset UTF8 = Charset.forName("utf-8");
    private final String key;
    private final String newValue;
    private final String oldValue;

    public SetTranslationAction(String key, String value) {
        this.key = key;
        this.newValue = value;
        this.oldValue = INSTANCE.func_74805_b(key);
    }

    @Override
    public void apply() {
        SetTranslationAction.set(this.key, this.newValue);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        SetTranslationAction.set(this.key, this.oldValue);
    }

    @Override
    public String describe() {
        return "Translating " + this.key + " to " + this.newValue;
    }

    @Override
    public String describeUndo() {
        return "Reverting " + this.key + " to " + this.oldValue;
    }

    private static void set(String key, String value) {
        if (value.contains("\\\"")) {
            value = value.replace("\\\"", "\"");
        }
        StringTranslate.inject((InputStream)new ByteArrayInputStream((key + "=" + value).getBytes(UTF8)));
    }

    @Override
    public Object getOverrideKey() {
        return null;
    }
}

