/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.mfr.machines;

import java.util.ArrayList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.mods.mfr.machines.IRedNetFunction;
import net.minecraft.nbt.NBTTagCompound;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetLogicCircuit;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mfr.RedNet")
@ModOnly(value={"MineFactoryReloaded"})
public class RedNet {
    @ZenMethod
    public static void addCircuit(String name, String[] inputs, String[] outputs, IRedNetFunction function) {
        MineTweakerAPI.apply(new AddCircuitAction(new TweakerRedNetLogicCircuit(name, inputs, outputs, function)));
    }

    @ZenMethod
    public static void removeCircuit(String name) {
        ArrayList<IRedNetLogicCircuit> toRemove = new ArrayList<IRedNetLogicCircuit>();
        for (IRedNetLogicCircuit circuit : MFRRegistry.getRedNetLogicCircuits()) {
            if (!circuit.getUnlocalizedName().equals(name)) continue;
            toRemove.add(circuit);
        }
        if (toRemove.isEmpty()) {
            MineTweakerAPI.logWarning("No such rednet circuit: " + name);
        } else {
            for (IRedNetLogicCircuit toRemoveEntry : toRemove) {
                MineTweakerAPI.apply(new RemoveCircuitAction(toRemoveEntry));
            }
        }
    }

    private static class RemoveCircuitAction
    implements IUndoableAction {
        private final IRedNetLogicCircuit circuit;

        public RemoveCircuitAction(IRedNetLogicCircuit circuit) {
            this.circuit = circuit;
        }

        @Override
        public void apply() {
            MFRRegistry.getRedNetLogicCircuits().remove(this.circuit);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.getRedNetLogicCircuits().add(this.circuit);
        }

        @Override
        public String describe() {
            return "Removing RedNet circuit " + this.circuit.getUnlocalizedName();
        }

        @Override
        public String describeUndo() {
            return "Restoring RedNet circuit " + this.circuit.getUnlocalizedName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddCircuitAction
    implements IUndoableAction {
        private final TweakerRedNetLogicCircuit circuit;

        public AddCircuitAction(TweakerRedNetLogicCircuit circuit) {
            this.circuit = circuit;
        }

        @Override
        public void apply() {
            MFRRegistry.registerRedNetLogicCircuit((IRedNetLogicCircuit)this.circuit);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.getRedNetLogicCircuits().remove(this.circuit);
        }

        @Override
        public String describe() {
            return "Adding rednet circuit " + this.circuit.name;
        }

        @Override
        public String describeUndo() {
            return "Removing rednet circuit " + this.circuit.name;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class TweakerRedNetLogicCircuit
    implements IRedNetLogicCircuit {
        private final String name;
        private final String[] inputs;
        private final String[] outputs;
        private final IRedNetFunction function;

        public TweakerRedNetLogicCircuit(String name, String[] inputs, String[] outputs, IRedNetFunction function) {
            this.name = name;
            this.inputs = inputs;
            this.outputs = outputs;
            this.function = function;
        }

        public byte getInputCount() {
            return (byte)this.inputs.length;
        }

        public byte getOutputCount() {
            return (byte)this.outputs.length;
        }

        public int[] recalculateOutputValues(long l, int[] ints) {
            return this.function.calculate(l, ints);
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        public String getInputPinLabel(int i) {
            return this.inputs[i];
        }

        public String getOutputPinLabel(int i) {
            return this.outputs[i];
        }

        public void readFromNBT(NBTTagCompound nbttc) {
        }

        public void writeToNBT(NBTTagCompound nbttc) {
        }
    }
}

