/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.runtime.providers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import minetweaker.MineTweakerAPI;
import minetweaker.runtime.IScriptIterator;
import minetweaker.runtime.IScriptProvider;
import minetweaker.runtime.providers.ScriptIteratorDirectory;
import minetweaker.runtime.providers.ScriptIteratorSingle;
import minetweaker.runtime.providers.ScriptIteratorZip;

public class ScriptProviderDirectory
implements IScriptProvider {
    private final File directory;

    public ScriptProviderDirectory(File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("directory cannot be null");
        }
        this.directory = directory;
    }

    @Override
    public Iterator<IScriptIterator> getScripts() {
        ArrayList<IScriptIterator> scripts = new ArrayList<IScriptIterator>();
        if (this.directory.exists()) {
            for (File file : this.directory.listFiles()) {
                if (file.isDirectory()) {
                    scripts.add(new ScriptIteratorDirectory(file));
                    continue;
                }
                if (file.getName().endsWith(".zs")) {
                    scripts.add(new ScriptIteratorSingle(file));
                    continue;
                }
                if (!file.getName().endsWith(".zip")) continue;
                try {
                    scripts.add(new ScriptIteratorZip(file));
                }
                catch (IOException ex) {
                    MineTweakerAPI.logError("Could not load " + file.getName() + ": " + ex.getMessage());
                }
            }
        }
        return scripts.iterator();
    }
}

