/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.eggs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Jingle {
    public static Map<String, Jingle> jingles = new HashMap<String, Jingle>();
    private static final Random jingler = new Random();
    public static final String backupJingle = "11,17,10,10,17,13,13,13,15,11";
    private static int minRange;
    private static int maxRange;
    private List<PlayTick> playTicks = new ArrayList<PlayTick>();
    private int minNote = -1;
    private int maxNote = 0;
    private static final char PLAY_TICK_DELIMITER = ',';
    private static final char LENGTH_DELIMITER = '_';
    private static final char NOTE_DELIMITER = '&';
    private static final int DEFAULT_LENGTH = 2;

    public static Jingle getBackupJingle() {
        return Jingle.parse(backupJingle);
    }

    public static int getMaxRange() {
        return maxRange;
    }

    public static int getMinRange() {
        return minRange;
    }

    public static Jingle getRandomJingle(int range) {
        int totalWeight = 0;
        ArrayList<Jingle> possibleJingles = new ArrayList<Jingle>();
        for (Jingle jingle : jingles.values()) {
            int jingleRange = jingle.getRange();
            if (jingleRange > range) continue;
            totalWeight += range - Math.abs(range - jingleRange);
            possibleJingles.add(jingle);
        }
        float choice = jingler.nextFloat() * (float)totalWeight;
        for (Jingle jingle : possibleJingles) {
            if (!((choice -= (float)(range - Math.abs(range - jingle.getRange()))) <= 0.0f)) continue;
            return jingle;
        }
        return null;
    }

    public static void initJingles(String[] jingles) {
        Jingle.jingles.clear();
        minRange = Integer.MAX_VALUE;
        maxRange = Integer.MIN_VALUE;
        for (String jingle : jingles) {
            Jingle parsedJingle = Jingle.parse(jingle);
            int range = parsedJingle.getRange();
            if (range < minRange) {
                minRange = range;
            }
            if (range > maxRange) {
                maxRange = range;
            }
            Jingle.jingles.put(jingle, parsedJingle);
        }
    }

    public static Jingle parse(String string) {
        String[] parts;
        if (jingles.containsKey(string)) {
            return jingles.get(string);
        }
        Jingle jingle = new Jingle();
        for (String part : parts = string.split(",")) {
            String[] noteEvent = part.split("_");
            if (noteEvent.length == 0) continue;
            try {
                int[] notes;
                String note = noteEvent[0];
                if (note.indexOf(38) == -1) {
                    notes = new int[]{Integer.parseInt(noteEvent[0])};
                } else {
                    String[] noteStrings = note.split("&");
                    notes = new int[noteStrings.length];
                    for (int i = 0; i < notes.length; ++i) {
                        notes[i] = Integer.parseInt(noteStrings[i]);
                    }
                }
                jingle.addPlayTick(new PlayTick(notes, noteEvent.length == 1 ? 2 : Integer.parseInt(noteEvent[1])));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (jingle.getNoteCount() == 0) {
            jingle = Jingle.getBackupJingle();
        }
        jingle.calculateRange();
        return jingle;
    }

    public void addPlayTick(PlayTick playTick) {
        this.playTicks.add(playTick);
    }

    public void calculateRange() {
        this.minNote = 24;
        this.maxNote = 0;
        for (PlayTick playTick : this.playTicks) {
            for (int note : playTick.notes) {
                if (note > this.maxNote) {
                    this.maxNote = note;
                }
                if (note >= this.minNote) continue;
                this.minNote = note;
            }
        }
        if (this.minNote > this.maxNote) {
            this.minNote = -1;
            this.maxNote = 0;
        }
    }

    public int getLowestNote() {
        return this.minNote;
    }

    public int getNoteCount() {
        return this.playTicks.size();
    }

    public List<PlayTick> getPlayTicks() {
        return this.playTicks;
    }

    public int getRange() {
        return this.maxNote - this.minNote + 1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean mostCommonLength = false;
        boolean numberof = false;
        for (int n = 0; n < this.playTicks.size(); ++n) {
            PlayTick playTick = this.playTicks.get(n);
            for (int i = 0; i < playTick.notes.length; ++i) {
                stringBuilder.append(playTick.notes[i]);
                if (i >= playTick.notes.length - 1) continue;
                stringBuilder.append('&');
            }
            stringBuilder.append('_');
            stringBuilder.append(playTick.length);
            if (n >= this.playTicks.size() - 1) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.toString();
    }

    public static class PlayTick {
        private int[] notes;
        private int length;

        public PlayTick(int[] note, int length) {
            this.notes = note;
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public int[] getNotes() {
            return this.notes;
        }
    }
}

