/*
 * Decompiled with CFR 0.152.
 */
package info.inpureprojects.core.Scripting.Objects;

public class JavaScriptCompressor {
    private static final char LINE_FEED = '\n';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private String script;
    private StringBuffer outputBuffer;
    private int pos;
    private char ch;
    private char lastAppend;
    private boolean endReached;
    private boolean contentAppendedAfterLastIdentifier = true;

    private JavaScriptCompressor(String script) {
        this.script = script;
        this.outputBuffer = new StringBuffer(script.length());
        this.nextChar();
        while (!this.endReached) {
            if (Character.isJavaIdentifierStart(this.ch)) {
                this.renderIdentifier();
                continue;
            }
            if (this.ch == ' ') {
                this.skipWhiteSpace();
                continue;
            }
            if (this.isWhitespace()) {
                this.skipWhiteSpace();
                continue;
            }
            if (this.ch == '\"' || this.ch == '\'') {
                this.renderString();
                continue;
            }
            if (this.ch == '/') {
                this.nextChar();
                if (this.ch == '/') {
                    this.nextChar();
                    this.skipLineComment();
                    continue;
                }
                if (this.ch == '*') {
                    this.nextChar();
                    this.skipBlockComment();
                    continue;
                }
                this.append('/');
                continue;
            }
            this.append(this.ch);
            this.nextChar();
        }
    }

    public static String compress(String script) {
        JavaScriptCompressor jsc = new JavaScriptCompressor(script);
        return jsc.outputBuffer.toString();
    }

    private void append(char ch) {
        this.lastAppend = ch;
        this.outputBuffer.append(ch);
        this.contentAppendedAfterLastIdentifier = true;
    }

    private boolean isWhitespace() {
        return this.ch == '\r' || this.ch == ' ' || this.ch == '\t' || this.ch == '\n';
    }

    private void nextChar() {
        if (!this.endReached) {
            if (this.pos < this.script.length()) {
                this.ch = this.script.charAt(this.pos++);
            } else {
                this.endReached = true;
                this.ch = '\u0000';
            }
        }
    }

    private void renderIdentifier() {
        if (!this.contentAppendedAfterLastIdentifier) {
            this.append(' ');
        }
        this.append(this.ch);
        this.nextChar();
        while (Character.isJavaIdentifierPart(this.ch)) {
            this.append(this.ch);
            this.nextChar();
        }
        this.contentAppendedAfterLastIdentifier = false;
    }

    private void renderString() {
        char startCh = this.ch;
        this.append(this.ch);
        this.nextChar();
        while (this.ch != '\n' && this.ch != '\r' && !this.endReached) {
            if (this.ch == '\\') {
                this.append(this.ch);
                this.nextChar();
                if (this.ch == '\n' || this.ch == '\r' || this.endReached) {
                    return;
                }
                this.append(this.ch);
                this.nextChar();
                continue;
            }
            this.append(this.ch);
            if (this.ch == startCh) {
                this.nextChar();
                return;
            }
            this.nextChar();
        }
        return;
    }

    private void skipLineComment() {
        while (this.ch != '\r' && this.ch != '\n') {
            if (this.endReached) {
                return;
            }
            this.nextChar();
        }
    }

    private void skipBlockComment() {
        while (!this.endReached) {
            if (this.ch == '*') {
                this.nextChar();
                if (this.ch != '/') continue;
                this.nextChar();
                return;
            }
            this.nextChar();
        }
        return;
    }

    private void renderNewLine() {
        if (this.lastAppend != '\n' && this.lastAppend != '\r') {
            this.append('\n');
        }
    }

    private void skipWhiteSpace() {
        if (this.ch == '\n' || this.ch == '\r') {
            this.renderNewLine();
        } else {
            this.append(this.ch);
        }
        this.nextChar();
        while (this.ch == '\n' || this.ch == '\r' || this.ch == ' ' || this.ch == '\t') {
            if (this.ch == '\n' || this.ch == '\r') {
                this.renderNewLine();
            }
            this.nextChar();
        }
    }
}

