/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.world.gen;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class WorldProviderSpace
extends WorldProvider
implements IGalacticraftWorldProvider {
    long timeCurrentOffset = 0L;
    long preTickTime = Long.MIN_VALUE;
    static Field tickCounter;

    public abstract Vector3 getFogColor();

    public abstract Vector3 getSkyColor();

    public abstract boolean canRainOrSnow();

    public abstract boolean hasSunset();

    public abstract long getDayLength();

    public abstract Class<? extends IChunkProvider> getChunkProviderClass();

    public abstract Class<? extends WorldChunkManager> getWorldChunkManagerClass();

    public void setDimension(int var1) {
        this.field_76574_g = var1;
        super.setDimension(var1);
    }

    public String func_80007_l() {
        return this.getCelestialBody().getLocalizedName();
    }

    @Override
    public boolean isGasPresent(IAtmosphericGas gas) {
        return this.getCelestialBody().atmosphere.contains((Object)gas);
    }

    public boolean hasAtmosphere() {
        return this.getCelestialBody().atmosphere.size() > 0;
    }

    public void updateWeather() {
        if (!this.field_76579_a.field_72995_K) {
            long newTime = this.field_76579_a.func_72912_H().func_76073_f();
            if (this.preTickTime == Long.MIN_VALUE) {
                int savedTick = 0;
                try {
                    tickCounter.setAccessible(true);
                    savedTick = tickCounter.getInt(this.field_76579_a.field_72982_D);
                    if (savedTick < 0) {
                        savedTick = 0;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.timeCurrentOffset = (long)savedTick - newTime;
            } else {
                long diff = newTime - this.preTickTime;
                if (diff > 1L) {
                    this.timeCurrentOffset -= diff - 1L;
                    this.saveTime();
                }
            }
            this.preTickTime = newTime;
        }
        if (this.canRainOrSnow()) {
            super.updateWeather();
        } else {
            this.field_76579_a.func_72912_H().func_76080_g(0);
            this.field_76579_a.func_72912_H().func_76084_b(false);
            this.field_76579_a.func_72912_H().func_76090_f(0);
            this.field_76579_a.func_72912_H().func_76069_a(false);
            this.field_76579_a.field_73004_o = 0.0f;
            this.field_76579_a.field_73017_q = 0.0f;
        }
    }

    public String getSaveFolder() {
        return "DIM" + this.getCelestialBody().getDimensionID();
    }

    public String getWelcomeMessage() {
        return "Entering " + this.getCelestialBody().getLocalizedName();
    }

    public String getDepartMessage() {
        return "Leaving " + this.getCelestialBody().getLocalizedName();
    }

    public boolean canBlockFreeze(int x, int y, int z, boolean byWater) {
        return this.canRainOrSnow();
    }

    public boolean canDoLightning(Chunk chunk) {
        return this.canRainOrSnow();
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return this.canRainOrSnow();
    }

    public float[] func_76560_a(float var1, float var2) {
        return this.hasSunset() ? super.func_76560_a(var1, var2) : null;
    }

    public float func_76563_a(long par1, float par3) {
        par1 = this.getWorldTime();
        int j = (int)(par1 % this.getDayLength());
        float f1 = ((float)j + par3) / (float)this.getDayLength() - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 0.5f - MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) / 2.0f;
        return f2 + (f1 - f2) / 3.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float var1, float var2) {
        Vector3 fogColor = this.getFogColor();
        return Vec3.func_72443_a((double)fogColor.floatX(), (double)fogColor.floatY(), (double)fogColor.floatZ());
    }

    public Vec3 getSkyColor(Entity cameraEntity, float partialTicks) {
        Vector3 skyColor = this.getSkyColor();
        return Vec3.func_72443_a((double)skyColor.floatX(), (double)skyColor.floatY(), (double)skyColor.floatZ());
    }

    public boolean func_76561_g() {
        return true;
    }

    public boolean func_76569_d() {
        return this.field_76579_a == null ? false : this.field_76579_a.field_72995_K;
    }

    public boolean func_76567_e() {
        return false;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return this.shouldForceRespawn() ? this.field_76574_g : 0;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    @Override
    public boolean hasBreathableAtmosphere() {
        return this.isGasPresent(IAtmosphericGas.OXYGEN) && !this.isGasPresent(IAtmosphericGas.CO2);
    }

    @Override
    public boolean netherPortalsOperational() {
        return false;
    }

    public IChunkProvider func_76555_c() {
        try {
            Class<? extends IChunkProvider> chunkProviderClass = this.getChunkProviderClass();
            Constructor<?>[] constructors = chunkProviderClass.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> constr = constructors[i];
                if (Arrays.equals(constr.getParameterTypes(), new Object[]{World.class, Long.TYPE, Boolean.TYPE})) {
                    return (IChunkProvider)constr.newInstance(this.field_76579_a, this.field_76579_a.func_72905_C(), this.field_76579_a.func_72912_H().func_76089_r());
                }
                if (constr.getParameterTypes().length != 0) continue;
                return (IChunkProvider)constr.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void func_76572_b() {
        if (this.getWorldChunkManagerClass() == null) {
            super.func_76572_b();
        } else {
            try {
                Constructor<?>[] constructors;
                Class<? extends WorldChunkManager> chunkManagerClass = this.getWorldChunkManagerClass();
                for (Constructor<?> constr : constructors = chunkManagerClass.getConstructors()) {
                    if (Arrays.equals(constr.getParameterTypes(), new Object[]{World.class})) {
                        this.field_76578_c = (WorldChunkManager)constr.newInstance(this.field_76579_a);
                        continue;
                    }
                    if (constr.getParameterTypes().length != 0) continue;
                    this.field_76578_c = (WorldChunkManager)constr.newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean shouldMapSpin(String entity, double x, double y, double z) {
        return false;
    }

    @Override
    public float getSolarSize() {
        return 1.0f / this.getCelestialBody().getRelativeDistanceFromCenter().unScaledDistance;
    }

    public void setWorldTime(long time) {
        this.field_76579_a.func_72912_H().func_76068_b(time);
        long diff = -this.timeCurrentOffset;
        this.timeCurrentOffset = time - this.field_76579_a.func_72912_H().func_76073_f();
        this.preTickTime += (diff += this.timeCurrentOffset);
        if (diff != 0L) {
            this.saveTime();
        }
    }

    public long getWorldTime() {
        return this.field_76579_a.func_72912_H().func_76073_f() + this.timeCurrentOffset;
    }

    public void adjustTimeOffset(long diff) {
        this.timeCurrentOffset -= diff;
        this.preTickTime += diff;
        if (diff != 0L) {
            this.saveTime();
        }
    }

    private void saveTime() {
        try {
            VillageCollection vc = this.field_76579_a.field_72982_D;
            tickCounter.setAccessible(true);
            tickCounter.setInt(vc, (int)this.getWorldTime());
            vc.func_76185_a();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            tickCounter = VillageCollection.class.getDeclaredField(GCCoreUtil.isDeobfuscated() ? "tickCounter" : "field_75553_e");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

