/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITargetedTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TranslationTextComponentFormatException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.TextComponentMessageFormatHandler;

public class TranslationTextComponent
extends TextComponent
implements ITargetedTextComponent {
    private static final Object[] field_240753_d_ = new Object[0];
    private static final ITextProperties field_240754_e_ = ITextProperties.func_240652_a_((String)"%");
    private static final ITextProperties field_240755_f_ = ITextProperties.func_240652_a_((String)"null");
    private final String field_150276_d;
    private final Object[] field_150277_e;
    @Nullable
    private LanguageMap field_240756_i_;
    private final List<ITextProperties> field_150278_b = Lists.newArrayList();
    private static final Pattern field_150279_c = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public TranslationTextComponent(String p_i232574_1_) {
        this.field_150276_d = p_i232574_1_;
        this.field_150277_e = field_240753_d_;
    }

    public TranslationTextComponent(String p_i45160_1_, Object ... p_i45160_2_) {
        this.field_150276_d = p_i45160_1_;
        this.field_150277_e = p_i45160_2_;
    }

    private void func_150270_g() {
        LanguageMap languagemap = LanguageMap.func_74808_a();
        if (languagemap != this.field_240756_i_) {
            this.field_240756_i_ = languagemap;
            this.field_150278_b.clear();
            String s = languagemap.func_230503_a_(this.field_150276_d);
            try {
                this.func_240758_a_(s);
            }
            catch (TranslationTextComponentFormatException translationtextcomponentformatexception) {
                this.field_150278_b.clear();
                this.field_150278_b.add(ITextProperties.func_240652_a_((String)s));
            }
        }
    }

    private void func_240758_a_(String p_240758_1_) {
        Matcher matcher = field_150279_c.matcher(p_240758_1_);
        try {
            int i = 0;
            int j = 0;
            while (matcher.find(j)) {
                int k = matcher.start();
                int l = matcher.end();
                if (k > j) {
                    String s = p_240758_1_.substring(j, k);
                    if (s.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    this.field_150278_b.add(ITextProperties.func_240652_a_((String)s));
                }
                String s4 = matcher.group(2);
                String s1 = p_240758_1_.substring(k, l);
                if ("%".equals(s4) && "%%".equals(s1)) {
                    this.field_150278_b.add(field_240754_e_);
                } else {
                    int i1;
                    if (!"s".equals(s4)) {
                        throw new TranslationTextComponentFormatException(this, "Unsupported format: '" + s1 + "'");
                    }
                    String s2 = matcher.group(1);
                    int n = i1 = s2 != null ? Integer.parseInt(s2) - 1 : i++;
                    if (i1 < this.field_150277_e.length) {
                        this.field_150278_b.add(this.func_240757_a_(i1));
                    }
                }
                j = l;
            }
            if (j == 0) {
                j = TextComponentMessageFormatHandler.handle((TranslationTextComponent)this, this.field_150278_b, (Object[])this.field_150277_e, (String)p_240758_1_);
            }
            if (j < p_240758_1_.length()) {
                String s3 = p_240758_1_.substring(j);
                if (s3.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                this.field_150278_b.add(ITextProperties.func_240652_a_((String)s3));
            }
        }
        catch (IllegalArgumentException illegalargumentexception) {
            throw new TranslationTextComponentFormatException(this, (Throwable)illegalargumentexception);
        }
    }

    private ITextProperties func_240757_a_(int p_240757_1_) {
        if (p_240757_1_ >= this.field_150277_e.length) {
            throw new TranslationTextComponentFormatException(this, p_240757_1_);
        }
        Object object = this.field_150277_e[p_240757_1_];
        if (object instanceof ITextComponent) {
            return (ITextComponent)object;
        }
        return object == null ? field_240755_f_ : ITextProperties.func_240652_a_((String)object.toString());
    }

    public TranslationTextComponent func_230531_f_() {
        return new TranslationTextComponent(this.field_150276_d, this.field_150277_e);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T> Optional<T> func_230534_b_(ITextProperties.IStyledTextAcceptor<T> p_230534_1_, Style p_230534_2_) {
        this.func_150270_g();
        for (ITextProperties itextproperties : this.field_150278_b) {
            Optional optional = itextproperties.func_230439_a_(p_230534_1_, p_230534_2_);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public <T> Optional<T> func_230533_b_(ITextProperties.ITextAcceptor<T> p_230533_1_) {
        this.func_150270_g();
        for (ITextProperties itextproperties : this.field_150278_b) {
            Optional optional = itextproperties.func_230438_a_(p_230533_1_);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public IFormattableTextComponent func_230535_a_(@Nullable CommandSource p_230535_1_, @Nullable Entity p_230535_2_, int p_230535_3_) throws CommandSyntaxException {
        Object[] aobject = new Object[this.field_150277_e.length];
        for (int i = 0; i < aobject.length; ++i) {
            Object object = this.field_150277_e[i];
            aobject[i] = object instanceof ITextComponent ? TextComponentUtils.func_240645_a_((CommandSource)p_230535_1_, (ITextComponent)((ITextComponent)object), (Entity)p_230535_2_, (int)p_230535_3_) : object;
        }
        return new TranslationTextComponent(this.field_150276_d, aobject);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof TranslationTextComponent)) {
            return false;
        }
        TranslationTextComponent translationtextcomponent = (TranslationTextComponent)((Object)p_equals_1_);
        return Arrays.equals(this.field_150277_e, translationtextcomponent.field_150277_e) && this.field_150276_d.equals(translationtextcomponent.field_150276_d) && super.equals(p_equals_1_);
    }

    public int hashCode() {
        int i = super.hashCode();
        i = 31 * i + this.field_150276_d.hashCode();
        return 31 * i + Arrays.hashCode(this.field_150277_e);
    }

    public String toString() {
        return "TranslatableComponent{key='" + this.field_150276_d + '\'' + ", args=" + Arrays.toString(this.field_150277_e) + ", siblings=" + this.field_150264_a + ", style=" + this.func_150256_b() + '}';
    }

    public String func_150268_i() {
        return this.field_150276_d;
    }

    public Object[] func_150271_j() {
        return this.field_150277_e;
    }
}

